/*
 * Copyright (c) 2001-2008 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/bgp_base.cc,v 1.56 2008/01/04 03:18:05 pavlin Exp $"


#include "bgp_base.hh"


XrlBgpTargetBase::XrlBgpTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlBgpTargetBase::~XrlBgpTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlBgpTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlBgpTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_bgp_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_bgp_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t version;
    try {
	XrlCmdError e = bgp_0_3_get_bgp_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_bgp_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_local_config(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/local_config");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_local_config(
	    xa_inputs.get_string("as"),
	    xa_inputs.get_ipv4("id"),
	    xa_inputs.get_bool("use_4byte_asnums"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/local_config", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_local_as(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_local_as");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_local_as(
	    xa_inputs.get_string("as"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_local_as", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_4byte_as_support(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_4byte_as_support");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_4byte_as_support(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_4byte_as_support", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_local_as(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_local_as");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string as;
    try {
	XrlCmdError e = bgp_0_3_get_local_as(
	    as);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_local_as", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("as", as);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_bgp_id(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_bgp_id");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_bgp_id(
	    xa_inputs.get_ipv4("id"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_bgp_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_bgp_id(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_bgp_id");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 id;
    try {
	XrlCmdError e = bgp_0_3_get_bgp_id(
	    id);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_bgp_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("id", id);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_confederation_identifier(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_confederation_identifier");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_confederation_identifier(
	    xa_inputs.get_string("as"),
	    xa_inputs.get_bool("disable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_confederation_identifier", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_cluster_id(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_cluster_id");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_cluster_id(
	    xa_inputs.get_ipv4("cluster_id"),
	    xa_inputs.get_bool("disable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_cluster_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_damping(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_damping");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_damping(
	    xa_inputs.get_uint32("half_life"),
	    xa_inputs.get_uint32("max_suppress"),
	    xa_inputs.get_uint32("reuse"),
	    xa_inputs.get_uint32("suppress"),
	    xa_inputs.get_bool("disable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_damping", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_add_peer(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 7) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(7), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/add_peer");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_add_peer(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_string("as"),
	    xa_inputs.get_ipv4("next_hop"),
	    xa_inputs.get_uint32("holdtime"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/add_peer", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_delete_peer(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/delete_peer");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_delete_peer(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/delete_peer", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_enable_peer(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/enable_peer");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_enable_peer(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/enable_peer", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_disable_peer(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/disable_peer");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_disable_peer(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/disable_peer", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_change_local_ip(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/change_local_ip");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_change_local_ip(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_string("new_local_ip"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/change_local_ip", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_change_local_port(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/change_local_port");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_change_local_port(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_uint32("new_local_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/change_local_port", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_change_peer_port(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/change_peer_port");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_change_peer_port(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_uint32("new_peer_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/change_peer_port", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_peer_as(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_peer_as");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_peer_as(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_string("peer_as"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_peer_as", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_holdtime(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_holdtime");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_holdtime(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_uint32("holdtime"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_holdtime", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_delay_open_time(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_delay_open_time");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_delay_open_time(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_uint32("delay_open_time"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_delay_open_time", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_route_reflector_client(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_route_reflector_client");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_route_reflector_client(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_bool("state"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_route_reflector_client", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_confederation_member(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_confederation_member");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_confederation_member(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_bool("state"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_confederation_member", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_prefix_limit(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_prefix_limit");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_prefix_limit(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_uint32("maximum"),
	    xa_inputs.get_bool("state"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_prefix_limit", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_nexthop4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_nexthop4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_nexthop4(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_ipv4("next_hop"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_nexthop4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_nexthop6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_nexthop6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_nexthop6(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_ipv6("next_hop"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_nexthop6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_nexthop6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_nexthop6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv6 next_hop;
    try {
	XrlCmdError e = bgp_0_3_get_nexthop6(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    next_hop);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_nexthop6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("next_hop", next_hop);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_peer_state(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_peer_state");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_peer_state(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_bool("toggle"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_peer_state", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_peer_md5_password(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_peer_md5_password");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_peer_md5_password(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_string("password"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_peer_md5_password", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_activate(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/activate");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_activate(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/activate", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_set_parameter(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/set_parameter");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_set_parameter(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_string("parameter"),
	    xa_inputs.get_bool("toggle"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/set_parameter", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_next_hop_rewrite_filter(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/next_hop_rewrite_filter");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_next_hop_rewrite_filter(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    xa_inputs.get_ipv4("next_hop"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/next_hop_rewrite_filter", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_originate_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/originate_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_originate_route4(
	    xa_inputs.get_ipv4net("nlri"),
	    xa_inputs.get_ipv4("next_hop"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/originate_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_originate_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/originate_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_originate_route6(
	    xa_inputs.get_ipv6net("nlri"),
	    xa_inputs.get_ipv6("next_hop"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/originate_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_withdraw_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/withdraw_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_withdraw_route4(
	    xa_inputs.get_ipv4net("nlri"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/withdraw_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_withdraw_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/withdraw_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_withdraw_route6(
	    xa_inputs.get_ipv6net("nlri"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/withdraw_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_trace(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/trace");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_trace(
	    xa_inputs.get_string("tvar"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/trace", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_list_start(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_list_start");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t token;
    bool more;
    try {
	XrlCmdError e = bgp_0_3_get_peer_list_start(
	    token,
	    more);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_list_start", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("token", token);
	pxa_outputs->add("more", more);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_list_next(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_list_next");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string local_ip;
    uint32_t local_port;
    string peer_ip;
    uint32_t peer_port;
    bool more;
    try {
	XrlCmdError e = bgp_0_3_get_peer_list_next(
	    xa_inputs.get_uint32("token"),
	    local_ip,
	    local_port,
	    peer_ip,
	    peer_port,
	    more);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_list_next", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("local_ip", local_ip);
	pxa_outputs->add("local_port", local_port);
	pxa_outputs->add("peer_ip", peer_ip);
	pxa_outputs->add("peer_port", peer_port);
	pxa_outputs->add("more", more);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_id(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_id");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 peer_id;
    try {
	XrlCmdError e = bgp_0_3_get_peer_id(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    peer_id);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_id", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("peer_id", peer_id);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t peer_state;
    uint32_t admin_status;
    try {
	XrlCmdError e = bgp_0_3_get_peer_status(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    peer_state,
	    admin_status);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("peer_state", peer_state);
	pxa_outputs->add("admin_status", admin_status);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_negotiated_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_negotiated_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    int32_t neg_version;
    try {
	XrlCmdError e = bgp_0_3_get_peer_negotiated_version(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    neg_version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_negotiated_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("neg_version", neg_version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_as(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_as");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string peer_as;
    try {
	XrlCmdError e = bgp_0_3_get_peer_as(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    peer_as);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_as", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("peer_as", peer_as);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_msg_stats(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_msg_stats");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t in_updates;
    uint32_t out_updates;
    uint32_t in_msgs;
    uint32_t out_msgs;
    uint32_t last_error;
    uint32_t in_update_elapsed;
    try {
	XrlCmdError e = bgp_0_3_get_peer_msg_stats(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    in_updates,
	    out_updates,
	    in_msgs,
	    out_msgs,
	    last_error,
	    in_update_elapsed);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_msg_stats", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("in_updates", in_updates);
	pxa_outputs->add("out_updates", out_updates);
	pxa_outputs->add("in_msgs", in_msgs);
	pxa_outputs->add("out_msgs", out_msgs);
	pxa_outputs->add("last_error", last_error);
	pxa_outputs->add("in_update_elapsed", in_update_elapsed);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_established_stats(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_established_stats");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t transitions;
    uint32_t established_time;
    try {
	XrlCmdError e = bgp_0_3_get_peer_established_stats(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    transitions,
	    established_time);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_established_stats", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("transitions", transitions);
	pxa_outputs->add("established_time", established_time);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_peer_timer_config(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_peer_timer_config");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t retry_interval;
    uint32_t hold_time;
    uint32_t keep_alive;
    uint32_t hold_time_conf;
    uint32_t keep_alive_conf;
    uint32_t min_as_orgination_interval;
    uint32_t min_route_adv_interval;
    try {
	XrlCmdError e = bgp_0_3_get_peer_timer_config(
	    xa_inputs.get_string("local_ip"),
	    xa_inputs.get_uint32("local_port"),
	    xa_inputs.get_string("peer_ip"),
	    xa_inputs.get_uint32("peer_port"),
	    retry_interval,
	    hold_time,
	    keep_alive,
	    hold_time_conf,
	    keep_alive_conf,
	    min_as_orgination_interval,
	    min_route_adv_interval);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_peer_timer_config", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("retry_interval", retry_interval);
	pxa_outputs->add("hold_time", hold_time);
	pxa_outputs->add("keep_alive", keep_alive);
	pxa_outputs->add("hold_time_conf", hold_time_conf);
	pxa_outputs->add("keep_alive_conf", keep_alive_conf);
	pxa_outputs->add("min_as_orgination_interval", min_as_orgination_interval);
	pxa_outputs->add("min_route_adv_interval", min_route_adv_interval);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_register_rib(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/register_rib");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = bgp_0_3_register_rib(
	    xa_inputs.get_string("name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/register_rib", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_v4_route_list_start(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_v4_route_list_start");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t token;
    try {
	XrlCmdError e = bgp_0_3_get_v4_route_list_start(
	    xa_inputs.get_ipv4net("net"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    token);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_v4_route_list_start", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("token", token);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_v6_route_list_start(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_v6_route_list_start");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t token;
    try {
	XrlCmdError e = bgp_0_3_get_v6_route_list_start(
	    xa_inputs.get_ipv6net("net"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    token);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_v6_route_list_start", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("token", token);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_v4_route_list_next(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_v4_route_list_next");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 peer_id;
    IPv4Net net;
    uint32_t best_and_origin;
    vector<uint8_t> aspath;
    IPv4 nexthop;
    int32_t med;
    int32_t localpref;
    int32_t atomic_agg;
    vector<uint8_t> aggregator;
    int32_t calc_localpref;
    vector<uint8_t> attr_unknown;
    bool valid;
    bool unicast;
    bool multicast;
    try {
	XrlCmdError e = bgp_0_3_get_v4_route_list_next(
	    xa_inputs.get_uint32("token"),
	    peer_id,
	    net,
	    best_and_origin,
	    aspath,
	    nexthop,
	    med,
	    localpref,
	    atomic_agg,
	    aggregator,
	    calc_localpref,
	    attr_unknown,
	    valid,
	    unicast,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_v4_route_list_next", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("peer_id", peer_id);
	pxa_outputs->add("net", net);
	pxa_outputs->add("best_and_origin", best_and_origin);
	pxa_outputs->add("aspath", aspath);
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("med", med);
	pxa_outputs->add("localpref", localpref);
	pxa_outputs->add("atomic_agg", atomic_agg);
	pxa_outputs->add("aggregator", aggregator);
	pxa_outputs->add("calc_localpref", calc_localpref);
	pxa_outputs->add("attr_unknown", attr_unknown);
	pxa_outputs->add("valid", valid);
	pxa_outputs->add("unicast", unicast);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_bgp_0_3_get_v6_route_list_next(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "bgp/0.3/get_v6_route_list_next");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    IPv4 peer_id;
    IPv6Net net;
    uint32_t best_and_origin;
    vector<uint8_t> aspath;
    IPv6 nexthop;
    int32_t med;
    int32_t localpref;
    int32_t atomic_agg;
    vector<uint8_t> aggregator;
    int32_t calc_localpref;
    vector<uint8_t> attr_unknown;
    bool valid;
    bool unicast;
    bool multicast;
    try {
	XrlCmdError e = bgp_0_3_get_v6_route_list_next(
	    xa_inputs.get_uint32("token"),
	    peer_id,
	    net,
	    best_and_origin,
	    aspath,
	    nexthop,
	    med,
	    localpref,
	    atomic_agg,
	    aggregator,
	    calc_localpref,
	    attr_unknown,
	    valid,
	    unicast,
	    multicast);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "bgp/0.3/get_v6_route_list_next", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("peer_id", peer_id);
	pxa_outputs->add("net", net);
	pxa_outputs->add("best_and_origin", best_and_origin);
	pxa_outputs->add("aspath", aspath);
	pxa_outputs->add("nexthop", nexthop);
	pxa_outputs->add("med", med);
	pxa_outputs->add("localpref", localpref);
	pxa_outputs->add("atomic_agg", atomic_agg);
	pxa_outputs->add("aggregator", aggregator);
	pxa_outputs->add("calc_localpref", calc_localpref);
	pxa_outputs->add("attr_unknown", attr_unknown);
	pxa_outputs->add("valid", valid);
	pxa_outputs->add("unicast", unicast);
	pxa_outputs->add("multicast", multicast);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_policy_backend_0_1_configure(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/configure");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_configure(
	    xa_inputs.get_uint32("filter"),
	    xa_inputs.get_string("conf"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/configure", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_policy_backend_0_1_reset(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/reset");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_reset(
	    xa_inputs.get_uint32("filter"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/reset", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_policy_backend_0_1_push_routes(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "policy_backend/0.1/push_routes");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_backend_0_1_push_routes();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_backend/0.1/push_routes", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_policy_redist4_0_1_add_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/add_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_add_route4(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/add_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_policy_redist4_0_1_delete_route4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "policy_redist4/0.1/delete_route4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist4_0_1_delete_route4(
	    xa_inputs.get_ipv4net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist4/0.1/delete_route4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_policy_redist6_0_1_add_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "policy_redist6/0.1/add_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist6_0_1_add_route6(
	    xa_inputs.get_ipv6net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_list("policytags"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist6/0.1/add_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_policy_redist6_0_1_delete_route6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "policy_redist6/0.1/delete_route6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = policy_redist6_0_1_delete_route6(
	    xa_inputs.get_ipv6net("network"),
	    xa_inputs.get_bool("unicast"),
	    xa_inputs.get_bool("multicast"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "policy_redist6/0.1/delete_route6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_rib_client_0_1_route_info_changed4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "rib_client/0.1/route_info_changed4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_client_0_1_route_info_changed4(
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("prefix_len"),
	    xa_inputs.get_ipv4("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib_client/0.1/route_info_changed4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_rib_client_0_1_route_info_changed6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 6) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(6), XORP_UINT_CAST(xa_inputs.size()), "rib_client/0.1/route_info_changed6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_client_0_1_route_info_changed6(
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_uint32("prefix_len"),
	    xa_inputs.get_ipv6("nexthop"),
	    xa_inputs.get_uint32("metric"),
	    xa_inputs.get_uint32("admin_distance"),
	    xa_inputs.get_string("protocol_origin"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib_client/0.1/route_info_changed6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_rib_client_0_1_route_info_invalid4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "rib_client/0.1/route_info_invalid4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_client_0_1_route_info_invalid4(
	    xa_inputs.get_ipv4("addr"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib_client/0.1/route_info_invalid4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_rib_client_0_1_route_info_invalid6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "rib_client/0.1/route_info_invalid6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = rib_client_0_1_route_info_invalid6(
	    xa_inputs.get_ipv6("addr"),
	    xa_inputs.get_uint32("prefix_len"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "rib_client/0.1/route_info_invalid6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_profile_0_1_enable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/enable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_enable(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/enable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_profile_0_1_disable(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/disable");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_disable(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/disable", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_profile_0_1_get_entries(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/get_entries");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_get_entries(
	    xa_inputs.get_string("pname"),
	    xa_inputs.get_string("instance_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/get_entries", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_profile_0_1_clear(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/clear");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = profile_0_1_clear(
	    xa_inputs.get_string("pname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/clear", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlBgpTargetBase::handle_profile_0_1_list(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "profile/0.1/list");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string info;
    try {
	XrlCmdError e = profile_0_1_list(
	    info);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "profile/0.1/list", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("info", info);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

void
XrlBgpTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlBgpTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlBgpTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlBgpTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlBgpTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("bgp/0.3/get_bgp_version",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_bgp_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_bgp_version");
	}
	if (_cmds->add_handler("bgp/0.3/local_config",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_local_config)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/local_config");
	}
	if (_cmds->add_handler("bgp/0.3/set_local_as",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_local_as)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_local_as");
	}
	if (_cmds->add_handler("bgp/0.3/set_4byte_as_support",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_4byte_as_support)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_4byte_as_support");
	}
	if (_cmds->add_handler("bgp/0.3/get_local_as",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_local_as)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_local_as");
	}
	if (_cmds->add_handler("bgp/0.3/set_bgp_id",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_bgp_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_bgp_id");
	}
	if (_cmds->add_handler("bgp/0.3/get_bgp_id",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_bgp_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_bgp_id");
	}
	if (_cmds->add_handler("bgp/0.3/set_confederation_identifier",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_confederation_identifier)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_confederation_identifier");
	}
	if (_cmds->add_handler("bgp/0.3/set_cluster_id",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_cluster_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_cluster_id");
	}
	if (_cmds->add_handler("bgp/0.3/set_damping",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_damping)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_damping");
	}
	if (_cmds->add_handler("bgp/0.3/add_peer",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_add_peer)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/add_peer");
	}
	if (_cmds->add_handler("bgp/0.3/delete_peer",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_delete_peer)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/delete_peer");
	}
	if (_cmds->add_handler("bgp/0.3/enable_peer",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_enable_peer)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/enable_peer");
	}
	if (_cmds->add_handler("bgp/0.3/disable_peer",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_disable_peer)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/disable_peer");
	}
	if (_cmds->add_handler("bgp/0.3/change_local_ip",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_change_local_ip)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/change_local_ip");
	}
	if (_cmds->add_handler("bgp/0.3/change_local_port",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_change_local_port)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/change_local_port");
	}
	if (_cmds->add_handler("bgp/0.3/change_peer_port",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_change_peer_port)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/change_peer_port");
	}
	if (_cmds->add_handler("bgp/0.3/set_peer_as",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_peer_as)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_peer_as");
	}
	if (_cmds->add_handler("bgp/0.3/set_holdtime",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_holdtime)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_holdtime");
	}
	if (_cmds->add_handler("bgp/0.3/set_delay_open_time",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_delay_open_time)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_delay_open_time");
	}
	if (_cmds->add_handler("bgp/0.3/set_route_reflector_client",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_route_reflector_client)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_route_reflector_client");
	}
	if (_cmds->add_handler("bgp/0.3/set_confederation_member",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_confederation_member)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_confederation_member");
	}
	if (_cmds->add_handler("bgp/0.3/set_prefix_limit",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_prefix_limit)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_prefix_limit");
	}
	if (_cmds->add_handler("bgp/0.3/set_nexthop4",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_nexthop4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_nexthop4");
	}
	if (_cmds->add_handler("bgp/0.3/set_nexthop6",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_nexthop6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_nexthop6");
	}
	if (_cmds->add_handler("bgp/0.3/get_nexthop6",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_nexthop6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_nexthop6");
	}
	if (_cmds->add_handler("bgp/0.3/set_peer_state",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_peer_state)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_peer_state");
	}
	if (_cmds->add_handler("bgp/0.3/set_peer_md5_password",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_peer_md5_password)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_peer_md5_password");
	}
	if (_cmds->add_handler("bgp/0.3/activate",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_activate)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/activate");
	}
	if (_cmds->add_handler("bgp/0.3/set_parameter",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_set_parameter)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/set_parameter");
	}
	if (_cmds->add_handler("bgp/0.3/next_hop_rewrite_filter",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_next_hop_rewrite_filter)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/next_hop_rewrite_filter");
	}
	if (_cmds->add_handler("bgp/0.3/originate_route4",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_originate_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/originate_route4");
	}
	if (_cmds->add_handler("bgp/0.3/originate_route6",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_originate_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/originate_route6");
	}
	if (_cmds->add_handler("bgp/0.3/withdraw_route4",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_withdraw_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/withdraw_route4");
	}
	if (_cmds->add_handler("bgp/0.3/withdraw_route6",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_withdraw_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/withdraw_route6");
	}
	if (_cmds->add_handler("bgp/0.3/trace",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_trace)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/trace");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_list_start",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_list_start)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_list_start");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_list_next",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_list_next)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_list_next");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_id",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_id)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_id");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_status",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_status");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_negotiated_version",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_negotiated_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_negotiated_version");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_as",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_as)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_as");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_msg_stats",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_msg_stats)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_msg_stats");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_established_stats",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_established_stats)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_established_stats");
	}
	if (_cmds->add_handler("bgp/0.3/get_peer_timer_config",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_peer_timer_config)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_peer_timer_config");
	}
	if (_cmds->add_handler("bgp/0.3/register_rib",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_register_rib)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/register_rib");
	}
	if (_cmds->add_handler("bgp/0.3/get_v4_route_list_start",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_v4_route_list_start)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_v4_route_list_start");
	}
	if (_cmds->add_handler("bgp/0.3/get_v6_route_list_start",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_v6_route_list_start)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_v6_route_list_start");
	}
	if (_cmds->add_handler("bgp/0.3/get_v4_route_list_next",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_v4_route_list_next)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_v4_route_list_next");
	}
	if (_cmds->add_handler("bgp/0.3/get_v6_route_list_next",
	    callback(this, &XrlBgpTargetBase::handle_bgp_0_3_get_v6_route_list_next)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "bgp/0.3/get_v6_route_list_next");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlBgpTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlBgpTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("policy_backend/0.1/configure",
	    callback(this, &XrlBgpTargetBase::handle_policy_backend_0_1_configure)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "policy_backend/0.1/configure");
	}
	if (_cmds->add_handler("policy_backend/0.1/reset",
	    callback(this, &XrlBgpTargetBase::handle_policy_backend_0_1_reset)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "policy_backend/0.1/reset");
	}
	if (_cmds->add_handler("policy_backend/0.1/push_routes",
	    callback(this, &XrlBgpTargetBase::handle_policy_backend_0_1_push_routes)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "policy_backend/0.1/push_routes");
	}
	if (_cmds->add_handler("policy_redist4/0.1/add_route4",
	    callback(this, &XrlBgpTargetBase::handle_policy_redist4_0_1_add_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "policy_redist4/0.1/add_route4");
	}
	if (_cmds->add_handler("policy_redist4/0.1/delete_route4",
	    callback(this, &XrlBgpTargetBase::handle_policy_redist4_0_1_delete_route4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "policy_redist4/0.1/delete_route4");
	}
	if (_cmds->add_handler("policy_redist6/0.1/add_route6",
	    callback(this, &XrlBgpTargetBase::handle_policy_redist6_0_1_add_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "policy_redist6/0.1/add_route6");
	}
	if (_cmds->add_handler("policy_redist6/0.1/delete_route6",
	    callback(this, &XrlBgpTargetBase::handle_policy_redist6_0_1_delete_route6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "policy_redist6/0.1/delete_route6");
	}
	if (_cmds->add_handler("rib_client/0.1/route_info_changed4",
	    callback(this, &XrlBgpTargetBase::handle_rib_client_0_1_route_info_changed4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "rib_client/0.1/route_info_changed4");
	}
	if (_cmds->add_handler("rib_client/0.1/route_info_changed6",
	    callback(this, &XrlBgpTargetBase::handle_rib_client_0_1_route_info_changed6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "rib_client/0.1/route_info_changed6");
	}
	if (_cmds->add_handler("rib_client/0.1/route_info_invalid4",
	    callback(this, &XrlBgpTargetBase::handle_rib_client_0_1_route_info_invalid4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "rib_client/0.1/route_info_invalid4");
	}
	if (_cmds->add_handler("rib_client/0.1/route_info_invalid6",
	    callback(this, &XrlBgpTargetBase::handle_rib_client_0_1_route_info_invalid6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "rib_client/0.1/route_info_invalid6");
	}
	if (_cmds->add_handler("profile/0.1/enable",
	    callback(this, &XrlBgpTargetBase::handle_profile_0_1_enable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "profile/0.1/enable");
	}
	if (_cmds->add_handler("profile/0.1/disable",
	    callback(this, &XrlBgpTargetBase::handle_profile_0_1_disable)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "profile/0.1/disable");
	}
	if (_cmds->add_handler("profile/0.1/get_entries",
	    callback(this, &XrlBgpTargetBase::handle_profile_0_1_get_entries)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "profile/0.1/get_entries");
	}
	if (_cmds->add_handler("profile/0.1/clear",
	    callback(this, &XrlBgpTargetBase::handle_profile_0_1_clear)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "profile/0.1/clear");
	}
	if (_cmds->add_handler("profile/0.1/list",
	    callback(this, &XrlBgpTargetBase::handle_profile_0_1_list)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "bgp", "profile/0.1/list");
	}
	_cmds->finalize();
}

void
XrlBgpTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("bgp/0.3/get_bgp_version");
	_cmds->remove_handler("bgp/0.3/local_config");
	_cmds->remove_handler("bgp/0.3/set_local_as");
	_cmds->remove_handler("bgp/0.3/set_4byte_as_support");
	_cmds->remove_handler("bgp/0.3/get_local_as");
	_cmds->remove_handler("bgp/0.3/set_bgp_id");
	_cmds->remove_handler("bgp/0.3/get_bgp_id");
	_cmds->remove_handler("bgp/0.3/set_confederation_identifier");
	_cmds->remove_handler("bgp/0.3/set_cluster_id");
	_cmds->remove_handler("bgp/0.3/set_damping");
	_cmds->remove_handler("bgp/0.3/add_peer");
	_cmds->remove_handler("bgp/0.3/delete_peer");
	_cmds->remove_handler("bgp/0.3/enable_peer");
	_cmds->remove_handler("bgp/0.3/disable_peer");
	_cmds->remove_handler("bgp/0.3/change_local_ip");
	_cmds->remove_handler("bgp/0.3/change_local_port");
	_cmds->remove_handler("bgp/0.3/change_peer_port");
	_cmds->remove_handler("bgp/0.3/set_peer_as");
	_cmds->remove_handler("bgp/0.3/set_holdtime");
	_cmds->remove_handler("bgp/0.3/set_delay_open_time");
	_cmds->remove_handler("bgp/0.3/set_route_reflector_client");
	_cmds->remove_handler("bgp/0.3/set_confederation_member");
	_cmds->remove_handler("bgp/0.3/set_prefix_limit");
	_cmds->remove_handler("bgp/0.3/set_nexthop4");
	_cmds->remove_handler("bgp/0.3/set_nexthop6");
	_cmds->remove_handler("bgp/0.3/get_nexthop6");
	_cmds->remove_handler("bgp/0.3/set_peer_state");
	_cmds->remove_handler("bgp/0.3/set_peer_md5_password");
	_cmds->remove_handler("bgp/0.3/activate");
	_cmds->remove_handler("bgp/0.3/set_parameter");
	_cmds->remove_handler("bgp/0.3/next_hop_rewrite_filter");
	_cmds->remove_handler("bgp/0.3/originate_route4");
	_cmds->remove_handler("bgp/0.3/originate_route6");
	_cmds->remove_handler("bgp/0.3/withdraw_route4");
	_cmds->remove_handler("bgp/0.3/withdraw_route6");
	_cmds->remove_handler("bgp/0.3/trace");
	_cmds->remove_handler("bgp/0.3/get_peer_list_start");
	_cmds->remove_handler("bgp/0.3/get_peer_list_next");
	_cmds->remove_handler("bgp/0.3/get_peer_id");
	_cmds->remove_handler("bgp/0.3/get_peer_status");
	_cmds->remove_handler("bgp/0.3/get_peer_negotiated_version");
	_cmds->remove_handler("bgp/0.3/get_peer_as");
	_cmds->remove_handler("bgp/0.3/get_peer_msg_stats");
	_cmds->remove_handler("bgp/0.3/get_peer_established_stats");
	_cmds->remove_handler("bgp/0.3/get_peer_timer_config");
	_cmds->remove_handler("bgp/0.3/register_rib");
	_cmds->remove_handler("bgp/0.3/get_v4_route_list_start");
	_cmds->remove_handler("bgp/0.3/get_v6_route_list_start");
	_cmds->remove_handler("bgp/0.3/get_v4_route_list_next");
	_cmds->remove_handler("bgp/0.3/get_v6_route_list_next");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("policy_backend/0.1/configure");
	_cmds->remove_handler("policy_backend/0.1/reset");
	_cmds->remove_handler("policy_backend/0.1/push_routes");
	_cmds->remove_handler("policy_redist4/0.1/add_route4");
	_cmds->remove_handler("policy_redist4/0.1/delete_route4");
	_cmds->remove_handler("policy_redist6/0.1/add_route6");
	_cmds->remove_handler("policy_redist6/0.1/delete_route6");
	_cmds->remove_handler("rib_client/0.1/route_info_changed4");
	_cmds->remove_handler("rib_client/0.1/route_info_changed6");
	_cmds->remove_handler("rib_client/0.1/route_info_invalid4");
	_cmds->remove_handler("rib_client/0.1/route_info_invalid6");
	_cmds->remove_handler("profile/0.1/enable");
	_cmds->remove_handler("profile/0.1/disable");
	_cmds->remove_handler("profile/0.1/get_entries");
	_cmds->remove_handler("profile/0.1/clear");
	_cmds->remove_handler("profile/0.1/list");
}
