fib2mrib_common_get_target_name()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: fib2mrib_common_get_target_name"
        exit 1
    fi

    XRL="finder://fib2mrib/common/0.1/get_target_name"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_common_get_version()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: fib2mrib_common_get_version"
        exit 1
    fi

    XRL="finder://fib2mrib/common/0.1/get_version"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_common_get_status()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: fib2mrib_common_get_status"
        exit 1
    fi

    XRL="finder://fib2mrib/common/0.1/get_status"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_common_shutdown()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: fib2mrib_common_shutdown"
        exit 1
    fi

    XRL="finder://fib2mrib/common/0.1/shutdown"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_finder_event_observer_xrl_target_birth()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: fib2mrib_finder_event_observer_xrl_target_birth <target_class:txt> <target_instance:txt>"
        exit 1
    fi

    XRL="finder://fib2mrib/finder_event_observer/0.1/xrl_target_birth?target_class:txt=$1&target_instance:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_finder_event_observer_xrl_target_death()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: fib2mrib_finder_event_observer_xrl_target_death <target_class:txt> <target_instance:txt>"
        exit 1
    fi

    XRL="finder://fib2mrib/finder_event_observer/0.1/xrl_target_death?target_class:txt=$1&target_instance:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_add_route4()
{
    if [ $# -ne 8 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_add_route4 <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt> <metric:u32> <admin_distance:u32> <protocol_origin:txt> <xorp_route:bool>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/add_route4?network:ipv4net=$1&nexthop:ipv4=$2&ifname:txt=$3&vifname:txt=$4&metric:u32=$5&admin_distance:u32=$6&protocol_origin:txt=$7&xorp_route:bool=$8"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_add_route6()
{
    if [ $# -ne 8 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_add_route6 <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt> <metric:u32> <admin_distance:u32> <protocol_origin:txt> <xorp_route:bool>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/add_route6?network:ipv6net=$1&nexthop:ipv6=$2&ifname:txt=$3&vifname:txt=$4&metric:u32=$5&admin_distance:u32=$6&protocol_origin:txt=$7&xorp_route:bool=$8"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_replace_route4()
{
    if [ $# -ne 8 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_replace_route4 <network:ipv4net> <nexthop:ipv4> <ifname:txt> <vifname:txt> <metric:u32> <admin_distance:u32> <protocol_origin:txt> <xorp_route:bool>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/replace_route4?network:ipv4net=$1&nexthop:ipv4=$2&ifname:txt=$3&vifname:txt=$4&metric:u32=$5&admin_distance:u32=$6&protocol_origin:txt=$7&xorp_route:bool=$8"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_replace_route6()
{
    if [ $# -ne 8 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_replace_route6 <network:ipv6net> <nexthop:ipv6> <ifname:txt> <vifname:txt> <metric:u32> <admin_distance:u32> <protocol_origin:txt> <xorp_route:bool>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/replace_route6?network:ipv6net=$1&nexthop:ipv6=$2&ifname:txt=$3&vifname:txt=$4&metric:u32=$5&admin_distance:u32=$6&protocol_origin:txt=$7&xorp_route:bool=$8"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_delete_route4()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_delete_route4 <network:ipv4net> <ifname:txt> <vifname:txt>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/delete_route4?network:ipv4net=$1&ifname:txt=$2&vifname:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_delete_route6()
{
    if [ $# -ne 3 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_delete_route6 <network:ipv6net> <ifname:txt> <vifname:txt>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/delete_route6?network:ipv6net=$1&ifname:txt=$2&vifname:txt=$3"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_resolve_route4()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_resolve_route4 <network:ipv4net>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/resolve_route4?network:ipv4net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fea_fib_client_resolve_route6()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: fib2mrib_fea_fib_client_resolve_route6 <network:ipv6net>"
        exit 1
    fi

    XRL="finder://fib2mrib/fea_fib_client/0.1/resolve_route6?network:ipv6net=$1"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_policy_backend_configure()
{
    if [ $# -ne 2 ] ; then
        echo "Usage: fib2mrib_policy_backend_configure <filter:u32> <conf:txt>"
        exit 1
    fi

    XRL="finder://fib2mrib/policy_backend/0.1/configure?filter:u32=$1&conf:txt=$2"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_policy_backend_reset()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: fib2mrib_policy_backend_reset <filter:u32>"
        exit 1
    fi

    XRL="finder://fib2mrib/policy_backend/0.1/reset?filter:u32=$1"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_policy_backend_push_routes()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: fib2mrib_policy_backend_push_routes"
        exit 1
    fi

    XRL="finder://fib2mrib/policy_backend/0.1/push_routes"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fib2mrib_enable_fib2mrib()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: fib2mrib_fib2mrib_enable_fib2mrib <enable:bool>"
        exit 1
    fi

    XRL="finder://fib2mrib/fib2mrib/0.1/enable_fib2mrib?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fib2mrib_start_fib2mrib()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: fib2mrib_fib2mrib_start_fib2mrib"
        exit 1
    fi

    XRL="finder://fib2mrib/fib2mrib/0.1/start_fib2mrib"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fib2mrib_stop_fib2mrib()
{
    if [ $# -ne 0 ] ; then
        echo "Usage: fib2mrib_fib2mrib_stop_fib2mrib"
        exit 1
    fi

    XRL="finder://fib2mrib/fib2mrib/0.1/stop_fib2mrib"
    call_xrl_wrapper -p all "${XRL}"
}

fib2mrib_fib2mrib_enable_log_trace_all()
{
    if [ $# -ne 1 ] ; then
        echo "Usage: fib2mrib_fib2mrib_enable_log_trace_all <enable:bool>"
        exit 1
    fi

    XRL="finder://fib2mrib/fib2mrib/0.1/enable_log_trace_all?enable:bool=$1"
    call_xrl_wrapper -p all "${XRL}"
}

