#!/usr/bin/python

import sys
import unittest
#import os
import logging
#import settings
import tempfile
#import copy
import gtk
import gobject

import XKit.xutils
import XKit.xorgparser

import XorgOptionsEditor.XorgOptionsEditorGtk

import re
import os
cwd = os.getcwd()
tempFile = os.path.join(cwd, 'tmp')

class XorgEditorTestCase(unittest.TestCase):
    
    def setUp(self):
        self.ui = XorgOptionsEditor.XorgOptionsEditorGtk.XorgOptionsEditor()
        self.failed = False
        self.tempList = []
    
    def tearDown(self):
#        self.parser.comments.insert(0, '\n-----' + self.this_function_name + '-----\n')
#        self.parser.writeFile(destinationFile, test=True)
        try:
            os.remove(tempFile)
        except(OSError, IOError):
            pass
        
    def _startGtkLoop(self):
        '''Start the GTK loop'''
        XorgOptionsEditor.XorgOptionsEditorGtk.main()
    
    def _clickQuit(self):
        '''Send event of clicking the close button.'''

        self.ui.exit_button.emit('clicked')
        
    def _clickApply(self):
        '''Send event of clicking the apply button.'''

        self.ui.apply_button.emit('clicked')
    
    def _startWithCustomConfFile(self, source, destination=None):
        '''Read from custom xorg.conf and write to custom xorg.conf'''
        self.ui = XorgOptionsEditor.XorgOptionsEditorGtk.XorgOptionsEditor(source, destination)
    
    
    def _getCompleteXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Monitor"
	Identifier     "Configured Monitor"
EndSection

Section "Monitor"
	Identifier     "Monitor0"
	VendorName     "Unknown"
	ModelName      "Samsung SyncMaster"
	HorizSync       30.0 - 81.0
	VertRefresh     56.0 - 75.0
EndSection

Section "Monitor"
	Identifier     "Monitor1"
	VendorName     "Unknown"
	ModelName      "TV-0"
	HorizSync       28.0 - 55.0
	VertRefresh     43.0 - 72.0
EndSection

Section "Screen"
	Identifier     "Default Screen"
	Device         "Configured Video Device"
	Monitor        "Configured Monitor"
	DefaultDepth	24
EndSection

Section "Screen"
	Identifier     "Screen0"
	Device         "Videocard0"
	Monitor        "Monitor0"
	Option         "TwinView" "0"
	Option         "metamodes" "CRT: nvidia-auto-select +0+0"
	DefaultDepth	24
EndSection

Section "Screen"
	Identifier     "Screen1"
	Device         "Videocard1"
	Monitor        "Monitor1"
	Option         "TwinView" "0"
	Option         "metamodes" "TV: nvidia-auto-select +0+0"
	DefaultDepth	24
EndSection

Section "Module"
	Load           "glx"
EndSection

Section "InputDevice"
  Driver        "wacom"
  Identifier    "Wacom Pen"
  Option        "Device"        "/dev/input/wacom"
  Option        "Type"          "stylus"
  Option        "USB"           "on"
  Option        "PressCurve"    "0,0,100,100"
  Option        "tilt"         "on"  # add this if your tablet supports tilt
  #Option "Twinview" "horizontal"
  #Option "TVResolution" "1600x1200,1024x768"
EndSection

Section "InputDevice"
  Driver        "wacom"
  Identifier    "Wacom Eraser"
  Option        "Device"        "/dev/input/wacom"
  Option        "Type"          "eraser"
  Option        "USB"           "on"
  Option        "tilt"         "on"  # add this if your tablet supports tilt
  #Option "Twinview" "horizontal"
  #Option "TVResolution" "1600x1200,1024x768"
EndSection

Section "ServerLayout"
	Identifier     "Default Layout"
	Screen      0  "Screen0" 0 0#1024 0
	Screen      1  "Screen1" RightOf "Screen0"
	#InputDevice "Wacom Tablet"        "SendCoreEvents"
	InputDevice "Wacom Pen"           "SendCoreEvents"
	InputDevice "Wacom Eraser"        "SendCoreEvents"
	#InputDevice "Wacom Mouse"         "SendCoreEvents"
EndSection

Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection

Section "Device"
	Identifier     "Videocard0"
	VendorName     "NVIDIA Corporation"
	BoardName      "GeForce 7300 GT"
	BusID          "PCI:1:0:0"
	Screen          0
	Driver	"nvidia"
EndSection

Section "Device"
	Identifier     "Videocard1"
	VendorName     "NVIDIA Corporation"
	BoardName      "GeForce 7300 GT"
	BusID          "PCI:1:0:0"
	Screen          1
	Driver	"nvidia"
EndSection

Section "ServerFlags"
	Option         "Xinerama" "0"
EndSection

'''
        confFile.close()
        
        return tempFile
    
    def _getStandardXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Device"
	Identifier     "Configured Video Device"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getEmptyXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
#Section "Device"
#	Identifier     "Configured Video Device"
#EndSection

'''
        confFile.close()
        
        return tempFile

    def _getNoXorgConf(self):
        try:
            os.remove(tempFile)
        except(OSError, IOError):
            pass
        
        return tempFile

    def _getBrokenXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Screen"
	Identifier     "Screen0"
	Device         "Videocard0"
	Monitor        "Monitor0"
	Option         "TwinView" "0"
	Option         "metamodes" "CRT: nvidia-auto-select +0+0"
	DefaultDepth	24
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getNoScreenNoMonitorXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
#Section "Monitor"
#	Identifier     "Configured Monitor"
#EndSection

#Section "Screen"
#	Identifier     "Default Screen"
#	Device         "Configured Video Device"
#	Monitor        "Configured Monitor"
#	DefaultDepth	24
#EndSection

Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection


'''
        confFile.close()
        
        return tempFile

    def _getNoScreenXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Monitor"
	Identifier     "Configured Monitor"
EndSection

#Section "Screen"
#	Identifier     "Default Screen"
#	Device         "Configured Video Device"
#	Monitor        "Configured Monitor"
#	DefaultDepth	24
#EndSection

Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection


'''
        confFile.close()
        
        return tempFile

    def _getNoScreenXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Monitor"
	Identifier     "Configured Monitor"
EndSection

#Section "Screen"
#	Identifier     "Default Screen"
#	Device         "Configured Video Device"
#	Monitor        "Configured Monitor"
#	DefaultDepth	24
#EndSection

Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection


'''
        confFile.close()
        
        return tempFile

    def _getNoMonitorXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
#Section "Monitor"
#	Identifier     "Configured Monitor"
#EndSection

Section "Screen"
	Identifier     "Default Screen"
	Device         "Configured Video Device"
#	Monitor        "Configured Monitor"
	DefaultDepth	24
EndSection

Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getUnlinkedDeviceScreenMonitorXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Monitor"
	Identifier     "Configured Monitor"
EndSection

Section "Screen"
	Identifier     "Default Screen"
#	Device         "Configured Video Device"
#	Monitor        "Configured Monitor"
	DefaultDepth	24
EndSection

Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getEmptyServerFlagsXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "ServerFlags"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getFullServerFlagsXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "ServerFlags"
	Option         "Xinerama" "0"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getDeviceEmptyServerFlagsXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection

Section "ServerFlags"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getEmptyDeviceServerFlagsXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Device"
EndSection

Section "ServerFlags"
	Option         "DontZap" "False"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getEmptyDeviceEmptyServerFlagsXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Device"
EndSection

Section "ServerFlags"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _getDeviceServerFlagsXorgConf(self):
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Device"
	Identifier     "Configured Video Device"
	Option         "NoLogo" "True"
	Driver	"nvidia"
EndSection

Section "ServerFlags"
	Option         "Xinerama" "0"
EndSection

'''
        confFile.close()
        
        return tempFile

    def _addOption(self, mainEntry, newValue, newOption):
        # Select tree entry
        self._selectTreeEntry(mainEntry)
        
        # Click on "Add"
        self.ui.add_button.emit('clicked')
        
        # Do some type-check
        try:
            # it's an integer
            newOption + 1
            option = newOption
        except TypeError:
            # it's a string
            
            # Get the position of the option in treeview_full
            option = self._getNewOptionPosition(newOption)

            # Make sure that it didn't fail to get the position
            self.assert_(option != None)
            
        
#        if optionName:
#            # Get the position of the option in the treeview
#            option = self._getNewOptionPosition(optionName)

#            # Make sure that it didn't fail to get the position
#            self.assert_(option != False)
#        else:
#            option = optionPosition
        
        # Select option in treeview_full
        self._selectNewOption(option)
        
        # Click on full_select_button
        self.ui.full_select_button.emit('clicked')
        
        # Enter value in text_entry
        self.ui.text_entry.set_text(newValue)
        
        # Click on dlg_apply_button
        self.ui.dlg_apply_button.emit('clicked')
        
        # See if edit_option_dialog
        if self.ui.edit_option_dialog.get_property('visible'):
            self.failed = True
            #raise Exception('Wrong value type')

    def _removeOption(self, mainEntry, optionEntry):
        '''Remove an existing option'''
        self._selectTreeEntry(mainEntry)
        self._selectTreeOption(optionEntry)
        self.ui.remove_button.emit('clicked')
#        print >> sys.stderr, 'Removed Option'
        
    
    def _getTreeSelection(self, treeview, hasValue=False):
        '''Extract the option and value from a treeview item
        
        hasValue=True has to be used only for options
            (options_treeview)
        hasValue=False has to be used only for entries in the
            leftmost treeview (main_treeview)
        '''
        selection = treeview.get_selection()
        result = selection.get_selected()
        if result:
            model, iter = result
            if iter:
                if hasValue:
                    option = model.get_value(iter, 0).replace('<b>', '').replace('</b>', '')
                    value = model.get_value(iter, 1).replace('<i>', '').replace('</i>', '')
                    
                    option = option[:option.find('\n')]
                else:
                    option = model.get_value(iter, 0)
                    value = None
                
                return (option, value)
        return (None, None)
    
    def _getTreeSelectedOptionValue(self):
        '''Return tuple with the selected option and value'''
        treeview = self.ui.options_treeview
        return self._getTreeSelection(treeview, hasValue=True)

    def _getTreeSelectedEntry(self):
        '''Return the content of the selected item in main_treeview'''
        treeview = self.ui.main_treeview
        return self._getTreeSelection(treeview, hasValue=False)[0]
    
    def _selectTreeEntry(self, position):
        self.ui.main_treeview.set_cursor(position)
    
    def _selectNewOption(self, position):
        self.ui.treeview_full.set_cursor(position)
    
    def _getNewOptionPosition(self, optionName):
        pattern = r'.*<b>(.+)</b>.*'
        pat1 = re.compile(pattern)
        it = 0
        model = self.ui.treeview_full.get_model()
        for row in model:
            line = row[0]
            m1 = pat1.match(line)
            if m1:
                option = m1.group(1)
                #print >> sys.stderr, '\noption', str(option)
                if option.strip().lower() == optionName.strip().lower():
                    return it
            it += 1
        return None
    
    def _selectTreeOption(self, position):
        selection = self.ui.options_treeview.get_selection()
        result = selection.get_selected()
        if result:
            model, iter = result
            if iter:
                self.ui.options_treeview.set_cursor(position)
        
    
    def _isTreeOptionAvailable(self, optionName, mainEntry, optionEntry, optionValue=None):
        '''See if the same option is available in the same place'''
        self._selectTreeEntry(mainEntry)
        
        if optionEntry != None:
            self._selectTreeOption(optionEntry)
        option, value = self._getTreeSelectedOptionValue()
        
#        errorString = '\noption= %s, optionName= %s, optionEntry= %s, optionValue= %s' % (option, optionName, optionEntry, optionValue)
#        print >> sys.stderr, errorString#'\noption', str(option)
        
        #self.assert_(option)
        if optionValue != None:
            return(option == optionName and str(value).strip().lower() == str(optionValue).strip().lower())
        
        return(option == optionName)
   
    def _doOptionsMatch(self, optionName, mainEntry, optionEntry):
        # Select option 0 of ServerFlags
        self._selectTreeEntry(mainEntry)
        
        # this will fail if the option was removed and there's
        # no other entry
#        try:
#            self._selectTreeOption(optionEntry)
#        except:
#            pass
        
        # Get option 0 of ServerFlags
        # from the treeview and see if it's in XKit
        option, value = self._getTreeSelectedOptionValue()
        
        position = self.ui.optionsRef.get(mainEntry).get(option).get('position')
        
        #self.ui.globalDetails.get(mainEntry)
        
        section = self.ui.optionsRef.get(mainEntry).get(option).get('section')
        
#        print >> sys.stderr, '\nsection', section, '\nposition', position
        
        try:
            xValue = self.ui.xorg.xparser.getValue(section, optionName, position)
        except XKit.xorgparser.OptionException:
            # Set it to False so that None != False
            xValue = False
#        print >> sys.stderr, 'Do options match?'
        self.assert_(value == xValue)
        
    def _assertRemoval(self, optionName, mainEntry, optionEntry):
        # See if it's still available in the tree
        stillAvailable = self._isTreeOptionAvailable(optionName, mainEntry, optionEntry)
#        print >> sys.stderr, 'assertRemoval'
        self.failIf(stillAvailable)
        
        # See if in optionsRef
#        print >> sys.stderr, self.ui.optionsRef.get(mainEntry).get(optionName)
        
        if self.ui.optionsRef.get(mainEntry).get(optionName):
            self.failed = True

    def _assertAddition(self, mainEntry, optionName, optionValue):
        # See if it's available in the tree
#        optionEntry = None
        
        optionEntry = self._getNewOptionPosition(optionName)
        
        isAvailable = self._isTreeOptionAvailable(optionName, mainEntry, optionEntry, optionValue=optionValue)
#        print >> sys.stderr, 'assertRemoval'
        self.assert_(isAvailable)
        
        # See if in optionsRef
#        print >> sys.stderr, self.ui.optionsRef.get(mainEntry).get(optionName)
        
        if not self.ui.optionsRef.get(mainEntry).get(optionName):
            self.failed = True
        
        # FIXME: test that the value was set correctly
        
        
    def testRemoveOption1(self):
        '''Remove an option from ServerFlags'''
        # ServerFlags has only Option DontZap "False"
        confFile = self._getEmptyDeviceServerFlagsXorgConf()
        self._startWithCustomConfFile(confFile)
        
        gobject.timeout_add(5000, self._clickQuit)
        
        # See if DontZap is in both the treeview and in XKit
        gobject.timeout_add(1000, self._doOptionsMatch, 'DontZap', 0, 0)
        
        # Select option 0 of ServerFlags
        # and remove it
        gobject.timeout_add(2000, self._removeOption, 0, 0)
        
        gobject.timeout_add(3000, self._assertRemoval, 'DontZap', 0, 0)
        
        self._startGtkLoop()
        self.failIf(self.failed, 'Entry not removed from self.ui.optionsRef')
    
    def testAddOption1(self):
        '''1 Add option to 1st Device section'''
        # ServerFlags has only Option DontZap "False"
        confFile = self._getEmptyDeviceServerFlagsXorgConf()
        self._startWithCustomConfFile(confFile)
        
        gobject.timeout_add(3000, self._clickQuit)
        
        mainEntry = 1
        newOption = 'VendorName'
        newValue = 'Mickey Mouse'
        
        # Add the option
        gobject.timeout_add(1000, self._addOption, mainEntry, newValue, newOption)
        
        # Check that it's been added
        gobject.timeout_add(2000, self._assertAddition, mainEntry, newOption, newValue)
        
        self._startGtkLoop()
        
        self.failIf(self.failed, 'Option not added successfully')
    
    def _hasIntType(self, option):
        '''See whether an int value is acceptable or not'''
        valueType = self.ui.manOptions.get(option).get('valueType')
        value = 'Fake'#'1'
        return not self.ui.xorg.hasValidType(value, valueType)[0]

#    def _automateAssertions(self, mainEntry, strValue, intValue):
#        # Check that it's been added
#        gobject.timeout_add(5000, self._assertAddition, mainEntry, option, newValue)
        
    def _automateAdditions(self, mainEntry, strValue, intValue):
        pattern = r'.*<b>(.+)</b>.*'
        pat1 = re.compile(pattern)
        it = 0
        model = self.ui.treeview_full.get_model()
        for row in model:
            try:
                line = row[0]
            except TypeError:
                break
            m1 = pat1.match(line)
            if m1:
                option = m1.group(1).strip()
                
                # See whether it requires an int as a value
                if self._hasIntType(option):
                    newValue = intValue
                else:
                    newValue = strValue#'Fake'
                
                # Add "it" option
                #gobject.timeout_add(3000, self._addOption, mainEntry, newValue, it)
                self._addOption(mainEntry, newValue, it)
                self.tempList.append([mainEntry, option, newValue])
                
        
                
            it += 1
        #return False
    
    def _findOption(self, mainEntry, option, value):
        '''Find an option in the optionsRef'''
        for curOption in self.ui.optionsRef[mainEntry]:
            if curOption == option:
                return True
        return False
    
    def _testAnyEntry(self, strValue, intValue):
        '''Add any option in the man page to the xorg.conf and test that all goes well'''
        for mainEntry in self.ui.globalDetails:
            # Select mainEntry in main_treeview
            self._selectTreeEntry(mainEntry)
            
            # Add all the options to that entry:
            self._automateAdditions(mainEntry, strValue, intValue)
        
        for opt in self.tempList:
            # Check that it's been added
            if not self._findOption(*opt):
                self.failed = True
                errorString = 'mainEntry= %s, option= %s, newValue= %s' % (opt[0], opt[1], opt[2])
                print >> sys.stderr, errorString


    def testAddAllOptions(self):
        # ServerFlags has only Option DontZap "False"
        confFile = self._getEmptyDeviceServerFlagsXorgConf()
        self._startWithCustomConfFile(confFile)
        
        
        strValue = 'Fake'
        intValue = '1'
        
        gobject.timeout_add(6000, self._clickQuit)
        
        gobject.timeout_add(1000, self._testAnyEntry, strValue, intValue)
        
        self._startGtkLoop()
        
#        print >> sys.stderr, self.ui.optionsRef
        self.failIf(self.failed, 'Option not added successfully')

    def testMainWindow1(self):
        '''Main window and quit with standard xorg.conf'''
        confFile = self._getStandardXorgConf()
        self._startWithCustomConfFile(confFile)
        gobject.timeout_add(1000, self._clickQuit)
        self._startGtkLoop()

    def testMainWindow2(self):
        '''Main window and quit with complete xorg.conf'''
        confFile = self._getCompleteXorgConf()
        self._startWithCustomConfFile(confFile)
        gobject.timeout_add(1000, self._clickQuit)
        self._startGtkLoop()
    
    def testMainWindow3(self):
        '''Main window and quit with empty xorg.conf'''
        confFile = self._getEmptyXorgConf()
        self._startWithCustomConfFile(confFile)
        gobject.timeout_add(1000, self._clickQuit)
        self._startGtkLoop()

    def testMainWindow4(self):
        '''Main window and quit with no xorg.conf'''
        confFile = self._getNoXorgConf()
        self._startWithCustomConfFile(confFile)
        gobject.timeout_add(1000, self._clickQuit)
        self._startGtkLoop()

    def testMainWindow5(self):
        '''Main window and quit with broken xorg.conf'''
        confFile = self._getBrokenXorgConf()
        self._startWithCustomConfFile(confFile)
        gobject.timeout_add(1000, self._clickQuit)
        self._startGtkLoop()

    def _clickAnyEntry(self, confFile):
        for mainEntry in self.ui.globalDetails:
            # Select mainEntry in main_treeview
            self._selectTreeEntry(mainEntry)

    def _selectComboboxEntry(self, combobox, entry):
        combobox.set_active(entry)
    
    def testDriverChanges1(self):
        '''Main window and quit with broken xorg.conf'''
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Device"
	Identifier     "Configured Video Device 0"
EndSection

Section "Device"
	Identifier     "Configured Video Device 1"
EndSection

'''
        self._startWithCustomConfFile(confFile)
        gobject.timeout_add(2000, self._clickQuit)
        gobject.timeout_add(1000, self._clickAnyEntry, confFile)
        self._startGtkLoop()
        
        self.assertRaises(XKit.xorgparser.OptionException,
                          self.ui.xorg.xparser.getDriver, 'Device', 0)
        self.assertRaises(XKit.xorgparser.SectionException,
                          self.ui.xorg.xparser.getDriver, 'Device', 1)

    def testDriverChanges2(self):
        '''Main window and quit with broken xorg.conf'''
        confFile = open(tempFile, 'w')
        print >> confFile, '''
Section "Device"
	Identifier     "Configured Video Device 0"
EndSection

Section "Device"
	Identifier     "Configured Video Device 1"
EndSection

'''
        self._startWithCustomConfFile(confFile)
        gobject.timeout_add(2000, self._clickQuit)
        gobject.timeout_add(1000, self._clickAnyEntry, confFile)
        gobject.timeout_add(1000, self._selectComboboxEntry, self.ui.driver_combobox, 1)
        self._startGtkLoop()
        
        self.assert_(self.ui.xorg.xparser.getDriver('Device', 0) != 'fbdev')



if __name__ == '__main__':
    unittest.main()
    
