# -*- coding: utf-8 -*-
# License:: GPL
# Author:: Alberto Milone (aka tseliot) (mailto:albertomilone@alice.it)
# Website:: http://albertomilone.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import gettext

class XorgOptionsEditorStrings(object):
    def __init__(self):
        gettext.textdomain('xorg-options-editor')#, unicode=True)
        self.init_strings()
    
    
    def init_strings(self):
        self.main_treeview_column_header_1 = self._('Option')
        self.main_treeview_column_header_2 = self._('Value')
        
        self.dbus_connection_error = self._('Could not connect to XorgOptionsEditor DBUS service.')
        self.operation_complete_success = self._('Operation complete. You will have to restart the Xserver in order to apply your settings.')
        self.operation_complete_failure = self._('X.org Options Editor can\'t apply your settings.')
        
        self.option_validation_error = self._('Error: entered value is not\n suitable for the option')

        self.driver_label = self._('Driver')#bold
        # Screen identifier
        self.screen_identifier_label = self._('Screen')#bold
        
        self.main_title = self._('X.org Options Editor')
        
        self.dlg_selected_option = self._('Selected option')
        
        self.categories = self._('Categories')
        # translators: the result will look like 'Enter the value to assign to NAME_OF_THE_OPTION:'
        self.enter_value_request = self._('Enter the value to assign to')
        
        self.select_option_request = self._('Select an option')
        
        self.edit_xorg_config = self._('Edit X.org Configuration')
        
        self.privileges_notification = self._('Editing the X.org configuration requires privileges.')
        
        self.edit_option_dialog_title = self._('Edit')
        
        self.full_options_dialog_title = self._('Add')
        
    def _(self, str, convert_keybindings=False):
        '''Keyboard accelerator aware gettext() wrapper.
        
        This optionally converts keyboard accelerators to the appropriate
        format for the frontend.

        All strings in the source code should use the '_' prefix for key
        accelerators (like in GTK). For inserting a real '_', use '__'.
        '''
        # KDE compatible conversion
        result = unicode(gettext.gettext(str), 'UTF-8')

#        if convert_keybindings:
#            result = self.convert_keybindings(result)

        return result
