#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>
#include <glib.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "configfile.h"

#include "spc-config.h"
#include "spc-util.h"

spc_cfg_t spc_cfg;

/****************************************************************************/

void spc_cfg_read(void) {
	ConfigFile *cfg;
	gchar *filename, *tmp;

	spc_cfg.default_loop_length = (3*60+0)*32000;
	spc_cfg.default_fade_length = (0*60+10)*32000;

	spc_cfg.playtime_style = PTS_LOOP_COUNT;
	spc_cfg.loop_count = 1;
	spc_cfg.loop_mintime = (3*60+0)*32000;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/openspc.conf", NULL);
	cfg = xmms_cfg_open_file(filename);

	if (cfg) {
		tmp = NULL;
		xmms_cfg_read_string(cfg, "Plugin", "playtime_style", &tmp);
		if (!tmp) {
			/* Don't do a thing */
		} else if (!strcasecmp(tmp, "loop-count")) {
			spc_cfg.playtime_style = PTS_LOOP_COUNT;
		} else if (!strcasecmp(tmp, "loop-forever")) {
			spc_cfg.playtime_style = PTS_LOOP_FOREVER;
		} else if (!strcasecmp(tmp, "loop-minimum-time")) {
			spc_cfg.playtime_style = PTS_LOOP_MINTIME;
		}

		xmms_cfg_read_int(cfg, "Plugin", "loop_count", &spc_cfg.loop_count);
		xmms_cfg_read_int(cfg, "Plugin", "loop_mintime", &spc_cfg.loop_mintime);

		xmms_cfg_read_int(cfg, "id666", "default_loop_length", &spc_cfg.default_loop_length);
		xmms_cfg_read_int(cfg, "id666", "default_fade_length", &spc_cfg.default_fade_length);
		
		xmms_cfg_free(cfg);
	}

	g_free(filename);
}

void spc_cfg_write(void) {
	ConfigFile *cfg;
	gchar *filename, *tmp;

	filename = g_strconcat(g_get_home_dir(), "/.xmms/openspc.conf", NULL);
	cfg = xmms_cfg_open_file(filename);
	if (!cfg) cfg = xmms_cfg_new();

	switch (spc_cfg.playtime_style) {
		case PTS_LOOP_COUNT:	tmp = "loop-count"; break;
		case PTS_LOOP_FOREVER:	tmp = "loop-forever"; break;
		case PTS_LOOP_MINTIME:	tmp = "loop-minimum-time"; break;
	}
	xmms_cfg_write_string(cfg, "Plugin", "playtime_style", tmp);
	xmms_cfg_write_int(cfg, "Plugin", "loop_count", spc_cfg.loop_count);
	xmms_cfg_write_int(cfg, "Plugin", "loop_mintime", spc_cfg.loop_mintime);

	xmms_cfg_write_int(cfg, "id666", "default_loop_length", spc_cfg.default_loop_length);
	xmms_cfg_write_int(cfg, "id666", "default_fade_length", spc_cfg.default_fade_length);

	xmms_cfg_write_file(cfg, filename);
	xmms_cfg_free(cfg);
	g_free(filename);
}

/****************************************************************************/

static GtkWidget *config_win;

static void conf_destroy(GtkWidget *w, gpointer data) {
	config_win = NULL;
}

static void conf_ok(GtkWidget *w, gpointer data) {
	spc_cfg_write();
	gtk_widget_destroy(config_win);
}

static void conf_cancel(GtkWidget *w, gpointer data) {
	spc_cfg_read();
	gtk_widget_destroy(config_win);
}

static void conf_playstyle_loop_count(GtkWidget *w, gpointer data) {
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
		spc_cfg.playtime_style = PTS_LOOP_COUNT;
}

static void conf_playstyle_loop_mintime(GtkWidget *w, gpointer data) {
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
		spc_cfg.playtime_style = PTS_LOOP_MINTIME;
}

static void conf_playstyle_loop_forever(GtkWidget *w, gpointer data) {
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
		spc_cfg.playtime_style = PTS_LOOP_FOREVER;
}

void spc_configure(void) {
	GtkWidget *wbox, *frame, *radio, *vbox, *hbox, *widget;
	GSList *radiogroup;

	if (config_win)
		return;

	/* Race condition exists here.  I don't care. :) */

	config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(config_win), "destroy", GTK_SIGNAL_FUNC(conf_destroy), NULL);
	gtk_window_set_title(GTK_WINDOW(config_win), PACKAGE " configuration");
	gtk_container_set_border_width(GTK_CONTAINER(config_win), 5);

	wbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(config_win), wbox);

	/**/

	frame = gtk_frame_new("id666");
	gtk_box_pack_start(GTK_BOX(wbox), frame, FALSE, FALSE, 0);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	hbox = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
	widget = gtk_label_new("Default loop length");
	gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, FALSE, 0);
	widget = util_widget_entry_time(&spc_cfg.default_loop_length);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, FALSE, 0);
	widget = gtk_label_new("Default fade length");
	gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, FALSE, 0);
	widget = util_widget_entry_time(&spc_cfg.default_fade_length);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	/**/
	
	frame = gtk_frame_new("Looping");
	gtk_box_pack_start(GTK_BOX(wbox), frame, FALSE, FALSE, 0);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	radio = gtk_radio_button_new(NULL);
	gtk_signal_connect(GTK_OBJECT(radio), "toggled", GTK_SIGNAL_FUNC(conf_playstyle_loop_count), NULL);
	gtk_box_pack_start(GTK_BOX(vbox), radio, FALSE, FALSE, 0);
	hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(radio), hbox);
	widget = gtk_label_new("Loop ");
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	widget = util_widget_entry_number(&spc_cfg.loop_count, 0, INT_MAX, 40);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	widget = gtk_label_new(" time(s)");
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	radio = gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON(radio));
	gtk_signal_connect(GTK_OBJECT(radio), "toggled", GTK_SIGNAL_FUNC(conf_playstyle_loop_mintime), NULL);
	gtk_box_pack_start(GTK_BOX(vbox), radio, FALSE, FALSE, 0);
	hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(radio), hbox);
	widget = gtk_label_new("Loop until ");
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	widget = util_widget_entry_time(&spc_cfg.loop_mintime);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);
	widget = gtk_label_new(" has passed");
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	radio = gtk_radio_button_new_from_widget(GTK_RADIO_BUTTON(radio));
	gtk_signal_connect(GTK_OBJECT(radio), "toggled", GTK_SIGNAL_FUNC(conf_playstyle_loop_forever), NULL);
	gtk_box_pack_start(GTK_BOX(vbox), radio, FALSE, FALSE, 0);
	hbox = gtk_hbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(radio), hbox);
	widget = gtk_label_new("Loop Forever");
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	/**/

	hbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(hbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);
	gtk_box_pack_start(GTK_BOX(wbox), hbox, TRUE, TRUE, 0);

	widget = gtk_button_new_with_label("Ok");
	gtk_signal_connect(GTK_OBJECT(widget), "clicked", GTK_SIGNAL_FUNC(conf_ok), NULL);
	GTK_WIDGET_SET_FLAGS(widget, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	widget = gtk_button_new_with_label("Cancel");
	gtk_signal_connect(GTK_OBJECT(widget), "clicked", GTK_SIGNAL_FUNC(conf_cancel), NULL);
	GTK_WIDGET_SET_FLAGS(widget, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 0);

	/**/

	gtk_widget_show_all(config_win);
}

