%define rel 1
%define prefix /usr
%define confdir /etc
%define statedir /var

Summary: A tool for defining, selecting and indicating XKB keyboards
Name: xkbsel
Version: 0.13
Release: %{rel}
Copyright: GPL
Group: User Interface/Desktops
Source: ftp://ftp.penguin.cz/pub/users/stano/i18n/%{name}-%{version}.tar.gz
URL: ftp://ftp.penguin.cz/pub/users/stano/i18n/%{name}-%{version}.tar.gz
Requires: XFree86
Buildroot: /var/tmp/%{name}-root

%description
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the maintenance application
the command-line tool and the simple Xaw GUI tool.

%prep
if [ ! "${RPM_BUILD_ROOT}" = "/" ]; then
  rm -rf "${RPM_BUILD_ROOT}" ;
fi
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure --with-kde --with-gnome --with-wmaker \
	--prefix=%{prefix} --sysconfdir=%{confdir} \
	--localstatedir=%{statedir}
make

%install
make prefix=$RPM_BUILD_ROOT%{prefix} sysconfdir=$RPM_BUILD_ROOT%{confdir} \
	localstatedir=$RPM_BUILD_ROOT%{statedir} install-strip

%clean
if [ ! "${RPM_BUILD_ROOT}" = "/" ]; then
  rm -rf "${RPM_BUILD_ROOT}" ;
fi

%package common
Summary: A tool for defining, selecting and indicating XKB keyboards
Group: User Interface/Desktops
Requires: XFree86

%description common
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the maintenance application
the command-line tool and the simple Xaw GUI tool.

%post common
/usr/bin/xkbseldb -R

%preun common
rm -rf %{statedir}/%{name}/compiled/*
rm -f %{statedir}/%{name}/xkbseldb.*


%package devel
Summary: Header files and libraries for developing xkbsel applications
Group: Development/Libraries
Requires: xkbsel-common XFree86-devel

%description devel
Header files and libraries for developing selectors
and indicators in the xkbsel framework.

%package kde
Summary: Dockable XKB keyboard selector and indicator for KDE
Group: User Interface/Desktops
Requires: xkbsel-common kdebase

%description kde
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the dockable selector
and indicator for kpanel.

%package gnome
Summary: XKB keyboard selector and indicator applet for Gnome
Group: User Interface/Desktops
Requires: xkbsel-common gnome-core

%description gnome
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the dockable selector
and indicator applet for the Gnome panel.

%package wmaker
Summary: XKB keyboard selector and indicator applet for Window Maker
Group: User Interface/Desktops
Requires: xkbsel-common gtk+

%description wmaker
xkbsel is a framework for defining, selecting and
indicating XKB keyboard mappings, without the need
to modify X11 distribution in any way.

This package contains the dockable selector
and indicator applet for the Window Maker.

The code was contributed by Kaspar Toomik <kt@personalchemistry.com>.

%files common
%defattr(-, root, root)

%doc ABOUT-NLS AUTHORS COPYING ChangeLog INSTALL NEWS README TODO
%{prefix}/bin/xkbseldb
%{prefix}/bin/xkbsel
%{prefix}/bin/xkbsel-aw
%{prefix}/man
%{prefix}/share/xkbsel
%{prefix}/share/locale
%{statedir}
%config %{confdir}/xkbsel.conf

%files devel
%defattr(-, root, root)
%{prefix}/lib
%{prefix}/include
%doc COPYING AUTHORS NEWS doc/protocol.txt

%files kde
%defattr(-, root, root)
%{prefix}/bin/xkbsel-kde
%{prefix}/share/applnk/Utilities/xkbsel-kde.kdelnk

%files gnome
%defattr(-, root, root)
%{prefix}/bin/xkbsel_gnome_applet
%{prefix}/share/applets/Utility/xkbsel_gnome_applet.desktop
%{confdir}/CORBA/servers/xkbsel_gnome_applet.gnorba

%files wmaker
%defattr(-, root, root)
%{prefix}/bin/wmxkbsel

%changelog
* Sun Apr 9 2000 Stanislav Meduna <stano@trillian.eunet.sk>
- version 0.13 released
* Sun Jul 25 1999 Stanislav Meduna <stano@trillian.eunet.sk>
- first public version

