#ifndef XIMP3_H
#define XIMP3_H

#define BS_BUFBYTES 60000U
#define PCM_BUFBYTES (1152 * 4 * 4)
#define TOT_PLAYBUFS 30


typedef struct {
    char pcm[PCM_BUFBYTES];
    int size;
    int in_bytes;
    int frames;
} PLAYBUF;


typedef struct {
/*****  misc stuff  *****/
    char device[40];
    int audio_fd;
    int audio_bufsize;
    char **flist;
    int flist_size;
    int *shuffle_ord;
    int shuffle;
    int loop;
    int verbose;
    int remote;
    int bytes_sec;
    int sfds[2];
    int pid, ppid;
    int retval;
    
/******  bitstream buffer  *****/
    unsigned char *bs_buffer;
    unsigned char *bs_bufptr;
    int bs_trigger;
    int bs_bufbytes;

/********  play buffers  ********/
    PLAYBUF *playbufs;
    int tot_playbufs, n_playbufs;
    int playbuf, addbuf;
    int playing;
} VARS;


extern VARS *v;

#endif
