/* xfkc.c
 * Copyright (C) 2006 Gauvain Pocentek <gauvainpocentek@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include <gtk/gtk.h>
#include <libxklavier/xklavier.h>
#include <libxfce4util/libxfce4util.h>
#include <glib.h>

#include "xfkc.h"

#define XFKC_RC_FILE "xfce4/xfkc/xfkcrc"

void load_default_settings ()
{
	xkl_config_rec_get_from_server (user_rec_config, engine);
	
	xfkc_settings->use_X_config = 1;
	
	xfkc_settings->layouts = g_strjoinv(",", user_rec_config->layouts);
	xfkc_settings->variants = g_strjoinv(",", user_rec_config->variants);
	xfkc_settings->model = user_rec_config->model;
}

void write_settings_in_rc_file ()
{
	XfceRc * conf;
	
	conf = xfce_rc_simple_open (config_file, FALSE);
	xfce_rc_write_int_entry (conf, "use_X_config",
								xfkc_settings->use_X_config);
	xfce_rc_write_entry (conf, "model",
								xfkc_settings->model);
	xfce_rc_write_entry (conf, "layouts",
								xfkc_settings->layouts);
	xfce_rc_write_entry (conf, "variants",
								xfkc_settings->variants);
								
	xfce_rc_close (conf);
}

void read_settings_in_rc_file ()
{
	XfceRc * conf;
	
	conf = xfce_rc_simple_open (config_file, TRUE);
	
	xfkc_settings->use_X_config = xfce_rc_read_int_entry (conf, "use_X_config", 1);
	xfkc_settings->model = g_strdup (xfce_rc_read_entry (conf, "model", "test"));
	xfkc_settings->layouts = g_strdup (xfce_rc_read_entry (conf, "layouts", "test"));
	xfkc_settings->variants = g_strdup (xfce_rc_read_entry (conf, "variants", "test"));
	xfce_rc_close (conf);
}

void
store_settings_in_user_rec ()
{
	user_rec_config->model = xfkc_settings->model;
	user_rec_config->layouts = g_strsplit_set(xfkc_settings->layouts, ",", 0);
	user_rec_config->variants = g_strsplit_set(xfkc_settings->variants, ",", 0);
}

void set_config ()
{
	if (xfkc_settings->use_X_config == 0)
	{
		store_settings_in_user_rec ();
		xkl_config_rec_activate (user_rec_config, engine);
	}
}

void xfkc_init ()
{	
	dsp = XOpenDisplay(NULL);
	g_type_init();
	engine = xkl_engine_get_instance (dsp);
	
	xfkc_settings = g_new0(xfkcConfig, 1);
	
	user_rec_config = xkl_config_rec_new ();
	registry = xkl_config_registry_get_instance (engine);
	xkl_config_registry_load (registry);

	config_file = xfce_resource_save_location(XFCE_RESOURCE_CONFIG, XFKC_RC_FILE, TRUE);
	rc_file = xfce_rc_simple_open(config_file, TRUE);
	if (rc_file == NULL)
	{
		load_default_settings ();
		write_settings_in_rc_file ();
	}
	else
		read_settings_in_rc_file ();
	store_settings_in_user_rec ();
}

int
main( int argc, char *argv[] )
{
	xfce_textdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR, "UTF-8");

	xfkc_init ();

	if ((argc > 1) && (strcmp(argv[1], "--apply") == 0))
		set_config ();
	else
	{
		gtk_set_locale ();
		gtk_init (&argc, &argv);
		define_dialog ();
		gtk_main ();
	}

	return 0;
}
