/*
 * Copyright (C) 2007 Gauvain Pocentek <gpocentek@linutop.com>
 * 
 * Mostly taken from the gsynaptics mcs plugin
 * Copyright (c) 2004 Danny Milosavljevic <danny_milo@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; You may only use version 2 of the License,
 * you have no option to use any other version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-manager.h>
#include <xfce-mcs-manager/manager-plugin.h>

#define EXE "scim-setup"
#define ICON "scim-setup"

/* static prototypes */
static void run_dialog (McsPlugin *);

/*
 */
McsPluginInitResult
mcs_plugin_init (McsPlugin * plugin)
{
	gchar *where = NULL;

	xfce_textdomain (GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

	plugin->plugin_name = g_strdup ("scim");
	plugin->caption = g_strdup (Q_("Button Label|Scim Input"));
	plugin->run_dialog = run_dialog;
	plugin->icon = xfce_themed_icon_load (ICON, 32);
	if (plugin->icon)
		g_object_set_data_full (G_OBJECT (plugin->icon),
		                        "mcs-plugin-icon-name",
					g_strdup (ICON),
					g_free);

	where = g_find_program_in_path (EXE);
	if (where)
	{
		g_free (where);
		return (MCS_PLUGIN_INIT_OK);
	}

	g_free (where);
	return (MCS_PLUGIN_INIT_ERROR);
}

/*
 *  */
static void
run_dialog (McsPlugin * plugin)
{
	xfce_exec(EXE, FALSE, FALSE, NULL);
}
	
