#ifdef HAVE_SYS_EVTCHN_H
# include <xen/sys/evtchn.h>
#else
# include <xen/linux/evtchn.h>
#endif

#define EVTCHND_PORT 26547
#define EVTCHND_PATH "/var/run/evtchnd"

/* send ioctls over socket */
struct evtchn_ioctl_msg {
    uint8_t  data[32 - sizeof(uint32_t)*3];
    uint32_t ioctl;
    uint32_t retval;
    uint32_t error;
};

/* evtchnd signaling */
#define EVTCHND_DOMID   _IOC(_IOC_NONE, 'E', 0x20, sizeof(struct evtchnd_domid))
#define EVTCHND_NOTIFY	_IOC(_IOC_NONE, 'E', 0x21, sizeof(struct evtchnd_port))
#define EVTCHND_UNMASK	_IOC(_IOC_NONE, 'E', 0x22, sizeof(struct evtchnd_port))
struct evtchnd_domid {
        unsigned int domid;
};
struct evtchnd_port {
        unsigned int port;
};
