/* Copyleft (C) 1994 Software Research Academy Japan.
 * 
 * $Id: xeji.c,v 1.3 94/05/09 00:25:54 yoneyama Exp $
 */
#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#ifdef XPM
/*#include <X11/xpm.h>*/
#include </usr/local/X11R5/include/xpm.h>
#include "eji.xpm"
#endif /* XPM */
#include "eji.xbm"
#include "ejimask.xbm"

#define L_CENTER_X1   67
#define L_CENTER_Y1   88
#define R_CENTER_X1   122
#define R_CENTER_Y1   88
#define EYE_SIZE      11
#define EYE_MOVER_X   7
#define EYE_MOVER_Y   3
#define TMP_X         L_CENTER_X1 - EYE_MOVER_X - EYE_SIZE / 2
#define TMP_Y         L_CENTER_Y1 - EYE_MOVER_Y - EYE_SIZE / 2
#define TMP_WIDTH     R_CENTER_X1 + EYE_MOVER_X * 2 + EYE_SIZE - L_CENTER_X1 + 1
#define TMP_HEIGHT    EYE_MOVER_Y * 2 + EYE_SIZE + 1
  
char            *programname = "XEJI";
char            *displayname = NULL;
Display	        *display;
int	        screen;
unsigned int    defaultdepth;
Window	        root;
Window	        ejiwin;
GC              gc;
Pixmap          ejimask, xeji;
Pixmap          tmpxpm;

int             shapeok = True;
int             mono    = False;

int             rootwidth;
int             rootheight;
unsigned long   black;
unsigned long   white;

void geteyepos(int *, int *, int, int, int, int);
void DrawEyes(int, int, int, int);


void usage()
{
  printf("Usage: xeji [-noshape] [-mono] [-display <display>]\n");
  exit(0);
}


int main(argc, argv)
int  argc;
char *argv[];
{
  unsigned int mask;
  Window dw, cw;
#ifdef XPM  
  XpmAttributes xpm_attributes;
#endif /* XPM */
  XWindowAttributes winfo;
  int dx, dy, mx, my;
  int olx1, oly1, orx1, ory1;
  int nlx1, nly1, nrx1, nry1;
  int ejiposi = 0;
  XGCValues		gcval;
  XEvent e;
  XSetWindowAttributes winattr;
  XSizeHints           shints;
  unsigned long	       winmask;
  int		       event_base, error_base;
  int i;
  
  /* option check */
  if(argc >= 2) {
    for(i=1;i<argc;i++) {
      if(strcmp(argv[i],"-display") == 0 && i < argc - 1) {
        i++;
      	displayname = argv[i];
      }
      else if(strcmp(argv[i],"-noshape") == 0) {
      	shapeok = False;
      }
      else if(strcmp(argv[i],"-mono") == 0) {
      	mono = True;
      }
      else {
        usage();
      }
    }
  }  

  if ((display = XOpenDisplay(displayname)) == NULL) {
    fprintf(stderr, "%s: Can't open display", programname);
    if (displayname != NULL) {
      fprintf(stderr, " %s.\n", displayname);
    } else {
      fprintf(stderr, ".\n");
    }
    exit(1);
  }
  
  if(shapeok == True)
    if(XShapeQueryExtension(display, &event_base, &error_base) == False)
      shapeok = False;
  
  screen = DefaultScreen(display);
  defaultdepth = DefaultDepth(display, screen);
  
  root = RootWindow(display, screen);
  
  rootwidth  = DisplayWidth(display, screen);
  rootheight = DisplayHeight(display, screen);
  
  if(shapeok == True) 
    winattr.override_redirect = True;
  else
    winattr.override_redirect = False;
  winmask = CWOverrideRedirect;
  
  ejiwin = XCreateWindow(display, root, 0, rootheight - ejimask_height,
			    ejimask_width, ejimask_height,
			    0, defaultdepth, InputOutput, CopyFromParent,
			    winmask, &winattr);
  tmpxpm = XCreatePixmap(display, root, TMP_WIDTH, TMP_HEIGHT, defaultdepth);
  
  XStoreName(display, ejiwin, programname);
  if(shapeok == False) {
    shints.max_width  = ejimask_width;
    shints.max_height = ejimask_height;
    shints.flags = PMaxSize;
    XSetNormalHints(display, ejiwin, &shints);
  }
  
  XMapWindow(display, ejiwin);

  black = BlackPixel(display, screen);
  white = WhitePixel(display, screen);
  
  gcval.function = GXcopy;
  gcval.foreground = black;
  gcval.background = white;
  gcval.fill_style = FillTiled;
  gcval.ts_x_origin = 0;
  gcval.ts_y_origin = 0;
  
  gc  = XCreateGC(display, ejiwin,
		     GCFunction | GCForeground | GCBackground | 
		     GCTileStipXOrigin | GCTileStipYOrigin | GCFillStyle,
		     &gcval);
  
  ejimask = XCreateBitmapFromData(display, root,
				  (char *)ejimask_bits,
		ejimask_width, ejimask_height);
  if(shapeok == True)
    XShapeCombineMask(display, ejiwin, ShapeBounding,
                      0, 0, ejimask, ShapeSet);
  
  XMapRaised(display, ejiwin);
  
  XGetWindowAttributes(display, root, &winfo);
  xpm_attributes.colormap = winfo.colormap;
  xpm_attributes.valuemask = XpmSize | XpmReturnPixels | XpmColormap;
  
#ifdef XPM
  if(mono == False)
/*    XpmCreatePixmapFromData(display, root, (char **)&eji ,&xeji, */
    XpmCreatePixmapFromData(display, root, (char **)eji ,&xeji, 
                            NULL,  &xpm_attributes);
  else
    xeji = XCreatePixmapFromBitmapData(display, root, (char *)eji_bits,
                  eji_width, eji_height, black, white, defaultdepth);
#else  /* !XPM */
  xeji = XCreateBitmapFromData(display, root, (char *)eji_bits,
                               eji_width, eji_height);
#endif /* XPM */
  
  XSetWindowBackgroundPixmap(display, ejiwin, xeji);
  
#ifndef X11R4
  XClearWindow(display, ejiwin);
#else /* !X11R4 */
  XCopyArea(display, xeji, ejiwin, gc, 0, 0,
	    ejimask_width, ejimask_height,0, 0);
#endif /* X11R4 */
  
  XSelectInput(display, ejiwin, ExposureMask | ButtonPressMask |
               VisibilityChangeMask);
  XSelectInput(display, root, PointerMotionMask);
  
  XQueryPointer(display, ejiwin, &dw, &cw, &dx, &dy, &mx, &my, &mask);
  geteyepos(&nlx1, &nly1, L_CENTER_X1, L_CENTER_Y1, mx, my);
  geteyepos(&nrx1, &nry1, R_CENTER_X1, R_CENTER_Y1, mx, my);
  olx1 = nlx1; oly1 = nly1;
  orx1 = nrx1; ory1 = nry1;

  DrawEyes(EYE_MOVER_X * 2 + nlx1, EYE_MOVER_Y * 2 + nly1,
           EYE_MOVER_X * 2 + (R_CENTER_X1 - L_CENTER_X1) + nrx1,
           EYE_MOVER_Y * 2 + nry1);
  
  XFlush(display);
  
  while(1) {

    XNextEvent(display, &e);
    
    switch(e.type) {
    case ButtonPress:
      if(shapeok == False) break;
      if(ejiposi == 0) {
        for(i = ejiposi; i < rootwidth - ejimask_width;
            i += (rootwidth - ejimask_width) / 5) {
          XMoveWindow(display, ejiwin, i, rootheight - ejimask_height);
          XFlush(display);
        }
        ejiposi = rootwidth - ejimask_width;
        XMoveWindow(display, ejiwin, ejiposi, rootheight - ejimask_height);
      }
      else {
      	for(i = ejiposi; i > 0; i -= (rootwidth - ejimask_width) / 5) {
      	  XMoveWindow(display, ejiwin, i, rootheight - ejimask_height);
      	  XFlush(display);
      	}
      	ejiposi = 0;
        XMoveWindow(display, ejiwin, ejiposi, rootheight - ejimask_height);
      }
    case VisibilityNotify:
      if(shapeok == False) break;
      XRaiseWindow(display, ejiwin);
    case Expose:
#ifdef X11R4
	XSetFunction(display,  gc, GXcopy);
	XCopyArea(display, xeji, ejiwin, gc,
	0, 0, ejimask_width, ejimask_height,0,0);
#endif /* X11R4 */
    case MotionNotify:
      olx1 = nlx1; oly1 = nly1;
      orx1 = nrx1; ory1 = nry1;
      XQueryPointer(display, ejiwin, &dw, &cw, &dx, &dy, &mx, &my, &mask);
      geteyepos(&nlx1, &nly1, L_CENTER_X1, L_CENTER_Y1, mx, my);
      geteyepos(&nrx1, &nry1, R_CENTER_X1, R_CENTER_Y1, mx, my);
      DrawEyes(EYE_MOVER_X * 2 + nlx1, EYE_MOVER_Y * 2 + nly1,
               EYE_MOVER_X * 2 + (R_CENTER_X1 - L_CENTER_X1) + nrx1,
               EYE_MOVER_Y * 2 + nry1);
      break;
    }
    XFlush(display);
  }
}


void DrawEyes(nlx, nly, nrx, nry)
int nlx, nly, nrx, nry;
{
    XSetFunction(display, gc, GXcopy);
    XCopyArea(display, xeji, tmpxpm, gc, TMP_X, TMP_Y,
              TMP_WIDTH, TMP_HEIGHT, 0, 0);

    XSetForeground(display, gc, black);
    XSetFunction(display, gc, GXset);
    XFillArc(display, tmpxpm, gc, nlx - EYE_SIZE / 2, nly - EYE_SIZE / 2,
             EYE_SIZE, EYE_SIZE, 0, 360*64);
    XSetFunction(display, gc, GXclear);
    XFillArc(display, tmpxpm, gc, nlx+2 - EYE_SIZE / 2, nly+2 - EYE_SIZE / 2,
             3, 3, 0, 360*64);

    XSetForeground(display, gc, black);
    XSetFunction(display, gc, GXset);
    XFillArc(display, tmpxpm, gc, nrx - EYE_SIZE / 2, nry - EYE_SIZE / 2,
             EYE_SIZE, EYE_SIZE, 0, 360*64);
    XSetFunction(display, gc, GXclear);
    XFillArc(display, tmpxpm, gc, nrx+2 - EYE_SIZE / 2, nry+2 - EYE_SIZE / 2,
             3, 3, 0, 360*64);

    XSetFunction(display, gc, GXcopy);
    XCopyArea(display, tmpxpm, ejiwin, gc, 0, 0, TMP_WIDTH, TMP_HEIGHT,
              TMP_X, TMP_Y);
}


void geteyepos(retx, rety, bx, by, mx, my)
int *retx, *rety;
int bx, by, mx, my;
{
  int rx, ry;
  int x, y;
  double th;
  
  rx = mx - bx;
  ry = my - by;
  if(sqrt(rx * rx + ry * ry) <= EYE_MOVER_Y) {
    *retx = rx;
    *rety = ry;
    return;
  }
  if(rx == 0) {
    rx = 1;
  }
  th = fabs(atan((double)ry / (double)rx));
  x = (int)((double)EYE_MOVER_X * cos(th));
  y = (int)((double)EYE_MOVER_Y * sin(th));
  if(rx < 0 ) *retx = (-x);
  else        *retx = x;
  if(ry < 0)  *rety = (-y);
  else        *rety = y;

  return;
}
