#include "xdvi-config.h"
#include "xdvi.h"
#include "kpathsea/c-vararg.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "run_tests.h"

#include "string-utils.h"

#define DEBUG 0

static Boolean test_get_extension(int verbose)
{
    const char *test_strings[][2] = {
	{ "/dev/fd/3", NULL },
	{ "/home/user/file.dvi", ".dvi" },
	{ "/home/user/file.ps", ".ps" },
	{ "/home/user.bar/file.dvi", ".dvi" },
	{ "/home/user.bar/file", NULL },
	{ "/home/user/file", NULL },
	{ NULL, NULL }
    };

    size_t i;
    
    for (i = 0; test_strings[i][0] != NULL; i++) {
	const char *tmp = get_extension(test_strings[i][0]);
	if (tmp == NULL && test_strings[i][1] == NULL) {
	    if (verbose)
		INFO((stderr, "Checking extension of |%s| OK: <NULL> == <NULL>\n", test_strings[i][0]));
	}
	else if (tmp == NULL && test_strings[i][1] != NULL) {
	    if (verbose)
		ERROR((stderr, "extension of |%s| gave <NULL> - should be |%s|\n",
		       test_strings[i][0], test_strings[i][1]));
	    return False;
	}
	else if (tmp != NULL && test_strings[i][1] == NULL) {
	    if (verbose)
		ERROR((stderr, "extension of |%s| gave |%s| - should be <NULL>\n",
		       test_strings[i][0], tmp));
	    return False;
	}
	else {
	    if (strcmp(tmp, test_strings[i][1]) != 0) {
		if (verbose)
		    ERROR((stderr, "ERROR: extension of |%s| gave |%s| - should be |%s|\n",
			   test_strings[i][0], tmp, test_strings[i][1]));
		return False;
	    }
	    else {
		if (verbose)
		    INFO((stderr, "Checking extension of |%s| OK: |%s| == |%s|\n",
			  test_strings[i][0], tmp, test_strings[i][1]));
	    }
	}
    }

    return True;
}

void register_all_from_test_string_utils(void)
{
    register_test(test_get_extension, "Filename extensions");
}
