 /*
 * file      : win_pulse.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>

#include "callbacks.h"

#include <string.h>

#include "global.h"
#include "win_pulse.h"
#include "win_control.h"
#include "secu.h"
#include "utils.h"



/*
*--------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {
	GtkWidget	*Adr_win;				/* Adresse fenetre                    */
	gboolean	 Bool;
	GtkWidget	*Adr_labeltitle;			/* Adresse du label                   */
	GtkWidget	*Adr_labelfile;				/* Adresse du label                   */
	GtkWidget	*Adr_progressbar;			/* Adresse progressbar                */
	guint		 Handler_Timeout;			/* Numero Timeout                     */
	gboolean	 typeispulse;				/* TRUE is PULSE else PROGRESS        */
	guint		 ElemTotal;				/* Nombre total d'elements            */
	gboolean	 event_close;				/* Fermeture de la fenetre            */
	gboolean	 event_set_close;			/* Demande de fermeture de la fenetre */
	gboolean	 event_init_progress;			/* Transforme en PROGRESSBAR          */
	gboolean	 event_init_pulse;			/* Transforme en PULSEBAR             */
	gchar		*wintitle;				/* Chaine titre                       */
	gchar		*labeltitle;				/* Chaine label-titre                 */
	gboolean	 bool_labelfile;			/* TRUE*/
	gchar		*labelfile;				/* Chaine label-fichier               */
	gdouble		 percent;				/* Pourcentage                        */
	gchar		*strpercent;				/* Chaine pourcentage                 */

} VAR_PULSE;

VAR_PULSE winpulse;

/*
*---------------------------------------------------------------------------
* REALIZE WINDOW
*---------------------------------------------------------------------------
*/

gboolean on_wind_pulse_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	winpulse.event_set_close = TRUE;
	return TRUE;
}
gboolean on_wind_pulse_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	winpulse.event_set_close = TRUE;
	return TRUE;
}
void on_progressbar_wind_pulse_realize (GtkWidget *widget, gpointer user_data)
{
	winpulse.Adr_progressbar = widget;
}
void on_label_titre_wind_pulse_realize (GtkWidget *widget, gpointer user_data)
{
	winpulse.Adr_labeltitle = widget;
}
void on_label_track_wind_pulse_realize (GtkWidget *widget, gpointer user_data)
{
	winpulse.Adr_labelfile = widget;
}
void on_button_cancel_wind_pulse_realize (GtkButton *button, gpointer user_data)
{
	winpulse.event_set_close = TRUE;
}



/*
*---------------------------------------------------------------------------
* TIMEOUT
*---------------------------------------------------------------------------
*/

static gint call_timeout_winpulse (gpointer data)
{
	if (winpulse.strpercent) {
		gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (winpulse.Adr_progressbar), winpulse.percent);
		gtk_progress_bar_set_text (GTK_PROGRESS_BAR (winpulse.Adr_progressbar), winpulse.strpercent);
		g_free (winpulse.strpercent);
		winpulse.strpercent = NULL;
	}
	if (winpulse.event_init_pulse) {
		winpulse.event_init_pulse = FALSE;
		gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (winpulse.Adr_progressbar), GTK_PROGRESS_DISCRETE);
	}
	else if (winpulse.event_init_progress) {
		winpulse.event_init_progress = FALSE;
		gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (winpulse.Adr_progressbar), GTK_PROGRESS_CONTINUOUS);
	}
	else if (winpulse.wintitle) {
		gtk_window_set_title (GTK_WINDOW (winpulse.Adr_win), winpulse.wintitle);
		g_free (winpulse.wintitle);
		winpulse.wintitle = NULL;
	}
	else if (winpulse.labeltitle) {
		gtk_label_set_markup (GTK_LABEL (winpulse.Adr_labeltitle), winpulse.labeltitle);
		g_free (winpulse.labeltitle);
		winpulse.labeltitle = NULL;
	}
	else if (winpulse.labelfile) {
		if (winpulse.bool_labelfile == FALSE) {
			
			winpulse.bool_labelfile = TRUE;
			
			gtk_label_set_markup (GTK_LABEL (winpulse.Adr_labelfile), winpulse.labelfile);
			g_free (winpulse.labelfile);
			winpulse.labelfile = NULL;
			
			winpulse.bool_labelfile = FALSE;
		}
	}
	else if (winpulse.event_close == TRUE) {
		winpulse.event_close = FALSE;
		NEW_wincontrol_realize_window (&winpulse.Adr_win, "wind_pulse", &winpulse.Bool, WIND_IS_SHOW, WIND_USE_STRUCT, WIND_IS_MODAL, WIND_IS_TRANSIENT);
		gtk_timeout_remove (winpulse.Handler_Timeout);
		return (TRUE);
	}
	if (winpulse.typeispulse) {
		gtk_progress_bar_pulse(GTK_PROGRESS_BAR (winpulse.Adr_progressbar));
	}

	return (TRUE);
}

/*
*---------------------------------------------------------------------------
* FUNCTIONS EXTERNES
*---------------------------------------------------------------------------
*/

void winpulse_create (void)
{
	/* Informations programmeur */

	// PRINT_FUNC_LF();
	// if (winpulse.Adr_win == NULL) {
		winpulse.wintitle = NULL;
		winpulse.labeltitle = NULL;
		winpulse.labelfile = NULL;
		winpulse.bool_labelfile = FALSE;
		winpulse.strpercent = NULL;
		winpulse.event_close = FALSE;
		winpulse.event_set_close = FALSE;
		NEW_wincontrol_realize_window (&winpulse.Adr_win, "wind_pulse", &winpulse.Bool, WIND_IS_SHOW, WIND_USE_STRUCT, WIND_IS_MODAL, WIND_IS_TRANSIENT);
		winpulse.Handler_Timeout = gtk_timeout_add (130, call_timeout_winpulse, 0);
	// }
}
void winpulse_close (void)
{
	winpulse.event_close = TRUE;
}
gboolean winpulse_event_set_close (void)
{
	return (winpulse.event_set_close);
}
void winpulse_set_title (gchar *title)
{
	if (winpulse.Adr_win != NULL) {
		if (winpulse.wintitle) {
			g_free (winpulse.wintitle);
			winpulse.wintitle = NULL;
		}
		winpulse.wintitle = g_strdup (title);
	}
}
void winpulse_set_labeltitle (gchar *labeltitle)
{
	if (winpulse.Adr_win != NULL) {
		if (winpulse.labeltitle) {
			g_free (winpulse.labeltitle);
			winpulse.labeltitle = NULL;
		}
		winpulse.labeltitle = g_strdup_printf ("<span font_desc=\"sans 15\"><span color=\"black\"><b>%s</b></span></span>", labeltitle);
	}
}
void winpulse_set_labelfile (gchar *labelfile)
{
	if (winpulse.Adr_win != NULL) {
		if (winpulse.bool_labelfile == FALSE) {
			
			winpulse.bool_labelfile = TRUE;
			
			if (winpulse.labelfile) {
				g_free (winpulse.labelfile);
				winpulse.labelfile = NULL;
			}
			/*winpulse.labelfile = g_strdup_printf ("<i>%s</i>", labelfile);*/
			winpulse.labelfile = g_strdup_printf ("<i>%s</i>", g_markup_escape_text (labelfile, -1));
			
			winpulse.bool_labelfile = FALSE;
		}
	}
}
void winpulse_set_ElemTotal (guint ElemTotal)
{
	winpulse.ElemTotal = ElemTotal;
}
void winpulse_set_elem_actif (guint elem_inc)
{
	if (winpulse.Adr_win != NULL) {
		winpulse.percent = (gdouble)elem_inc / (gdouble)winpulse.ElemTotal;
		if (winpulse.percent < 0.0) winpulse.percent = 0.0;
		if (winpulse.percent > 1.0) winpulse.percent = 1.0;
		if (winpulse.strpercent) {
			g_free (winpulse.strpercent);
			winpulse.strpercent = NULL;
		}
		winpulse.strpercent = g_strdup_printf ("%d sur %d    %d%%", elem_inc, winpulse.ElemTotal, (gint)(winpulse.percent * 100));
	}
}
void winpulse_set_init_pulse (void)
{
	winpulse.event_init_pulse = TRUE;
	winpulse.typeispulse = TRUE;
}
void winpulse_set_init_progress (void)
{
	winpulse.event_init_progress = TRUE;
	winpulse.typeispulse = FALSE;
}




