 /*
 * file    : tags_ogg.c
 * project : xcfa
 * with    : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>
#include "level.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* FILE IS OGG ?
*---------------------------------------------------------------------------
*/
gboolean tagsogg_file_is_ogg (gchar *namefile)
{
	FILE        *fp = NULL;
	size_t       lenread = 0;
	gchar       *buf = NULL;
	gint         cpt;
	gboolean     bool_signature = FALSE;
	
	/*PRINT_FUNC_LF();*/

	if ((buf = (gchar *)g_malloc0 (sizeof(gchar) * 2048)) == NULL) return (FALSE);
	if ((fp = fopen (namefile, "rb")) != NULL) {
		lenread = fread (buf, 1, 2000, fp);
		fclose (fp);
	}
/*
case FILE_IS_OGG :
	Bool_Ret = strstr (Lout, "Ogg data") ? FILE_IS_OGG : FILE_IS_NONE;
	if (Bool_Ret == FILE_IS_OGG) Bool_Ret = strstr (Lout, "Vorbis audio") ? FILE_IS_OGG : FILE_IS_NONE;
	break;
*/

	for (cpt = 0; cpt < 2000; cpt ++) {
		if (buf [ cpt + 0 ] == 'O' &&
		    buf [ cpt + 1 ] == 'g' &&
		    buf [ cpt + 2 ] == 'g' &&
		    buf [ cpt + 3 ] == 'S') {
		    bool_signature = TRUE;
		    break;
		}
	}

	if (bool_signature == TRUE) {
		bool_signature = FALSE;
		for (cpt = 0; cpt < 2000; cpt ++) {
			/*
			if (buf [ cpt +  0 ] == 'l' &&
			    buf [ cpt +  1 ] == 'i' &&
			    buf [ cpt +  2 ] == 'b' &&
			    buf [ cpt +  3 ] == 'V' &&
			    buf [ cpt +  4 ] == 'o' &&
			    buf [ cpt +  5 ] == 'r' &&
			    buf [ cpt +  6 ] == 'b' &&
			    buf [ cpt +  7 ] == 'i' &&
			    buf [ cpt +  8 ] == 's'){
			    */
			if (buf [ cpt +  3 ] == 'v' &&
			    buf [ cpt +  4 ] == 'o' &&
			    buf [ cpt +  5 ] == 'r' &&
			    buf [ cpt +  6 ] == 'b' &&
			    buf [ cpt +  7 ] == 'i' &&
			    buf [ cpt +  8 ] == 's'){
			    bool_signature = TRUE;
			    break;
			}
		}
	}

	g_free (buf);
	buf = NULL;
	
	return (bool_signature);
}

/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/
INFO_OGG *tagsogg_remove_info (INFO_OGG *info)
{
	if (info) {
		g_free (info->namefile);
		g_free (info->Channels);
		g_free (info->Rate);
		g_free (info->Nominal_bitrate);
		g_free (info->time);
		g_free (info->size);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_OGG *)NULL);
}

INFO_OGG *tagsogg_get_info (DETAIL *detail, gchar *namefile)
{
	TagLib_File  *file;
	TagLib_Tag   *tag;
	INFO_OGG     *ptrinfo = NULL;
	const TagLib_AudioProperties *properties;
	gint          seconds;
	gint          minutes;

	ptrinfo = (INFO_OGG *)g_malloc0 (sizeof (INFO_OGG));
	if (ptrinfo == NULL) return (NULL);
	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	
	if ((file = taglib_file_new (namefile))) {
	
		taglib_set_strings_unicode(FALSE);
		tag = taglib_file_tag(file);
		properties = taglib_file_audioproperties(file);
		
		ptrinfo->tags->Title     = g_strdup (taglib_tag_title(tag));
		ptrinfo->tags->Artist    = g_strdup (taglib_tag_artist(tag));
		ptrinfo->tags->Album     = g_strdup (taglib_tag_album(tag));
		ptrinfo->tags->IntYear   = taglib_tag_year(tag);
		ptrinfo->tags->Year      = g_strdup_printf ("%d", ptrinfo->tags->IntYear);
		ptrinfo->tags->Comment   = g_strdup (taglib_tag_comment(tag));
		ptrinfo->tags->IntNumber = taglib_tag_track(tag);
		ptrinfo->tags->Number    = g_strdup_printf ("%d", ptrinfo->tags->IntNumber);
		ptrinfo->tags->Genre     = g_strdup (taglib_tag_genre(tag));
		ptrinfo->tags->IntGenre  = infosong_get_genre_by_value (ptrinfo->tags->Genre);

		ptrinfo->namefile        = g_strdup (namefile);
		ptrinfo->Channels        = g_strdup_printf ("%d", taglib_audioproperties_channels (properties));
		ptrinfo->Rate            = g_strdup_printf ("%d", taglib_audioproperties_samplerate (properties));
		ptrinfo->Nominal_bitrate = g_strdup_printf ("%d", taglib_audioproperties_bitrate (properties));

		ptrinfo->SecTime =  taglib_audioproperties_length(properties);

		if (detail != NULL) {
			detail->ValuePlay.SecTime = ptrinfo->SecTime;
		}

		ptrinfo->ValueMark.SecTime    = taglib_audioproperties_length(properties);
		ptrinfo->ValueMark.ValueMarkA = 0.0;
		ptrinfo->ValueMark.ValueMarkB = 100.0;
		ptrinfo->ValueMark.Value = 0.0;
		
		seconds = taglib_audioproperties_length(properties) % 60;
		minutes = (taglib_audioproperties_length(properties) - seconds) / 60;
		/*if (minutes == 0 && seconds == 0) seconds = 1;*/
		ptrinfo->time            = g_strdup_printf ("%02d:%02d", minutes, seconds);
		ptrinfo->size            = g_strdup_printf ("%d Ko", (gint)infosong_get_size_file (namefile) / 1024);
			
		taglib_tag_free_strings();
		taglib_file_free (file);
	}
	/*
	ptrinfo->level = level_get_from (FILE_IS_OGG, namefile);
g_print ("%s\t%d\n", namefile, ptrinfo->level);
	*/
	ptrinfo->LevelDbfs.level = -1;
	ptrinfo->LevelDbfs.NewLevel = -1;

	return (ptrinfo);
}
/*
INFO_OGG *tagsogg_get_info (gchar *namefile)
{
	gchar        *Lout = NULL;
	gchar        *ptr = NULL;
	INFO_OGG     *ptrinfo = NULL;
#define MAX_STR 200
	static gchar  str [ MAX_STR + 2];
	gint          cpt = 0;
	gchar        *term[] = {"Channels:",
				"Rate:",
				"Nominal bitrate:",
				"TRACKNUMBER=",
				"tracknumber=",
				"TITLE=",
				"title=",
				"ARTIST=",
				"artist=",
				"ALBUM=",
				"album=",
				"GENRE=",
				"genre=",
				"DATE=",
				"date=",
				"COMMENT=",
				"comment=",
				"Playback length:"
				};
	gint          i;
	GString      *gstr = NULL;


	gstr = get_with_ogginfo (namefile);
	Lout = gstr->str;

	ptrinfo = (INFO_OGG *)g_malloc0 (sizeof (INFO_OGG));
	if (ptrinfo == NULL) {
		g_string_free (gstr, TRUE);
		Lout = NULL;
		return (NULL);
	}

	ptrinfo->namefile = g_strdup (namefile);

	ptrinfo->size = g_strdup_printf ("%d Ko", infosong_get_size_file (namefile) / 1024);

	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);

	for (i = 0; i < 18; i ++) {

		if ((ptr = strstr (gstr->str, term[ i ]))) {

			for (cpt=0; cpt < MAX_STR; cpt++) str [ cpt ] = '\0';
			cpt = 0;

			switch (i) {
			case 0 :
			case 1 :
			case 2 :
			case 17 :
				ptr = strchr (ptr, ':');
				ptr ++;
				while (*ptr == ' ') ptr ++;
				break;
			default :
				ptr = strchr (ptr, '=');
				ptr ++;
				break;
			}

			while (*ptr != '\n') {
				if (cpt > MAX_STR) break;
				str [ cpt ++ ] = *ptr ++;
			}
			str [ cpt ] = '\0';

			switch ( i ) {
			case 0 :
				ptrinfo->Channels = g_strdup (str);
				break;
			case 1 :
				ptrinfo->Rate = g_strdup (str);
				break;
			case 2 :
				if ((ptr = strchr (str, ',')) == NULL)
					ptr = strchr (str, '.');
				if (ptr != NULL) {
					*ptr = '\0';
					ptrinfo->Nominal_bitrate = g_strdup (str);
				}
				break;
			case 3 :
			case 4 :
				ptrinfo->tags->Number = g_strdup (str);
				ptrinfo->tags->IntNumber = atoi (str);
				i ++;
				break;
			case 5 :
			case 6 :
				ptrinfo->tags->Title = g_strdup (str);
				i ++;
				break;
			case 7 :
			case 8 :
				ptrinfo->tags->Artist = g_strdup (str);
				i ++;
				break;
			case 9 :
			case 10 :
				ptrinfo->tags->Album = g_strdup (str);
				i ++;
				break;
			case 11 :
			case 12 :
				if (str && *str && *str == '-') {
					ptrinfo->tags->Genre = g_strdup ("0");
				}
				else {
					ptrinfo->tags->Genre = g_strdup (str);
				}
				i ++;
				break;
			case 13 :
			case 14 :
				ptrinfo->tags->Year = g_strdup (str);
				i ++;
				break;
			case 15 :
			case 16 :
				ptrinfo->tags->Comment = g_strdup (str);
				break;
			case 17 :
				{
				gchar min [ 12 ];
				gchar sec [ 12 ];
				gint  int_h;
				gint  int_m;
				gint  int_s;
				gint  i = 0;

				ptr = &str [ 0 ];

				i = 0;
				while (*ptr != 'm') min [ i ++ ] = *ptr ++;
				min [ i ] = '\0';

				while (*ptr != ':') ptr ++;
				ptr ++;

				i = 0;
				sec [ i ++ ] = *ptr ++;
				sec [ i ++ ] = *ptr ++;
				sec [ i ] = '\0';

				if (atoi (min) > 60) {
					int_h = atoi (min) / 60;
					int_m = atoi (min) % 60;
					int_s = atoi (sec);
					ptrinfo->time = g_strdup_printf ("%02d:%02d:%02d", int_h, int_m, int_s);
				} else {
					int_m = atoi (min);
					int_s = atoi (sec);
					ptrinfo->time = g_strdup_printf ("%02d:%02d", int_m, int_s);
				}
				break;
				}
			}
		}
	}

	g_string_free (gstr, TRUE);
	Lout = NULL;

	tags_set (namefile, ptrinfo->tags);

	return (ptrinfo);
}
*/

