 /*
 * file    : tags_aiff.c
 * project : xcfa
 * with    : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#include <gtk/gtk.h>
#include <glib/gstdio.h>

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "tags.h"
#include <taglib/tag_c.h>
#include "get.h"



/*
*---------------------------------------------------------------------------
* FILE IS AIFF ?
*---------------------------------------------------------------------------
*/
/*
POS	ASCII	HEXA
00	F		46
01	O		4f
02	R		52
03	M		4d
04	
05	
06	
07	
08	A		41
09	I		49
10	F		46
11	F		46
12	C		43
13	O		4f
14	M		4d
15	M		4d
*/
gboolean tagsaiff_file_is_aiff (gchar *namefile)
{
	FILE        *fp = NULL;
	size_t       lenread = 0;
	gchar       *buf = NULL;
	gboolean     bool_signature = FALSE;
	
	/*PRINT_FUNC_LF();*/

	buf = (gchar *)g_malloc0 (sizeof(gchar) * 512);
	if ((fp = fopen (namefile, "rb")) != NULL) {
		lenread = fread (buf, 1, 500, fp);
		fclose (fp);
	
		if (buf [  0 ] == 0x46 &&	// F
		    buf [  1 ] == 0x4f &&	// O
		    buf [  2 ] == 0x52 &&	// R
		    buf [  3 ] == 0x4d &&	// M
		    
		    buf [  8 ] == 0x41 &&	// A
		    buf [  9 ] == 0x49 &&	// I
		    buf [ 10 ] == 0x46 &&	// F
		    buf [ 11 ] == 0x46 &&	// F
		    buf [ 12 ] == 0x43 &&	// C
		    buf [ 13 ] == 0x4f &&	// O
		    buf [ 14 ] == 0x4d &&	// M
		    buf [ 15 ] == 0x4d)	{	// M
		    
			bool_signature = TRUE;
		}
	}

	g_free (buf);
	buf = NULL;
	
	return (bool_signature);
}

/*
*---------------------------------------------------------------------------
* REMOVE HEADER
*---------------------------------------------------------------------------
*/
INFO_AIFF *tagsaiff_remove_info (INFO_AIFF *info)
{
	if (info) {
		g_free (info->namefile);

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_AIFF *)NULL);
}

/*
*---------------------------------------------------------------------------
* GET HEADER
*---------------------------------------------------------------------------
*/
INFO_AIFF *tagsaiff_get_info (gchar *namefile)
{
	INFO_AIFF     *ptrinfo = NULL;

	ptrinfo = (INFO_AIFF *)g_malloc0 (sizeof (INFO_AIFF));
	if (ptrinfo == NULL) return (NULL);

	ptrinfo->namefile = g_strdup (namefile);

	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	tags_set (namefile, ptrinfo->tags);

	return ((INFO_AIFF *)ptrinfo);
}











