 /*
 * file      : prg_audio.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>

#include <string.h>
#include "global.h"
#include "utils.h"
#include "prg_audio.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

enum
{
	NUM_TREE_Nom = 0,
	NUM_TREE_Status,
	NUM_TREE_Action,
	NUM_TREE_Param,
	NUM_TREE_ALL_COLUMN
};


enum
{
	PRGAUDIO_NAME = 0,
	PRGAUDIO_STATUS,
	PRGAUDIO_COMMENT,
	PRGAUDIO_PARAM,
	PRGAUDIO_PARAM_EDITABLE,
	PRGAUDIO_TOTAL_COLUMN
};

typedef struct
{
	gchar		*Param;
	gboolean	 BoolEdit;

} ARTICLES_PRGAUDIO;

GArray           *ArticlesPrgAudio = NULL;


VAR_PRGAUDIO VarPrgAudio = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };


/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

gboolean prgaudio_name_is_internal (void)
{
	gchar *Ptr = prgaudio_get_name_is_actived ();
	
	if (Ptr && strcmp (Ptr, READER_AUDIO_XCFA) == 0) return (TRUE);
	return (FALSE);
}

gchar *prgaudio_get_name_is_actived (void)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name = NULL;
	gboolean      actif;
	
	/* PRINT_FUNC_LF(); */

	if (VarPrgAudio.Adr_Tree_Model == NULL) return (NULL);
	
	valid = gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_STATUS, &actif, -1);
		if (actif) {
			gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_NAME, &name, -1);
			return (name);
		}
		valid = gtk_tree_model_iter_next (VarPrgAudio.Adr_Tree_Model, &iter);
	}
	return (NULL);
}
gchar *prgaudio_get_param_is_actived (void)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *Param = NULL;
	gboolean      actif;
	
	/* PRINT_FUNC_LF(); */

	if (VarPrgAudio.Adr_Tree_Model == NULL) return (NULL);
	
	valid = gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_STATUS, &actif, -1);
		if (actif) {
			gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_PARAM, &Param, -1);
			return (Param);
		}
		valid = gtk_tree_model_iter_next (VarPrgAudio.Adr_Tree_Model, &iter);
	}
	return (NULL);
}


void prgaudio_test_is_selected (void)
{
	GtkTreeIter   iter;
	
	if (prgaudio_get_name_is_actived () == NULL) {
		if (gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter)) {
			gtk_list_store_set (GTK_LIST_STORE (VarPrgAudio.Adr_Tree_Model), &iter, PRGAUDIO_STATUS, TRUE, -1);
		}
	}
}

void prgaudio_all_deselect (void)
{
	gboolean     valid;
	GtkTreeIter  iter;
	
	valid = gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_list_store_set (GTK_LIST_STORE (VarPrgAudio.Adr_Tree_Model), &iter, PRGAUDIO_STATUS, FALSE, -1);
		valid = gtk_tree_model_iter_next (VarPrgAudio.Adr_Tree_Model, &iter);
	}
}

gboolean prgaudio_is_find (gchar *name)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name_navi = NULL;
	
	valid = gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_NAME, &name_navi, -1);
		if (strcmp (name, name_navi) == 0) return (TRUE);
		
		valid = gtk_tree_model_iter_next (VarPrgAudio.Adr_Tree_Model, &iter);
	}
	return (FALSE);
}

void prgaudio_set_name (gchar *Name, gchar *Param)
{
	GtkTreeIter		iter;
	ARTICLES_PRGAUDIO	Foo;
	
	if (prgaudio_is_find (Name) == FALSE) {
		if (utils_scan_by_which (Name, NULL) == TRUE) {
			
			Foo.Param    = g_strdup (Param);
			Foo.BoolEdit = TRUE;

			g_array_append_vals (ArticlesPrgAudio, &Foo, 1);

			gtk_list_store_append (VarPrgAudio.Adr_List_Store, &iter);
			gtk_list_store_set (VarPrgAudio.Adr_List_Store, &iter,
						PRGAUDIO_NAME,			Name,
						PRGAUDIO_STATUS,		FALSE,
						PRGAUDIO_COMMENT,		_("Lecteur de fichier audio"),
						PRGAUDIO_PARAM,			Foo.Param,
						PRGAUDIO_PARAM_EDITABLE,	Foo.BoolEdit,
						-1);
		}
	}
}

gboolean prgaudio_traite_button_press_event (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	gint                Pos_X = 0, Pos_Y = 0;
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	gchar              *name = NULL;
	
	/* PRINT_FUNC_LF(); */

	/* Single clicks only */
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, &Pos_X, &Pos_Y)) {
	
		gtk_entry_set_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio), "");
		return (FALSE);
	}

	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);

	/* Vider la saisie */
	/*options_set_name_to_entry_ps ("");*/

	/*
	enum
	{
		NUM_TREE_Nom = 0,
		NUM_TREE_Status,
		NUM_TREE_Action,
		NUM_TREE_Param,
		NUM_TREE_ALL_COLUMN
	};
	*/
	/*if (strcmp(column->title, "Status") == 0) {*/
	if (gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), NUM_TREE_Status) == column) {

		/* position du curseur a l'instant du click */
		if (Pos_X < 20 || Pos_X > 36) return (FALSE);
		if (Pos_Y < 4 || Pos_Y > 18) return (FALSE);

		prgaudio_all_deselect ();
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, PRGAUDIO_STATUS, TRUE, -1);
	}
	/*else if (strcmp(column->title, "Nom") == 0) {*/
	if (gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), NUM_TREE_Nom) == column) {
	
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_NAME, &name, -1);
		if (strcmp (name, READER_AUDIO_XCFA) == 0)
			gtk_entry_set_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio), "");
		else	gtk_entry_set_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio), name);
	}
	return (FALSE);
}

static void prgaudio_cell_edited (GtkCellRendererText *cell, const gchar *path_string, const gchar *new_text, gpointer data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath  *path = gtk_tree_path_new_from_string (path_string);
	GtkTreeIter   iter;
	gint          column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (cell), "column"));

	/* PRINT_FUNC_LF(); */

	gtk_tree_model_get_iter (model, &iter, path);

	if (column == PRGAUDIO_PARAM) {
		gint     Num_cell;
		gchar   *old_text;

		gtk_tree_model_get (model, &iter, PRGAUDIO_PARAM, &old_text, -1);
		g_free (old_text);
		old_text = NULL;

		Num_cell = gtk_tree_path_get_indices (path)[0];
/*g_print("Num_cell = %d\n", Num_cell);*/

		g_free (g_array_index (ArticlesPrgAudio, ARTICLES_PRGAUDIO, Num_cell).Param);
		g_array_index (ArticlesPrgAudio, ARTICLES_PRGAUDIO, Num_cell).Param = NULL;
		g_array_index (ArticlesPrgAudio, ARTICLES_PRGAUDIO, Num_cell).Param = g_strdup (new_text);
		
		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					PRGAUDIO_PARAM,
					g_array_index (ArticlesPrgAudio, ARTICLES_PRGAUDIO, Num_cell).Param,
					-1);
	}
	gtk_tree_path_free (path);
}

static void prgaudio_add_columns (GtkTreeView *treeview)
{
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);

	/* SIGNAL : 'button-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "button-press-event",
                    	 (GCallback) prgaudio_traite_button_press_event,
			 model);
			 
	/* SIGNAL 'changed'
	*/
	VarPrgAudio.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	gtk_tree_selection_set_mode (VarPrgAudio.Adr_Line_Selected, GTK_SELECTION_BROWSE);

	/* PRGAUDIO_NAME */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Nom"),
							renderer,
							"text", PRGAUDIO_NAME,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
						GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 150);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	/* PRGAUDIO_STATUS */
	renderer = gtk_cell_renderer_toggle_new ();
	/*g_signal_connect (renderer, "toggled", G_CALLBACK (prgnavigator_fixed_toggled), model);*/
	gtk_cell_renderer_toggle_set_radio ((GtkCellRendererToggle *)renderer, TRUE);
	g_object_set (renderer, "xalign", 0.5, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Status"),
							renderer,
							"active", PRGAUDIO_STATUS,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 60);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	/* PRGAUDIO_COMMENT */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	column = gtk_tree_view_column_new_with_attributes (
							_("Action"),
							renderer,
							"text", PRGAUDIO_COMMENT,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 200);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	
	/*  PRGAUDIO_PARAM
	 *  PRGAUDIO_PARAM_EDITABLE
	 */
	renderer = gtk_cell_renderer_text_new ();
	g_signal_connect (renderer, "edited", G_CALLBACK (prgaudio_cell_edited), model);
	g_object_set (renderer, "xalign", 0.0, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *)PRGAUDIO_PARAM);
	column = gtk_tree_view_column_new_with_attributes (
							_("Parametres du lecteur"),
							renderer,
							"text", PRGAUDIO_PARAM,
							"editable", PRGAUDIO_PARAM_EDITABLE,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 160);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
}

void prgaudio_make_scrolledwindow (GtkWidget *widget)
{
	GtkTreeModel *model;
	GtkWidget    *treeview;
	GtkListStore *store;

	/*PRINT_FUNC_LF();*/

	ArticlesPrgAudio = g_array_sized_new (FALSE, FALSE, sizeof (ARTICLES_PRGAUDIO), 1);

	VarPrgAudio.Adr_scroll = widget;
	VarPrgAudio.Adr_List_Store =
	store = gtk_list_store_new (PRGAUDIO_TOTAL_COLUMN,	/* Nombre total de colonnes */
				    G_TYPE_STRING,		/* Name */
				    G_TYPE_BOOLEAN,		/* Status */
				    G_TYPE_STRING,		/* Commentaire */
				    G_TYPE_STRING,		/* Parametres */
				    G_TYPE_BOOLEAN,        	/* Parametres editable */
				    G_TYPE_POINTER		/* Pointeur sur structure */
				    );
	VarPrgAudio.Adr_Tree_Model = model = GTK_TREE_MODEL (store);

	treeview = gtk_tree_view_new_with_model (model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);

	g_object_unref (model);
	gtk_container_add (GTK_CONTAINER (widget), treeview);

	/* add columns to the tree view */
	prgaudio_add_columns (GTK_TREE_VIEW (treeview));
			
	gtk_widget_show_all (widget);
	
	/*
	prgaudio_set_name ("vlc");
	prgaudio_set_name ("quodlibet");
	prgaudio_set_name ("xmms");
	prgaudio_set_name ("totem");
	prgaudio_set_name ("xfmedia");
	prgaudio_set_name ("kaboodle");
	prgaudio_set_name ("audacious");
	
	prgaudio_test_is_selected ();
	*/
}

void prgaudio_entry_name_audio_changed (void)
{
	gchar *Name = NULL;
	
	if (VarPrgAudio.Adr_entry_name_audio == NULL) return;
	
	/* PRINT_FUNC_LF(); */
	
	Name = (gchar *)gtk_entry_get_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio));

	if (*Name == '\0' || strcmp (Name, READER_AUDIO_XCFA) == 0) {
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_add_audio")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_del_audio")), FALSE);
	}
	else if (prgaudio_is_find (Name)) {
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_add_audio")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_del_audio")), TRUE);
	}
	else {
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_add_audio")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_del_audio")), FALSE);
	}
	prgaudio_test_is_selected ();
}

void prgaudio_button_add_audio_clicked (void)
{
	gchar        *name = (gchar *)gtk_entry_get_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio));
	
	/* PRINT_FUNC_LF(); */
	
	prgaudio_set_name (name, "");
	while (gtk_events_pending()) gtk_main_iteration();
	prgaudio_entry_name_audio_changed ();
	gtk_entry_set_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio), "");
}

void prgaudio_button_del_audio_clicked (void)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name = (gchar *)gtk_entry_get_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio));
	gchar        *name_navi = NULL;
	
	valid = gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_NAME, &name_navi, -1);
		if (strcmp (name, name_navi) == 0) {
			gtk_list_store_remove (VarPrgAudio.Adr_List_Store, &iter);
			break;
		}
		valid = gtk_tree_model_iter_next (VarPrgAudio.Adr_Tree_Model, &iter);
	}
	while (gtk_events_pending()) gtk_main_iteration();
	prgaudio_entry_name_audio_changed ();
	gtk_entry_set_text (GTK_ENTRY (VarPrgAudio.Adr_entry_name_audio), "");
}

GList *prgaudio_remove_glist_prog (GList *list)
{
	GList		*NewList = NULL;
	PRGAUDIO_SAVE	*PrgAudioSave = NULL;

	NewList = g_list_first (list);
	while (NewList) {
		if ((PrgAudioSave = (PRGAUDIO_SAVE *)NewList->data)) {
			g_free (PrgAudioSave->Name);
			g_free (PrgAudioSave->Param);
			g_free (PrgAudioSave);
			PrgAudioSave = NULL;
			NewList->data = NULL;
		}
		NewList = g_list_next(NewList);
	}
	g_list_free (list);
	list = NULL;
	return ((GList*)NULL);

}
GList *prgaudio_get_glist_prog (GList *list)
{
	GtkTreeIter	 iter;
	gboolean	 valid;
	gchar		*Name = NULL;
	gchar		*Param = NULL;
	PRGAUDIO_SAVE	*PrgAudioSave = NULL;

	if (VarPrgAudio.Adr_Tree_Model == NULL) return ((GList *)NULL);
	
	/* Tous les navigateurs */
	valid = gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_NAME, &Name, -1);
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_PARAM, &Param, -1);
		
		PrgAudioSave = (PRGAUDIO_SAVE *)g_malloc0 (sizeof (PRGAUDIO_SAVE));
		PrgAudioSave->Name  = g_strdup (Name);
		PrgAudioSave->Param = g_strdup (Param);
		
		list = g_list_append (list, PrgAudioSave);

		valid = gtk_tree_model_iter_next (VarPrgAudio.Adr_Tree_Model, &iter);
	}

	return ((GList *)list);
}

gboolean prgaudio_activate (gchar *name)
{
	gboolean      valid;
	GtkTreeIter   iter;
	gchar        *name_navi = NULL;
	
	if (VarPrgAudio.Adr_Tree_Model == NULL) return (FALSE);

	if (name == NULL || *name == '\0') {
		if (gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter)) {
			prgaudio_all_deselect ();
			gtk_list_store_set (GTK_LIST_STORE (VarPrgAudio.Adr_Tree_Model), &iter, PRGAUDIO_STATUS, TRUE, -1);
			return (TRUE);
		}
	}
	
	/* all treeview */
	valid = gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (VarPrgAudio.Adr_Tree_Model, &iter, PRGAUDIO_NAME, &name_navi, -1);
		/* name existe ? */
		if (strcmp (name, name_navi) == 0) {
			prgaudio_all_deselect ();
			gtk_list_store_set (GTK_LIST_STORE (VarPrgAudio.Adr_Tree_Model), &iter, PRGAUDIO_STATUS, TRUE, -1);
			return (TRUE);
		}
		valid = gtk_tree_model_iter_next (VarPrgAudio.Adr_Tree_Model, &iter);
	}
	
	/**/
	if (gtk_tree_model_get_iter_first (VarPrgAudio.Adr_Tree_Model, &iter)) {
		prgaudio_all_deselect ();
		gtk_list_store_set (GTK_LIST_STORE (VarPrgAudio.Adr_Tree_Model), &iter, PRGAUDIO_STATUS, TRUE, -1);
		return (TRUE);
	}
	
	return (FALSE);
}

void prgaudio_affiche (void)
{
	GList			*list = NULL;
	GtkTreeIter		 iter;
	ARTICLES_PRGAUDIO	 Foo;
	PRGAUDIO_SAVE		*PrgAudioSave = NULL;
	
	/*PRINT_FUNC_LF();*/

	Foo.Param    = g_strdup ("");
	Foo.BoolEdit = FALSE;

	g_array_append_vals (ArticlesPrgAudio, &Foo, 1);

	/* Le lecteur Xcfa toujours en premier */
	gtk_list_store_append (VarPrgAudio.Adr_List_Store, &iter);
	gtk_list_store_set (VarPrgAudio.Adr_List_Store, &iter,
				PRGAUDIO_NAME,			READER_AUDIO_XCFA,
				PRGAUDIO_STATUS,		FALSE,
				PRGAUDIO_COMMENT,		_("Lecteur de fichier audio"),
				PRGAUDIO_PARAM,			Foo.Param,
				PRGAUDIO_PARAM_EDITABLE,	Foo.BoolEdit,
				-1);
	
	/* Affichage de la liste */
	if ((list = g_list_first (VarPrgAudio.ListLecteurs)) == NULL) {
		prgaudio_set_name ("vlc", 		"");
		prgaudio_set_name ("quodlibet",		"");
		prgaudio_set_name ("xmms",		"");
		prgaudio_set_name ("totem",		"");
		prgaudio_set_name ("xfmedia",		"");
		prgaudio_set_name ("kaboodle",		"");
		prgaudio_set_name ("amarok",		"");
		prgaudio_set_name ("gnome-mplayer",	"");
		prgaudio_set_name ("audacious",		"");
	}

	while (list) {
		if ((PrgAudioSave = (PRGAUDIO_SAVE *)list->data)) {
			prgaudio_set_name (PrgAudioSave->Name, PrgAudioSave->Param);
		}
		list = g_list_next(list);
	}

	/* Selection du navigateur */
	prgaudio_activate (VarPrgAudio.LecteurActif);
	
	/* Suppressions de la liste */
	list = prgaudio_remove_glist_prog (list);

	/* Suppressions navigateur actif */	
	g_free (VarPrgAudio.LecteurActif);
	VarPrgAudio.LecteurActif = NULL;
}







