/*
 * file      : parse.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnorg/licenses/>.
 * 
 * ==================================================================================
 * vendredi 22 janvier 2010
 * Fri, 22 Jan 2010
 * ==================================================================================
 * 
 * Un patch pour la fonction %u avec pour caractere unique avait ete code par
 * jerome AT jolimont POINT fr : Jerome Lafrechoux
 * J'ai recode cette fonction, trop restrictive, en ameliorant la fonction tel que:
 *   %u(SOURCE=DESTINATION)
 *   SOURCE
 *     peut etre un ou une suite de caracteres
 *   DESTINATION
 *     est un caractere unique pour remplacer la SOURCE
 * 
 * Par exemple:
 *   %u(éêè=e)
 * Les caracteres SOURCE [ éêè ] seront remplaces par DESTINATION [ e ]
 * La fonction %u() peut figurer plusieurs fois en entree:
 *   %u(àâã=a)%u(éêè=e)%u( =_)
 * etc, ...
 * 
 * ==================================================================================
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>

#include "global.h"
#include "cd_audio.h"
#include "parse.h"


	/*
	%a  -  artiste
	%b  -  titre de l'album
	%c  -  numero de la piste
	%d  -  titre de la chanson
	%e  -  annee
	%g  -  genre
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio));


	%a  -  artiste
	%b  -  titre de l'album
	%c  -  numero de la piste
	%d  -  titre de la chanson
	%e  -  annee
	%g  -  genre
	%f  -  creation d'un fichier *.m3u et *.xspf
	%u  -  remplacement des caracteres speciaux
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio));
	*/
	
typedef enum {
	CD_TAG_ARTIST = 0,
	CD_TAG_ALBUM,
	CD_TAG_INT_NUMBER,
	CD_TAG_TITLE,
	CD_TAG_YEAR,
	CD_TAG_GENRE,
	CD_TAG_FILE_M3U_XSPF,	// BoolCreateFileM
	CD_TAG_CAR_REPLACE,	// StringReplace
	CD_TAG_DEFAULT		// StringDefault
} CD_TYPE_TAG;


typedef struct {
	CD_TYPE_TAG	 CdTypeTag;		// CD_TYPE_TAG
	gboolean	 BoolCreateFileM3uXspf;	// CD_TAG_FILE_M3U_XSPF
	gchar		*StringReplaceOld;	// CD_TAG_CAR_REPLACE
	gchar		*StringReplaceNew;	// CD_TAG_CAR_REPLACE		
	gchar		*StringDefault;		// CD_TAG_DEFAULT
} PARSE;


typedef struct {
	GList	*ListParseStockCd;	// Liste PARSE de Preference->CD->Dossier de stockage
	GList	*ListParseTitleCd;	// Liste PARSE de CD->Arrangement des titres du CD
} VAR_PARSE;

VAR_PARSE VarParse = { NULL, NULL };



// DEBUGING ...
//
void Parse_debug (PARSE_TYPE p_ParseType)
{
	GList	*list = NULL;
	PARSE	*Parse = NULL;
	gchar	*Str[] = {"DD_TAG_ARTIST", "CD_TAG_ALBUM", "CD_TAG_INT_NUMBER", "CD_TAG_TITLE", "CD_TAG_YEAR", "CD_TAG_GENRE", "CD_TAG_FILE_M3U_XSPF", "CD_TAG_CAR_REPLACE", "CD_TAG_DEFAULT" };
		
	if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
		list = g_list_first (VarParse.ListParseStockCd);
	} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
		list = g_list_first (VarParse.ListParseTitleCd);
	}
	while (list) {
		if ((Parse = (PARSE *)list->data) != NULL) {
			g_print ("%s\n", Str [ Parse->CdTypeTag ]);
			if (p_ParseType == PARSE_TYPE_TITLE_CD) {
				if (Parse->CdTypeTag == CD_TAG_CAR_REPLACE) {
					g_print("%s ", Parse->StringReplaceOld);
					g_print("%s\n", Parse->StringReplaceNew);
				}
			}
		}
		list = g_list_next (list);
	}
}

// SUPRESSION DES STRUCTURES DES GLIST ET DES GLIST
//
void Parse_remove (PARSE_TYPE p_ParseType)
{
	GList	*list = NULL;
	PARSE	*Parse = NULL;
	
	if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
		list = g_list_first (VarParse.ListParseStockCd);
	} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
		list = g_list_first (VarParse.ListParseTitleCd);
	}
	while (list) {
		if ((Parse = (PARSE *)list->data) != NULL) {
			switch (Parse->CdTypeTag) {
			case CD_TAG_ARTIST :
			case CD_TAG_ALBUM :
			case CD_TAG_INT_NUMBER :
			case CD_TAG_TITLE :
			case CD_TAG_YEAR :
			case CD_TAG_GENRE :
			case CD_TAG_FILE_M3U_XSPF :
				break;
			case CD_TAG_CAR_REPLACE :
				g_free (Parse->StringReplaceOld);
				Parse->StringReplaceOld = NULL;
				g_free (Parse->StringReplaceNew);
				Parse->StringReplaceNew = NULL;
				break;
			case CD_TAG_DEFAULT :
				g_free (Parse->StringDefault);
				Parse->StringDefault = NULL;
				break;
			}
			g_free (Parse);
			Parse = NULL;
			list->data = NULL;
		}
		list = g_list_next (list);
	}
	
	if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
		g_list_free (VarParse.ListParseStockCd);
		VarParse.ListParseStockCd = NULL;
	} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
		g_list_free (VarParse.ListParseTitleCd);
		VarParse.ListParseTitleCd = NULL;
	}
}

// ALLOCATION ET STOCKAGE DE TOUS LES TYPES SAUF: CD_TAG_CAR_REPLACE
// 
void Parse_allocate (PARSE_TYPE p_ParseType, CD_TYPE_TAG p_CdTypeTag, gchar *p_Str)
{
	PARSE	*New = NULL;
	
	New = (PARSE *)g_malloc0 (sizeof(PARSE));
	New->CdTypeTag = p_CdTypeTag;
	
	if (p_ParseType == PARSE_TYPE_TITLE_CD) {
		if (p_CdTypeTag == CD_TAG_FILE_M3U_XSPF) {
			New->BoolCreateFileM3uXspf = TRUE;
		}
	}
	if (p_CdTypeTag == CD_TAG_DEFAULT && p_Str != NULL) {
		New->StringDefault = g_strdup_printf ("%s", p_Str);
	}
	
	// REFERENCE LE POINTEUR DE STRUCTURE DANS LE GLIST
	if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
		VarParse.ListParseStockCd = g_list_append (VarParse.ListParseStockCd, New);
	} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
		VarParse.ListParseTitleCd = g_list_append (VarParse.ListParseTitleCd, New);
	}
}

// ALLOCATION ET STOCKAGE DU TYPE: CD_TAG_CAR_REPLACE
// 
void Parse_allocate_function (PARSE_TYPE p_ParseType, CD_TYPE_TAG p_CdTypeTag, gchar *p_Str)
{
	gchar	*Ptr = p_Str;
	gchar	*PtrEnd = p_Str;
	gchar	*PtrEqual = NULL;
	PARSE	*New = NULL;
	gchar	Str [ 10 ];
		
	// PRINT_FUNC_LF();
	
	// LE CARACTERE DE REMPLACEMENT
	while (PtrEnd && *PtrEnd) PtrEnd ++;
	PtrEnd --;
	if (*PtrEnd == ')') {
		*PtrEnd = '\0';
		PtrEnd --;
	}
	while (PtrEnd && *PtrEnd && *PtrEnd != '=') PtrEnd --;
	PtrEnd ++;
	
	Ptr = p_Str;
	
	for (PtrEqual = PtrEnd; *PtrEqual != '='; PtrEqual --);

	// LE CARACTERE A REMPLACER
	while (Ptr < PtrEqual) {
		
		if (Ptr == PtrEqual) break;
		
		if (*Ptr < 0) {
			Str [ 0 ] = *Ptr;
			Str [ 1 ] = *(Ptr +1);
			Str [ 2 ] = '\0';
		} else {
			Str [ 0 ] = *Ptr;
			Str [ 1 ] = '\0';
		}
		
		// NOUVELLE STRUCTURE
		New = (PARSE *)g_malloc0 (sizeof(PARSE));
		New->CdTypeTag = p_CdTypeTag;
		
		//
		New->StringReplaceOld = g_strdup_printf ("%s", Str);
		New->StringReplaceNew = g_strdup_printf ("%s", PtrEnd);
		
		// STOCKE LA STRUCTURE DANS LA LISTE
		if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
			VarParse.ListParseStockCd = g_list_append (VarParse.ListParseStockCd, New);
		} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
			VarParse.ListParseTitleCd = g_list_append (VarParse.ListParseTitleCd, New);
		}
		
		if (*Ptr < 0)
			Ptr += 2;
		else	Ptr ++;
	}
}

// SUPPRESSION ET PARSE COMPLET
// 
void Parse_entry (PARSE_TYPE p_ParseType)
{
	gchar		*PtrTemplate = NULL;
	gchar		 Str [ 10 ];
	gboolean	 BoolTagOk = FALSE;
	
	// QUELLE LIGNE ANALISER ?
	if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
		PtrTemplate = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio));
	} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
		PtrTemplate = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio));
	} else {
		PRINT("ERREUR PARAMETRE");
		return;
	}
	
	// REMOVE LISTE
	Parse_remove (p_ParseType);
	
	// PARSE
	while (PtrTemplate && *PtrTemplate != '\0') {
		if (*PtrTemplate == '%') {
			if (*(PtrTemplate +1) == 'a') {
				Parse_allocate (p_ParseType, CD_TAG_ARTIST, NULL);
				PtrTemplate += 2;
				BoolTagOk = TRUE;
			}
			else if (*(PtrTemplate +1) == 'b') {
				Parse_allocate (p_ParseType, CD_TAG_ALBUM, NULL);
				PtrTemplate += 2;
				BoolTagOk = TRUE;
			}
			else if (*(PtrTemplate +1) == 'c') {
				Parse_allocate (p_ParseType, CD_TAG_INT_NUMBER, NULL);
				PtrTemplate += 2;
				BoolTagOk = TRUE;
			}
			else if (*(PtrTemplate +1) == 'd') {
				Parse_allocate (p_ParseType, CD_TAG_TITLE, NULL);
				PtrTemplate += 2;
				BoolTagOk = TRUE;
			}
			else if (*(PtrTemplate +1) == 'e') {
				Parse_allocate (p_ParseType, CD_TAG_YEAR, NULL);
				PtrTemplate += 2;
			}
			else if (*(PtrTemplate +1) == 'f') {
				Parse_allocate (p_ParseType, CD_TAG_FILE_M3U_XSPF, NULL);
				PtrTemplate += 2;
			}
			else if (*(PtrTemplate +1) == 'g') {
				Parse_allocate (p_ParseType, CD_TAG_GENRE, NULL);
				PtrTemplate += 2;
				BoolTagOk = TRUE;
			}
			else if (*(PtrTemplate +1) == 'u') {
				// CD_TAG_CAR_REPLACE
				gchar	*Ptr = (PtrTemplate +2);
				gchar	*PtrBegin = NULL;
				gchar	*PtrEnd = NULL;
				gchar	*String = NULL;
				
				// LA PARENTEZE OUVRE LA FONCTION
				if (*Ptr >= 0 && *Ptr == '(') {
					PtrEnd = PtrBegin = Ptr;
					Ptr ++;
					if (*Ptr < 0) Ptr ++;
					// PASSER LE CARACTERE APRES LA PARENTEZE
					if (*Ptr) Ptr ++;
					// SI PAS FIN DE CHAINE
					while (*Ptr && *(Ptr +1) != '\0' && *(Ptr +2) != '\0') {
						// SI FIN DE FONCTION TROUVEE
						if (*(Ptr +1) < 0) {
							if (*Ptr == '=' && *(Ptr +3) == ')') {
								PtrEnd = Ptr +3;
								break;
							}
						}
						else {
							if (*Ptr == '=' && *(Ptr +2) == ')') {
								PtrEnd = Ptr +2;
								break;
							}
						}
						Ptr ++;
					}
					// SI FIN DE FONCTION ABSENTE ALORS QUIT L'ANALIZE DE FIN DE CHAINE
					if (*PtrEnd != ')') break;
					// PREPARE LA CHAINE POUR ANALYSE
					String = g_strnfill ((PtrEnd - PtrBegin) *2, '\0');
					strncpy(String, PtrBegin +1, PtrEnd - PtrBegin);
					// g_print("String = %s\n", String);
					Parse_allocate_function (p_ParseType, CD_TAG_CAR_REPLACE, String);
					g_free (String);
					String = NULL;
					PtrTemplate = (PtrEnd +1);
				} else break;
			}
			else {
				Str [ 0 ] = *PtrTemplate;
				Str [ 1 ] = '\0';
				Parse_allocate (p_ParseType, CD_TAG_DEFAULT, Str);
				PtrTemplate ++;
			}
		}
		else {
			if (*PtrTemplate < 0) {
				Str [ 0 ] = *PtrTemplate;
				Str [ 1 ] = *(PtrTemplate +1);
				Str [ 2 ] = '\0';
				PtrTemplate += 2;
			} else {
				Str [ 0 ] = *PtrTemplate;
				Str [ 1 ] = '\0';
				PtrTemplate ++;
			}
			Parse_allocate (p_ParseType, CD_TAG_DEFAULT, Str);
		}
	}
	
	if (BoolTagOk == FALSE) {
		// SI LISTE VIDE -> CREATION D'UN MINIMUM AVEC LE TITRE
		Parse_allocate (p_ParseType, CD_TAG_TITLE, NULL);
	}
	
	// Parse_debug (p_ParseType);
}

// RECUPERATION DU PARSE DE LA LIGNE: p_Num_cell(0 .. n-1) 
// 
gchar *Parse_get_line (PARSE_TYPE p_ParseType, gint p_Num_cell)
{
	AUDIO		*Audio = NULL;
	GList		*ListCD = NULL;
	GList		*ListParse = NULL;
	PARSE		*Parse = NULL;
	GString		*gstr = NULL;
	GString		*gstrNew = NULL;
	gchar		*Ptr = NULL;
	gchar		*Str = NULL;
		
	ListCD = g_list_nth (EnteteCD.GList_Audio_cd, p_Num_cell);
	if ((Audio = (AUDIO *)ListCD->data)) {
	
		gstr = g_string_new (NULL);
		
		if (Audio->tags == NULL) {
			g_string_append_printf (gstr, "Track_%02d", p_Num_cell +1);
			Str = g_strdup (gstr->str);
			g_string_free (gstr, TRUE);
			return (Str);
		}
		
		// QUELLE LIGNE ANALISER ?
		if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
			ListParse = g_list_first (VarParse.ListParseStockCd);
		} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
			ListParse = g_list_first (VarParse.ListParseTitleCd);
		}
		
		// LISTE PARSE
		while (ListParse) {
			if ((Parse = (PARSE *)ListParse->data) != NULL) {
				switch (Parse->CdTypeTag) {
				case CD_TAG_ARTIST :
					// g_print("CD_TAG_ARTIST\n");
					// g_print("%s\n", Audio->tags->Artist);
					g_string_append_printf (gstr, "%s", Audio->tags->Artist);
					break;
				case CD_TAG_ALBUM :
					// g_print("CD_TAG_ALBUM\n");
					// g_print("%s\n", Audio->tags->Album);
					g_string_append_printf (gstr, "%s", Audio->tags->Album);
					break;
				case CD_TAG_INT_NUMBER :
					// g_print("CD_TAG_INT_NUMBER\n");
					// g_print("%02d\n", Audio->tags->IntNumber);
					g_string_append_printf (gstr, "%02d", Audio->tags->IntNumber);
					break;
				case CD_TAG_TITLE :
					// g_print("CD_TAG_TITLE\n");
					// g_print("'%s'\n", Audio->tags->Title);
					g_string_append_printf (gstr, "%s", Audio->tags->Title);
					break;
				case CD_TAG_YEAR :
					// g_print("CD_TAG_YEAR\n");
					// g_print("%s\n", Audio->tags->Year);
					g_string_append_printf (gstr, "%s", Audio->tags->Year);
					break;
				case CD_TAG_GENRE :
					// g_print("CD_TAG_GENRE\n");
					// g_print("%s\n", Audio->tags->Genre);
					g_string_append_printf (gstr, "%s", Audio->tags->Genre);
					break;
				case CD_TAG_FILE_M3U_XSPF :
					// g_print("CD_TAG_FILE_M3U_XSPF\n");
					// g_print("BoolCreateFileM3uXspf = %s\n", Parse->BoolCreateFileM3uXspf ? "TRUE" : "FALSE");
					var_cd.Bool_create_file_m3u = FALSE;
					var_cd.Bool_create_file_m3u = Parse->BoolCreateFileM3uXspf;
					break;
				case CD_TAG_CAR_REPLACE :
					// LES REMPLACEMENT DE CARACTERES SE FONT A LA FIN ...
					// g_print("CD_TAG_REPLACE\n");
					// g_print("%s ==> %s\n", Parse->StringReplaceOld,  Parse->StringReplaceNew);
					break;
				case CD_TAG_DEFAULT :
					// g_print("CD_TAG_DEFAULT\n");
					// g_print("%s\n", Parse->StringDefault);
					g_string_append_printf (gstr, "%s", Parse->StringDefault);
					break;
				}
			}
			// STRUCTURE SUIVANTE
			ListParse = g_list_next (ListParse);
		}
		
		
		// QUELLE LIGNE ANALISER ?
		if (p_ParseType == PARSE_TYPE_STOCKAGE_CD) {
			ListParse = g_list_first (VarParse.ListParseStockCd);
		} else if (p_ParseType == PARSE_TYPE_TITLE_CD) {
			ListParse = g_list_first (VarParse.ListParseTitleCd);
		}
		
		// LISTE PARSE: REMPLACEMENT DE CARACTERES
		while (ListParse) {
			if ((Parse = (PARSE *)ListParse->data) != NULL) {
				if (Parse->CdTypeTag == CD_TAG_CAR_REPLACE) {
					gstrNew = g_string_new (NULL);
					Ptr = gstr->str;
					while (*Ptr) {
						// SI LES CARACTERES A COMPARER SONT DU MEME TYPE
						if (*Parse->StringReplaceOld < 0 && *(Parse->StringReplaceOld +1) < 0) {
							if (*Ptr < 0 && *(Ptr +1) < 0) {
								// REMPLACEMENT POSSIBLE ?
								if (*Parse->StringReplaceOld == *Ptr && *(Parse->StringReplaceOld +1) == *(Ptr +1)) {
									g_string_append_printf (gstrNew, "%s", Parse->StringReplaceNew);
									Ptr += 2;
									continue;
								}
							}
						// SI LES CARACTERES A COMPARER SONT DU MEME TYPE
						} else if (*Parse->StringReplaceOld > 0) {
							if (*Ptr > 0) {
								// REMPLACEMENT POSSIBLE ?
								if (*Parse->StringReplaceOld == *Ptr) {
									g_string_append_printf (gstrNew, "%s", Parse->StringReplaceNew);
									Ptr ++;
									continue;
								}
							}
						}
						g_string_append_printf (gstrNew, "%c", *Ptr);	
						Ptr ++;
					}
					g_string_free (gstr, TRUE);
					gstr = g_string_new (NULL);
					g_string_append_printf (gstr, "%s", gstrNew->str);
					g_string_free (gstrNew, TRUE);
				}
			}
			// STRUCTURE SUIVANTE
			ListParse = g_list_next (ListParse);
		}
	}
	
	Str = g_strdup (gstr->str);
	g_string_free (gstr, TRUE);
	return (Str);
}

// DEBUGING ...
//
void Parse_print_cd (PARSE_TYPE p_ParseType)
{
	gint	 Num_cell = 0;
	gchar	*Str = NULL;
	
	for (Num_cell = 0; Num_cell < EnteteCD.TotalTracks; Num_cell ++) {
		Str = Parse_get_line (p_ParseType, Num_cell);
		g_print ("%02d  %s\n", Num_cell, Str);
		g_free (Str);
		Str = NULL;
	}
}
	








