 /*
 * file      : options_flac.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>

#include <string.h>
#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "options.h"
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "info_song.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/
void optionsFlac_combobox_flac_compression_realize (GtkWidget *widget)
{
 	var_options.Adr_Widget_flac_compression =  GTK_COMBO_BOX (widget);
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("0  (Rapide)"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),   "1");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),   "2");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),   "3");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),   "4");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),   "5");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),   "6");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget),   "7");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("8  (Lent)"));

	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.compression_level_flac);
}

gchar *optionsFlac_get_compression_level_flac (void)
{
	static gchar *CompLevel[] = {"-0","-1","-2","-3","-4","-5","-6","-7","-8"};

	return ((gchar *)CompLevel [ gtk_combo_box_get_active ( var_options.Adr_Widget_flac_compression) ]);
}


void optionsFlac_combobox_flac_compression_changed (void)
{
	options_set_datas_interne (COLOR_FLAC_TAUX_COMPRESSION, var_options.Adr_label_flac_flac, FLAC_WAV_TO_FLAC);
}
