 /*
 * file      : notify_send.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>

#include "global.h"
#include "utils.h"
#include "notify_send.h"



typedef struct {
	pthread_t	 nmr_tid;
	gchar		*Title;
	gchar		*Str;
} VAR_NOTIFYSEND ;

VAR_NOTIFYSEND NotifySend;


void NotifySend_call (void)
{
	pid_t  pid;

	if ((pid = fork ()) == 0) {
		execlp ("notify-send",
			"notify-send",
			NotifySend.Title,
			NotifySend.Str,
			NULL);
		_exit (0);
	}
}

static void NotifySend_thread (void *arg)
{
	NotifySend_call ();
	pthread_exit(0);
}

void NotifySend_msg (gchar *Title, gchar *Str)
{
	if (NotifySend.Title != NULL) {
		g_free (NotifySend.Title);
		NotifySend.Title = NULL;
	}
	if (NotifySend.Str != NULL) {
		g_free (NotifySend.Str);
		NotifySend.Str = NULL;
	}
	
	if (utils_scan_by_which ("notify-send", NULL) == FALSE) {
		PRINT("(Package libnotify-bin): notify-send NOT EXIST");
		return;
	}
	
	NotifySend.Title = g_strdup_printf ("%s", Title);
	NotifySend.Str   = g_strdup_printf ("%s", Str);
	pthread_create (&NotifySend.nmr_tid, NULL ,(void *)NotifySend_thread, (void *)NULL);
}


