 /*
 * file      : normalise.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>

#include "global.h"
#include "file.h"
#include "utils.h"
#include "options.h"
#include "prg_init.h"
#include "win_control.h"
#include "win_norm_replay.h"
#include "logs.h"
#include "normalise.h"




/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/
typedef struct {
	gchar           *NameFile;
	gchar           *NameFileCopieWav;
	gchar           *NameFileCopieOgg;
	gchar           *NameFileCopieMp3;

	gchar           *NameDestWav;
	gchar           *NameDestOgg;
	gchar           *NameDestMp3;

	gchar           *StrDBFS;
	TAGS            *tags;

	gboolean         BoolWithConvert;

	ETAT_NORMALISE  *EtatNormalise;
	ETAT_TRASH_FILE *EtatTrash;
	
} INDI_FIX;

typedef struct {
	gboolean          bool_etat;
	gchar            *MessUser;
	
	/* Individuel */
	GList            *ListFixWav;
	GList            *ListFixOgg;
	GList            *ListFixMp3;

	GList            *ListPeakWav;
	GList            *ListPeakOgg;
	GList            *ListPeakMp3;

	GList            *ListMixGroupWav;
	GList            *ListMixGroupOgg;
	GList            *ListMixGroupMp3;

	GList            *ListPeakGroupWav;
	GList            *ListPeakGroupOgg;
	GList            *ListPeakGroupMp3;

	/* Exec */
	guint             Handler_Timeout;
	pthread_t         nmr_tid;
	gboolean          bool_thread_end;
	gboolean          bool_set_end_of_user;

	/* Controle duree */
	gboolean          bool_pass_conv;
	gint              pass_conv;
	gint              NbrElementsInList;
	gint              ElementActif;
	double            total_percent;

	/**/
	gchar            *FileOgg;
	gchar            *FileWav;
	gchar            *TmpRep;

	gint              LevelMix;
} NORMALISE;

NORMALISE normalise;



/*
*---------------------------------------------------------------------------
* REMOVE LIST
*---------------------------------------------------------------------------
*/
GList *normalise_remove_glist (GList *p_list)
{
	GList     *List = NULL;
	gchar     *Ptr = NULL;

	List = g_list_first (p_list);
	while (List) {
		if ((Ptr = (gchar *)List->data)) {
			g_free (Ptr);
			Ptr = NULL;
			List->data = NULL;
		}
		List = g_list_next(List);
	}
	g_list_free (p_list);
	p_list = NULL;
	return ((GList *)NULL);
}

GList *normalise_remove_glist_STRUCT (GList *p_list)
{
	GList     *List = NULL;
	INDI_FIX  *IndiFix = NULL;

	List = g_list_first (p_list);
	while (List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {
			if (IndiFix->NameFile) {
				g_free (IndiFix->NameFile);
				IndiFix->NameFile = NULL;
			}
			if (IndiFix->NameFileCopieWav) {
				g_free (IndiFix->NameFileCopieWav);
				IndiFix->NameFileCopieWav = NULL;
			}
			if (IndiFix->NameFileCopieOgg) {
				g_free (IndiFix->NameFileCopieOgg);
				IndiFix->NameFileCopieOgg = NULL;
			}
			if (IndiFix->NameFileCopieMp3) {
				g_free (IndiFix->NameFileCopieMp3);
				IndiFix->NameFileCopieMp3 = NULL;
			}

			if (IndiFix->NameDestWav) {
				g_free (IndiFix->NameDestWav);
				IndiFix->NameDestWav = NULL;
			}
			if (IndiFix->NameDestOgg) {
				g_free (IndiFix->NameDestOgg);
				IndiFix->NameDestOgg = NULL;
			}
			if (IndiFix->NameDestMp3) {
				g_free (IndiFix->NameDestMp3);
				IndiFix->NameDestMp3 = NULL;
			}

			if (IndiFix->StrDBFS) {
				g_free (IndiFix->StrDBFS);
				IndiFix->StrDBFS = NULL;
			}
			IndiFix->tags = NULL;

			IndiFix->EtatNormalise = NULL;
			
			g_free (IndiFix);
			IndiFix = NULL;
			List->data = NULL;
		}
		List = g_list_next(List);
	}
	g_list_free (p_list);
	p_list = NULL;
	return ((GList *)NULL);
}

/*
*---------------------------------------------------------------------------
* CONSTRUCTION INDIVIDUEL
*---------------------------------------------------------------------------
*/
void normalise_print_DEBUG (GList *p_list)
{
	GList     *List = NULL;
	INDI_FIX  *IndiFix = NULL;

	List = g_list_first (p_list);
	while (List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {
			g_print ("IndiFix->NameFile      = %s\n", IndiFix->NameFile);
			g_print ("IndiFix->NameFileCopieWav = %s\n", IndiFix->NameFileCopieWav);
		}
		List = g_list_next(List);
	}
}

void normalise_copy_wav_to_tmp (GList *p_list)
{
	GList         *List = NULL;
	INDI_FIX      *IndiFix = NULL;
	
	List = g_list_first (p_list);
	while (List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {
			conv_copy_src_to_dest (IndiFix->NameFile, IndiFix->NameFileCopieWav);
			normalise.ElementActif ++;
		}
		List = g_list_next(List);
	}
}

void normalise_set_mess (gchar *p_Mess)
{
	if (normalise.bool_etat == FALSE) {
		// normalise.bool_etat = TRUE;
		// normalise.MessUser = g_strdup (p_Mess);
	}
}

void normalise_FIX_wav (void)
{
	GList         *List = NULL;
	GList         *ListNorm = NULL;
	INDI_FIX      *IndiFix = NULL;

	List = g_list_first (normalise.ListFixWav);
	while (normalise.bool_set_end_of_user == FALSE && List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {

			/* Copie temporaire
			*/
			normalise.ElementActif ++;

			normalise_set_mess ("Copie");
			conv_copy_src_to_dest (IndiFix->NameFile, IndiFix->NameFileCopieWav);

			/* Normalisation du Wav
			*/
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup ("-a"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%s,0000dB", IndiFix->StrDBFS));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));

			normalise_set_mess ("Normalise Wav -> Fix");

			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> Fix");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
			
			normalise.ElementActif ++;

			/* Restitution
			*/
			/*
			NameDestWav *
			NameDestOgg
			NameDestMp3
			*/
			if (IndiFix->BoolWithConvert == FALSE) {

				normalise_set_mess ("Restitution");

				conv_copy_src_to_dest (IndiFix->NameFileCopieWav, IndiFix->NameDestWav);
				infosong_delete_file (IndiFix->NameFileCopieWav);
				
				logs_writeln_datas ("FIX WAV");
				logs_write_datas ("\t");
				logs_writeln_datas (IndiFix->NameDestWav);
				
				normalise.ElementActif ++;
			}

			/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF;*/
			if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
		}
		List = g_list_next(List);
	}
}
void normalise_FIX_ogg (void)
{
	GList		*List = NULL;
	GList		*ListNorm = NULL;
	GList		*listmplayer = NULL;
	INDI_FIX	*IndiFix = NULL;
	PARAM_FILELC	 param_filelc;

	List = g_list_first (normalise.ListFixOgg);
	while (normalise.bool_set_end_of_user == FALSE && List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {

			/* Conversion Ogg vers Wav
			*/

			normalise_set_mess ("Conversion Ogg vers Wav");
			/*
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			ListNorm = g_list_append (ListNorm, g_strdup ("ogg123"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-d"));
			ListNorm = g_list_append (ListNorm, g_strdup ("wav"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-f"));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));

			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, OGG123_OGG_TO_WAV, ListNorm, "OGG123_OGG_TO_WAV CONVERSION Ogg vers Wav");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
			*/
		GDK_THREADS_ENTER();
			listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
			listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
			listmplayer = g_list_append (listmplayer, g_strdup_printf ("%d", options_get_val_nice ()));
			listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
			
			listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
			listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

			listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
			listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
			listmplayer = g_list_append (listmplayer, g_strdup (IndiFix->NameFile));
			listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
			listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", IndiFix->NameFileCopieWav));

			conv.ArgConv = conv_alloc_arg (listmplayer);
		GDK_THREADS_LEAVE();
			conv_exec (FALSE, MPLAYER_OGG_TO_WAV, listmplayer, "MPLAYER_OGG_TO_WAV");
		GDK_THREADS_ENTER();
			listmplayer = filelc_remove_glist (listmplayer);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
		GDK_THREADS_LEAVE();

			normalise.ElementActif ++;

			/* Normalisation du Wav
			*/

			normalise_set_mess ("Normalise Wav -> Fix");

			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup ("-a"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%s,0000dB", IndiFix->StrDBFS));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));

			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC NORMALISATION du Wav");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;

			normalise.ElementActif ++;

			/* Restitution: Conversion Wav vers Ogg
			*/
			/*
			NameDestWav
			NameDestOgg *
			NameDestMp3
			*/
			if (IndiFix->BoolWithConvert == FALSE) {

				normalise_set_mess ("Conversion Wav vers Ogg");

				param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
				param_filelc.With_CommandLineUser  = FALSE;
				param_filelc.filesrc               = IndiFix->NameFileCopieWav;
				param_filelc.filedest              = IndiFix->NameDestOgg;
				param_filelc.tags                  = IndiFix->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				ListNorm = filelc_get_command_line (&param_filelc);
				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, OGGENC_WAV_TO_OGG, ListNorm, "OGGENC_WAV_TO_OGG");
				ListNorm = normalise_remove_glist (ListNorm);
				infosong_delete_file (IndiFix->NameFileCopieWav);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
				
				logs_writeln_datas ("FIX OGG");
				logs_write_datas ("\t");
				logs_writeln_datas (IndiFix->NameDestOgg);
				
				normalise.ElementActif ++;
			}

			/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
			if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
		}
		List = g_list_next(List);
	}
}
void normalise_FIX_mp3 (void)
{
	GList         *List = NULL;
	GList         *ListNorm = NULL;
	INDI_FIX      *IndiFix = NULL;
	PARAM_FILELC   param_filelc;

	List = g_list_first (normalise.ListFixMp3);
	while (normalise.bool_set_end_of_user == FALSE && List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {

			/* Conversion Mp3 vers Wav
			*/

			normalise_set_mess ("Conversion Mp3 vers Wav");

			/*
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			ListNorm = g_list_append (ListNorm, g_strdup ("mpg321"));
			ListNorm = g_list_append (ListNorm, g_strdup ("--stereo"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-v"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-w"));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, MPG321_MP3_TO_WAV, ListNorm, "MPG321_MP3_TO_WAV");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
			*/
		GDK_THREADS_ENTER();
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			ListNorm = g_list_append (ListNorm, g_strdup ("mplayer"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-nojoystick"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-nolirc"));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
			ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
			ListNorm = g_list_append (ListNorm, g_strdup ("pcm"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("pcm:file=%s",IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup ("-af"));
			ListNorm = g_list_append (ListNorm, g_strdup ("channels=2"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-srate"));
			ListNorm = g_list_append (ListNorm, g_strdup ("44100"));
			conv.ArgConv = conv_alloc_arg (ListNorm);
		GDK_THREADS_LEAVE();
			conv_exec (FALSE, MPLAYER_WAV_TO_WAV, ListNorm, "MPLAYER_WAV_TO_WAV");
		GDK_THREADS_ENTER();
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
		GDK_THREADS_LEAVE();
			
			normalise.ElementActif ++;

			/* Normalisation du Wav
			*/

			normalise_set_mess ("Normalise Wav -> Fix");

			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup ("-a"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%s,0000dB", IndiFix->StrDBFS));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));

			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC NORMALISATION du Wav");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;

			normalise.ElementActif ++;

			/* Restitution: Conversion Wav vers Mp3
			*/
			/*
			NameDestWav
			NameDestOgg
			NameDestMp3 *
			*/
			if (IndiFix->BoolWithConvert == FALSE) {

				normalise_set_mess ("Conversion du Wav vers Mp3");

				param_filelc.type_conv            = LAME_WAV_TO_MP3;
				param_filelc.With_CommandLineUser = FALSE;
				param_filelc.filesrc              = IndiFix->NameFileCopieWav;
				/*param_filelc.filedest             = IndiFix->NameFile;*/
				param_filelc.filedest             = IndiFix->NameDestMp3;
				param_filelc.tags                 = IndiFix->tags;
				param_filelc.cdrom                = NULL;
				param_filelc.num_track            = NULL;

				ListNorm = filelc_get_command_line (&param_filelc);
				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, LAME_WAV_TO_MP3, ListNorm, "LAME_WAV_TO_MP3");
				ListNorm = normalise_remove_glist (ListNorm);
				infosong_delete_file (IndiFix->NameFileCopieWav);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
				
				logs_writeln_datas ("FIX MP3");
				logs_write_datas ("\t");
				logs_writeln_datas (IndiFix->NameDestMp3);
				
				normalise.ElementActif ++;
			}

			/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
			if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
		}
		List = g_list_next(List);
	}
}
void normalise_PEAK_wav (void)
{
	GList         *List = NULL;
	GList         *ListNorm = NULL;
	INDI_FIX      *IndiFix = NULL;
	
	List = g_list_first (normalise.ListPeakWav);
	while (normalise.bool_set_end_of_user == FALSE && List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {

			/* Copie temporaire
			*/

			normalise_set_mess ("Copie");

			conv_copy_src_to_dest (IndiFix->NameFile, IndiFix->NameFileCopieWav);
			
			normalise.ElementActif ++;

			/* Normalisation du Wav
			*/

			normalise_set_mess ("Normalise Wav -> Peak");

			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup ("--peak"));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup ("--"));
			/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
			if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;

			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> Peak");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
			
			normalise.ElementActif ++;

			/* Restitution
			*/
			/*
			NameDestWav *
			NameDestOgg
			NameDestMp3
			*/
			if (IndiFix->BoolWithConvert == FALSE) {

				normalise_set_mess ("Restitution");

				conv_copy_src_to_dest (IndiFix->NameFileCopieWav, IndiFix->NameDestWav);
				infosong_delete_file (IndiFix->NameFileCopieWav);
				
				logs_writeln_datas ("PEAK WAV");
				logs_write_datas ("\t");
				logs_writeln_datas (IndiFix->NameDestWav);
				
				normalise.ElementActif ++;
			}

		}
		List = g_list_next(List);
	}
}
void normalise_PEAK_ogg (void)
{
	GList         *List = NULL;
	GList         *ListNorm = NULL;
	INDI_FIX      *IndiFix = NULL;
	PARAM_FILELC   param_filelc;

	List = g_list_first (normalise.ListPeakOgg);
	while (normalise.bool_set_end_of_user == FALSE && List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {

			/* Conversion Ogg vers Wav
			*/
			normalise_set_mess ("Conversion Ogg vers Wav");

			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			ListNorm = g_list_append (ListNorm, g_strdup ("ogg123"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-d"));
			ListNorm = g_list_append (ListNorm, g_strdup ("wav"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-f"));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));

			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, OGG123_OGG_TO_WAV, ListNorm, "OGG123_OGG_TO_WAV CONVERSION Ogg vers Wav");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;

			normalise.ElementActif ++;
		
			/* Normalisation du Wav
			*/
			normalise_set_mess ("Normalise Wav -> Fix");

			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup ("--peak"));
			/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
			if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;

			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> Peak");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;

			normalise.ElementActif ++;
		
			/* Restitution: Conversion Wav vers Ogg
			*/
			/*
			NameDestWav
			NameDestOgg *
			NameDestMp3
			*/
			if (IndiFix->BoolWithConvert == FALSE) {

				normalise_set_mess ("Conversion Wav vers Ogg");

				param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
				param_filelc.With_CommandLineUser  = FALSE;
				param_filelc.filesrc               = IndiFix->NameFileCopieWav;
				param_filelc.filedest              = IndiFix->NameDestOgg;
				param_filelc.tags                  = IndiFix->tags;
				param_filelc.cdrom                 = NULL;
				param_filelc.num_track             = NULL;

				ListNorm = filelc_get_command_line (&param_filelc);
				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, OGGENC_WAV_TO_OGG, ListNorm, "OGGENC_WAV_TO_OGG");
				ListNorm = normalise_remove_glist (ListNorm);
				infosong_delete_file (IndiFix->NameFileCopieWav);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
				
				logs_writeln_datas ("PEAK OGG");
				logs_write_datas ("\t");
				logs_writeln_datas (IndiFix->NameDestOgg);
				
				normalise.ElementActif ++;
			}

		}
		List = g_list_next(List);
	}
}
void normalise_PEAK_mp3 (void)
{
	GList         *List = NULL;
	GList         *ListNorm = NULL;
	INDI_FIX      *IndiFix = NULL;
	PARAM_FILELC   param_filelc;

	List = g_list_first (normalise.ListPeakMp3);
	while (normalise.bool_set_end_of_user == FALSE && List) {
		if ((IndiFix = (INDI_FIX *)List->data)) {

			/* Conversion Mp3 vers Wav
			*/
			normalise_set_mess ("Conversion Mp3 vers Wav");

			/*
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			ListNorm = g_list_append (ListNorm, g_strdup ("mpg321"));
			ListNorm = g_list_append (ListNorm, g_strdup ("--stereo"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-v"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-w"));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, MPG321_MP3_TO_WAV, ListNorm, "MPG321_MP3_TO_WAV");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
			*/
		GDK_THREADS_ENTER();
			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			ListNorm = g_list_append (ListNorm, g_strdup ("mplayer"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-nojoystick"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-nolirc"));
			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
			ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
			ListNorm = g_list_append (ListNorm, g_strdup ("pcm"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("pcm:file=%s",IndiFix->NameFileCopieWav));
			ListNorm = g_list_append (ListNorm, g_strdup ("-af"));
			ListNorm = g_list_append (ListNorm, g_strdup ("channels=2"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-srate"));
			ListNorm = g_list_append (ListNorm, g_strdup ("44100"));
			conv.ArgConv = conv_alloc_arg (ListNorm);
		GDK_THREADS_LEAVE();
			conv_exec (FALSE, MPLAYER_WAV_TO_WAV, ListNorm, "MPLAYER_WAV_TO_WAV");
		GDK_THREADS_ENTER();
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;
		GDK_THREADS_LEAVE();
			
			normalise.ElementActif ++;

			/* Normalisation du Wav
			*/
			normalise_set_mess ("Normalise Wav -> Peak");

			ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
			ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
			ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
			// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
			ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
			ListNorm = g_list_append (ListNorm, g_strdup ("--peak"));

			/*ListNorm = g_list_append (ListNorm, g_strdup ("-T"));
			ListNorm = g_list_append (ListNorm, g_strdup ("0,2"));*/

			ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieMp3));
			conv.ArgConv = conv_alloc_arg (ListNorm);
			conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> Peak");
			ListNorm = normalise_remove_glist (ListNorm);
			g_free (conv.ArgConv);
			conv.ArgConv = NULL;

			normalise.ElementActif ++;

			/* Restitution: Conversion Wav vers Mp3
			*/
			/*
			NameDestWav
			NameDestOgg
			NameDestMp3 *
			*/
			if (IndiFix->BoolWithConvert == FALSE) {

				normalise_set_mess ("Conversion du Wav vers Mp3");

				param_filelc.type_conv            = LAME_WAV_TO_MP3;
				param_filelc.With_CommandLineUser = FALSE;
				param_filelc.filesrc              = IndiFix->NameFileCopieWav;
				param_filelc.filedest             = IndiFix->NameDestMp3;
				param_filelc.tags                 = IndiFix->tags;
				param_filelc.cdrom                = NULL;
				param_filelc.num_track            = NULL;

				ListNorm = filelc_get_command_line (&param_filelc);
				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, LAME_WAV_TO_MP3, ListNorm, "LAME_WAV_TO_MP3");
				ListNorm = normalise_remove_glist (ListNorm);
				infosong_delete_file (IndiFix->NameFileCopieWav);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
				
				logs_writeln_datas ("PEAK MP3");
				logs_write_datas ("\t");
				logs_writeln_datas (IndiFix->NameDestMp3);
				
				normalise.ElementActif ++;
			}

			/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
			if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
		}
		List = g_list_next(List);
	}
}
void normalise_MIX_RMS_GROUP_wav_ogg_mp3 (void)
{
	GList         *List = NULL;
	GList         *ListNorm = NULL;
	INDI_FIX      *IndiFix = NULL;
	PARAM_FILELC   param_filelc;

	PRINT_FUNC_LF();

	/* COPIE  WAV OGG MP3
	*/
	if (normalise.bool_set_end_of_user == FALSE && normalise.ListMixGroupWav != NULL) {

		normalise_set_mess ("(MIX)RMS/GROUPE (Temp): Copie 'wav' vers dossier temporaire");
		
		conv.bool_percent_conv = TRUE;
		normalise_copy_wav_to_tmp (normalise.ListMixGroupWav);
	}
	/* Conversion Ogg vers Wav */
	if (normalise.bool_set_end_of_user == FALSE && normalise.ListMixGroupOgg != NULL) {

		normalise_set_mess ("(MIX)RMS/GROUPE (Temp): Conversion Ogg vers Wav");
		
		List = g_list_first (normalise.ListMixGroupOgg);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
				ListNorm = g_list_append (ListNorm, g_strdup ("ogg123"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-d"));
				ListNorm = g_list_append (ListNorm, g_strdup ("wav"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-f"));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));

				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, OGG123_OGG_TO_WAV, ListNorm, "OGG123_OGG_TO_WAV CONVERSION Ogg vers Wav");
				ListNorm = normalise_remove_glist (ListNorm);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;

				normalise.ElementActif ++;
			}
			List = g_list_next(List);
		}
	}
	/* Conversion Mp3 vers Wav */
	if (normalise.bool_set_end_of_user == FALSE && normalise.ListMixGroupMp3 != NULL) {

		normalise_set_mess ("(MIX)RMS/GROUPE (Temp): Conversion Mp3 vers Wav");

		List = g_list_first (normalise.ListMixGroupMp3);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				
				/*
				ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
				ListNorm = g_list_append (ListNorm, g_strdup ("mpg321"));
				ListNorm = g_list_append (ListNorm, g_strdup ("--stereo"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-v"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-w"));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, MPG321_MP3_TO_WAV, ListNorm, "MPG321_MP3_TO_WAV");
				ListNorm = normalise_remove_glist (ListNorm);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
				*/
			GDK_THREADS_ENTER();
				ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
				ListNorm = g_list_append (ListNorm, g_strdup ("mplayer"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-nojoystick"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-nolirc"));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
				ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
				ListNorm = g_list_append (ListNorm, g_strdup ("pcm"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("pcm:file=%s",IndiFix->NameFileCopieWav));
				ListNorm = g_list_append (ListNorm, g_strdup ("-af"));
				ListNorm = g_list_append (ListNorm, g_strdup ("channels=2"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-srate"));
				ListNorm = g_list_append (ListNorm, g_strdup ("44100"));
				conv.ArgConv = conv_alloc_arg (ListNorm);
			GDK_THREADS_LEAVE();
				conv_exec (FALSE, MPLAYER_WAV_TO_WAV, ListNorm, "MPLAYER_WAV_TO_WAV");
			GDK_THREADS_ENTER();
				ListNorm = normalise_remove_glist (ListNorm);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
			GDK_THREADS_LEAVE();
				
				normalise.ElementActif ++;
			}
			List = g_list_next(List);
		}
	}
	
	/* NORMALISE  WAV
	*/
	if (normalise.bool_set_end_of_user == FALSE) {

		normalise_set_mess ("(MIX)RMS/GROUPE: Normalise Wav");
		
		ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
		ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
		ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
		// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
		ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
		ListNorm = g_list_append (ListNorm, g_strdup ("-a"));
		ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d,0000dB", normalise.LevelMix));
		ListNorm = g_list_append (ListNorm, g_strdup ("--batch"));
		/* Creation liste WAV */
		List = g_list_first (normalise.ListMixGroupWav);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
				if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
			}
			List = g_list_next(List);
		}
		/* Creation liste OGG */
		List = g_list_first (normalise.ListMixGroupOgg);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
				if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
			}
			List = g_list_next(List);
		}
		/* Creation liste MP3 */
		List = g_list_first (normalise.ListMixGroupMp3);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
				if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
			}
			List = g_list_next(List);
		}
		/* Normalisation */
		conv.ArgConv = conv_alloc_arg (ListNorm);
		conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> (MIX)RMS/GROUPE");
		ListNorm = normalise_remove_glist (ListNorm);
		g_free (conv.ArgConv);
		conv.ArgConv = NULL;
		normalise.ElementActif ++;
	}
	
	/* RESTITUE  WAV OGG MP3
	*/
	if (normalise.bool_set_end_of_user == FALSE) {
		/* Restitue liste WAV */
		if (IndiFix->BoolWithConvert == FALSE) {

			normalise_set_mess ("(MIX)RMS/GROUPE (Restitution): Restitution des fichiers 'wav'");
			
			List = g_list_first (normalise.ListMixGroupWav);
			while (List) {
				if ((IndiFix = (INDI_FIX *)List->data)) {
					conv_copy_src_to_dest (IndiFix->NameFileCopieWav, IndiFix->NameDestWav);
					infosong_delete_file (IndiFix->NameFileCopieWav);
					normalise.ElementActif ++;
					conv.bool_percent_conv = TRUE;
				
					logs_writeln_datas ("(MIX)RMS/GROUPE: WAV");
					logs_write_datas ("\t");
					logs_writeln_datas (IndiFix->NameDestWav);
				}
				List = g_list_next(List);
			}
		}
		/* Restitue liste OGG */
		if (IndiFix->BoolWithConvert == FALSE) {

			normalise_set_mess ("(MIX)RMS/GROUPE (Restitution): Conversion Wav vers Ogg");
			
			List = g_list_first (normalise.ListMixGroupOgg);
			while (List) {
				if ((IndiFix = (INDI_FIX *)List->data)) {
					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = IndiFix->NameFileCopieWav;
					param_filelc.filedest              = IndiFix->NameDestOgg;
					param_filelc.tags                  = IndiFix->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;

					ListNorm = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (ListNorm);
					conv_exec (FALSE, OGGENC_WAV_TO_OGG, ListNorm, "OGGENC_WAV_TO_OGG");
					ListNorm = normalise_remove_glist (ListNorm);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;

					infosong_delete_file (IndiFix->NameFileCopieWav);

					normalise.ElementActif ++;
				
					logs_writeln_datas ("(MIX)RMS/GROUPE: OGG");
					logs_write_datas ("\t");
					logs_writeln_datas (IndiFix->NameDestOgg);
				}
				List = g_list_next(List);
			}
		}
		/* Restitue liste MP3 */
		if (IndiFix->BoolWithConvert == FALSE) {

			normalise_set_mess ("(MIX)RMS/GROUPE (Restitution): Conversion Wav vers Mp3");
			
			List = g_list_first (normalise.ListMixGroupMp3);
			while (List) {
				if ((IndiFix = (INDI_FIX *)List->data)) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = IndiFix->NameFileCopieWav;
					param_filelc.filedest             = IndiFix->NameDestMp3;
					param_filelc.tags                 = IndiFix->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;

					ListNorm = filelc_get_command_line (&param_filelc);

					conv.ArgConv = conv_alloc_arg (ListNorm);
					conv_exec (FALSE, LAME_WAV_TO_MP3, ListNorm, "LAME_WAV_TO_MP3");
					ListNorm = normalise_remove_glist (ListNorm);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;

					infosong_delete_file (IndiFix->NameFileCopieWav);

					normalise.ElementActif ++;
				
					logs_writeln_datas ("(MIX)RMS/GROUPE: MP3");
					logs_write_datas ("\t");
					logs_writeln_datas (IndiFix->NameDestMp3);
				}
				List = g_list_next(List);
			}
		}
	}
}
void normalise_PEAK_RMS_GROUP_wav_ogg_mp3 (void)
{
	GList         *List = NULL;
	GList         *ListNorm = NULL;
	INDI_FIX      *IndiFix = NULL;
	PARAM_FILELC   param_filelc;
	
	/* COPIE  WAV OGG MP3
	*/
	if (normalise.bool_set_end_of_user == FALSE && normalise.ListPeakGroupWav != NULL) {

		normalise_set_mess ("PEAK/GROUPE (Temp): Copie 'wav' vers dossier temporaire");
		
		normalise_copy_wav_to_tmp (normalise.ListPeakGroupWav);
	}
	/* Conversion Ogg vers Wav */
	if (normalise.bool_set_end_of_user == FALSE && normalise.ListPeakGroupOgg != NULL) {

		normalise_set_mess ("PEAK/GROUPE (Temp): Conversion Ogg vers Wav");
		
		List = g_list_first (normalise.ListPeakGroupOgg);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
				ListNorm = g_list_append (ListNorm, g_strdup ("ogg123"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-d"));
				ListNorm = g_list_append (ListNorm, g_strdup ("wav"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-f"));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));

				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, OGG123_OGG_TO_WAV, ListNorm, "OGG123_OGG_TO_WAV CONVERSION Ogg vers Wav");
				ListNorm = normalise_remove_glist (ListNorm);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;

				normalise.ElementActif ++;
			}
			List = g_list_next(List);
		}
	}
	/* Conversion Mp3 vers Wav */
	if (normalise.bool_set_end_of_user == FALSE && normalise.ListPeakGroupMp3 != NULL) {

		normalise_set_mess ("PEAK/GROUPE (Temp): Conversion Mp3 vers Wav");
		
		List = g_list_first (normalise.ListPeakGroupMp3);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				
				/*
				ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
				ListNorm = g_list_append (ListNorm, g_strdup ("mpg321"));
				ListNorm = g_list_append (ListNorm, g_strdup ("--stereo"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-v"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-w"));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
				conv.ArgConv = conv_alloc_arg (ListNorm);
				conv_exec (FALSE, MPG321_MP3_TO_WAV, ListNorm, "MPG321_MP3_TO_WAV");
				ListNorm = normalise_remove_glist (ListNorm);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
				*/
			GDK_THREADS_ENTER();
				ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
				ListNorm = g_list_append (ListNorm, g_strdup ("mplayer"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-nojoystick"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-nolirc"));
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFile));
				ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
				ListNorm = g_list_append (ListNorm, g_strdup ("pcm"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-ao"));
				ListNorm = g_list_append (ListNorm, g_strdup_printf ("pcm:file=%s",IndiFix->NameFileCopieWav));
				ListNorm = g_list_append (ListNorm, g_strdup ("-af"));
				ListNorm = g_list_append (ListNorm, g_strdup ("channels=2"));
				ListNorm = g_list_append (ListNorm, g_strdup ("-srate"));
				ListNorm = g_list_append (ListNorm, g_strdup ("44100"));
				conv.ArgConv = conv_alloc_arg (ListNorm);
			GDK_THREADS_LEAVE();
				conv_exec (FALSE, MPLAYER_WAV_TO_WAV, ListNorm, "MPLAYER_WAV_TO_WAV");
			GDK_THREADS_ENTER();
				ListNorm = normalise_remove_glist (ListNorm);
				g_free (conv.ArgConv);
				conv.ArgConv = NULL;
			GDK_THREADS_LEAVE();
				
				normalise.ElementActif ++;
			}
			List = g_list_next(List);
		}
	}
	
	/* NORMALISE  WAV
	*/
	if (normalise.bool_set_end_of_user == FALSE) {
		
		GList *ListFile = NULL;
		
		normalise_set_mess ("PEAK/GROUPE: Chercher la moyenne Peak");
		
		/* CHERCHER LA MOYENNE PEAK */
		ListFile = g_list_append (ListFile, g_strdup ("nice"));
		ListFile = g_list_append (ListFile, g_strdup ("-n"));
		ListFile = g_list_append (ListFile, g_strdup_printf ("%d", options_get_val_nice ()));
		// ListFile = g_list_append (ListFile, g_strdup (PrgInit.name_normalize));
		ListFile = g_list_append (ListFile, g_strdup (prginit_get_name (NMR_normalize)));

		ListFile = g_list_append (ListFile, g_strdup ("-n"));
		/* Creation liste WAV */
		List = g_list_first (normalise.ListPeakGroupWav);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListFile = g_list_append (ListFile, g_strdup (IndiFix->NameFileCopieWav));
			}
			List = g_list_next(List);
		}
		/* Creation liste OGG */
		List = g_list_first (normalise.ListPeakGroupOgg);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListFile = g_list_append (ListFile, g_strdup (IndiFix->NameFileCopieWav));
			}
			List = g_list_next(List);
		}
		/* Creation liste MP3 */
		List = g_list_first (normalise.ListPeakGroupMp3);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListFile = g_list_append (ListFile, g_strdup (IndiFix->NameFileCopieWav));
			}
			List = g_list_next(List);
		}
		/* Chercher la moyenne PEAK */
		conv.ArgConv = conv_alloc_arg (ListFile);
		conv_exec (FALSE, NORMALISE_GET_LEVEL, ListFile, "NORMALISE_GET_LEVEL TEST -> PEAK/GROUP");
		ListFile = normalise_remove_glist (ListFile);
		
		/* APPLIQUER LA MOYENNE PEAK */

		normalise_set_mess ("PEAK/GROUPE: Normalise Wav");
		
		ListNorm = g_list_append (ListNorm, g_strdup ("nice"));
		ListNorm = g_list_append (ListNorm, g_strdup ("-n"));
		ListNorm = g_list_append (ListNorm, g_strdup_printf ("%d", options_get_val_nice ()));
		// ListNorm = g_list_append (ListNorm, g_strdup (PrgInit.name_normalize));
		ListNorm = g_list_append (ListNorm, g_strdup (prginit_get_name (NMR_normalize)));
		ListNorm = g_list_append (ListNorm, g_strdup_printf ("--gain=%fdB", conv.value_PEAK_RMS_GROUP_ARGS));
		
		/* Creation liste WAV */
		List = g_list_first (normalise.ListPeakGroupWav);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
				if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
			}
			List = g_list_next(List);
		}
		/* Creation liste OGG */
		List = g_list_first (normalise.ListPeakGroupOgg);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
				if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
			}
			List = g_list_next(List);
		}
		/* Creation liste MP3 */
		List = g_list_first (normalise.ListPeakGroupMp3);
		while (List) {
			if ((IndiFix = (INDI_FIX *)List->data)) {
				ListNorm = g_list_append (ListNorm, g_strdup (IndiFix->NameFileCopieWav));
				/* *IndiFix->EtatNormalise = NORM_SCAN_ACTIF; */
				if (*IndiFix->EtatTrash == FILE_TRASH_OK) *IndiFix->EtatTrash = FILE_TRASH_VERIF_OK;
			}
			List = g_list_next(List);
		}
		/* Normalisation */
		conv.ArgConv = conv_alloc_arg (ListNorm);
		conv_exec (FALSE, NORMALISE_EXEC, ListNorm, "NORMALISE_EXEC Wav -> PEAK/GROUP");
		ListNorm = normalise_remove_glist (ListNorm);
		g_free (conv.ArgConv);
		conv.ArgConv = NULL;
		normalise.ElementActif ++;
	}
	
	/* RESTITUE  WAV OGG MP3
	*/
	if (normalise.bool_set_end_of_user == FALSE) {
		/* Restitue liste WAV */
		if (IndiFix->BoolWithConvert == FALSE) {

			normalise_set_mess ("PEAK/GROUPE (Restitution): Restitution des fichiers 'wav'");
			
			List = g_list_first (normalise.ListPeakGroupWav);
			while (List) {
				if ((IndiFix = (INDI_FIX *)List->data)) {
					/* Bug de copie signalee par @Dzef
					*/
					if (IndiFix->BoolWithConvert == TRUE) {
						conv_copy_src_to_dest (IndiFix->NameFileCopieWav, IndiFix->NameDestWav);
					}
					infosong_delete_file (IndiFix->NameFileCopieWav);
					normalise.ElementActif ++;
				
					logs_writeln_datas ("PEAK/GROUPE: WAV");
					logs_write_datas ("\t");
					logs_writeln_datas (IndiFix->NameDestWav);
				}
				List = g_list_next(List);
			}
		}
		/* Restitue liste OGG */
		if (IndiFix->BoolWithConvert == FALSE) {

			normalise_set_mess ("PEAK/GROUPE (Restitution): Conversion Wav vers Ogg");

			List = g_list_first (normalise.ListPeakGroupOgg);
			while (List) {
				if ((IndiFix = (INDI_FIX *)List->data)) {
					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = FALSE;
					param_filelc.filesrc               = IndiFix->NameFileCopieWav;
					param_filelc.filedest              = IndiFix->NameDestOgg;
					param_filelc.tags                  = IndiFix->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;

					ListNorm = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (ListNorm);
					conv_exec (FALSE, OGGENC_WAV_TO_OGG, ListNorm, "OGGENC_WAV_TO_OGG");
					ListNorm = normalise_remove_glist (ListNorm);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;

					infosong_delete_file (IndiFix->NameFileCopieWav);

					normalise.ElementActif ++;
				
					logs_writeln_datas ("PEAK/GROUPE: OGG");
					logs_write_datas ("\t");
					logs_writeln_datas (IndiFix->NameDestOgg);
				}
				List = g_list_next(List);
			}
		}
		/* Restitue liste MP3 */
		if (IndiFix->BoolWithConvert == FALSE) {

			normalise_set_mess ("PEAK/GROUPE (Restitution): Conversion Wav vers Mp3");

			List = g_list_first (normalise.ListPeakGroupMp3);
			while (List) {
				if ((IndiFix = (INDI_FIX *)List->data)) {
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = FALSE;
					param_filelc.filesrc              = IndiFix->NameFileCopieWav;
					param_filelc.filedest             = IndiFix->NameDestMp3;
					param_filelc.tags                 = IndiFix->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;

					ListNorm = filelc_get_command_line (&param_filelc);

					conv.ArgConv = conv_alloc_arg (ListNorm);
					conv_exec (FALSE, LAME_WAV_TO_MP3, ListNorm, "LAME_WAV_TO_MP3");
					ListNorm = normalise_remove_glist (ListNorm);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;

					infosong_delete_file (IndiFix->NameFileCopieWav);

					normalise.ElementActif ++;
				
					logs_writeln_datas ("PEAK/GROUPE: MP3");
					logs_write_datas ("\t");
					logs_writeln_datas (IndiFix->NameDestMp3);
				}
				List = g_list_next(List);
			}
		}
	}
}

void normalise_action (void)
{
	// PRINT_FUNC_LF();

	normalise.bool_pass_conv = TRUE;
	
	if (normalise.ListFixWav != NULL) normalise_FIX_wav ();
	if (normalise.ListFixOgg != NULL) normalise_FIX_ogg ();
	if (normalise.ListFixMp3 != NULL) normalise_FIX_mp3 ();
	
	if (normalise.ListPeakWav != NULL) normalise_PEAK_wav ();
	if (normalise.ListPeakOgg != NULL) normalise_PEAK_ogg ();
	if (normalise.ListPeakMp3 != NULL) normalise_PEAK_mp3 ();
	
	if (normalise.ListMixGroupWav != NULL ||
	    normalise.ListMixGroupOgg != NULL ||
	    normalise.ListMixGroupMp3 != NULL) normalise_MIX_RMS_GROUP_wav_ogg_mp3 ();
	
	if (normalise.ListPeakGroupWav != NULL ||
	    normalise.ListPeakGroupOgg != NULL ||
	    normalise.ListPeakGroupMp3 != NULL) normalise_PEAK_RMS_GROUP_wav_ogg_mp3 ();
	
	normalise.bool_pass_conv = FALSE;
}

/*
*---------------------------------------------------------------------------
* TESTS IF INDIVIDUEL OR COLLECTIF
*---------------------------------------------------------------------------
*/
gboolean normalise_individuel (void)
{
	GList            *List = NULL;
	DETAIL           *detail = NULL;
	FIC              *Fic = NULL;

	List = g_list_first (entetefile);
	while (List) {
		if ((detail = (DETAIL *)List->data)) {
			if ((Fic = (FIC *)detail->fic)) {
				if (Fic->Etat_Normalise == NORM_RMS_FIX) {

					gint Level = 0, NewLevel = 0;

					if (detail->type_infosong_file_is == FILE_IS_WAV) {
						INFO_WAV *info = (INFO_WAV *)detail->info;
						Level    = info->LevelDbfs.level;
						NewLevel = info->LevelDbfs.NewLevel;
					}
					else if (detail->type_infosong_file_is == FILE_IS_OGG) {
						INFO_OGG *info = (INFO_OGG *)detail->info;
						Level    = info->LevelDbfs.level;
						NewLevel = info->LevelDbfs.NewLevel;
					}
					else if (detail->type_infosong_file_is == FILE_IS_MP3) {
						INFO_MP3 *info = (INFO_MP3 *)detail->info;
						Level    = info->LevelDbfs.level;
						NewLevel = info->LevelDbfs.NewLevel;
					}
					if (Level != NewLevel) return (TRUE);
				}
				else if (Fic->Etat_Normalise > NORM_READY_FOR_SELECT) {
					return (TRUE);
				}
			}
		}
		List = g_list_next(List);
	}
	return (FALSE);
}

gboolean normalise_acces (DETAIL *detail)
{
	FIC  *Fic = NULL;

	if ((Fic = (FIC *)detail->fic) == NULL) return (FALSE);

	if (Fic->Etat_Normalise == NORM_RMS_FIX) {

		gint Level = 0, NewLevel = 0;

		if (detail->type_infosong_file_is == FILE_IS_WAV) {
			INFO_WAV *info = (INFO_WAV *)detail->info;
			Level    = info->LevelDbfs.level;
			NewLevel = info->LevelDbfs.NewLevel;
		}
		else if (detail->type_infosong_file_is == FILE_IS_OGG) {
			INFO_OGG *info = (INFO_OGG *)detail->info;
			Level    = info->LevelDbfs.level;
			NewLevel = info->LevelDbfs.NewLevel;
		}
		else if (detail->type_infosong_file_is == FILE_IS_MP3) {
			INFO_MP3 *info = (INFO_MP3 *)detail->info;
			Level    = info->LevelDbfs.level;
			NewLevel = info->LevelDbfs.NewLevel;
		}
		if (Level != NewLevel) return (TRUE);
	}
	else if (Fic->Etat_Normalise > NORM_READY_FOR_SELECT) {
		return (TRUE);
	}
	return (FALSE);
}

/*
*---------------------------------------------------------------------------
* THREAD
*---------------------------------------------------------------------------
*/
void normalise_get_NameFileCopie (INDI_FIX *p_IndiFix, gint pos)
{
	if (conv.TmpRep == NULL)
		conv.TmpRep  = utils_create_temporary_rep (PATH_TMP_XCFA_AUDIOFILE);

	p_IndiFix->NameFileCopieWav = g_strdup_printf ("%s/%d.wav", conv.TmpRep, pos);
	p_IndiFix->NameFileCopieOgg = g_strdup_printf ("%s/%d.ogg", conv.TmpRep, pos);
	p_IndiFix->NameFileCopieMp3 = g_strdup_printf ("%s/%d.mp3", conv.TmpRep, pos);
}

gboolean normalise_with_convert (DETAIL *detail)
{
	FIC   *fic = (FIC*)detail->fic;

	if (detail->type_infosong_file_is == FILE_IS_WAV ||
	    detail->type_infosong_file_is == FILE_IS_OGG ||
	    detail->type_infosong_file_is == FILE_IS_MP3) {

		if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
		    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
		    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

			if (fic->Etat_Normalise == NORM_RMS_FIX) {

				gint Level = 0, NewLevel = 0;

				if (detail->type_infosong_file_is == FILE_IS_WAV) {
					INFO_WAV *info = (INFO_WAV *)detail->info;
					Level    = info->LevelDbfs.level;
					NewLevel = info->LevelDbfs.NewLevel;
				}
				else if (detail->type_infosong_file_is == FILE_IS_OGG) {
					INFO_OGG *info = (INFO_OGG *)detail->info;
					Level    = info->LevelDbfs.level;
					NewLevel = info->LevelDbfs.NewLevel;
				}
				else if (detail->type_infosong_file_is == FILE_IS_MP3) {
					INFO_MP3 *info = (INFO_MP3 *)detail->info;
					Level    = info->LevelDbfs.level;
					NewLevel = info->LevelDbfs.NewLevel;
				}
				if (Level != NewLevel) {
					return (TRUE);
				}
			}
			else if (fic->Etat_Normalise > NORM_RMS_FIX) {
				return (TRUE);
			}
		}
	}

	return (FALSE);
}


void normalise_force_scan (gchar *p_Name)
{
	GList		*List = NULL;
	DETAIL		*detail = NULL;
	FIC		*Fic = NULL;
	
	List = g_list_first (entetefile);
	while (List) {
		if ((detail = (DETAIL *)List->data) != NULL) {
			if ((Fic = (FIC *)detail->fic) != NULL) {
			
				if (detail->type_infosong_file_is == FILE_IS_WAV ||
				    detail->type_infosong_file_is == FILE_IS_OGG ||
				    detail->type_infosong_file_is == FILE_IS_MP3) {
				    	
				    	if (strcmp (detail->namefile, p_Name) == 0) {
				    	
				    		if (Fic->Etat_Normalise == NORM_RMS_MIX_ALBUM || Fic->Etat_Normalise == NORM_RMS_FIX) {
							Fic->Etat_Scan = ETAT_SCAN_NONE;
							break;
						}
					}
				}
			}
		}
		List = g_list_next(List);
	}
}

void normalise_set_verif (GList *p_List)
{
	GList		*List = NULL;
	INDI_FIX	*IndiFix = NULL;

	List = g_list_first (p_List);
	while (List) {
		if ((IndiFix = (INDI_FIX *)List->data) != NULL) {
			normalise_force_scan (IndiFix->NameFile);
			normalise_force_scan (IndiFix->NameDestWav);
			normalise_force_scan (IndiFix->NameDestOgg);
			normalise_force_scan (IndiFix->NameDestMp3);
		}
		List = g_list_next(List);
	}
}

static void normalise_struct_lists (void *arg)
{
	GList            *List = NULL;
	DETAIL           *detail = NULL;
	FIC              *Fic = NULL;
	INDI_FIX         *IndiFix = NULL;

	// PRINT_FUNC_LF();

	normalise.bool_thread_end = FALSE;
	normalise.bool_set_end_of_user = FALSE;
	
	/* Si liste individuel */
	if (normalise_individuel ()) {

		gboolean bool_mix_wav = FALSE;
		gboolean bool_mix_ogg = FALSE;
		gboolean bool_mix_mp3 = FALSE;
		gboolean bool_peak_wav = FALSE;
		gboolean bool_peak_ogg = FALSE;
		gboolean bool_peak_mp3 = FALSE;

		/* FIX */
		normalise.ListFixWav		= normalise_remove_glist_STRUCT (normalise.ListFixWav);
		normalise.ListFixOgg		= normalise_remove_glist_STRUCT (normalise.ListFixOgg);
		normalise.ListFixMp3		= normalise_remove_glist_STRUCT (normalise.ListFixMp3);
		/* PEAK */
		normalise.ListPeakWav		= normalise_remove_glist_STRUCT (normalise.ListPeakWav);
		normalise.ListPeakOgg		= normalise_remove_glist_STRUCT (normalise.ListPeakOgg);
		normalise.ListPeakMp3		= normalise_remove_glist_STRUCT (normalise.ListPeakMp3);
		/* MIX */
		normalise.ListMixGroupWav	= normalise_remove_glist_STRUCT (normalise.ListMixGroupWav);
		normalise.ListMixGroupOgg	= normalise_remove_glist_STRUCT (normalise.ListMixGroupOgg);
		normalise.ListMixGroupMp3	= normalise_remove_glist_STRUCT (normalise.ListMixGroupMp3);
		/* PEAK-GROUP */
		normalise.ListPeakGroupWav	= normalise_remove_glist_STRUCT (normalise.ListPeakGroupWav);
		normalise.ListPeakGroupOgg	= normalise_remove_glist_STRUCT (normalise.ListPeakGroupOgg);
		normalise.ListPeakGroupMp3	= normalise_remove_glist_STRUCT (normalise.ListPeakGroupMp3);

		List = g_list_first (entetefile);
		while (List) {
			if ((detail = (DETAIL *)List->data)) {
				if ((Fic = (FIC *)detail->fic)) {

					/*
					bool_mix_wav = FALSE;
					bool_mix_ogg = FALSE;
					bool_mix_mp3 = FALSE;
					bool_peak_wav = FALSE;
					bool_peak_ogg = FALSE;
					bool_peak_mp3 = FALSE;

					if (normalise_with_convert (detail) == FALSE) {
						List = g_list_next(List);
						continue;
					}
					*/

					/* FILE_IS_WAV */
					if (detail->type_infosong_file_is == FILE_IS_WAV && normalise_acces (detail)) {

						INFO_WAV *info = (INFO_WAV *)detail->info;

						if (Fic->Etat_Normalise == NORM_RMS_FIX ||
						    Fic->Etat_Normalise == NORM_PEAK ||
						    Fic->Etat_Normalise == NORM_RMS_MIX_ALBUM ||
						    Fic->Etat_Normalise == NORM_PEAK_ALBUM) {

							info->LevelDbfs.level = Fic->LevelMix;
							
							IndiFix = (INDI_FIX *)g_malloc0 (sizeof (INDI_FIX));
							IndiFix->NameFile      = g_strdup (detail->namefile);
							IndiFix->StrDBFS       = g_strdup_printf ("%d", info->LevelDbfs.NewLevel);
							IndiFix->tags          = info->tags;
							
							IndiFix->EtatNormalise = &Fic->Etat_Normalise;
							
							IndiFix->EtatTrash     = &Fic->EtatTrash;
							
							normalise_get_NameFileCopie (IndiFix, g_list_position (entetefile, List));
							// GList *g_list_nth (GList *list, guint n);
										
							if ((IndiFix->BoolWithConvert = normalise_with_convert (detail)) == TRUE) {
								detail->namefileCopie = g_strdup (IndiFix->NameFileCopieWav);
							}

							IndiFix->NameDestWav = file_make_pathname_file (detail, FILE_IS_WAV);
							IndiFix->NameDestOgg = file_make_pathname_file (detail, FILE_IS_OGG);
							IndiFix->NameDestMp3 = file_make_pathname_file (detail, FILE_IS_MP3);
						}

						if (Fic->Etat_Normalise == NORM_RMS_FIX) {
							normalise.ListFixWav = g_list_append (normalise.ListFixWav, IndiFix);
							/* actions: 3 */
							normalise.NbrElementsInList += 2;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							
							/* Fic->Etat_Scan = ETAT_SCAN_DEMANDE;*/
						}
						else if (Fic->Etat_Normalise == NORM_PEAK) {
							normalise.ListPeakWav = g_list_append (normalise.ListPeakWav, IndiFix);
							/* actions: 3 */
							normalise.NbrElementsInList += 2;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
						}
						else if (Fic->Etat_Normalise == NORM_RMS_MIX_ALBUM) {
							normalise.ListMixGroupWav = g_list_append (normalise.ListMixGroupWav, IndiFix);
							/*-*/
							normalise.NbrElementsInList ++;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							bool_mix_wav = TRUE;
							normalise.LevelMix = Fic->LevelMix;
							
							/* Fic->Etat_Scan = ETAT_SCAN_DEMANDE;*/
						}
						else if (Fic->Etat_Normalise == NORM_PEAK_ALBUM) {
							normalise.ListPeakGroupWav = g_list_append (normalise.ListPeakGroupWav, IndiFix);
							/*-*/
							normalise.NbrElementsInList ++;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							bool_peak_wav = TRUE;
						}
					}
					/* FILE_IS_OGG */
					else if (detail->type_infosong_file_is == FILE_IS_OGG && normalise_acces (detail)) {

						INFO_OGG *info = (INFO_OGG *)detail->info;

						if (Fic->Etat_Normalise == NORM_RMS_FIX ||
						    Fic->Etat_Normalise == NORM_PEAK ||
						    Fic->Etat_Normalise == NORM_RMS_MIX_ALBUM ||
						    Fic->Etat_Normalise == NORM_PEAK_ALBUM) {

							info->LevelDbfs.level = Fic->LevelMix;
							
							IndiFix = (INDI_FIX *)g_malloc0 (sizeof (INDI_FIX));
							IndiFix->NameFile      = g_strdup (detail->namefile);
							IndiFix->StrDBFS       = g_strdup_printf ("%d", info->LevelDbfs.NewLevel);
							IndiFix->tags          = info->tags;
							
							IndiFix->EtatNormalise = &Fic->Etat_Normalise;
							
							IndiFix->EtatTrash     = &Fic->EtatTrash;
							
							normalise_get_NameFileCopie (IndiFix, g_list_position (entetefile, List));
							if ((IndiFix->BoolWithConvert = normalise_with_convert (detail)) == TRUE) {
								detail->namefileCopie = g_strdup (IndiFix->NameFileCopieWav);
							}

							IndiFix->NameDestWav = file_make_pathname_file (detail, FILE_IS_WAV);
							IndiFix->NameDestOgg = file_make_pathname_file (detail, FILE_IS_OGG);
							IndiFix->NameDestMp3 = file_make_pathname_file (detail, FILE_IS_MP3);
						}

						if (Fic->Etat_Normalise == NORM_RMS_FIX) {
							normalise.ListFixOgg = g_list_append (normalise.ListFixOgg, IndiFix);
							/*-*/
							normalise.NbrElementsInList += 2;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							
							/* Fic->Etat_Scan = ETAT_SCAN_DEMANDE;*/
							
						}
						else if (Fic->Etat_Normalise == NORM_PEAK) {
							normalise.ListPeakOgg = g_list_append (normalise.ListPeakOgg, IndiFix);
							/*-*/
							normalise.NbrElementsInList += 2;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
						}
						else if (Fic->Etat_Normalise == NORM_RMS_MIX_ALBUM) {
							normalise.ListMixGroupOgg = g_list_append (normalise.ListMixGroupOgg, IndiFix);
							normalise.NbrElementsInList ++;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							bool_mix_ogg = TRUE;
							normalise.LevelMix = Fic->LevelMix;
							
							/* Fic->Etat_Scan = ETAT_SCAN_DEMANDE;*/
						}
						else if (Fic->Etat_Normalise == NORM_PEAK_ALBUM) {
							normalise.ListPeakGroupOgg = g_list_append (normalise.ListPeakGroupOgg, IndiFix);
							/*-*/
							normalise.NbrElementsInList ++;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							bool_peak_ogg = TRUE;
						}
					}
					/* FILE_IS_MP3 */
					else if (detail->type_infosong_file_is == FILE_IS_MP3 && normalise_acces (detail)) {

						INFO_MP3 *info = (INFO_MP3 *)detail->info;

						if (Fic->Etat_Normalise == NORM_RMS_FIX ||
						    Fic->Etat_Normalise == NORM_PEAK ||
						    Fic->Etat_Normalise == NORM_RMS_MIX_ALBUM ||
						    Fic->Etat_Normalise == NORM_PEAK_ALBUM) {

							info->LevelDbfs.level = Fic->LevelMix;
							
							IndiFix = (INDI_FIX *)g_malloc0 (sizeof (INDI_FIX));
							IndiFix->NameFile      = g_strdup (detail->namefile);
							IndiFix->StrDBFS       = g_strdup_printf ("%d", info->LevelDbfs.NewLevel);
							IndiFix->tags          = info->tags;
							
							IndiFix->EtatNormalise = &Fic->Etat_Normalise;
							
							IndiFix->EtatTrash     = &Fic->EtatTrash;
							
							normalise_get_NameFileCopie (IndiFix, g_list_position (entetefile, List));
							if ((IndiFix->BoolWithConvert = normalise_with_convert (detail)) == TRUE) {
								detail->namefileCopie = g_strdup (IndiFix->NameFileCopieWav);
							}

							IndiFix->NameDestWav = file_make_pathname_file (detail, FILE_IS_WAV);
							IndiFix->NameDestOgg = file_make_pathname_file (detail, FILE_IS_OGG);
							IndiFix->NameDestMp3 = file_make_pathname_file (detail, FILE_IS_MP3);
						}

						if (Fic->Etat_Normalise == NORM_RMS_FIX) {
							normalise.ListFixMp3 = g_list_append (normalise.ListFixMp3, IndiFix);
							/*-*/
							normalise.NbrElementsInList += 2;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							
							/* Fic->Etat_Scan = ETAT_SCAN_DEMANDE;*/
						}
						else if (Fic->Etat_Normalise == NORM_PEAK) {
							normalise.ListPeakMp3 = g_list_append (normalise.ListPeakMp3, IndiFix);
							/*-*/
							normalise.NbrElementsInList += 2;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
						}
						else if (Fic->Etat_Normalise == NORM_RMS_MIX_ALBUM) {
							normalise.ListMixGroupMp3 = g_list_append (normalise.ListMixGroupMp3, IndiFix);
							normalise.NbrElementsInList ++;
							/*-*/
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							bool_mix_mp3 = TRUE;
							normalise.LevelMix = Fic->LevelMix;
							
							/* Fic->Etat_Scan = ETAT_SCAN_DEMANDE;*/
						}
						else if (Fic->Etat_Normalise == NORM_PEAK_ALBUM) {
							normalise.ListPeakGroupMp3 = g_list_append (normalise.ListPeakGroupMp3, IndiFix);
							/*-*/
							normalise.NbrElementsInList ++;
							if (IndiFix->BoolWithConvert == FALSE) normalise.NbrElementsInList ++;
							bool_peak_mp3 = TRUE;
						}
					}
					
				}
			}
			List = g_list_next(List);
		}
		if (bool_mix_wav == TRUE) normalise.NbrElementsInList ++;
		if (bool_mix_ogg == TRUE) normalise.NbrElementsInList ++;
		if (bool_mix_mp3 == TRUE) normalise.NbrElementsInList ++;
		if (bool_peak_wav == TRUE) normalise.NbrElementsInList ++;
		if (bool_peak_ogg == TRUE) normalise.NbrElementsInList ++;
		if (bool_peak_mp3 == TRUE) normalise.NbrElementsInList ++;
		/**/
		normalise_action ();
	}

	/* POUR GARDER LA FENETRE OUVERTE
	*/
	normalise.bool_thread_end = TRUE;
	normalise.bool_set_end_of_user = TRUE;
	pthread_exit(0);
}

/*
*---------------------------------------------------------------------------
* TIMEOUT
*---------------------------------------------------------------------------
*/
static gint normalise_timeout (gpointer data)
{
	if (WinNormReplay_is_get_close () == TRUE) {
		conv_stop_conversion ();
		normalise.bool_set_end_of_user = TRUE;
	}
	
	if (conv.bool_percent_conv == TRUE || normalise.bool_pass_conv == TRUE) {
		/*normalise.total_percent = (double)normalise.ElementActif / (double)normalise.NbrElementsInList;*/
		normalise.total_percent = (double)((double)normalise.ElementActif + (double)conv.conversion_percent) / (double)normalise.NbrElementsInList;
		WinNormReplay_set_data_progressBar (normalise.total_percent);
	}

	if (normalise.bool_etat == TRUE) {
		if (normalise.MessUser != NULL) {
			// WinNormReplay_set_etat (normalise.MessUser);
			g_free (normalise.MessUser);
			normalise.MessUser = NULL;
		}
		normalise.bool_etat = FALSE;
	}

	if (normalise.bool_pass_conv == TRUE) {

		gchar *str = NULL;
    		gchar *spinner="|/-\\";
		// gchar *Ptr = NULL;
		gchar  foo [ 2 ];
		
		foo [ 0 ] = spinner[normalise.pass_conv++%4];
		foo [ 1 ] = '\0';
		// Ptr = utils_convert_string (foo, TRUE);
		
		str = g_strdup_printf ("<b>En cours: %d sur %d   %s</b>",
					normalise.ElementActif +1,
					normalise.NbrElementsInList,
					foo
					);
		WinNormReplay_set_compteur (str);
		g_free (str);
		str = NULL;
		// g_free (Ptr);
		// Ptr = NULL;

		return (TRUE);
	}

	else if (normalise.bool_thread_end == TRUE && normalise.bool_set_end_of_user == TRUE) {
		
		/* FIX */
		
		normalise_set_verif (normalise.ListFixWav);
		normalise_set_verif (normalise.ListFixOgg);
		normalise_set_verif (normalise.ListFixMp3);
		
		normalise.ListFixWav		= normalise_remove_glist_STRUCT (normalise.ListFixWav);
		normalise.ListFixOgg		= normalise_remove_glist_STRUCT (normalise.ListFixOgg);
		normalise.ListFixMp3		= normalise_remove_glist_STRUCT (normalise.ListFixMp3);
		
		/* PEAK */
		
		normalise_set_verif (normalise.ListPeakWav);
		normalise_set_verif (normalise.ListPeakOgg);
		normalise_set_verif (normalise.ListPeakMp3);
	
		normalise.ListPeakWav		= normalise_remove_glist_STRUCT (normalise.ListPeakWav);
		normalise.ListPeakOgg		= normalise_remove_glist_STRUCT (normalise.ListPeakOgg);
		normalise.ListPeakMp3		= normalise_remove_glist_STRUCT (normalise.ListPeakMp3);
		
		/* MIX */
		
		normalise_set_verif (normalise.ListMixGroupWav);
		normalise_set_verif (normalise.ListMixGroupOgg);
		normalise_set_verif (normalise.ListMixGroupMp3);
		
		normalise.ListMixGroupWav	= normalise_remove_glist_STRUCT (normalise.ListMixGroupWav);
		normalise.ListMixGroupOgg	= normalise_remove_glist_STRUCT (normalise.ListMixGroupOgg);
		normalise.ListMixGroupMp3	= normalise_remove_glist_STRUCT (normalise.ListMixGroupMp3);
		
		/* PEAK-GROUP */
		
		normalise_set_verif (normalise.ListPeakGroupWav);
		normalise_set_verif (normalise.ListPeakGroupOgg);
		normalise_set_verif (normalise.ListPeakGroupMp3);
		
		normalise.ListPeakGroupWav	= normalise_remove_glist_STRUCT (normalise.ListPeakGroupWav);
		normalise.ListPeakGroupOgg	= normalise_remove_glist_STRUCT (normalise.ListPeakGroupOgg);
		normalise.ListPeakGroupMp3	= normalise_remove_glist_STRUCT (normalise.ListPeakGroupMp3);

		WinNormReplay_close ();
		fileaction_set_end ();
		gtk_timeout_remove (normalise.Handler_Timeout);
		conv_set_struct_not_used ();
		file_pixbuf_update_glist_file ();
	}

	return (TRUE);
}

/*
*---------------------------------------------------------------------------
* ACTION
*---------------------------------------------------------------------------
*/
void normalise_file (void)
{
	// PRINT_FUNC_LF();

	logs_add_datas_session ("FROM FILE->NORMALISE");
	
	normalise.bool_thread_end = FALSE;
	normalise.bool_set_end_of_user = FALSE;
	normalise.bool_pass_conv = FALSE;
	normalise.pass_conv = -1;
	normalise.bool_etat = FALSE;
	normalise.NbrElementsInList = 0;
	normalise.ElementActif = 0;

	conv_reset_struct ();
	
	WinNormReplay_Create (_("Normalise"));
	WinNormReplay_reset_progressBar ();
	pthread_create (&normalise.nmr_tid, NULL ,(void *)normalise_struct_lists, (void *)NULL);
	normalise.Handler_Timeout = gtk_timeout_add (100, normalise_timeout, 0);

}




