 /*
 * file      : main.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <glib.h>
#include <gdk/gdk.h>

#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <locale.h>
#include <unistd.h>

#include "callbacks.h"

#include "global.h"
#include "config_user.h"
#include "prg_init.h"
#include "utils.h"
#include "file.h"
#include "options.h"
#include "cd_audio.h"
#include "win_control.h"
#include "prg_navigator.h"
#include "scan_cd.h"
#include "dvd_audio.h"
#include "split.h"
#include "showhide_treeview.h"
#include "mplayer.h"
#include "info_song.h"
#include "prg_audio.h"
#include "process.h"
#include "fileselect.h"
#include "split_shuttle.h"
#include "poche.h"
#include "logs.h"



/*
*---------------------------------------------------------------------------
* VARIABLE GLOBALE
*---------------------------------------------------------------------------
*/

WIND_MAIN wind_main = { NULL, TRUE };

HOST_CONF	 HostConf;

GtkBuilder	*GtkBuilderXcfa = NULL;


/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

typedef struct {
	gchar Mess_1 [ 100 ];
	gchar Mess_2 [ 100 ];
	gchar Mess_3 [ 100 ];
} ERROR;

ERROR error;

void segfault_handler_mess_error (gchar *p_mess)
{
	strcpy (error.Mess_3, error.Mess_2);
	strcpy (error.Mess_2, error.Mess_1);
	strcpy (error.Mess_1, p_mess);
}

/* Install un 'handler' sur une mauvaise allocation memoire
*  --
*  entree : int sig :
*  retour : -
*/
void segfault_handler(int sig)
{
	// PRINT_FUNC_LF();
	
	unlink (XCFA_FILE_LOAD);
	unlink (XCFA_PROCESS);
	unlink (XCFA_PID);
	
	g_print ("\n=========================================================\n");
	g_print ("=  Segmentation fault\n");
	g_print (_("=  Adressage memoire invalide\n"));
	g_print ("=-------------------------------------------------------=\n");
	g_print ("=      You've probably found a bug in XCFA\n");
	g_print (_("=      Vous avez probablement trouve un bug dans XCFA\n"));
	if (error.Mess_1[ 0 ] != '\0') {
		g_print ("=-------------------------------------------------------=\n");
		g_print ("%s\n", error.Mess_1);
		g_print ("%s\n", error.Mess_2);
		g_print ("%s\n", error.Mess_3);
	}
	g_print ("=========================================================\n\n");
	
	g_print ("infosong_delete_file:\n\t"
			XCFA_FILE_LOAD
			"\n\t"
			XCFA_PROCESS
			"\n"
			);
	
	exit (EXIT_FAILURE);
}

/* Affiche la version
*  --
*  entree : -
*  retour : -
*/
void Version (void)
{
	/* PRINT_FUNC_LF(); */
	g_print ("\nVERSION = %s %s\n\n", PACKAGE, VERSION);
}


/* Affiche l'usage et sortie
*  --
*  entree : -
*  retour : -
*/
void Usage (void)
{
	// PRINT_FUNC_LF();
	g_print ("USAGE\n");
	g_print ("-h -H --help     Help of this application\n");
	g_print ("-v -V --version  Version of application\n");
	g_print ("--no_cd_dvd      Desactivation de la reconnaissance du/des lecteurs cd-dvd\n");
	g_print ("*.ogg            Charge tous les fichiers ogg\n");
	g_print ("\n");

	// infosong_delete_file (XCFA_FILE_LOAD);
	// infosong_delete_file (XCFA_PROCESS);
	unlink (XCFA_FILE_LOAD);
	unlink (XCFA_PROCESS);
	unlink (XCFA_PID);

	exit (EXIT_SUCCESS);
}

/* Definition de la structure de la ligne de commande
*/
struct option long_options[] =
{
	{"help",      0, 0, 0},
	{"version",   0, 0, 0},
	{"no_cd_dvd", 0, 0, 0},
	{0, 0, 0, 0}
};


/* Analyse des option passees sur la ligne de commande
*  --
*  entree :
*      int argc
*      gchar *argv[]
*  retour : -
*/
void AnalyseCommandLine_getopt_long (int argc, gchar *argv[])
{
	gint    c, o;

	// PRINT_FUNC_LF();

	while ((c = getopt_long(argc, argv, "*HhVv?", long_options, &o)) != -1)
	{
		switch (c)
		{
		case 0:
			switch (o)
			{
			case 0:
				g_print ("--help\n");
				Usage ();
				break;
			case 1:
				g_print ("--version\n");
				Version ();
				Usage ();
				break;
			
			case 2:
				g_print ("--no_cd_dvd\n");
				scancd_set_bool_scan (FALSE);
				break;

			default :
				g_print ("DEBUG COMMAND LINE\n");
			}
			break;

		case 'h':
		case 'H':
			g_print ("-h\n");
			Usage ();
			break;
		case 'v':
		case 'V':
			g_print ("-v\n");
			Version ();
			Usage ();
			break;
		case '?' :
			g_print ("-?\n");
			Usage ();
			break;

		default :
			g_print ("Commande inconnue\n");
			Usage ();
		}
	}
}
void AnalyseCommandLine_set_argv (int argc, gchar *argv[])
{
	gint	 i;
	gchar	*str_current_dir = g_get_current_dir();
	FILE	*fp = NULL;
	
	/* Creation du fichier */
	fp = fopen (XCFA_FILE_LOAD, "a");
	
	for (i = optind; i < argc; i++)
	{
		if (argv[i][0] == '/') {

			/*g_print ("'%s'\n", argv[i]);*/
			/*fileanalyze_create_glist_analyze_file (argv[i], FALSE);*/

			fprintf (fp, "%s\n", argv[ i ]);
		}
		else {
			gchar *str = NULL;
			
			str = g_strdup_printf ("%s/%s", str_current_dir, argv[i]);

			/*g_print (">%s\n", str);*/
			/*fileanalyze_create_glist_analyze_file (str, FALSE);*/

			fprintf (fp, "%s\n", str);
			g_free (str);
			str = NULL;
		}
	}
	g_print ("\n");
		
	g_free (str_current_dir);
	str_current_dir = NULL;
	
	/* Fermeture du fichier */
	fclose (fp);
}

void put_display (void)
{
        const char *display_name;
        display_name = gdk_display_get_name (gdk_display_get_default ());
	g_print ("display_name = %s\n", display_name);
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void add_pixmap_directory (const gchar *directory)
{
	pixmaps_directories = g_list_prepend (pixmaps_directories, g_strdup (directory));
}
/* This is an internally used function to find pixmap files. */
static gchar *find_pixmap_file (const gchar *filename)
{
	GList *elem;

	/* We step through each of the pixmaps directory to find it. */
	elem = pixmaps_directories;
	while (elem)
	{
		gchar *pathname = g_strdup_printf ("%s%s%s", (gchar*)elem->data, G_DIR_SEPARATOR_S, filename);
		if (g_file_test (pathname, G_FILE_TEST_EXISTS)) return pathname;
		g_free (pathname);
		elem = elem->next;
	}
	return NULL;
}

/* This is an internally used function to create pixmaps. */
GtkWidget *create_pixmap (GtkWidget *widget, const gchar *filename)
{
	gchar *pathname = NULL;
	GtkWidget *pixmap;

	if (!filename || !filename[0]) return gtk_image_new ();

	pathname = find_pixmap_file (filename);

	if (!pathname)
	{
		g_warning (_("Couldn't find pixmap file: %s"), filename);
		return gtk_image_new ();
	}

	pixmap = gtk_image_new_from_file (pathname);
	g_free (pathname);
	return pixmap;
}


/* gint main (gint argc, gchar *argv[], gchar **envp)
 *
 * argc  désigne le nombre d'arguments transmis au moment du lancement de l'exécutable
 * argv  désigne le vecteur contenant les différents arguments
 * envp  désigne le vecteur contenant les informations sur l'environnement
 */
gint main (gint argc, gchar *argv[], gchar **envp)
{
	GError	*p_err = NULL;
	gchar	*CurrentDir = g_get_current_dir ();
	gchar	*Path = NULL;
	gchar	*PathCurrentDir = NULL;
	gchar	*PathShareXcfa = NULL;
	
	/*
	g_mem_set_vtable (glib_mem_profiler_table);
	g_mem_profile ();
	*/
	FILE	*fp = NULL;
	
	if ((fp = fopen (XCFA_PROCESS, "r")) != NULL) {		// Test if XCFA_PROCESS exist
		fclose (fp);					// YES
			
		var_process.bool_read_access = FALSE;			// No access for XCFA_PROCESS file
		
		fp = fopen (XCFA_PROCESS, "w");				// Open XCFA_PROCESS
		fprintf (fp, "2");					// 1=original else 2=other process
		fclose (fp);						// Close XCFA_PROCESS
		
		AnalyseCommandLine_set_argv (argc, &argv[0]);		// Get and save param-file
		
		fp = fopen (XCFA_PROCESS, "w");				// Open XCFA_PROCESS
		fprintf (fp, "1");					// 1=original else 2=other process
		fclose (fp);						// Close XCFA_PROCESS

		var_process.bool_read_access = TRUE;			// access for XCFA_PROCESS file	is OK
		
		gdk_notify_startup_complete ();
		
		return (EXIT_SUCCESS);					// Quit process
	}
	else							// XCFA_PROCESS NOT exist
	{
		unlink (XCFA_FILE_LOAD);
		unlink (XCFA_PROCESS);
		unlink (XCFA_PID);
		
		fp = fopen (XCFA_PROCESS, "w");				// Open XCFA_PROCESS
		fprintf (fp, "1");					// 1=original else 2=other process
		fclose (fp);						// Close XCFA_PROCESS
		
		AnalyseCommandLine_getopt_long (argc, &argv[0]);	// Get options for original process
		AnalyseCommandLine_set_argv (argc, &argv[0]);		// Get and save param-file
	}
	var_process.bool_action_is_ready = FALSE;
	
	g_print ("\n");
	g_print ("***************************\n");
	g_print ("%s %s\n", PACKAGE, VERSION);
	g_print ("***************************\n");
	g_print ("%s %s compiled at %s %s\n", PACKAGE, VERSION, __DATE__, __TIME__);
	g_print ("Compiler: gcc %s\n", __VERSION__);
	g_print ("***************************\n");
	g_print ("Gtk version  = %d.%d.%d\n", GTK_MAJOR_VERSION, GTK_MICRO_VERSION, GTK_MINOR_VERSION);
	g_print ("Glib version = %d.%d.%d\n", GLIB_MAJOR_VERSION, GLIB_MICRO_VERSION, GLIB_MINOR_VERSION);
	g_print ("***************************\n");
	
	strcpy (error.Mess_1, "");
	utils_infos_ordi ();
	g_print ("HostConf.NbCpu   = %d CPU\n", HostConf.NbCpu);
	g_print ("HostConf.TypeCpu = %d Bits\n", HostConf.TypeCpu);
	g_print ("HostConf.Machine = %s\n", HostConf.Machine);
	g_print ("\n");
		
	/* IF Segmentation fault */
	signal (SIGSEGV, segfault_handler);

	/* Ignore Ctrl-C.
	 *
	 *  signal (SIGINT, SIG_IGN);
	 */

#ifdef ENABLE_NLS
	g_print ("ENABLE_NLS OK\n");
	g_print ("\tGETTEXT_PACKAGE    = %s\n", GETTEXT_PACKAGE);
	g_print ("\tPACKAGE_LOCALE_DIR = %s\n", PACKAGE_LOCALE_DIR);

	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#else
	g_error ("ENABLE_NLS IS NOT OK\n\n");
#endif
	g_print ("\tDATA_DIR           = %s\n", DATA_DIR);

	gtk_set_locale ();
	/*setlocale (LC_ALL, "fr");*/

	/* THREAD INIT
	*/
	g_thread_init (NULL);
	if (g_thread_supported()) {
		g_print ("\ng_thread_supported: YES\n\n");
	} else {
		g_print ("\ng_thread_supported: NO\n");
		g_print ("Desole les thread ne sont pas supportes pas votre plate-forme.\n"
			 "Il vous faut un systeme linux base sur la libc5 ainsi que GLIB & GTK+\n\n");

		g_print ("Sorry, threads isn't supported on your platform.\n"
			 "If you're on a libc5 based linux system and installed GLIB & GTK+ before you\n"
			 "installed LinuxThreads you need to recompile GLIB & GTK+\n\n");

		g_error ("\n");
	}
	
	gdk_threads_init ();

	gtk_init (&argc, &argv);
	gdk_threads_enter ();
	
	GtkBuilderXcfa = gtk_builder_new ();
	gtk_builder_set_translation_domain (GtkBuilderXcfa, NULL);

	if (GtkBuilderXcfa == NULL) {
		PRINT("GtkBuilderXcfa != NULL");
		gdk_threads_leave ();
		gtk_main ();
		return (EXIT_FAILURE);
	}
	
	PathCurrentDir = g_strdup_printf ("%s/glade/xcfa.ui", CurrentDir);
	g_free (CurrentDir);
	CurrentDir = NULL;
	PathShareXcfa = g_strdup_printf ("%s/xcfa/xcfa.ui", DATA_DIR);
	if (infosong_file_is_reg (PathCurrentDir) == FALSE && infosong_file_is_reg (PathShareXcfa) == FALSE) {
		
		g_print("!---------------------------------------------------------------------------------------------------\n");
		g_print("! LE FICHIER XML: [ %s ] N'EXISTE PAS !!!\n", PathCurrentDir);
		g_print("!---------------------------------------------------------------------------------------------------\n");
		g_print("! LE FICHIER XML: [ %s ] N'EXISTE PAS !!!\n", PathShareXcfa);
		g_print("!---------------------------------------------------------------------------------------------------\n");
		
		g_free (PathCurrentDir);
		PathCurrentDir = NULL;
		g_free (PathShareXcfa);
		PathShareXcfa = NULL;
		
		infosong_delete_file (XCFA_FILE_LOAD);
		infosong_delete_file (XCFA_PROCESS);
		gdk_threads_leave ();
		return (EXIT_FAILURE);
	}
	else if (infosong_file_is_reg (PathCurrentDir) == TRUE) {
		
		Path = PathCurrentDir;
	}
	else if (infosong_file_is_reg (PathShareXcfa) == TRUE) {
		
		Path = PathShareXcfa;
	}
	g_print("PATHNAME FILE xcfa.ui: %s\n\n", Path);
	if (gtk_builder_add_from_file (GtkBuilderXcfa, Path, &p_err) <= 0) {
		PRINT("EROR LOAD XML");
		g_warning ("Couldn't load builder file: %s", p_err->message);
		g_error_free (p_err);

		g_free (PathCurrentDir);
		PathCurrentDir = NULL;
		g_free (PathShareXcfa);
		PathShareXcfa = NULL;
		Path = NULL;
		
		infosong_delete_file (XCFA_FILE_LOAD);
		infosong_delete_file (XCFA_PROCESS);
		gdk_threads_leave ();
		return (EXIT_FAILURE);
	}
	g_free (PathCurrentDir);
	PathCurrentDir = NULL;
	g_free (PathShareXcfa);
	PathShareXcfa = NULL;
	Path = NULL;
		
	/* add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps"); */
	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");

	g_print ("PACKAGE_DATA_DIR = %s\n\n", PACKAGE_DATA_DIR);

	g_print ("gtk_set_locale ()                     = %s\n", gtk_set_locale ());
	gtk_builder_set_translation_domain  (GtkBuilderXcfa, gtk_set_locale ());
	g_print("gtk_builder_get_translation_domain () = %s\n\n", gtk_builder_get_translation_domain  (GtkBuilderXcfa));

	var_options.ColorLineCommand = COLOR_INIT;

	// LECTURE DE LA CONFIGURATION
	configuser_read_file_config ();
	showhidetreeview_set_etat_fields ();
	
	// CREATION DE LA FENETRE PRINCIPALE
	NEW_wincontrol_realize_window (&wind_main.AdrWin, "wind_main", &wind_main.Bool, WIND_IS_NOT_SHOW, WIND_USE_STRUCT, WIND_IS_NOT_MODAL, WIND_IS_NOT_TRANSIENT);
	// CONNECTION DES SIGNAUX
	gtk_builder_connect_signals (GtkBuilderXcfa, NULL);
	// TITRE FENETRE
	gtk_window_set_title (GTK_WINDOW (wind_main.AdrWin), "X Convert File Audio ");
	// REDIMENSIONNER LA FENETRE
	gtk_window_resize(GTK_WINDOW(wind_main.AdrWin), Config_User.Win_Width, Config_User.Win_Height);
	// PLACER LA FENETRE
	gtk_window_move(GTK_WINDOW(wind_main.AdrWin), Config_User.WinPos_X, Config_User.WinPos_Y);
	// AFFICHAGE
	gtk_widget_show (wind_main.AdrWin);	

	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGAUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGPOSTSCRIPT);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGNAVIGATOR);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGEXTERNES);
		
	// OPTIONS
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_OPTIONS);
		
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_EXPORT_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_AACPLUSENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_FAAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_MUSEPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_WAVPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_MAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_FLAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_OGGENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_LAME);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")),
				NOTEBOOK_OPTIONS_GENERAL);

	// POCHETTE
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_POCHETTE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_pochette")),
				NOTEBOOK_POCHETTE_TEXTE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_pochette")),
				NOTEBOOK_POCHETTE_TITRE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_pochette")),
				NOTEBOOK_POCHETTE_IMAGE);

	// NOTEBOOK_SPLIT
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_SPLIT);

	// FICHIERS
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_FICHIERS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_in_file")),
				NOTEBOOK_FICHIERS_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_in_file")),
				NOTEBOOK_FICHIERS_MP3OGG);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_in_file")),
				NOTEBOOK_FICHIERS_WAV);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_in_file")),
				NOTEBOOK_FICHIERS_CONVERSION);

	// CD-AUDIO
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_expander_cd")),
				NOTEBOOK_CD_AUDIO_CUE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_expander_cd")),
				NOTEBOOK_CD_AUDIO_TITRE_CD);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_expander_cd")),
				NOTEBOOK_CD_AUDIO_TAGS);

	// DVD-AUDIO
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_DVD_AUDIO);
	
// while (gtk_events_pending()) gtk_main_iteration(); 
	
	/*
	@patachonf:
	-----------
	SHOW or HIDE PAGE OF GTK_NOTEBOOK
	-----------
	
	http://forum.ubuntu-fr.org/viewtopic.php?pid=3186013#p3186013
	
	gtk_notebook_remove_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")), NOTEBOOK_PRGEXTERNES);
	gtk_notebook_append_page (
		GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
		GTK_WIDGET(XCFA_GET_OBJECT("vbox5")),
		GTK_WIDGET(XCFA_GET_OBJECT("label105"))
		);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")),
			NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGAUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGPOSTSCRIPT);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGNAVIGATOR);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")),
				NOTEBOOK_OPTIONS_PRGEXTERNES);
	*/

	
	// RESTAURE LA CONFIGURATION PRECEDENTE
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")), Config_User.notebook_general);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_expander_cd")), Config_User.notebook_expander_cd);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_in_file")), Config_User.notebook_file);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_options")), Config_User.notebook_options);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_pochette")), Config_User.notebook_pochette);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_app_externes")), Config_User.notebook_app);
	
	Config_User.BoolNewVersion = FALSE;
	if (strcmp (Config_User.Version, VERSION) != 0) {
		
		Config_User.BoolNewVersion = TRUE;
		
		g_print ("Config_User.Version  = %s\n", Config_User.Version);
		g_print ("VERSION              = %s\n", VERSION);
		g_print ("\n");
		g_free (Config_User.Version);
		Config_User.Version = NULL;
		Config_User.Version = g_strdup (VERSION);
		g_print ("\n");
	}
	
	cdaudio_set_flag_buttons_audio_cd ();
	file_set_flag_buttons_audio_file ();

	gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Label_Duree));
	gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Progressbar));
	gtk_widget_hide (GTK_WIDGET (var_cd.Adr_Button_Cancel_cddb));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame185")));

	cdaudio_put_label_status_bar_cd (_DUREE_, _HIDE_, "");
	cdaudio_put_label_status_bar_cd (_TITRE_, _HIDE_, "");
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
	utils_puts_statusbar_global ("");

#ifdef HAVE_LINUX_CDROM_H
	if (Config_User.Bool_directory_by_ioctl)
		gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_ioctl), TRUE);
	else	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia), TRUE);
#else
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (var_options.Adr_radiobutton_cdparanoia), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (var_options.Adr_radiobutton_ioctl), FALSE);	
#endif
		
	pocheevnt_init ();
	pochetimer_enable ();
	
	prgnavigator_affiche ();
	prgnavigator_entry_name_navigator_changed ();

	prgaudio_affiche (); 
	prgaudio_entry_name_audio_changed ();
	
	if (fileanalyze_linecommand_exist () == TRUE) {
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")), NOTEBOOK_DVD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (XCFA_GET_OBJECT("notebook_general")), NOTEBOOK_FICHIERS);
	}
	
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("button_annuler_lecture_dvd")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("progressbar_dvd_audio")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame_lecture_dvd")));

	options_init ();
	options_set_all_interne ();

	var_options.ColorLineCommand = COLOR_NONE;

	gtk_expander_set_expanded (GTK_EXPANDER (var_cd.Adr_Expander), Config_User.BoolEtatExpanderCd);
	filexpander_set_label_tag_change ();
	cdexpander_set_sensitive_notebook ();

	Config_User.Bool_Config_Ok = TRUE;

	dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Pret ..."));
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Pret ..."));
	utils_puts_statusbar_global (_("Pret ..."));
	split_set_flag_buttons_audio ();
	filetrash_test_trash_is_ok ();
	utils_puts_statusbar_global ("Pret  ;-)");
	showhidetreeview_set_etat_treeview (Config_User.notebook_general, Config_User.notebook_file);
	showhidetreeview_radiobutton_set_PosFieldsName ();
	
	VarMplayer.ListPlayFrom = LIST_MPLAYER_FROM_NONE;

	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_file.AdrComboboxNormalise)), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_SPIN_BUTTON (var_file.AdrSpinbuttonNormalise)), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd)), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_dvdaudio.Adr_combobox_normalise_dvd)), FALSE);
	
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("vbox_cue")), TRUE);
		
	splitshuttle_set_adr_redraw (GTK_WIDGET (XCFA_GET_OBJECT("hbox_splitshuttle")));
	splitshuttle_set_TimeSongSec (3600);
	splitshuttle_set_func_begin (split_NEW_set_debut);
	splitshuttle_set_func_end (split_NEW_set_fin);
	splitshuttle_set_percent_begin (25.0);
	splitshuttle_set_percent_end (75.0);
	splitshuttle_set_func_WaitPlay (split_NEW_WaitPlay);
	splitshuttle_set_func_StopPlay (split_NEW_StopPlay);
	
	/* LE PID EST L ORIGINAL DONC CE PROCESS SERA ACTIVE */
	fileselect_clear_glist ();
	process_goto_timeout ();
		
	gtk_main ();
	
	/* THREAD END
	*/
	gdk_threads_leave ();

	return (EXIT_SUCCESS);
}


