 /*
 * file      : logs.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
 
#include "global.h"
#include "info_song.h"
#include "config_user.h"
#include "fileselect.h"
#include "utils.h"
#include "logs.h"


#define LOG_NAME_XCFA "XcfaLog.txt"


typedef struct {
	GtkWidget   *AdrButtonPathFileSaveLog;		// [ Chemin de sauvegarde ]
	GtkWidget   *AdrCheckbuttonActivateFileLog;	// Activer l'enregistrement du fichier
	GtkWidget   *AdrButtonRemoveFileLog;		// Supprimer le fichier
} VAR_LOGS;
VAR_LOGS VarLogs;


	
void on_checkbutton_activate_journal_clicked (GtkButton *button, gpointer user_data)
{
	// PRINT_FUNC_LF();
	Config_User.Bool_Activate_Journal = gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (VarLogs.AdrCheckbuttonActivateFileLog));
}
void on_checkbutton_activate_journal_realize (GtkWidget *widget, gpointer user_data)
{
	VarLogs.AdrCheckbuttonActivateFileLog = widget;
	gtk_toggle_button_set_active ( GTK_TOGGLE_BUTTON (VarLogs.AdrCheckbuttonActivateFileLog), Config_User.Bool_Activate_Journal);
}
	
void on_button_remove_journal_clicked (GtkButton *button, gpointer user_data)
{
	gchar	*PathNameXcfaLogs = NULL;
	
	// PRINT_FUNC_LF();
	PathNameXcfaLogs = g_strdup_printf ("%s/%s", gtk_button_get_label (GTK_BUTTON (VarLogs.AdrButtonPathFileSaveLog)), LOG_NAME_XCFA);
	infosong_delete_file (PathNameXcfaLogs);
	g_free (PathNameXcfaLogs);
	PathNameXcfaLogs = NULL;
}
void on_button_remove_journal_realize (GtkWidget *widget, gpointer user_data)
{
	VarLogs.AdrButtonRemoveFileLog = widget;
}

void logs_select_new_path_destination (gchar *path)
{
	// PRINT_FUNC_LF();
	g_free (Config_User.Path_Dest_Journal);
	Config_User.Path_Dest_Journal = NULL;
	Config_User.Path_Dest_Journal = g_strdup (path);
	gtk_button_set_label (GTK_BUTTON (VarLogs.AdrButtonPathFileSaveLog), Config_User.Path_Dest_Journal);
}
void on_button_dossier_journal_clicked (GtkButton *button, gpointer user_data)
{
	// PRINT_FUNC_LF();
	fileselect_create (_PATH_DEST_JOURNAL_, logs_select_new_path_destination);
}
void on_button_dossier_journal_realize (GtkWidget *widget, gpointer user_data)
{
	VarLogs.AdrButtonPathFileSaveLog = widget;
	gtk_button_set_label (GTK_BUTTON (VarLogs.AdrButtonPathFileSaveLog), Config_User.Path_Dest_Journal);
}
	
gboolean logs_button_is_activate (void)
{
	return (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (VarLogs.AdrCheckbuttonActivateFileLog)));
}

void logs_write_datas (gchar *data)
{
	FILE	*fp = NULL;
	gchar	*PathNameXcfaLogs = NULL;
	
	// PRINT_FUNC_LF();
	// TODO: logs_add_datas() : VERIFIER LA PLACE RESTANT SUR LE SUPPORT AVANT LA SAUVEGARDE
	// if (gtk_toggle_button_get_active ( GTK_TOGGLE_BUTTON (VarLogs.AdrCheckbuttonActivateFileLog)) == TRUE) {
	if (Config_User.Bool_Activate_Journal == TRUE) {
		// PathNameXcfaLogs = g_strdup_printf ("%s/%s", gtk_button_get_label (GTK_BUTTON (VarLogs.AdrButtonPathFileSaveLog)), LOG_NAME_XCFA);
		PathNameXcfaLogs = g_strdup_printf ("%s/%s", Config_User.Path_Dest_Journal, LOG_NAME_XCFA);
		if ((fp = fopen (PathNameXcfaLogs, "a")) != NULL) {
			fprintf (fp, "%s", data);
			fclose (fp);
			// g_print ("%s", data);
		}
		g_free (PathNameXcfaLogs);
		PathNameXcfaLogs = NULL;
	}
}
void logs_writeln_datas (gchar *data)
{
	logs_write_datas (data);
	logs_write_datas ("\n");
}
void logs_add_datas_session (gchar *data)
{
	logs_write_datas ("\n\n");
	logs_write_datas ("SESSION XCFA: ");
	logs_write_datas (utils_get_str_date ());
	logs_write_datas ("  ");
	logs_write_datas (utils_get_str_time ());
	logs_write_datas ("  ");
	logs_write_datas (data);
	logs_write_datas ("\n\n");
}
void logs_write_double (gdouble DataInt)
{
	gchar	*Str = g_strdup_printf ("%f", DataInt);
	logs_write_datas (Str);
	g_free (Str);
	Str = NULL;
}


