 /*
 * file      : info_song.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __info_song_h__
#define __info_song_h__ 1


#include "file.h"



gboolean   infosong_create_dir (gchar *NameDir);
gchar     *infosong_create_rep (gchar *path);
gchar     *infosong_remove_rep (gchar *path);
gboolean   infosong_file_is_dir (gchar *File);
gboolean   infosong_file_is_reg (gchar *File);
void       infosong_delete_file (gchar *PathName);
size_t     infosong_get_size_file (gchar *PathName);
void       infosong_rename_file (gchar *oldname, gchar *newname);
void       infosong_copy_file (gchar *oldname, gchar *newname);

typedef enum			/* En retour de infosong_access_mode () si TRUE */
{
	AM_FILE_EXIST,		/* Le fichier existe                */
	AM_FILE_READ,		/* Lire le contenu du fichier       */
	AM_FILE_WRITE,		/* Ecrire dans le fichier           */
	AM_FILE_EXEC,		/* Executer le fichier              */
	AM_FILE_IS_REG,		/* Est un fichier regulier          */
	AM_FILE_IS_DIR,		/* Est un repertoire                */
	AM_FILE_IS_BLOCK,	/* Est un fichier peripherique blok */
	AM_FILE_IS_MIND,	/* Le fichier m'appartient          */
	AM_NO_RET

} RET_ACCESS_MODE;

typedef struct {

	gboolean FileExist;        /* F_OK     Le fichier existe t-il ?             */
	gboolean ReadFileOk;       /* R_OK     Puis-je lire le contenu du fichier ? */
	gboolean WriteFileOk;      /* W_OK     Puis-ecrire dans le fichier ?        */
	gboolean ExecFileOk;       /* X_OK     Puis-executer le fichier ?           */
	gboolean FileIsReg;        /* S_ISREG  Est un fichier regulier              */
	gboolean FileIsDir;        /* S_ISDIR  Est un repertoire                    */
	gboolean FileIsBlok;       /* S_ISBLK  Est un fichier peripherique blok     */
	gboolean BoolManipFile;    /* TRUE     Manipulation du fichier              */

} ACCESS_MODE;

gboolean  infosong_access_mode (RET_ACCESS_MODE Flag_Ret_Mode, const char *nom_fichier, ACCESS_MODE  *StructAccessMode);

TYPE_FILE_IS  infosong_file_is (TYPE_FILE_IS type_infosong_file_is, gchar *PathName);
TYPE_FILE_IS  infosong_get_type_file_is (gchar *NameSong);
gboolean      infosong_g_str_has_suffix (gchar *NameSong, gchar *Suffixe);
gboolean      infosong_type_is_song (gchar *NameSong);
gchar        *infosong_get_str_type_file_is (TYPE_FILE_IS type);
gint          infosong_get_genre_by_value (gchar *name);
gchar        *infosong_get_genre_by_name (gint value);
void          infosong_set_elements_combobox (GtkWidget *widget);
gint          infosong_get_elements_combobox (gint num);
gint          infosong_get_num_combobox (gint value);


#endif
