 /*
 * file      : dvd_audio.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>

#include "global.h"
#include "file.h"
#include "utils.h"
#include "scan_cd.h"
#include "options.h"
#include "config_user.h"
#include "fileselect.h"
#include "win_info.h"
#include "dvd_audio.h"
#include "conv.h"
#include "popup.h"
#include "mplayer.h"
#include "win_play.h"
#include "scan_cd.h"




/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

enum
{
	DVD_TITLE_COLUMN = 0,
	DVD_PIXBUF_COLUMN_PLAY,
	DVD_TIME_COLUMN,
	DVD_CHANNELS_COLUMN,
	DVD_PIXBUF_CHOICE_COLUMN,
	
	DVD_PIXBUF_FILE_NORMALIZE,
	
	DVD_NAME_COLUMN,
	DVD_NAME_EDITABLE_COLUMN,
	DVD_POINTER_STRUCT_COLUMN,
	DVD_NUM_COLUMNS
};

VAR_DVDAUDIO var_dvdaudio;


GList *GlistDvdExtract = NULL;

enum
{
	NUM_TREE_Titres = 0,
	NUM_TREE_Play,
	NUM_TREE_Temps,
	NUM_TREE_Format,
	NUM_TREE_Choix,
	NUM_TREE_Normalise,
	NUM_TREE_Nom,
	NUM_TREE_ALL_COLUMN
};



/*
*---------------------------------------------------------------------------
* FUNCTIONS
*---------------------------------------------------------------------------
*/

gboolean dvdaudio_foreach_remove_GtkTree (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR        *var = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	if (var) {
		g_free (var->def);
		g_free (var->time);
		g_free (var->name_file);
		g_free (var->StrNumerateTitle);
		g_free (var->StrNumerateChapter);
		g_free (var->StrNumberChannel);
		g_free (var->StrNumerateStreamId);
		g_free (var);
		var = NULL;
	}
	 /* continuer à parcourir l'arbre */
	return FALSE;
}
void dvdaudio_remove_GtkTree (void)
{
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_remove_GtkTree, NULL);
	gtk_tree_store_clear ((GtkTreeStore *)var_dvdaudio.Adr_Tree_Model);
}

gchar *dvdaudio_get_channels (VAR *var)
{
	/* PRINT_FUNC_LF(); */

	/*
	1: Original
	2: 2ch: stéréo
	3: 3ch
	4: 4ch
	5: 5ch
	6: 6ch: surround 5.1
	*/
	switch (atoi (var->StrNumberChannel)) {
	case 1 : return ("<span color=\"black\"><b>1ch</b></span>");
	case 2 : return ("<span color=\"black\"><b>2ch</b></span>");
	case 3 : return ("<span color=\"black\"><b>3ch</b></span>");
	case 4 : return ("<span color=\"black\"><b>4ch</b></span>");
	case 5 : return ("<span color=\"black\"><b>5ch</b></span>");
	case 6 : return ("<span color=\"black\"><b>6ch</b></span>");
	default :
		break;
	}
	return ("???");
}

void dvdaudio_set_new_channels (gint channel)
{
}

GdkPixbuf *dvdaudio_get_pixbuf_normalise (gboolean EtatNormaliseCd)
{
	if (EtatNormaliseCd == FALSE) return (var_dvdaudio.Pixbuf_Coche);
	return (var_dvdaudio.Pixbuf_Selected);
}

void dvdaudio_affiche_list (void)
{
	GtkTreeIter      piter0 = {0,NULL,NULL,NULL};
	GtkTreeIter      piter1 = {0,NULL,NULL,NULL};
	GtkTreeIter      piter2 = {0,NULL,NULL,NULL};
	GtkTreeIter      piter3 = {0,NULL,NULL,NULL};
	GtkTreeIter      piter4 = {0,NULL,NULL,NULL};
	GtkTreeStore    *model = (GtkTreeStore *)var_dvdaudio.Adr_Tree_Model;
	GList           *list = NULL;
	VAR             *var =  NULL;
	gchar           *time = NULL;
	gchar           *str = NULL;
	gint             NumStruct = 1;
	GtkAdjustment   *Adj = NULL;
	gdouble          AdjValue;

	gtk_tree_store_clear ((GtkTreeStore *)var_dvdaudio.Adr_Tree_Model);
	
	/* Mise a jour du scroll vertical */
	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (var_dvdaudio.Adr_scroll));
	AdjValue = gtk_adjustment_get_value (Adj);
	gtk_adjustment_set_value (Adj, AdjValue);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (var_dvdaudio.Adr_scroll), Adj);
	
	gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (GTK_SCROLLED_WINDOW (var_dvdaudio.Adr_scroll)), NULL, NULL, TRUE, 0.5, 0.5);

	list = g_list_first (GlistDvd);
	while (list) {
		if ((var = (VAR *)list->data)) {

			var->NumStruct = NumStruct ++;
			var->BoolDvdPlay = FALSE;
			var->EtatNormalise = FALSE;

			switch (var->type_list_dvd) {
			case _DVD_NAME :
				str = g_strdup_printf ("<span color=\"red\"><b>%s</b></span>", var->def);

				gtk_tree_store_append (model, &piter0, NULL);
				gtk_tree_store_set (model, &piter0,
						DVD_TITLE_COLUMN,		str,
						DVD_PIXBUF_COLUMN_PLAY,		NULL,
						DVD_TIME_COLUMN,		"",
						DVD_CHANNELS_COLUMN,		"",
						DVD_PIXBUF_CHOICE_COLUMN,	NULL,
						DVD_PIXBUF_FILE_NORMALIZE,	NULL,
						DVD_NAME_COLUMN,		"",
						DVD_NAME_EDITABLE_COLUMN,	FALSE,
						DVD_POINTER_STRUCT_COLUMN,	var,
						-1);

				g_free (str);	str = NULL;
				break;

			case _DVD_TITLE :
				str = g_strdup_printf ("<span color=\"black\"><b>%s</b></span>", var->def);

				gtk_tree_store_append (model, &piter1, &piter0);
				gtk_tree_store_set (model, &piter1,
						DVD_TITLE_COLUMN,		str,
						DVD_PIXBUF_COLUMN_PLAY,		NULL,
						DVD_TIME_COLUMN,		"",
						DVD_CHANNELS_COLUMN,		"",
						DVD_PIXBUF_CHOICE_COLUMN,	NULL,
						DVD_PIXBUF_FILE_NORMALIZE,	NULL,
						DVD_NAME_COLUMN,		"",
						DVD_NAME_EDITABLE_COLUMN,	FALSE,
						DVD_POINTER_STRUCT_COLUMN,	var,
						-1);

				g_free (str);	str = NULL;
				break;

			case _DVD_DATA_ALL :
				var->OldChannels = var->NewChannels = (gint)atoi (var->StrNumberChannel);

				time = g_strdup_printf ("<b>%s</b>", var->time);

				gtk_tree_store_append (model, &piter4, &piter1);
				gtk_tree_store_set (model, &piter4,
						DVD_TITLE_COLUMN,		var->def,
						DVD_PIXBUF_COLUMN_PLAY,		var_dvdaudio.Pixbuf_FilePlay,
						DVD_TIME_COLUMN,		time,
						DVD_CHANNELS_COLUMN,		dvdaudio_get_channels (var),
						DVD_PIXBUF_CHOICE_COLUMN,	var_dvdaudio.Pixbuf_Coche,
						DVD_PIXBUF_FILE_NORMALIZE,	var_dvdaudio.Pixbuf_Coche,
						DVD_NAME_COLUMN,		var->name_file,
						DVD_NAME_EDITABLE_COLUMN,	TRUE,
						DVD_POINTER_STRUCT_COLUMN,	var,
						-1);

				g_free (time);	time = NULL;
				break;

			case _DVD_CHAPTER :
				str = g_strdup_printf ("<span color=\"black\"><b>%s</b></span>", var->def);

				gtk_tree_store_append (model, &piter2, &piter1);
				gtk_tree_store_set (model, &piter2,
						DVD_TITLE_COLUMN,		str,
						DVD_PIXBUF_COLUMN_PLAY,		NULL,
						DVD_TIME_COLUMN,		"",
						DVD_CHANNELS_COLUMN,		"",
						DVD_PIXBUF_CHOICE_COLUMN,	NULL,
						DVD_PIXBUF_FILE_NORMALIZE,	NULL,
						DVD_NAME_COLUMN,		"",
						DVD_NAME_EDITABLE_COLUMN,	FALSE,
						DVD_POINTER_STRUCT_COLUMN,	var,
						-1);

				g_free (str);	str = NULL;
				break;

			case _DVD_DATA :
				var->OldChannels = var->NewChannels = (gint)atoi (var->StrNumberChannel);

				time = g_strdup_printf ("<b>%s</b>", var->time);

				gtk_tree_store_append (model, &piter3, &piter2);
				gtk_tree_store_set (model, &piter3,
						DVD_TITLE_COLUMN,		var->def,
						DVD_PIXBUF_COLUMN_PLAY,		var_dvdaudio.Pixbuf_FilePlay,
						DVD_TIME_COLUMN,		time,
						DVD_CHANNELS_COLUMN,		dvdaudio_get_channels (var),
						DVD_PIXBUF_CHOICE_COLUMN,	var_dvdaudio.Pixbuf_Coche,
						DVD_PIXBUF_FILE_NORMALIZE,	var_dvdaudio.Pixbuf_Coche,
						DVD_NAME_COLUMN,		var->name_file,
						DVD_NAME_EDITABLE_COLUMN,	TRUE,
						DVD_POINTER_STRUCT_COLUMN,	var,
						-1);

				g_free (time);	time = NULL;
				break;

			}
		}
		/* Détacher le pointeur de la structure */
		list->data = NULL;

		/* Liste suivante */
		list = g_list_next (list);
	}
}

gboolean dvdaudio_foreach_normalise (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	gint	 value = GPOINTER_TO_INT (user_data);
	VAR	*var = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	
	if (var->type_list_dvd == _DVD_DATA_ALL || var->type_list_dvd == _DVD_DATA) {
		var->EtatNormalise = value;

		gtk_tree_store_set (
			GTK_TREE_STORE (model),
			iter,
			DVD_PIXBUF_FILE_NORMALIZE,
			dvdaudio_get_pixbuf_normalise (var->EtatNormalise),
			-1
			);
	}
	
	/* continuer à parcourir l'arbre */
	return FALSE;
}

void dvdaudio_set_flag_normalise (gboolean EtatNormalise)
{
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_normalise, (gpointer)(glong)EtatNormalise);
}

gboolean dvdaudio_foreach_func_if (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR        *var = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	if (var && (var->type_list_dvd == _DVD_DATA || var->type_list_dvd == _DVD_DATA_ALL)) {

		if (var->EtatChoix == _SELECTED_ || var->EtatChoix == _CH_2_) {
			var_dvdaudio.bool_selected = TRUE;
			var_dvdaudio.total_selected ++;
		}

		if (var->EtatChoix == _CH_2_) {
			if (var->OldChannels > 3) var_dvdaudio.bool_sa = TRUE;
			var_dvdaudio.bool_selected = TRUE;
			var_dvdaudio.total_selected_2ch ++;
		}

	}

	/* continuer à parcourir l'arbre */
	return FALSE;
}

gboolean dvdaudio_foreach_is_norm_selected (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR	*var = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	
	if (var->type_list_dvd == _DVD_DATA_ALL || var->type_list_dvd == _DVD_DATA) {
		
		if (var->EtatNormalise == TRUE) var_dvdaudio.BoolNormIsSelected = TRUE;
	}
	
	return FALSE;
}

gboolean dvdaudio_get_is_norm_selected (void)
{
	var_dvdaudio.BoolNormIsSelected = FALSE;
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_is_norm_selected, NULL);
	return (var_dvdaudio.BoolNormIsSelected);
}

void dvdaudio_set_flag_buttons_dvd (void)
{
	gchar *str = NULL;

	var_dvdaudio.bool_selected = FALSE;
	var_dvdaudio.bool_sa = FALSE;
	var_dvdaudio.total_selected_2ch = 0;
	var_dvdaudio.total_selected = 0;

	if (GlistDvd == NULL) {
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_deplier_dvd")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_replier_dvd")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_extraction_dvd")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame187")), FALSE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame110")), FALSE);
		str = g_strdup ("");
		if (var_dvdaudio.Adr_combobox_normalise_dvd != NULL)
			gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_dvdaudio.Adr_combobox_normalise_dvd)), FALSE);
	}
	else {
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_deplier_dvd")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_replier_dvd")), TRUE);
		gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_func_if, NULL);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_extraction_dvd")), var_dvdaudio.total_selected > 0);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame187")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame110")), var_dvdaudio.bool_sa);

		gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_dvdaudio.Adr_combobox_normalise_dvd)), dvdaudio_get_is_norm_selected ());
		
		if (var_dvdaudio.bool_err == 0) {
			str = g_strdup_printf (_("Total selection%s: %d,     2ch: %d"),
				var_dvdaudio.total_selected > 1 ? _("s") : "",
				var_dvdaudio.total_selected,
				var_dvdaudio.total_selected_2ch
				);
		}
		else {
			str = g_strdup(_("<b>Ce fichier ne peut etre extrait !</b>"));
			var_dvdaudio.bool_err --;
		}
	}
	dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
	g_free (str);
	str = NULL;
}

gboolean dvdaudio_foreach_stop_play (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR        *var = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	if (var) {
		if (var->type_list_dvd == _DVD_DATA_ALL || var->type_list_dvd == _DVD_DATA) {
			var->BoolDvdPlay = FALSE;
			gtk_tree_store_set (GTK_TREE_STORE (model), iter, DVD_PIXBUF_COLUMN_PLAY, var_dvdaudio.Pixbuf_FilePlay, -1);
		}
	}
	 /* continuer à parcourir l'arbre */
	return FALSE;
}

gboolean dvdaudio_foreach_affiche_play (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR        *var = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	if (var) {
		if (var->type_list_dvd == _DVD_DATA_ALL || var->type_list_dvd == _DVD_DATA) {
			if (var->BoolDvdPlay == FALSE)
			gtk_tree_store_set (GTK_TREE_STORE (model), iter, DVD_PIXBUF_COLUMN_PLAY, var_dvdaudio.Pixbuf_FilePlay, -1);
			else
			gtk_tree_store_set (GTK_TREE_STORE (model), iter, DVD_PIXBUF_COLUMN_PLAY, var_dvdaudio.Pixbuf_FileStop, -1);
		}
	}
	 /* continuer à parcourir l'arbre */
	return FALSE;
}

void dvdaudio_set_etat_music_pixbuf (gboolean *PtrBoolDvdPlay, gboolean p_BoolDvdPlay)
{
	static gboolean *BoolDvdPlay = NULL;
	
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_stop_play, NULL);
	
	if (PtrBoolDvdPlay != NULL) 
		BoolDvdPlay = PtrBoolDvdPlay;
	if (BoolDvdPlay != NULL) {
		*BoolDvdPlay = p_BoolDvdPlay;
	}

	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_affiche_play, NULL);
}
/* CD_ETAT_PLAY_ATTENTE
   CD_ETAT_PLAY
   */
void dvdaudio_set_etat_music_pixbuf_with_detail (VAR *p_var, gboolean EtatPlay)
{
	/* Tous les flags et widget sur FILE_ETAT_PLAY_ATTENTE */
	
	if (EtatPlay == TRUE) {
		
	}
}

void dvdaudio_pixbuf_stop_play (void)
{
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_stop_play, NULL);
}

gboolean dvdaudio_event_click_mouse (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	gint                Pos_X = 0, Pos_Y = 0;
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeViewColumn  *ColumnDum;
	gint                i;
	guint               button;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	GtkTreeIter         iter;
	VAR                *var = NULL;
	GdkPixbuf          *Pixbuf = NULL;
	gboolean            bool_key_Control = (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R);
	gboolean            bool_key_Shift   = (keys.keyval == GDK_Shift_L || keys.keyval == GDK_Shift_R);
	gboolean            bool_key_Release = (bool_key_Control == FALSE &&  bool_key_Shift == FALSE);
	gboolean            bool_click_gauche = (event->button == 1);
	gboolean            bool_click_droit = (event->button == 3);

	gboolean            BoolSelectColTitres = FALSE;
	gboolean            BoolSelectColPlay = FALSE;
	gboolean            BoolSelectColTemps = FALSE;
	gboolean            BoolSelectColFormat = FALSE;
	gboolean            BoolSelectColChoix = FALSE;
	gboolean            BoolSelectColNormalise = FALSE;	
	gboolean            BoolSelectColNom = FALSE;

	/* Mise a jour du scroll vertical
	*/
	GtkAdjustment   *Adj = NULL;

	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (var_dvdaudio.Adr_scroll));
	gtk_adjustment_set_value (Adj, Adj->value);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (var_dvdaudio.Adr_scroll), Adj);

	var_dvdaudio.bool_click = FALSE;

	/* Single clicks only */
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/*if (bool_key_Release == FALSE || bool_click_gauche == FALSE) return (FALSE);*/
	if (bool_key_Release == FALSE) return (FALSE);

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, &Pos_X, &Pos_Y)) return (FALSE);
	/*
	PRINT_FUNC_LF();
	g_print ("------------> X=%d,  Y=%d\n", Pos_X,Pos_Y);
	*/
	/*
	enum
	{
		NUM_TREE_Titres
		NUM_TREE_Play
		NUM_TREE_Temps
		NUM_TREE_Format
		NUM_TREE_Choix
		NUM_TREE_Normalise
		NUM_TREE_Nom
		NUM_TREE_ALL_COLUMN
	};
	*/
	/* IDEE POUR REMPLACER LES COMPARAISON PAR NOMS. EXEMPLES:
	 * 	PLAY	= 0
	 * 	TRASH	= 1
	 *	TYPE	= 2
	 * 	etc ...
	 * NOTA:
	 * 	CET ALGO PERMET DE RENOMMER AISEMENT LES ENTETES DE COLONNES DANS TOUTES LES LANGUES: FR, EN, DE, ...
	 */
	for (i = 0; i < NUM_TREE_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			/* g_print ("\tNUM IS: %d\n", i); */
			switch ( i ) {
			case NUM_TREE_Titres :		BoolSelectColTitres		= TRUE;	break;
			case NUM_TREE_Play :		BoolSelectColPlay		= TRUE;	break;
			case NUM_TREE_Temps :		BoolSelectColTemps		= TRUE;	break;
			case NUM_TREE_Format :		BoolSelectColFormat		= TRUE;	break;
			case NUM_TREE_Choix :		BoolSelectColChoix		= TRUE;	break;
			case NUM_TREE_Normalise :	BoolSelectColNormalise		= TRUE;	break;
			case NUM_TREE_Nom :		BoolSelectColNom		= TRUE;	break;
			default: return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}


	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);

	if (var && (var->type_list_dvd == _DVD_DATA || var->type_list_dvd == _DVD_DATA_ALL)) {

		button = ((GdkEventButton*)event)->button;
	 	/*
	 	var_dvdaudio.popup_model = NULL;
	 	if ((button == 2 || button == 3) && strcmp(column->title, "Format") == 0) {

	 		var_dvdaudio.popup_model = GTK_TREE_STORE (model);
			var_dvdaudio.popup_iter  = iter;
	 		var_dvdaudio.popup_var   = var;

	 		popup_for_dvd ();
	 		return (FALSE);
		}
		*/
		
		/*if (bool_click_droit && strcmp(column->title, "Normalise") == 0) {*/
		if (bool_click_droit && BoolSelectColNormalise == TRUE) {
			popup_normalise_dvd ();
		}
		
		/*else if (bool_click_gauche && strcmp(column->title, "Normalise") == 0) {*/
		else if (bool_click_gauche && BoolSelectColNormalise == TRUE) {
			
			var->EtatNormalise = (var->EtatNormalise == TRUE) ? FALSE : TRUE;
			
			gtk_tree_store_set (
				GTK_TREE_STORE (model),
				&iter, DVD_PIXBUF_FILE_NORMALIZE,
				dvdaudio_get_pixbuf_normalise (var->EtatNormalise),
				-1
				);
			
			dvdaudio_set_flag_buttons_dvd ();
		}
		
		/*else if (bool_click_gauche && strcmp(column->title, "Choix") == 0) {*/
		else if (bool_click_gauche && BoolSelectColChoix == TRUE) {
			
			if (var->OldChannels == 2) {
				switch (var->EtatChoix) {
				case _COCHE_ :
					var->EtatChoix = _CH_2_;
					Pixbuf = var_dvdaudio.Pixbuf_2ch;
					var->NewChannels = 2;
					break;
				case _CH_2_ :
					var->EtatChoix = _COCHE_;
					Pixbuf = var_dvdaudio.Pixbuf_Coche;
					var->NewChannels = -1;
					break;
				case _SELECTED_ :
					break;
				}
			}
			else if (var->OldChannels > 2) {
				switch (var->EtatChoix) {
				case _COCHE_ :
					var->EtatChoix = _CH_2_;
					Pixbuf = var_dvdaudio.Pixbuf_2ch;
					var->NewChannels = 2;
					break;
				case _CH_2_ :
					var->EtatChoix = _SELECTED_;
					Pixbuf = var_dvdaudio.Pixbuf_Selected;
					var->NewChannels = var->OldChannels;
					break;
				case _SELECTED_ :
					var->EtatChoix = _COCHE_;
					Pixbuf = var_dvdaudio.Pixbuf_Coche;
					var->NewChannels = -1;
					break;
				}
			}
			gtk_tree_store_set (GTK_TREE_STORE (model), &iter, DVD_PIXBUF_CHOICE_COLUMN, Pixbuf, -1);
			dvdaudio_set_flag_buttons_dvd ();
		}
		/*else if (bool_click_gauche && strcmp(column->title, "Play") == 0) {*/
		else if (bool_click_gauche && BoolSelectColPlay == TRUE) {

			gtk_tree_model_get (model, &iter, DVD_PIXBUF_COLUMN_PLAY, &Pixbuf, -1);
			if (Pixbuf == var_dvdaudio.Pixbuf_FileStop) {

				/*gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_stop_play, NULL);
				*/
				dvdaudio_set_etat_music_pixbuf (&var->BoolDvdPlay, FALSE);
				mplayer_fifo_quit ();
			}
			else if (WinPlay_Is_Ok () == TRUE) {

				GList *list = NULL;
				gchar *Chapter = NULL;

				/*
				LIST_MPLAYER_FROM_DVD
				LIST_MPLAYER_FROM_CD
				LIST_MPLAYER_FROM_FILE
				*/
				if (WinPlay_IsOpen () == FALSE) {

					WinPlay_Open (LIST_MPLAYER_FROM_DVD, "From DVD", "DVD");
				}
				else {

					WinPlay_set_label_namefile (LIST_MPLAYER_FROM_DVD, "From DVD", "DVD");
				}

				dvdaudio_set_etat_music_pixbuf (&var->BoolDvdPlay, TRUE);

				list = g_list_append (list, g_strdup ("-vo"));
				list = g_list_append (list, g_strdup ("null"));

				list = g_list_append (list, g_strdup ("-chapter"));				
				if (*var->StrNumerateChapter == '0')
					list = g_list_append (list, g_strdup ("1"));
				else	list = g_list_append (list, g_strdup_printf ("%s-%s", var->StrNumerateChapter, var->StrNumerateChapter));
				
				list = g_list_append (list, g_strdup_printf ("dvd://%d", var->NumerateTitle));
				
				list = g_list_append (list, g_strdup ("-dvd-device"));
				list = g_list_append (list, g_strdup (scancd_get_text_combo_cd (_DVD_)));
				list = g_list_append (list, g_strdup ("-aid"));
				list = g_list_append (list, g_strdup_printf ("%d",utils_hexa_to_int (var->StrNumerateStreamId)));
				
				Chapter = g_strdup_printf ("%d",var->DebutLecture);
				
				var_dvdaudio.PlayDvdAudio.list = utils_clear_list (var_dvdaudio.PlayDvdAudio.list);

				var_dvdaudio.PlayDvdAudio.double_TempsTotal = (gdouble)var->GUINT_TempsTotal;
				var_dvdaudio.PlayDvdAudio.guint_TempsTotal  = var_dvdaudio.GUINT_TempsTotal;
				var_dvdaudio.PlayDvdAudio.list              = list;
				
				mplayer_set_list (LIST_MPLAYER_FROM_DVD, (gdouble)var->GUINT_TempsTotal, var_dvdaudio.GUINT_TempsTotal, list);
				
				g_free (Chapter);
				Chapter = NULL;
			}
		}

		/* position du curseur a l'instant du click */
		if (Pos_X < 10 || Pos_X > 22) return (FALSE);
		if (Pos_Y < 6 || Pos_Y > 18) return (FALSE);

		var_dvdaudio.bool_click = TRUE;
	}
	return (FALSE);
}

static void dvdaudio_cell_edited_namefile (GtkCellRendererText *cell,
                                            gchar       *path_string,
                                            gchar       *new_text,
                                            gpointer     data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath  *path = gtk_tree_path_new_from_string (path_string);
	GtkTreeIter   iter;
	gint          column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (cell), "column"));
	VAR          *var = NULL;

	/*PRINT_FUNC_LF();*/

	gtk_tree_model_get_iter (model, &iter, path);

	if (column == DVD_NAME_COLUMN) {
		gchar   *old_text;

		gtk_tree_model_get (model, &iter, DVD_NAME_COLUMN, &old_text, -1);
		g_free (old_text);
		old_text = NULL;

		gtk_tree_model_get (model, &iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
		g_free (var->name_file);
		var->name_file = NULL;

		var->name_file = g_strdup (new_text);

		/* actualise le nom */
		gtk_tree_store_set (GTK_TREE_STORE (model), &iter, column, new_text, -1);

	}
	gtk_tree_path_free (path);
}

gboolean dvdaudio_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	gint                x, y;
	GdkModifierType     state;
	GtkTreeIter         iter;
	gint                Pos_X = 0, Pos_Y = 0;
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeViewColumn  *ColumnDum;
	gint                i;
	GtkTreeModel       *model = (GtkTreeModel *)user_data;
	VAR                *var = NULL;
	gchar              *str = NULL;
	GdkPixbuf          *Pixbuf = NULL;

	gboolean            BoolSelectColTitres = FALSE;
	gboolean            BoolSelectColPlay = FALSE;
	gboolean            BoolSelectColTemps = FALSE;
	gboolean            BoolSelectColFormat = FALSE;
	gboolean            BoolSelectColChoix = FALSE;
	gboolean            BoolSelectColNormalise = FALSE;	
	gboolean            BoolSelectColNom = FALSE;

	/*PRINT_FUNC_LF();*/

	if (keys.eventkey == GDK_KEY_PRESS) {
		return (FALSE);
	}

	if (event->type == GDK_ENTER_NOTIFY) {
		var_dvdaudio.NumStruct = 0;
		var_dvdaudio.bool_dedans = TRUE;
	}
	else if (event->type == GDK_LEAVE_NOTIFY) {
		var_dvdaudio.NumStruct = 0;
		var_dvdaudio.bool_dedans = FALSE;
		dvdaudio_set_flag_buttons_dvd ();
		return (FALSE);
	}
	else if (event->type == GDK_MOTION_NOTIFY)  {
		var_dvdaudio.bool_dedans = TRUE;
	}

	if (var_dvdaudio.bool_dedans == FALSE) {
		var_dvdaudio.NumStruct = 0;
		dvdaudio_set_flag_buttons_dvd ();
		return (FALSE);
	}


	/* Si pas de selection a cet endroit retour */
	gdk_window_get_pointer (((GdkEventButton*)event)->window, &x, &y, &state);
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					   x, y,
					   &path, &column, &Pos_X, &Pos_Y)) {
		dvdaudio_set_flag_buttons_dvd ();
		return (FALSE);
	}

	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_dvdaudio.Adr_Tree_Model, &iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	if (var == NULL) return (FALSE);
	
	/*
	enum
	{
		NUM_TREE_Titres
		NUM_TREE_Play
		NUM_TREE_Temps
		NUM_TREE_Format
		NUM_TREE_Choix
		NUM_TREE_Normalise
		NUM_TREE_Nom
		NUM_TREE_ALL_COLUMN
	};
	*/
	/* IDEE POUR REMPLACER LES COMPARAISON PAR NOMS. EXEMPLES:
	 * 	PLAY	= 0
	 * 	TRASH	= 1
	 *	TYPE	= 2
	 * 	etc ...
	 * NOTA:
	 * 	CET ALGO PERMET DE RENOMMER AISEMENT LES ENTETES DE COLONNES DANS TOUTES LES LANGUES: FR, EN, DE, ...
	 */
	for (i = 0; i < NUM_TREE_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			/* g_print ("\tNUM IS: %d\n", i); */
			switch ( i ) {
			case NUM_TREE_Titres :		BoolSelectColTitres		= TRUE;	break;
			case NUM_TREE_Play :		BoolSelectColPlay		= TRUE;	break;
			case NUM_TREE_Temps :		BoolSelectColTemps		= TRUE;	break;
			case NUM_TREE_Format :		BoolSelectColFormat		= TRUE;	break;
			case NUM_TREE_Choix :		BoolSelectColChoix		= TRUE;	break;
			case NUM_TREE_Normalise :	BoolSelectColNormalise		= TRUE;	break;
			case NUM_TREE_Nom :		BoolSelectColNom		= TRUE;	break;
			default: return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}

	
	/*if (strcmp(column->title, "Normalise") == 0) {*/
	if (BoolSelectColNormalise == TRUE) {
	
		/*
		switch (var->EtatNormalise) {
		case CD_NORM_NONE :
			str = g_strdup (_("(Click Droit = Menu) / En attente de selection."));
			break;
		case CD_NORM_PEAK :
			str = g_strdup (_("(Click Droit = Menu) / Peak: Le volume sera ajuste au maximum pour cet element"));
			break;
		case CD_NORM_PEAK_ALBUM :
			str = g_strdup (_("(Click Droit = Menu) / Peak Groupe: Le volume sera ajuste au maximum pour tous ces elements"));
			break;
		}
		dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
		g_free (str);
		str = NULL;
		*/
	}

	/*else if (strcmp(column->title, "Nom") == 0) {*/
	if (BoolSelectColNom == TRUE) {
	
		if (var_dvdaudio.NumStruct == var->NumStruct) return (FALSE);
		var_dvdaudio.NumStruct = var->NumStruct;

		if (var->name_file && *var->name_file) {
			str = g_strdup_printf ("%s.wav", var->name_file);
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
			g_free (str);
			str = NULL;
		}
		else {
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, " ");
		}
	}

	/*else if (strcmp(column->title, "Choix") == 0) {*/
	if (BoolSelectColChoix == TRUE) {

		if (var->name_file && *var->name_file == '\0' )return (FALSE);

		/* position du curseur a l'instant du click */
		if (Pos_X < 10 || Pos_X > 38 || Pos_Y < 6 || Pos_Y > 22) {
			dvdaudio_set_flag_buttons_dvd ();
			return (FALSE);
		}

		if (var->OldChannels == 2) {
			switch (var->EtatChoix) {
			case _COCHE_ :
				str = g_strdup (_("En attente de selection. Un click activera la conversion vers 2 canaux."));
				dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
				break;
			case _SELECTED_ :
				/*
				str = g_strdup_printf (_("Conversion vers %s canaux."), var->StrNumberChannel);
				dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
				PRINT("SELECTED");
				*/
				break;
			case _CH_2_ :
				str = g_strdup_printf (_("Conversion vers 2 canaux."));
				dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
				break;
			}
		}
		else if (var->OldChannels > 2) {
			switch (var->EtatChoix) {
			case _COCHE_ :
				str = g_strdup (_("En attente de selection. Un click activera la conversion vers 2 canaux."));
				dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
				break;
			case _SELECTED_ :
				str = g_strdup_printf (_("Conversion vers %s canaux."), var->StrNumberChannel);
				dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
				break;
			case _CH_2_ :
				str = g_strdup_printf (
					_("Conversion vers 2 canaux. Un second click activera la conversion vers %s canaux."), var->StrNumberChannel);
				dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, str);
				break;
			}
		}
		if (str != NULL) {
			g_free (str);
			str = NULL;
		}
	}
	
	/*else if (strcmp(column->title, "Play") == 0) {*/
	if (BoolSelectColPlay == TRUE) {
	
		gtk_tree_model_get (model, &iter, DVD_PIXBUF_COLUMN_PLAY, &Pixbuf, -1);
		if (Pixbuf == var_dvdaudio.Pixbuf_FileStop) {
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Musique en ecoute."));
		}
		else if (Pixbuf == var_dvdaudio.Pixbuf_FilePlay) {
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Musique en attente."));
		}
		else {
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, " ");
		}
	}
	
	else {
		dvdaudio_set_flag_buttons_dvd ();
	}

	return (FALSE);
}

void dvdaudio_changed_selection_row_file_dvd (GtkTreeSelection *selection, gpointer data)
{
	var_dvdaudio.Adr_Line_Selected = selection;
}

gboolean dvdaudio_foreach_normalise_column (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR	*var = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	
	if (var->type_list_dvd == _DVD_DATA_ALL || var->type_list_dvd == _DVD_DATA) {
		
		var->EtatNormalise = (var->EtatNormalise == TRUE) ? FALSE : TRUE;
		gtk_tree_store_set (
			GTK_TREE_STORE (model),
			iter,
			DVD_PIXBUF_FILE_NORMALIZE,
			dvdaudio_get_pixbuf_normalise (var->EtatNormalise),
			-1
			);
	}
	
	/* continuer à parcourir l'arbre */
	return FALSE;
}

void dvdaudio_selected_column (GtkTreeViewColumn *treeviewcolumn, gpointer user_data)
{
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_normalise_column, NULL);
}

gboolean dvdaudio_foreach_update (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR		*var = NULL;
	GdkPixbuf	*Pixbuf = NULL;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);
	
	if (var->type_list_dvd == _DVD_DATA_ALL || var->type_list_dvd == _DVD_DATA) {

		/* Raffraihcissement COCHE */
		switch (var->EtatChoix) {
		case _COCHE_ :
			Pixbuf = var_dvdaudio.Pixbuf_Coche;
			var->NewChannels = -1;
			break;
		case _CH_2_ :
			Pixbuf = var_dvdaudio.Pixbuf_2ch;
			var->NewChannels = 2;
			break;
		case _SELECTED_ :
			Pixbuf = var_dvdaudio.Pixbuf_Selected;
			var->NewChannels = var->OldChannels;
			break;
		}
		gtk_tree_store_set (GTK_TREE_STORE (model), iter, DVD_PIXBUF_CHOICE_COLUMN, Pixbuf, -1);

		/* Raffraihcissement NORMALISE */
		gtk_tree_store_set (GTK_TREE_STORE (model), iter, DVD_PIXBUF_FILE_NORMALIZE, dvdaudio_get_pixbuf_normalise (var->EtatNormalise), -1);
	}
	/* continuer à parcourir l'arbre */
	return FALSE;
}
void dvdaudio_update (void)
{
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_update, NULL);
}

static void dvdaudio_add_columns (GtkTreeView *treeview)
{
	gint               col_offset;
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);

	var_dvdaudio.NumStruct = 0;
	var_dvdaudio.bool_dedans = FALSE;

	/* SIGNAL : 'event'
	*/
	g_signal_connect(G_OBJECT(treeview), "event", (GCallback) dvdaudio_event, model);

	/* SIGNAL : 'button-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview), "button-press-event", (GCallback) dvdaudio_event_click_mouse, model);
	
	/* Ligne actuellement selectionnee
	*/
	var_dvdaudio.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	g_signal_connect(G_OBJECT(var_dvdaudio.Adr_Line_Selected),
			 "changed",
                   	 G_CALLBACK(dvdaudio_changed_selection_row_file_dvd),
                   	 "1");
	
	/* DVD_TITLE_COLUMN */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("Titres"),	renderer,
							"markup",	DVD_TITLE_COLUMN,
							NULL);
	var_dvdaudio.Adr_Column_Titres =
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);

	/* DVD_PIXBUF_COLUMN_PLAY */
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("Play"), renderer,
							"pixbuf", DVD_PIXBUF_COLUMN_PLAY,
							NULL);
	var_dvdaudio.Adr_Column_Play =
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);

	/* DVD_TIME_COLUMN */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("Temps"),	renderer,
							"markup",	DVD_TIME_COLUMN,
							NULL);
	var_dvdaudio.Adr_Column_Temps =
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);

	/* DVD_CHANNELS_COLUMN */
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("Format"),	renderer,
							"markup",	DVD_CHANNELS_COLUMN,
							NULL);
	var_dvdaudio.Adr_Column_Format =
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);

	/* DVD_PIXBUF_CHOICE_COLUMN */
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("Choix"), renderer,
							"pixbuf", DVD_PIXBUF_CHOICE_COLUMN,
							NULL);
	var_dvdaudio.Adr_Column_Choix =
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);

	/* ITEM_WAV_SELECT_COLUMN */
	/*
	renderer = gtk_cell_renderer_toggle_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *)ITEM_WAV_SELECT_COLUMN);
	g_signal_connect (renderer, "toggled", G_CALLBACK (dvdaudio_item_toggled_wav), model);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							"Wav", renderer,
							"active",
							ITEM_WAV_SELECT_COLUMN,
							"visible",
							VISIBLE_COLUMN,
							"activatable",
							WORLD_COLUMN, NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	*/
	
	/* DVD_PIXBUF_FILE_NORMALIZE
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("Normalise"),	renderer,
							"pixbuf",	DVD_PIXBUF_FILE_NORMALIZE,
							NULL);
	var_dvdaudio.Adr_Column_Normalise =
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (dvdaudio_selected_column),
			GINT_TO_POINTER(0));
	
	/* DVD_NAME_COLUMN */
	var_dvdaudio.renderer =
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *)DVD_NAME_COLUMN);
	g_signal_connect (renderer, "edited", G_CALLBACK (dvdaudio_cell_edited_namefile), model);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("Nom"),
							renderer,
							"text", DVD_NAME_COLUMN,
							 "editable", DVD_NAME_EDITABLE_COLUMN,
							NULL);
	var_dvdaudio.Adr_Column_Nom =
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
}

GdkPixbuf *dvdaudio_init_pixbufs (char *NameFilePixbuf)
{
	GdkPixbuf *NewPixbuf = NULL;
	GError    *error = NULL;
	gchar     *Pathname_Pixbuf = NULL;

	Pathname_Pixbuf = utils_get_pathname (NameFilePixbuf);

	NewPixbuf = gdk_pixbuf_new_from_file(Pathname_Pixbuf, &error);
 	if (error) {
 		GDK_PIXBUF_ERROR;
		g_critical ("Could not load pixbuf: %s\n", error->message);
		g_error_free (error);
		g_free (Pathname_Pixbuf);
		Pathname_Pixbuf = NULL;
		return (NULL);
	}
	g_free (Pathname_Pixbuf);
	Pathname_Pixbuf = NULL;

	return (NewPixbuf);
}

void dvdaudio_make_scrolledwindow_realize (GtkWidget *widget)
{
	/* Chargement des PIXBUF */
	var_dvdaudio.Pixbuf_FilePlay    = dvdaudio_init_pixbufs ("no_play.png");
	var_dvdaudio.Pixbuf_FileStop    = dvdaudio_init_pixbufs ("sol.png");
	var_dvdaudio.Pixbuf_Coche       = dvdaudio_init_pixbufs ("coche.png");
	var_dvdaudio.Pixbuf_Coche_Exist = dvdaudio_init_pixbufs ("coche_exist.png");
	var_dvdaudio.Pixbuf_Selected    = dvdaudio_init_pixbufs ("selected.png");
	var_dvdaudio.Pixbuf_2ch         = dvdaudio_init_pixbufs ("2ch.png");

	var_dvdaudio.Adr_scroll = widget;

	var_dvdaudio.Adr_Tree_Model = (GtkTreeModel *) gtk_tree_store_new (DVD_NUM_COLUMNS,
					G_TYPE_STRING,		/* DVD_TITLE_COLUMN		*/
					GDK_TYPE_PIXBUF,	/* DVD_PIXBUF_COLUMN_PLAY	*/
					G_TYPE_STRING,		/* DVD_TIME_COLUMN		*/
					G_TYPE_STRING,		/* DVD_CHANNELS_COLUMN		*/
					GDK_TYPE_PIXBUF,	/* DVD_PIXBUF_CHOICE_COLUMN	*/
					GDK_TYPE_PIXBUF,	/* DVD_PIXBUF_FILE_NORMALIZE	*/
					G_TYPE_STRING,		/* DVD_NAME_COLUMN		*/
					G_TYPE_BOOLEAN,		/* DVD_NAME_EDITABLE_COLUMN	*/
					G_TYPE_POINTER		/* DVD_POINTER_STRUCT_COLUMN	*/
					);

	/* create tree view */
	var_dvdaudio.Adr_TreeView = gtk_tree_view_new_with_model (var_dvdaudio.Adr_Tree_Model);
	g_object_unref (var_dvdaudio.Adr_Tree_Model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (var_dvdaudio.Adr_TreeView), TRUE);

	dvdaudio_add_columns (GTK_TREE_VIEW (var_dvdaudio.Adr_TreeView));

	gtk_container_add (GTK_CONTAINER (widget), var_dvdaudio.Adr_TreeView);

	gtk_widget_show_all (widget);
}

void dvdaudio_combobox_peripherique_dvd_realize (GtkWidget *widget)
{
	GList *List = NULL;
	MEDIA *Media = NULL;

	/* PRINT_FUNC_LF(); */

	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	List = g_list_first (scancd_get_glist ());
	while (List) {
		if ((Media = (MEDIA *)List->data)) {
			gtk_combo_box_append_text (GTK_COMBO_BOX (widget), (gchar *)Media->Full_Name);
		}
		List = g_list_next(List);
	}
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Fichier structure DVD"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
	var_dvdaudio.Adr_ComboBox_Reader = GTK_COMBO_BOX (widget);
}

void *dvdaudio_pthread_reffresh_list_dvd (void *data)
{
	var_dvdaudio.bool_end_pthread = FALSE;
	var_dvdaudio.bool_read_dvd = TRUE;

	dvdexec_remove_list ();

	if (dvdexec_dvd_found () == FALSE) {
		var_dvdaudio.bool_read_dvd = FALSE;
	}
	else {
		if (var_dvdaudio.bool_halt == FALSE) {
			if (dvdexec_dvd_read () == TRUE) {
				var_dvdaudio.bool_read_dvd = TRUE;
			}
			else {
				var_dvdaudio.bool_read_dvd = FALSE;
			}
		}
	}

	var_dvdaudio.bool_end_pthread = TRUE;
	pthread_exit (0);
}

static gint dvdaudio_Timeout_Update_Handler (gpointer data)
{
	float val;

	val = gtk_progress_get_value(GTK_PROGRESS(var_dvdaudio.Adr_progressbar_dvd));
	val = val >= 100.0 ? 0.0 : val;
	gtk_progress_set_value(GTK_PROGRESS(var_dvdaudio.Adr_progressbar_dvd), val + 0.01);

	if (var_dvdaudio.bool_end_pthread == TRUE) {

		if (var_dvdaudio.bool_halt == TRUE) {
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Arret par l'utilisateur"));

		}
		else {
			if (var_dvdaudio.bool_read_dvd == TRUE) {
				
				/*
				dvdexec_create_recap_audio ();
				dvdexec_read_info_audio ();
				dvdexec_create_list_with_data ();
				*/
				
				dvdaudio_affiche_list ();
				gtk_tree_view_expand_all ( (GtkTreeView *)var_dvdaudio.Adr_TreeView);
				dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, "");
			}
		}

		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame106")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame107")), TRUE);
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("scrolledwindow_dvd_audio")), TRUE);
		gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("button_annuler_lecture_dvd")));
		gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("progressbar_dvd_audio")));
		gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame_lecture_dvd")));
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame187")));
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame109")));
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame110")));
		gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame184")));

		dvdaudio_set_flag_buttons_dvd ();

		if (var_dvdaudio.bool_read_dvd == FALSE) {
			dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Le DVD est absent du lecteur."));
		}

		conv_set_struct_not_used ();
		gtk_timeout_remove (var_dvdaudio.Handler_Timeout);
	}
	else if (var_dvdaudio.bool_halt == TRUE) {
		conv_stop_conversion ();
	}

	return (TRUE);
}
void dvdaudio_reffresh_list_dvd_action (void)
{
	pthread_t nmr_tid;

	dvdaudio_remove_GtkTree ();

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame106")), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("frame107")), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("scrolledwindow_dvd_audio")), FALSE);
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame187")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame109")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame110")));
	gtk_widget_hide (GTK_WIDGET (XCFA_GET_OBJECT("frame184")));

	gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("button_annuler_lecture_dvd")));
	gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("progressbar_dvd_audio")));
	gtk_widget_show (GTK_WIDGET (XCFA_GET_OBJECT("frame_lecture_dvd")));

	conv_reset_struct ();

	/*
	if (var_dvdaudio.PathDvd != NULL) {
		g_free (var_dvdaudio.PathDvd);
		var_dvdaudio.PathDvd = NULL;
	}
	var_dvdaudio.PathDvd = g_strdup (scancd_get_text_combo_cd (_DVD_));
	*/
	var_dvdaudio.PathDvd = scancd_get_text_combo_cd (_DVD_);
	
	gtk_progress_bar_pulse (GTK_PROGRESS_BAR (var_dvdaudio.Adr_progressbar_dvd));
	gtk_progress_set_value(GTK_PROGRESS((GtkWidget*)var_dvdaudio.Adr_progressbar_dvd), 0.0);
	gtk_progress_set_activity_mode (GTK_PROGRESS((GtkWidget*)var_dvdaudio.Adr_progressbar_dvd), TRUE);
	dvdaudio_puts_label_statusbar (_STATUSBAR_SET_, _("Recuperation de la liste des pistes. Veuillez patienter ..."));

	var_dvdaudio.bool_read_dvd = TRUE;
	var_dvdaudio.bool_halt = FALSE;
	var_dvdaudio.bool_end_pthread = FALSE;
	var_dvdaudio.Handler_Timeout = gtk_timeout_add (100, dvdaudio_Timeout_Update_Handler, 0);
	pthread_create (&nmr_tid, NULL ,(void *)dvdaudio_pthread_reffresh_list_dvd, (void *)NULL);
	pthread_detach (nmr_tid);
}

void dvdaudio_reffresh_list_directory_dvd (gchar *path)
{
	var_dvdaudio.from.bool_dvd = FALSE;

	g_free (var_dvdaudio.from.path);
	var_dvdaudio.from.path = NULL;
	var_dvdaudio.from.path = g_strdup (path);

	g_free (Config_User.Path_Load_File_DVD);
	Config_User.Path_Load_File_DVD = NULL;
	Config_User.Path_Load_File_DVD = g_strdup (path);

	mplayer_fifo_quit ();
	dvdaudio_reffresh_list_dvd_action ();
}

gboolean dvdaudio_bool_read_dvd_from_directory (void)
{
	guint nbr = g_list_length (scancd_get_glist ());
	gint  Nmr_Combo_Actif = gtk_combo_box_get_active (var_dvdaudio.Adr_ComboBox_Reader);

	return (Nmr_Combo_Actif >= nbr ? TRUE : FALSE);
}

void dvdaudio_reffresh_list_dvd (void)
{
	if (!var_dvdaudio.Adr_ComboBox_Reader) return;

	if (utils_scan_by_which ("lsdvd", NULL) == FALSE) {
		wininfo_create (
			_("lsdvd est absent  !"),
			_("    Il faut installer le programme: lsdvd     "),
			  "           \n\n",
			  "");
		return;
	}

	if (dvdaudio_bool_read_dvd_from_directory () == TRUE) {
		fileselect_create (_PATH_LOAD_DVD_FROM_DIRECTORY_, dvdaudio_reffresh_list_directory_dvd);
	}
	else {
		var_dvdaudio.from.bool_dvd = TRUE;
		g_free (var_dvdaudio.from.path);
		var_dvdaudio.from.path = NULL;
		mplayer_fifo_quit ();
		dvdaudio_reffresh_list_dvd_action ();
	}
}

void dvdaudio_button_destination_dvd_realize (GtkWidget *widget)
{
	var_dvdaudio.bool_selected = FALSE;
	dvdaudio_set_flag_buttons_dvd ();

	var_dvdaudio.Adr_button_destination_dvd = GTK_BUTTON (widget);
	gtk_button_set_use_underline (GTK_BUTTON (var_dvdaudio.Adr_button_destination_dvd), FALSE);
	gtk_button_set_label (GTK_BUTTON (var_dvdaudio.Adr_button_destination_dvd), Config_User.Path_Destination_DVD);
}

void dvdaudio_maj_destination_DVD (gchar *path)
{
	if (options_verif_dossier_is_ok (path) == TRUE) {
		if (utils_test_write (path) == TRUE) {
			g_free (Config_User.Path_Destination_DVD);
			Config_User.Path_Destination_DVD = NULL;
			Config_User.Path_Destination_DVD = g_strdup (path);
			gtk_button_set_label (GTK_BUTTON (var_dvdaudio.Adr_button_destination_dvd), Config_User.Path_Destination_DVD);
		}
	}
}

void dvdaudio_button_destination_dvd_clicked (void)
{
	fileselect_create (_PATH_DESTINATION_DVD_, dvdaudio_maj_destination_DVD);
}

void dvdaudio_puts_label_statusbar (STATUSBAR_FLAG StatusbarFlag, gchar *mess_label_status)
{
	static gchar *MessStatusBar = NULL;

	if (var_utils.AdrLabelStatusbarGlobal) {
		if (StatusbarFlag == _STATUSBAR_RESTITUE_) {
			if (MessStatusBar != NULL) {
				utils_puts_statusbar_global (mess_label_status);
			}
		}

		if (StatusbarFlag == _STATUSBAR_SAVE_) {
			g_free (MessStatusBar);
			MessStatusBar = NULL;
			MessStatusBar = g_strdup ((gchar *)gtk_label_get_label (GTK_LABEL (var_utils.AdrLabelStatusbarGlobal)));
			StatusbarFlag = _STATUSBAR_SET_;
		}

		if (StatusbarFlag == _STATUSBAR_SET_) {
			if (mess_label_status && *mess_label_status) {
				utils_puts_statusbar_global (mess_label_status);
			}
		}
	}
}

void dvdaudio_button_annuler_lecture_dvd_clicked (void)
{
	var_dvdaudio.bool_halt = TRUE;
	dvdaudioextract_halt ();
}

gboolean dvdaudio_foreach_func (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	VAR               *var = NULL;
	gchar             *chapter = NULL;
	gchar             *param = NULL;
	gchar             *ptr = NULL;
	NEW_DVD_EXTRACT   *StructDvdExtract = NULL;
	gchar            **Larrbuf = NULL;
	gint               cpt;

	gtk_tree_model_get (model, iter, DVD_POINTER_STRUCT_COLUMN, &var, -1);

	if (var && (var->type_list_dvd == _DVD_DATA || var->type_list_dvd == _DVD_DATA_ALL)) {

		if (var->EtatChoix == _SELECTED_ || var->EtatChoix == _CH_2_) {

			if (*var->StrNumerateChapter == '0')
				chapter = g_strdup ("-chapter 1");
			else	chapter = g_strdup_printf ("-chapter %s-%s", var->StrNumerateChapter, var->StrNumerateChapter);

			if (var->format_id == _AC3_) {
				ptr = dvdtable_get (var->OldChannels, var->NewChannels);
				param = g_strdup_printf ("-rawaudio format=0x2000 -demuxer -rawaudio -channels %d -af pan=%d:%s",
					var->OldChannels,
					var->NewChannels,
					ptr);
				/*
				param = g_strdup_printf ("-rawaudio format=0x2000 -channels %d -af pan=%d:%s",
					var->OldChannels,
					var->NewChannels,
					ptr);
				*/
				g_free (ptr);
				ptr = NULL;
			}
			else if (var->format_id == _DTS_) {
				if (var->OldChannels == var->NewChannels) {
					param = g_strdup_printf ("-af channels=%d", var->OldChannels);
				}
				else {
					ptr = dvdtable_get (var->OldChannels, var->NewChannels);
					param = g_strdup_printf ("-channels %d -af pan=%d:%s",
						var->OldChannels,
						var->NewChannels,
						ptr);
					g_free (ptr);
					ptr = NULL;
				}
			}
			else if (var->format_id == _INCONNU_) {
				g_print ("\nFORMAT == _INCONNU_\n\tExtraction comme AC3\n");

				ptr = dvdtable_get (var->OldChannels, var->NewChannels);
				param = g_strdup_printf ("-channels %d -af pan=%d:%s",
					var->OldChannels,
					var->NewChannels,
					ptr);
				g_free (ptr);
				ptr = NULL;
			}

			/* Allocate Structure DVD_EXTRACT */
			/* dvd_extract = (DVD_EXTRACT *)g_malloc0 (sizeof (DVD_EXTRACT)); */

			/* And set datas */
			/*
			dvd_extract->Name        = g_strdup_printf ("%s/%s.wav", Config_User.Path_Destination_DVD, var->name_file);
			dvd_extract->NameTemp    = g_strdup_printf ("%s/_%04d_tmp_xcfa.wav", Config_User.Path_Destination_DVD, var_dvdaudio.int_temp);
			var_dvdaudio.int_temp ++;

			dvd_extract->LineCommand =
				g_strdup_printf ("nice -n %s mplayer -vo null -ao pcm:file=%s %s dvd://%s -dvd-device %s -aid %d %s",
					conv.valuenice,
					dvd_extract->NameTemp,
					chapter,
					var->StrNumerateTitle,
					scancd_get_text_combo_cd (_DVD_),
					utils_hexa_to_int (var->StrNumerateStreamId),
					param
					);
					
			g_print ("dvd_extract->LineCommand =%s\n", dvd_extract->LineCommand);

			GlistDvdExtract = g_list_append (GlistDvdExtract, dvd_extract);
			*/

			/* NOUVEAU */
			StructDvdExtract = (NEW_DVD_EXTRACT *)g_malloc0 (sizeof (NEW_DVD_EXTRACT));
			
			StructDvdExtract->Path = g_strdup_printf ("%s/%s.wav", Config_User.Path_Destination_DVD, var->name_file);
			StructDvdExtract->Var  = var;
			
			StructDvdExtract->EtatNormalise = var->EtatNormalise;
			
			if (var->EtatNormalise == TRUE)	{
				switch (dvdaudio_get_value_normalise_dvd ()) {
				case 0 : var_dvdaudio.TTNormPeakCollectif ++;	break;
				case 1 : var_dvdaudio.TTNormPeak ++;		break;
				}
			}

			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("nice"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("-n"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup (conv.valuenice));
			
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("mplayer"));
					
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("-nojoystick"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("-nolirc"));

			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("-vo"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("null"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("-ao"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list,
				g_strdup_printf ("pcm:file=%s/%s.wav", Config_User.Path_Destination_DVD, var->name_file));
			
			Larrbuf = g_strsplit (chapter, " ", 0);
			for (cpt=0; Larrbuf[cpt]; cpt++) {
				StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup (Larrbuf[cpt]));
			}
			g_strfreev(Larrbuf);
			
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup_printf ("dvd://%s", var->StrNumerateTitle));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("-dvd-device"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup (scancd_get_text_combo_cd (_DVD_)));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup ("-aid"));
			StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup_printf ("%d",utils_hexa_to_int (var->StrNumerateStreamId)));
	
			Larrbuf = g_strsplit (param, " ", 0);
			for (cpt=0; Larrbuf[cpt]; cpt++) {
				StructDvdExtract->list = g_list_append (StructDvdExtract->list, g_strdup (Larrbuf[cpt]));
			}
			g_strfreev(Larrbuf);

			GlistDvdExtract = g_list_append (GlistDvdExtract, StructDvdExtract);

			g_free (param);		param = NULL;
		}
		else {
			var->EtatNormalise = FALSE;
		}
	}

	 /* continuer à parcourir l'arbre */
	return FALSE;
}

void dvdaudio_button_extraction_dvd_clicked (void)
{
	/* TESTS ET DEBUG
	   --------------
	gint c,p;
	dvdtable_save_tables_pan ();
	dvdtable_read_tables_pan ();
	g_print ("------\n");
	for (c=0;c<6;c++) {
		for (p=0;p<6;p++)
			g_print (">%s\n", dvdtable_get (c+1, p+1));
	}
	*/
	g_snprintf (conv.valuenice, 4, "%d", options_get_val_nice ());

	var_dvdaudio.int_temp = 0;
	var_dvdaudio.TTNormPeak          = 0;
	var_dvdaudio.TTNormPeakCollectif = 0;
	
	gtk_tree_model_foreach (GTK_TREE_MODEL(var_dvdaudio.Adr_Tree_Model), dvdaudio_foreach_func, NULL);

	mplayer_fifo_quit ();
	dvdaudioextract_dvd_to_file ();
}

void dvdaudio_combobox_sub_dvd_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));

	var_dvdaudio.Adr_combobox_sub_dvd = GTK_COMBO_BOX (widget);

	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Normal");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "-3dB");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "-6dB");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
}
void dvdaudio_combobox_ambiance_dvd_realize (GtkWidget *widget)
{
	/*PRINT_FUNC_LF();*/
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	var_dvdaudio.Adr_combobox_ambiance_dvd = GTK_COMBO_BOX (widget);
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Normal");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "-3dB");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "-6dB");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
}


void dvdaudio_combobox_normalise_dvd_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	var_dvdaudio.Adr_combobox_normalise_dvd = GTK_COMBO_BOX (widget);
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Peak/Album");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Peak");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);
}
gint dvdaudio_get_value_normalise_dvd (void)
{
	if (var_dvdaudio.Adr_combobox_normalise_dvd == NULL) return (-1);
	return (gtk_combo_box_get_active (var_dvdaudio.Adr_combobox_normalise_dvd));
}

void dvdaudio_button_eject_dvd_clicked (void)
{
	dvdaudio_remove_GtkTree ();
	dvdexec_remove_list ();
	dvdaudio_set_flag_buttons_dvd ();
	scancd_eject_media (_DVD_);
}




