 /*
 * file      : cd_db.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib/gstdio.h>

#include <string.h>
#include <stdlib.h>
#include <pthread.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>

#include "utils.h"
#include "global.h"
#include "cd_audio.h"
#include "info_song.h"
#include "cdtoc.h"
#include "get.h"
#include "scan_cd.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

typedef struct {
	
	gchar	*TmpRep;
	gchar	*TmpActuel;
	gchar	*PathNameCdIndex;	// audio.cdindex

} VAR_CDDB;

VAR_CDDB VarCddb = { NULL, NULL, NULL };

gboolean bool_cancel_cddb = FALSE;	/* FALSE = continue ELSE STOP */


int strcasecmp (const char *s1, const char *s2);
int strncasecmp (const char *s1, const char *s2, size_t n);



/* Si 'FLAG == FALSE', force l'arret de la recherche sur le serveur freedb
*  --
*  entree :
*      gboolean FLAG : TRUE or FALSE
*  retour : -
*/
void cddb_set_bool_cancel_cddb (gboolean FLAG)
{
	/*PRINT_FUNC_LF();*/
	bool_cancel_cddb = FLAG;
}

gboolean cddb_get_bool_cancel_cddb (void)
{
	return (bool_cancel_cddb);
}

gboolean cddb_is_ok (gchar *name)
{
	FILE      *fp = NULL;
	gchar     *buf = NULL;
	size_t     size = 0;
	gboolean   RetFunc = TRUE;

	if (infosong_get_size_file (name) == 0) return (FALSE);;
	
	if ((fp = fopen (name, "r"))) {
		size_t dummy;
		
		size = infosong_get_size_file (name);
		if ((buf = (gchar *)g_malloc0 (sizeof (gchar) * (size + 10))) == NULL) {
			fclose (fp);
			return (FALSE);
		}
		
		dummy = fread (buf, 1, size, fp);
		fclose (fp);
		
		if (strstr (buf, "Not Found")) RetFunc = FALSE;
		g_free (buf);
		buf = NULL;
	}
	else {
		RetFunc = FALSE;
	}
	
	return (RetFunc);
}

gboolean cddb_test_access_web (void)
{
	static gboolean   bool_access_ok = FALSE;

	if (utils_scan_by_which ("wget", NULL) == FALSE) {
		g_print ("WGET absent !\n");
		return (bool_access_ok);
	}
	
	get_with_wget ();
	bool_access_ok = cddb_is_ok ("/tmp/index.html");
	infosong_delete_file ("/tmp/index.html");
	
	return (bool_access_ok);
}

void cddb_get_datas_on_disk (gchar *PathNameFile)
{
#define MAX_CARS_CDDB 255
	FILE	*fp = NULL;
	gchar	*Ptr = NULL;
	gchar	 buf   [ MAX_CARS_CDDB +10 ];

	CdToc->Bool_Connected = CONNECT_IS_FALSE;
	CdToc->BoolMultiArtiste = FALSE;
	
	// IF FILE EXIST and SIZE FILE > 0
	if (infosong_file_is_reg (PathNameFile) == TRUE &&
	    infosong_get_size_file (PathNameFile) > 0) {
	
		if ((fp = fopen (PathNameFile, "r")) != NULL) {
			while (fgets (buf, MAX_CARS_CDDB, fp) != NULL) {
				
				Ptr = buf;
				
				// DEL CARIAGE RETURN
				while (*Ptr) {
					if (*Ptr == '\n') {
						*Ptr = '\0';
						break;
					}
					Ptr ++;
				}
				
				// g_print("buf = %s\n", buf);
				if ((Ptr = strstr (buf, "DGENRE")) != NULL) {
					
					// DGENRE=Chanson
					
					if (*(Ptr+7) == '\0') {
						CdToc->StrGenre = g_strdup ("Vocal");
					} else {
						CdToc->StrGenre = g_strdup (Ptr +7);
					}
					CdToc->NumGenre = infosong_get_genre_by_value (CdToc->StrGenre);
				}
				else if ((Ptr = strstr (buf, "DYEAR")) != NULL) {
					
					// DYEAR=1999
					
					if (*(Ptr+6) == '\0') {
						CdToc->NumYear = 1962;
					} else {
						CdToc->NumYear = atoi (Ptr +6);
					}
					CdToc->StrYear = g_strdup_printf ("%d", CdToc->NumYear);
				}
				else if ((Ptr = strstr (buf, "DTITLE")) != NULL) {
					
					// DTITLE=Charles Trenet / Charles Trenet
					
					if (*(Ptr+7) == '\0') {
						CdToc->TitleCD = g_strdup ("Inconnu");
					} else {
						// CdToc->TitleCD = g_strdup (Ptr +7);
						// CdToc->TitleCD = utils_convert_string (Ptr +7, TRUE);
						CdToc->TitleCD = g_locale_to_utf8 (Ptr +7, -1, NULL, NULL, NULL);
						g_utf8_validate (CdToc->TitleCD, -1, NULL);
					}
				}
				else if ((Ptr = strstr (buf, "TTITLE")) != NULL) {
					
					// TTITLE0=La Mer
					// TTITLE0=Black Eyed Peas / Meet me halfway
					// TTITLE0=Je m'voyais déjà

					gint	track;
					
					if (strstr (buf, " / ")) CdToc->BoolMultiArtiste = TRUE;

					Ptr += 6;
					track = atoi(Ptr);
					Ptr = strchr (Ptr, '=');
					Ptr++;
					if (*Ptr == '\0') {
						CdToc->TimeTrack [ track ].TitleTrack = g_strdup_printf ("%d", track);
					} else {
						CdToc->TimeTrack [ track ].TitleTrack = g_strdup (Ptr);
					}
				}
			}
			fclose (fp);
			CdToc->Bool_Connected = CONNECT_IS_TRUE;
		}
	}
}

CD_TOC *cddb_get_datas_cddb (CD_TOC *CdToc)
{
	GList	*list = NULL;
	
	VarCddb.TmpRep = utils_create_temporary_rep (PATH_TMP_XCFA_ICEDAX);
	VarCddb.TmpActuel = g_get_current_dir ();
	g_chdir (VarCddb.TmpRep);
	
	conv.ArgConv = (ARGS_TO_EXEC *)g_malloc0(sizeof(ARGS_TO_EXEC) * 100);
	GDK_THREADS_ENTER();

	// icedax --cddb 1 -device /dev/hda --verbose-level title --info-only
	// --cddb 1
	// 	first fit mode. The first entry is taken unconditionally
	//	Example:
	//		#icedax version 1.1.9, real time sched., soundcard, libparanoia support
	//		3 entries found:
	//		00: misc 8309790a Janis Joplin / Collections
	//		01: rock 8309790a Janis Joplin / Super Hits
	//		02: classical 8309790a Janis Joplin / Super Hits
	//		03: ignore
	//		please choose one (0-3): 
	// -device /dev/hda
	// 	uses device as the source for CDDA reading
	// --verbose-level title
	// 	prints verbose information about the CD
	// --info-only
	// 	does not write to a file, it just gives information about the disc
	
	list = g_list_append (list, g_strdup ("icedax"));
	list = g_list_append (list, g_strdup ("--cddb"));
	list = g_list_append (list, g_strdup ("1"));
	list = g_list_append (list, g_strdup ("-device"));
	// list = g_list_append (list, g_strdup ("/dev/hda"));
	list = g_list_append (list, g_strdup_printf ("%s", scancd_get_text_combo_cd (_CD_)));
	list = g_list_append (list, g_strdup ("--verbose-level"));
	list = g_list_append (list, g_strdup ("title"));
	list = g_list_append (list, g_strdup ("--info-only"));
	
	/*
	http://at.freedb.org/~cddb
	http://ca.freedb.org/~cddb
	http://de.freedb.org/~cddb
	http://fi.freedb.org/~cddb
	http://fr.freedb.org/~cddb
	http://no.freedb.org/~cddb
	http://uk.freedb.org/~cddb
	http://us.freedb.org/~cddb
	if (*ptrlang == 'a' && *(ptrlang+1) == 't')      strcpy (begin, "http://at.freedb.org/~cddb");
	else if (*ptrlang == 'c' && *(ptrlang+1) == 'a') strcpy (begin, "http://ca.freedb.org/~cddb");
	else if (*ptrlang == 'd' && *(ptrlang+1) == 'e') strcpy (begin, "http://de.freedb.org/~cddb");
	else if (*ptrlang == 'f' && *(ptrlang+1) == 'i') strcpy (begin, "http://fi.freedb.org/~cddb");
	else if (*ptrlang == 'f' && *(ptrlang+1) == 'r') strcpy (begin, "http://fr.freedb.org/~cddb");
	else if (*ptrlang == 'n' && *(ptrlang+1) == 'o') strcpy (begin, "http://no.freedb.org/~cddb");
	else if (*ptrlang == 'u' && *(ptrlang+1) == 'k') strcpy (begin, "http://uk.freedb.org/~cddb");
	else if (*ptrlang == 'u' && *(ptrlang+1) == 's') strcpy (begin, "http://us.freedb.org/~cddb");
	else	
						 strcpy (begin, "http://fr.freedb.org/~cddb");
	
	cddbp-server=freedb.freedb.org/
	cddbp-server=at.freedb.org/
	cddbp-server=ca.freedb.org/
	cddbp-server=de.freedb.org/
	cddbp-server=fi.freedb.org/
	cddbp-server=fr.freedb.org/
	cddbp-server=no.freedb.org/
	cddbp-server=uk.freedb.org/
	cddbp-server=us.freedb.org/

	http://search.cpan.org/~rcaputo/CDDB-1.21/lib/CDDB.pm
	use CDDB;

	### Connect to the cddbp server.
	my $cddbp = new CDDB(
	Host  => 'freedb.freedb.org', # default
	Port  => 8880,                # default
	Login => $login_id,           # defaults to %ENV's
	) or die $!;

	*/
	list = g_list_append (list, g_strdup ("cddbp-server=freedb.freedb.org/"));
	list = g_list_append (list, g_strdup ("cddbp-port=8880"));
	// TODO: ICEDAX => ADD Command line --Recover_noprintable
	
	GDK_THREADS_LEAVE();

	conv_exec (FALSE, ICEDAX, list, "ICEDAX");
	list = filelc_remove_glist (list);
	g_free (conv.ArgConv);
	conv.ArgConv = NULL;
	
	if (infosong_file_is_reg ("audio.cddb") == TRUE) {
		system ("iconv -f iso-8859-1 -t utf-8 ./audio.cddb  -o ./audio.t");
		// TRAITEMENT FICHIER: VarCddb.PathNameCdIndex (audio.cddb)
		VarCddb.PathNameCdIndex = g_strdup_printf ("%s/audio.t", VarCddb.TmpRep);
		cddb_get_datas_on_disk (VarCddb.PathNameCdIndex);
	}
	
	if (CdToc->TitleCD == NULL)	CdToc->TitleCD = g_strdup ("");
		
	g_chdir (VarCddb.TmpActuel);
	g_free (VarCddb.TmpActuel);
	VarCddb.TmpActuel = NULL;
	VarCddb.TmpRep = utils_remove_temporary_rep (VarCddb.TmpRep);
	
	if (VarCddb.PathNameCdIndex != NULL) {
		g_free (VarCddb.PathNameCdIndex);
		VarCddb.PathNameCdIndex = NULL;
	}
	
	return (CdToc);
}
/*

	// Create tmp rep
	if (!conv.TmpRep)  {
		// #define PATH_TMP_XCFA_AUDIOCD "xcfa_cdaudio"
		// #define PATH_TMP_XCFA_ICEDAX "XcfaIcedax"
		conv.TmpRep  = utils_create_temporary_rep (PATH_TMP_XCFA_ICEDAX);
	}
	// Delete tmp rep
	if (conv.TmpRep)   {
		conv.TmpRep  = utils_remove_temporary_rep (conv.TmpRep);
	}
	VarCdExtract.PtrDirActuel = g_get_current_dir ();
	g_chdir (conv.TmpRep);
	
	OldRep = GET OLD REP
	CHANGE REP TO: /tmp/XcfaIcedax
	ADJUST [ -device ]
	
	icedax --cddb 0 -device /dev/hda --verbose-level title --info-only
	--cddb 0
		interactive mode. The user selects the entry to use
	-device /dev/hda
		uses device as the source for CDDA reading
	--verbose-level title
		prints verbose information about the CD
	--info-only
		does not write to a file, it just gives information about the disc
	
	READ OF: audio.cddb
	CHANGE REP TO: OldRep
*/














