#! /bin/bash

# The following script was originally written by Edwin Taylor to 
# convert a list of filenames (with their paths) into the format
# required for X-CD-Roast to import them into its "Session view"
# panel.

# The script merely prompts the user for the name of the file in
# which the list is written, then for a filename for the desired
# output.

while [ "$VALID" != "yes" ]
do
clear
echo
echo -e "    \033[1mEnter filename (including path) of existing list of files:\033[0m"
echo
echo -n "    "
read FILENAME
   if [[ -f "$FILENAME" && -r "$FILENAME" ]]
   then # File is a real file and is readable.
   VALID="yes"
   else
   echo
   echo -n "    File not found or not readable."
   read NOTHING
   fi
done
VALID="no"

while [ "$VALID" != "yes" ]
do
clear
echo
echo -e "    \033[1mEnter filename (including path) for output file.  \033[0mIt is"
echo "    recommended that the file end with the extension '.lst':"
echo
echo -n "    "
read FILENAME2

PATHFOR=`echo "$FILENAME2" | sed 's/[^\/]*$//'`
if [[ -d "$PATHFOR" && -w "$PATHFOR" ]]
then # The directory is a real directory and is writeable.

  if [ -e "$FILENAME2" ]
  then # Directory is valid, but intended filename is already in use.
  echo
  echo -n -e "    \033[1mFile already exists.  Do you wish to overwrite it?\033[0m"
  echo
  echo -n -e "    \033[1m1\033[0m"
  echo " Yes"
  echo -n -e "    \033[1m2\033[0m"
  echo " No"
  echo
  echo -n "    "
  read ANSWER
  case $ANSWER
  	in
		1)
			VALID="yes"
		;;
		*)	
			VALID="no"
  esac
  else
  VALID="yes"
  fi

else echo -n "    Directory not found or not writeable."
read NOTHING
fi

done
VALID="no"


# These steps have given us the location of the input file ($FILENAME)
# and the location for the output file ($FILENAME2).

echo "#" > "$FILENAME2"
echo "# Roast-dinner.sh version 0.1 - Master-Paths" >> "$FILENAME2"
DAT=`date`
echo "# created: $DAT" >> "$FILENAME2"
PERS=`whoami`@`hostname`
echo "# by: $PERS" >> "$FILENAME2"
echo "#" >> "$FILENAME2"

LINES=`cat "$FILENAME" | wc -l | sed 's/ *//'`

for i in `seq $LINES`
do
clear
echo
echo "   $i of $LINES lines processed."
PLACE=`cat "$FILENAME" | sed -n "$i"p`
echo "ADD2 = \"$PLACE\",\"$PLACE\"" >> "$FILENAME2"
done
