/******************************************************************
 
        MUSCLE SmartCard Development ( http://www.musclecard.com )
            Title  : xcardPutKey.h
            Author : David Corcoran
            Date   : 10/05/01
	    License: Copyright (C) 2001 David Corcoran
	             <corcoran@linuxnet.com>
            Purpose: This provides functionality for the xcard
	             personalization tool for the musclecard.
 
********************************************************************/ 

#ifndef xcardPutKey_included
#define xcardPutKey_included

#include "xcardPutKeyData.h"

#ifdef MSC_TARGET_OSX
#include <PCSC/musclecard.h>
#else
#include <musclecard.h>
#endif

class xcardMain;

class xcardPutKey : public xcardPutKeyData
{
    Q_OBJECT

public:

    xcardPutKey(
		MSCLPTokenConnection pConn,
		xcardMain *mainWin,
		QWidget *parent = NULL,
		const char *name = NULL );

    virtual ~xcardPutKey();


    int XCInitializeKeyDialog(bool, bool, MSCLong32);

    MSCLPTokenConnection pConnect;
    xcardMain *mainWindow;
    QString importFile;
    MSCGenKeyParams pKeyParams;
    MSCLong32  choiceKeyNumber;
    MSCULong32 pubKeyNum;
    MSCULong32 prvKeyNum;
    int prvKeyIndex;
    bool isGenerate;
    bool isReGenerate;
    bool isFileOK;
    bool onFirstScreen;

    protected slots:

    virtual void XCKeyTypeChanged(const QString&);
    virtual void XCOKPutKeyClicked();
    virtual void XCCancelPutKeyClicked();
    virtual void XCKeySizeSelected(int);
};
#endif // xcardPutKey_included
