//////////////////////////////////////////////////////////////////////////////
// Name:        test.h
// Purpose:     Widget to display svg documents using svg library
// Author:      Alex Thuering
// Created:     2005/05/07
// RCS-ID:      $Id: svgui-test.h,v 1.6 2007/09/13 06:37:08 etisserant Exp $
// Copyright:   (c) Alex Thuering
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#ifndef SVGUI_TEST_H
#define SVGUI_TEST_H

#include <wx/wx.h>
#include <wxSVG/svgctrl.h>
#include <wxSVGXML/svgxml.h>
#include <wxSVG/SVGUIWindow.h>
#include <wxSVG/SVGUIButton.h>
#include <wxSVG/SVGUITextCtrl.h>
#include <wxSVG/SVGUIScrollBar.h>

class SVGViewApp: public wxApp
{
  public:
    bool OnInit();
};

class MySVGCanvas: public SVGUIWindow
{
public:
    MySVGCanvas(wxWindow* parent);
    void OnMouseLeftDown(wxMouseEvent& event);
    void OnMouseLeftUp(wxMouseEvent& event);
	void InitScrollBar(unsigned int position, unsigned int thumb, unsigned int range);
    void OnBouton1LeftDown(wxCommandEvent& event);
	void OnBouton2LeftDown(wxCommandEvent& event);
	void OnScrollBarChanged(wxScrollEvent& event);

private:

    DECLARE_EVENT_TABLE()
};

class MainFrame: public wxFrame
{
  public:
    MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
      const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);

  protected:
    MySVGCanvas* m_svgCtrl;
    void OnOpen(wxCommandEvent& event);
    void OnExit(wxCommandEvent& event);
    void Fit(wxCommandEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif //SVGUI_TEST_H
