#!/usr/bin/python
# -*- coding: iso-8859-15 -*-
import os, sys, platform, time, traceback

#from defclass import *
from DEFControler import *
from minixsv import pyxsval
from wxPython.wx import *
from wxPython.grid import *
#from Mysvgctrl import *
#from FBD_Objects import *
import wx.wxsvg
import wx
import locale

__version__ = "$Revision: 1.2 $"
HANDLE_SIZE = 6


wxSVG_COORDINATES_USER,wxSVG_COORDINATES_VIEWPORT,wxSVG_COORDINATES_SCREEN = range(3)



class VariableTable(wxPyGridTableBase):
    
    """
    A custom wxGrid Table using user supplied data
    """
    def __init__(self, parent, data, colnames):
        # The base class must be initialized *first*
        wxPyGridTableBase.__init__(self)
        self.data = data
        self.colnames = colnames
        self.Parent = parent
        # XXX
        # we need to store the row length and collength to
        # see if the table has changed size
        self._rows = self.GetNumberRows()
        self._cols = self.GetNumberCols()
    
    def GetNumberCols(self):
        return len(self.colnames)
        
    def GetNumberRows(self):
        return len(self.data)

    def GetColLabelValue(self, col):
        if col < len(self.colnames):
            return self.colnames[col]

    def GetRowLabelValues(self, row):
        return row

    def GetValue(self, row, col):
        if row < self.GetNumberRows():
            name = str(self.data[row].get(self.GetColLabelValue(col), ""))
            return name
    
    def GetValueByName(self, row, colname):
        return self.data[row].get(colname)

    def SetValue(self, row, col, value):
        if col < len(self.colnames):
            self.data[row][self.GetColLabelValue(col)] = value
        
    def ResetView(self, grid):
        """
        (wxGrid) -> Reset the grid view.   Call this to
        update the grid if rows and columns have been added or deleted
        """
        grid.BeginBatch()
        for current, new, delmsg, addmsg in [
            (self._rows, self.GetNumberRows(), wxGRIDTABLE_NOTIFY_ROWS_DELETED, wxGRIDTABLE_NOTIFY_ROWS_APPENDED),
            (self._cols, self.GetNumberCols(), wxGRIDTABLE_NOTIFY_COLS_DELETED, wxGRIDTABLE_NOTIFY_COLS_APPENDED),
        ]:
            if new < current:
                msg = wxGridTableMessage(self,delmsg,new,current-new)
                grid.ProcessTableMessage(msg)
            elif new > current:
                msg = wxGridTableMessage(self,addmsg,new-current)
                grid.ProcessTableMessage(msg)
                self.UpdateValues(grid)
        grid.EndBatch()

        self._rows = self.GetNumberRows()
        self._cols = self.GetNumberCols()
        # update the column rendering scheme
        self._updateColAttrs(grid)

        # update the scrollbars and the displayed part of the grid
        grid.AdjustScrollbars()
        grid.ForceRefresh()

    def UpdateValues(self, grid):
        """Update all displayed values"""
        # This sends an event to the grid table to update all of the values
        msg = wxGridTableMessage(self, wxGRIDTABLE_REQUEST_VIEW_GET_VALUES)
        grid.ProcessTableMessage(msg)

    def _updateColAttrs(self, grid):
        """
        wxGrid -> update the column attributes to add the
        appropriate renderer given the column name.

        Otherwise default to the default renderer.
        """
        
        grid.SetColSize(0, 120)
        grid.SetColSize(1, 100)
        
        typelist = None
        accesslist = None
        for row in range(self.GetNumberRows()):
            for col in range(self.GetNumberCols()):
                editor = None
                renderer = None
                colname = self.GetColLabelValue(col)
                grid.SetReadOnly(row, col, False)
                if colname in ["Name","Initial Value","Location"]:
                    editor = wxGridCellTextEditor()
                    renderer = wxGridCellStringRenderer()    
                elif colname == "Class":
                    if len(self.Parent.ClassList) == 1:
                        grid.SetReadOnly(row, col, True)
                    else:
                        editor = wxGridCellChoiceEditor()    
                        editor.SetParameters(",".join(self.Parent.ClassList))
                elif colname == "Type":
                    editor = wxGridCellChoiceEditor()
                    editor.SetParameters(self.Parent.TypeList)
                elif colname in ["Retain", "Constant"]:
                    editor = wxGridCellChoiceEditor()
                    editor.SetParameters(self.Parent.OptionList)
                    
                grid.SetCellEditor(row, col, editor)
                grid.SetCellRenderer(row, col, renderer)
                
                grid.SetCellBackgroundColour(row, col, wxWHITE)
    
    def SetData(self, data):
        self.data = data
    
    def GetData(self):
        return self.data
    
    def GetCurrentIndex(self):
        return self.CurrentIndex
    
    def SetCurrentIndex(self, index):
        self.CurrentIndex = index
    
    def AppendRow(self, row_content):
        self.data.append(row_content)

    def RemoveRow(self, row_index):
        self.data.pop(row_index)

    def GetRow(self, row_index):
        return self.data[row_index]

    def Empty(self):
        self.data = []
        self.editors = []



class EditorFrame(wx.Frame):
    def __init__(self, controller, solo_mode=True):
        wx.Frame.__init__(self, None,-1, title = "DefEditor", size = (800, 650))
        
        wx.ID_GENERATE = wx.NewId()
        
        self.splitterWindow1 = wx.SplitterWindow(
              name='splitterWindow1', parent=self, point=wx.Point(0, 0),
              size=wx.Size(-1, -1), style=wx.SP_3D)
        
        self.splitterWindow1.SetNeedUpdating(True)
        self.splitterWindow1.SetMinimumPaneSize(1)
        

        
        self.EditorPanel = wx.Panel(
              name='Panel', parent=self.splitterWindow1, pos=wx.Point(0, 0),
              size=wx.Size(-1, -1), style=wx.TAB_TRAVERSAL)
        self.ProjectTree = wx.TreeCtrl(
              name='treeCtrl1', parent=self.splitterWindow1, pos=wx.Point(0, 0),
              size=wx.Size(-1, -1),
              style=wx.TR_HAS_BUTTONS|wx.TR_EDIT_LABELS|wx.TR_SINGLE|wx.SUNKEN_BORDER)
        
        
        self.splitterWindow1.SplitVertically(self.ProjectTree, self.EditorPanel,
              200)
        
        #self.splitterWindow2 = wx.SplitterWindow(
        #      name='splitterWindow2', parent=self, point=wx.Point(0, 0),
        #      size=wx.Size(-1, -1), style=wx.SP_3D)
        
        #self.splitterWindow2.SetNeedUpdating(True)
        #self.splitterWindow2.SetMinimumPaneSize(1)
        
        #self.TablePanel = wx.Panel(
        #      name='tablepanel', parent=self.splitterWindow2, pos=wx.Point(0, 0),
        #      size=wx.Size(-1, -1), style=wx.TAB_TRAVERSAL)
        
        
        #self.splitterWindow2.SplitHorizontally(self.ProjectTree, self.TablePanel,
        #      200)
        
        
        #self.mySVGctrl = mysvgctrl(self.EditorPanel,size=wx.Size(450,350))
        self.mySVGctrl = wx.wxsvg.SVGUIWindow(self.EditorPanel,size=wx.Size(450,350))
        
       
        #self.mySVGctrl.SetFitToFrame(False)
        self.mySVGroot = None
        self.mySVGctrl.Bind(wx.EVT_LEFT_DOWN, self.OnSvgClick)
        
        #self.mySVGUIWindow = wx.wxsvg.SVGUIWindow(self.EditorPanel,size=wx.Size(450,350))
        
        self.Bind(wx.EVT_TREE_SEL_CHANGED, self.OnProjectTreeItemSelected)
        self.Bind(wx.EVT_TREE_BEGIN_DRAG, self.OnProjectTreeBeginDrag)
        self.Bind(wx.EVT_TREE_END_DRAG, self.OnProjectTreeEndDrag)
        self.Bind(wx.EVT_TREE_BEGIN_LABEL_EDIT, self.OnProjectTreeItemBeginEdit)

        self.VariablesGrid = wx.grid.Grid(
                  name='VariablesGrid', parent=self.EditorPanel, pos=wx.Point(0, 355),
                  size=wx.Size(250, 240), style=wxVSCROLL)
        self.VariablesGrid.CreateGrid(numRows=1,numCols=2)
        self.VariablesGrid.SetRowLabelSize(0)
        self.VariablesGrid.SetFont(wx.Font(12, 77, wx.NORMAL, wx.NORMAL, False,'Sans'))
        self.VariablesGrid.SetLabelFont(wx.Font(10, 77, wx.NORMAL, wx.NORMAL,False, 'Sans'))
        self.VariablesGrid.Bind(wx.grid.EVT_GRID_CELL_CHANGE, self.OnVariablesGridCellChange)
        self.VariablesGrid.Bind(wx.grid.EVT_GRID_CELL_LEFT_CLICK,self.OnVariablesGridCellSelect)
        self.Table = VariableTable(self, [], ["attribute","value"])
        self.VariablesGrid.SetTable(self.Table)
               
        if solo_mode:
            self.FileMenu = wx.Menu()
            self.FileMenu.Append(wx.ID_NEW,"&New\tCTRL+n","Create a new DEF File")
            self.FileMenu.Append(wx.ID_OPEN,"&Open\tCTRL+o","Open a DEF File")
            self.FileMenu.Append(wx.ID_CLOSE,"&Close\tCTRL+f","Close this DEF File")
            self.FileMenu.Append(wx.ID_SAVE,"&Save\tCTRL+s","Save this DEF File")
            self.FileMenu.Append(wx.ID_SAVEAS,"&Save As\tCTRL+SHIFT+s","Save this DEF File with a new name ")
            self.FileMenu.AppendSeparator()
            self.FileMenu.Append(wx.ID_GENERATE,"&Generate Program","Generate Program")
            self.FileMenu.AppendSeparator()
            self.FileMenu.Append(wx.ID_EXIT,"&Exit\tCTRL+q","Exit Program")
        else:
            self.FileMenu = None
            
        
        self.EditMenu = wx.Menu()
        self.EditMenu.Append(wx.ID_ADD,"&Add Element","Add an element")
        self.EditMenu.Append(wx.ID_DELETE,"&Delete Element","Delete Selected element")
        self.EditMenu.Append(wx.ID_CUT,"&Cut Element\tCTRL+x","Cut Selected element")        
        self.EditMenu.Append(wx.ID_PASTE,"&Paste Element\tCTRL+v","Paste Cut Element") 
        
        menuBarre = wx.MenuBar()
        if self.FileMenu:
            menuBarre.Append(self.FileMenu, "&File")
        menuBarre.Append(self.EditMenu, "&Edit")
        self.SetMenuBar(menuBarre)
        
        self.StatusBar = wx.StatusBar( name='HelpBar',
              parent=self, style=wxST_SIZEGRIP)
        self.SetStatusBar(self.StatusBar)
        
        wx.EVT_MENU(self, wx.ID_EXIT, self.OnExit)
        wx.EVT_MENU(self, wx.ID_OPEN, self.OnOpen)
        wx.EVT_MENU(self, wx.ID_NEW, self.OnNew)
        wx.EVT_MENU(self, wx.ID_CLOSE, self.OnClose)
        wx.EVT_MENU(self, wx.ID_SAVEAS, self.OnSaveAs)
        wx.EVT_MENU(self, wx.ID_SAVE, self.OnSave)
        wx.EVT_MENU(self, wx.ID_GENERATE, self.OnGenerate)
        
        wx.EVT_MENU(self, wx.ID_ADD, self.OnAdd)
        wx.EVT_MENU(self, wx.ID_DELETE, self.OnDelete)
        wx.EVT_MENU(self, wx.ID_CUT, self.OnCut)
        wx.EVT_MENU(self, wx.ID_PASTE, self.OnPaste)
        wx.EVT_PAINT(self.mySVGctrl, self.OnPaintSVGctrl)
                
        locale.setlocale(locale.LC_ALL, 'C')
        
        self.Controler = controller
        self.message = False
        self.completeGrid = True
        self.selectedCell = False
        self.Selected = None
        self.rotatings = None
        
        self.SVG = False
        
        self._init_sizers()
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        
        
        
        
    def _init_coll_MainGridSizer_Items(self, parent):
        # generated method, don't edit
        parent.AddWindow(self.splitterWindow1, 0, border=0, flag=wxGROW)

    def _init_coll_MainGridSizer_Growables(self, parent):
        # generated method, don't edit
        parent.AddGrowableCol(0)
        parent.AddGrowableRow(0)

    def _init_coll_EditorGridSizer_Growables(self, parent):
        # generated method, don't edit
        parent.AddGrowableCol(0)
        parent.AddGrowableRow(0)

    def _init_sizers(self):
        # generated method, don't edit
        self.MainGridSizer = wx.FlexGridSizer(cols=1, hgap=0, rows=1, vgap=0)

        self.EditorGridSizer = wx.FlexGridSizer(cols=1, hgap=0, rows=1, vgap=0)

        self._init_coll_MainGridSizer_Growables(self.MainGridSizer)
        self._init_coll_MainGridSizer_Items(self.MainGridSizer)
        self._init_coll_EditorGridSizer_Growables(self.EditorGridSizer)
        
        self.SetSizer(self.MainGridSizer)
        self.EditorPanel.SetSizer(self.EditorGridSizer)
        
    def InitScrollbars(self):
        scrollbars = self.Controler.GetScrollBarsList(self.Controler.GetRootObj())
        for scroll in scrollbars:
            elemUI = self.mySVGctrl.GetScrollBarById(str(scroll))
            if elemUI:
                elemUI.Init_ScrollBar(0,1,10)
        
        
    
    def SetSelected(self, selected):
        self.Selected = selected
    
    def OnPaintSVGctrl(self,event):
        wx.CallAfter(self.DrawBoundingBox)
        event.Skip()
    
    def OnNewFile(self):
        self.Controler.SelectThisObj(self.Controler.GetRootObj(),None)
        self.RefreshGrid()
        self.selected_pt_item = self.ProjectTree.GetRootItem()
        self.completeGrid = True
        self.selectedCell = False
        self.RefreshFileMenu()
        self.RefreshEditMenu()
                       
    def OnProjectTreeItemSelected(self, event):
        self.selectedCell = False
        if self.completeGrid :
            selected = event.GetItem()
            self.selected_pt_item = selected
            selected_name = self.ProjectTree.GetItemText(selected)
            selected_parent = self.ProjectTree.GetItemParent(selected)
            selected_parent_name = self.ProjectTree.GetItemText(selected_parent)
            self.Controler.SelectByName(selected_name,selected_parent_name)
            self.RefreshGrid()
            self.InitGridCursor()
            self.RefreshEditMenu()
            #self.SetSelected(None)
            #self.mySVGctrl.Refresh()
        else:
            if self.message == False:
                self.message = True
                self.ProjectTree.SelectItem(self.new_pt_item)
                self.message = False                
                message = wxMessageDialog(self, "You have to complete theses required cells :\n%s"%self.attrToComplete, "Error", wxOK|wxICON_ERROR)
                message.ShowModal()
                message.Destroy()
                
                
                    
    def OnProjectTreeBeginDrag(self,event):
        if self.completeGrid :
            item = event.GetItem()
            drag_name = self.ProjectTree.GetItemText(item)
            drag_parent_item = self.ProjectTree.GetItemParent(item)
            drag_parent_name = self.ProjectTree.GetItemText(drag_parent_item)
            objs = self.Controler.GetRootObj()
            self.drag_parent_obj = self.Controler.LookForObj(objs,drag_parent_name)
            self.drag_obj = self.Controler.LookForObj(objs,drag_name)
            event.Allow()
        else:
            event.Skip()
        
    def OnProjectTreeEndDrag(self,event):
        item = event.GetItem()
        drop_name = self.ProjectTree.GetItemText(item)
        objs = self.Controler.GetRootObj()
        drop_obj = self.Controler.LookForObj(objs,drop_name)
        if drop_obj != self.drag_obj and drop_obj != None and self.drag_obj != self.Controler.GetRootObj():
            self.ProjectTree.GetRootItem()
            #self.ProjectTree.CollapseAndReset(item)
            self.ProjectTree.CollapseAndReset(self.ProjectTree.GetRootItem())
            drop_is_ctn = self.Controler.DragDropElement(self.drag_obj,self.drag_parent_obj,drop_obj)
            if not drop_is_ctn:
                message = wxMessageDialog(self, "You can only drop this element in a Parent Container", "Error", wxOK|wxICON_ERROR)
                message.ShowModal()
                message.Destroy()
            self.RefreshProjectTree()
        event.Skip()
        
    def OnProjectTreeItemBeginEdit(self, event):
        event.Veto()

    def OnSvgClick(self,event):
        if (self.selectedCell and self.Controler.SvgFile):
            scale = self.mySVGctrl.GetScale()
            rect = wx.wxsvg.SVGRect(event.m_x*scale,event.m_y*scale, 1, 1)            
            list = self.GetIntersectionList(self.mySVGroot,rect)
            if len(list) != 0:
                dialog = SvgDialog(self,list)
                if dialog.ShowModal() == wxID_OK:
                    value = dialog.GetValue()
                    self.Controler.SetAttrValue(self.selectedAttr,value,"")
                    self.RefreshGrid()
                    self.LookForRequiredCells()
                    self.RefreshFileMenu()
                    self.RefreshEditMenu()
                    self.RefreshProjectTree()
                    self.SetSelected(self.Controler.SvgFile.GetElementById(value))
                    self.mySVGctrl.Refresh()
                    self.DrawBoundingBox()
                dialog.Destroy()
                self.StatusBar.SetStatusText("")
        event.Skip()
 
    def DrawBoundingBox(self):
        if self.Selected:
            bbox = self.Selected.GetElementBBox(self.Selected)
            self.dc = wx.ClientDC(self.mySVGctrl)
            self.dc.SetPen(wx.BLACK_PEN)
            self.dc.SetBrush(wx.BLACK_BRUSH)
            scale = 1/self.mySVGctrl.GetScale()
            x1, y1, x2, y2 = bbox.GetX(), bbox.GetY(), bbox.GetX()+bbox.GetWidth(), bbox.GetY()+bbox.GetHeight()
            root_bbox = self.Selected.GetElementBBox(self.mySVGroot)
            rootX = self.mySVGroot.GetX().GetBaseVal().GetValue()
            rootY = self.mySVGroot.GetY().GetBaseVal().GetValue()
            rootXMax = rootX + self.mySVGroot.GetWidth().GetBaseVal().GetValue()
            rootYMax = rootY + self.mySVGroot.GetHeight().GetBaseVal().GetValue()
            #print rootX, rootY, rootXMax, rootYMax
            #print x1, y1, x2, y2
            if x1 >= rootX and y1 >= rootY and x2 <= rootXMax and y2 <= rootYMax:
                x1, y1, x2, y2 = x1*scale, y1*scale, x2*scale, y2*scale
                width, height = bbox.GetWidth()*scale, bbox.GetHeight()*scale
                self.dc.DrawRectangle(x1 - HANDLE_SIZE - 2, y1 - HANDLE_SIZE - 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.DrawRectangle(x1 + (width - HANDLE_SIZE) / 2, y1 - HANDLE_SIZE - 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.DrawRectangle(x2 + 2, y1 - HANDLE_SIZE - 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.DrawRectangle(x2 + 2, y1 + (height - HANDLE_SIZE) / 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.DrawRectangle(x2 + 2, y2 + 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.DrawRectangle(x1 + (width - HANDLE_SIZE) / 2, y2 + 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.DrawRectangle(x1 - HANDLE_SIZE - 2, y2 + 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.DrawRectangle(x1 - HANDLE_SIZE - 2, y1 + (height - HANDLE_SIZE) / 2, HANDLE_SIZE, HANDLE_SIZE)
                self.dc.SetBrush(wx.WHITE_BRUSH)
            
    def GetIntersectionList(self,_root,_rect):
        nodelist = _root.GetIntersectionList(_rect,_root)
        nodelistcls = wx.wxsvg.NodeListCls(nodelist)
        interTab = []
        i=0
        while i < nodelistcls.GetSize() :
          interTab.append(nodelistcls.GetElement(i))
          i = i+1
        return interTab
        
    def RefreshGrid(self):
        self.Table.Empty()
        self.attrs = self.Controler.GetGridInfos(self.VariablesGrid,self.Table)
        if self.Controler.HasObjSelected() and self.attrs:
            for attr in self.attrs:
                self.Table.AppendRow(attr)
        else : 
            self.Table.Empty()
            self.VariablesGrid.ClearGrid()
            
        self.Table.ResetView(self.VariablesGrid)
        if self.attrs:
            types_attr = self.Controler.getCellType()
            self.SetGridCellType(types_attr)
    
    def InitGridCursor(self):
        self.VariablesGrid.SetGridCursor(0,0)
        
        
    def SetGridCellType(self, types_attr):
        numrow = 0
        for attr in types_attr:
            self.VariablesGrid.SetReadOnly(numrow,0)
            if attr["type"] == "float":
                editor = wxGridCellFloatEditor()
                self.VariablesGrid.SetCellEditor(numrow, 1, editor)
                self.VariablesGrid.SetCellAlignment(numrow,1,wxALIGN_RIGHT,wxALIGN_CENTER)
            elif attr["type"] == "int":
                editor = wxGridCellNumberEditor()
                self.VariablesGrid.SetCellEditor(numrow, 1, editor)
                self.VariablesGrid.SetCellAlignment(numrow,1,wxALIGN_RIGHT,wxALIGN_CENTER)
            elif attr["type"] == "text":
                editor = wxGridCellTextEditor()
                self.VariablesGrid.SetCellEditor(numrow, 1, editor)
                self.VariablesGrid.SetCellAlignment(numrow,1,wxALIGN_LEFT,wxALIGN_CENTER)
            elif attr["type"] == "choice":
                editor = wxGridCellChoiceEditor()
                editor.SetParameters(attr["value"])
                self.VariablesGrid.SetCellEditor(numrow, 1, editor)
                self.VariablesGrid.SetCellAlignment(numrow,1,wxALIGN_LEFT,wxALIGN_CENTER)
            numrow +=1
                
                
        
    def OnVariablesGridCellChange(self, event):
        row, col = event.GetRow(), event.GetCol()
        colname = self.Table.GetColLabelValue(col)
        value = self.Table.GetValue(row, col)
        attr = self.Table.GetValue(row,0)
        
        if attr == "name":
            if self.Controler.IsExistingName(value):
                message = wxMessageDialog(self, "This name is already used : %s!"%value, "Error", wxOK|wxICON_ERROR)
                message.ShowModal()
                message.Destroy()
                self.RefreshGrid()
        
        require_value = self.attrs[row]["require"]
        correct_value = self.Controler.SetAttrValue(attr,value,require_value)
        if not correct_value :
            message = wxMessageDialog(self, "This value is required : %s!"%attr, "Error", wxOK|wxICON_ERROR)
            message.ShowModal()
            message.Destroy()
            self.RefreshGrid()
            
        self.LookForRequiredCells()
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        self.RefreshProjectTree()
        if self.Controler.SvgFile:
            mySVGelement = self.Controler.SvgFile.GetElementById(value)
            if mySVGelement:
                self.SetSelected(mySVGelement)
            else:
                self.SetSelected(None)
            self.mySVGctrl.Refresh()
            self.DrawBoundingBox()
        
    def OnVariablesGridCellSelect(self,event):
        row, col = event.GetRow(), event.GetCol()
        colname = self.Table.GetColLabelValue(col)
        value = self.Table.GetValue(row, col)
        attr = self.Table.GetValue(row,0)
        if self.Controler.SvgFile:
            if value != "":
                mySVGelement = self.Controler.SvgFile.GetElementById(value)
                if mySVGelement:
                    self.SetSelected(mySVGelement)
                else:
                    self.SetSelected(None)
            else:
                self.SetSelected(None)
            self.mySVGctrl.Refresh()
            self.DrawBoundingBox()
        if col == 1 and self.Controler.getCellType()[row]["type"]== "text":
            if self.SVG == True:
                self.StatusBar.SetStatusText("Pick up an element in the SVG View to set the value")
            self.selectedCell = True
            self.selectedAttr = attr
        else:
            self.selectedCell = False
            self.StatusBar.SetStatusText("")
        event.Skip()
        
    def LookForRequiredCells(self):
        numrow = 0
        self.completeGrid = True
        self.attrToComplete = ""
        while numrow < self.Table.GetNumberRows():
            if self.attrs[numrow]["require"] and self.attrs[numrow]["value"] == "":
                if self.attrToComplete != "":
                    self.attrToComplete += ","
                self.attrToComplete += self.attrs[numrow]["attribute"]
                self.completeGrid = False
            numrow += 1
            
        
    def RefreshProjectTree(self):
        #self.ProjectTree.DeleteAllItems()
        infos = self.Controler.GetRootInfos()
        if infos != None:
            root = self.ProjectTree.GetRootItem()
            self.GenerateTreeBranch(root, infos)
            self.ProjectTree.Expand(self.ProjectTree.GetRootItem())
        else :
             self.RefreshGrid()
    
    
    def GenerateTreeBranch(self, root, infos):
        to_delete = []
        info_name = self.Controler.GetElementName(infos)
        if root.IsOk():
            self.ProjectTree.SetItemText(root, info_name)
        else:
            root = self.ProjectTree.AddRoot(info_name)
        self.ProjectTree.SetPyData(root, infos["id"])
        item, root_cookie = self.ProjectTree.GetFirstChild(root)
        if infos["type"] == ITEM_CONTAINER:
            if len(infos["children"]) > 0:
                for child in infos["children"]:
                    if not item.IsOk():
                        item = self.ProjectTree.AppendItem(root, "")
                        item, root_cookie = self.ProjectTree.GetNextChild(root, root_cookie)
                    self.GenerateTreeBranch(item, child)
                    item, root_cookie = self.ProjectTree.GetNextChild(root, root_cookie)
        while item.IsOk():
            to_delete.append(item)
            item, root_cookie = self.ProjectTree.GetNextChild(item, root_cookie)
        if len(to_delete) > 0:
            self.ProjectTree.Delete(to_delete[0])
        #for item in to_delete:
        #    print "before delete"
        #    self.ProjectTree.Delete(item)
        #    print "after delete"
            
    def RefreshFileMenu(self):
        if self.FileMenu:
            if self.Controler.HasOpenedProject():
                self.FileMenu.FindItemByPosition(2).Enable(True)
                self.FileMenu.FindItemByPosition(3).Enable(True)
                self.FileMenu.FindItemByPosition(4).Enable(True)
                self.FileMenu.FindItemByPosition(6).Enable(True)
                if self.completeGrid == False:
                    self.FileMenu.FindItemByPosition(2).Enable(False)
                    self.FileMenu.FindItemByPosition(3).Enable(False)
                    self.FileMenu.FindItemByPosition(4).Enable(False)
                    self.FileMenu.FindItemByPosition(6).Enable(False)
            else:
                self.FileMenu.FindItemByPosition(2).Enable(False)
                self.FileMenu.FindItemByPosition(3).Enable(False)
                self.FileMenu.FindItemByPosition(4).Enable(False)
                self.FileMenu.FindItemByPosition(6).Enable(False)
                
                
    def RefreshEditMenu(self):
        if self.EditMenu:
            if self.Controler.HasOpenedProject() and self.Controler.HasContainerObjSelected():
                self.EditMenu.FindItemByPosition(0).Enable(True)
                self.EditMenu.FindItemByPosition(1).Enable(True)
                if self.Controler.GetSelectedObj() == self.Controler.GetRootObj():
                    self.EditMenu.FindItemByPosition(2).Enable(False)
                else:
                    self.EditMenu.FindItemByPosition(2).Enable(True)
                if self.Controler.GetCutObj() != None:
                    self.EditMenu.FindItemByPosition(3).Enable(True)
                else:
                    self.EditMenu.FindItemByPosition(3).Enable(False)
                if self.completeGrid == False:
                    self.EditMenu.FindItemByPosition(2).Enable(False)
                    self.EditMenu.FindItemByPosition(3).Enable(False)
            elif self.Controler.HasOpenedProject() and self.Controler.HasObjSelected():
                self.EditMenu.FindItemByPosition(0).Enable(False)
                self.EditMenu.FindItemByPosition(1).Enable(True)
                if self.completeGrid == False:
                    self.EditMenu.FindItemByPosition(2).Enable(False)
                else :
                    self.EditMenu.FindItemByPosition(2).Enable(True)
                self.EditMenu.FindItemByPosition(3).Enable(False)
            else:
                self.EditMenu.FindItemByPosition(0).Enable(False)
                self.EditMenu.FindItemByPosition(1).Enable(False)
                self.EditMenu.FindItemByPosition(2).Enable(False)
                self.EditMenu.FindItemByPosition(3).Enable(False)
    
    def SaveQuestion(self):
        message = wxMessageDialog(self, "Would you like to save your project ?  ", "Confirmation", wxYES_NO|wxCANCEL)
        print message.ShowModal()
        if message.ShowModal() == wxID_YES:
            self.SaveProject()
            self.CloseProject()
            message.Destroy()
        elif message.ShowModal() == wxID_NO:
            self.CloseProject()
            message.Destroy()
        else:
            message.Destroy()
        
    
    def OnOpen(self,event):
        filepath = self.Controler.GetFilePath()
        if filepath != "":
            directory = os.path.dirname(filepath)
        else:
            directory = os.getcwd()
        dialog = wxFileDialog(self, "Choose a file", directory, "",  "DEF files (*.def)|*.def|All files|*.*", wxOPEN)
        if dialog.ShowModal() == wxID_OK:
            if self.Controler.HasOpenedProject():
                self.CloseProject()
            filepath = dialog.GetPath()
            if os.path.isfile(filepath):
                self.Controler.OpenXMLFile(filepath)
                self.Controler.filepath = filepath
                self.RefreshProjectTree()
                if self.OpenSVGFile(filepath):
                    self.StatusBar.SetStatusText("DEF file succesfuly open with his SVG file")
                else:
                    self.ResetSVG()
                    self.StatusBar.SetStatusText("No SVG File found with your DEF File")
            self.RefreshGrid()
            #self.completeGrid = True
            self.RefreshFileMenu()
            self.RefreshEditMenu()
            self.OnNewFile()
            #self.RefreshToolBar()
        dialog.Destroy()
        event.Skip()
    
    
    def OpenSVGFile(self,filepath):
        svgfile = os.path.splitext(filepath)[0]+".svg"
        if os.path.isfile(svgfile):
            #self.mySVGctrl.Load(svgfile)
            self.mySVGctrl.LoadFiles(svgfile,filepath)
            self.mySVGctrl.RefreshScale()
            self.Controler.SvgFilepath = svgfile
            self.Controler.SvgFile = self.mySVGctrl.GetSVG()
            self.mySVGroot = self.Controler.SvgFile.GetRootElement()
            self.Controler.SVGUIRootElement = self.mySVGctrl.GetSVGUIRootElement()
            self.Controler.SvguiCtrl = self.mySVGctrl
            self.InitScrollbars()
            self.SVG = True
            return True
        self.ResetSVG()
        return False
    
    def ResetSVG(self):
        self.mySVGctrl.Clear()
        self.mySVGctrl.Refresh()
        self.mySVGctrl.SetRoot(None)
        self.Controler.SVGUIRootElement = None
        self.Controler.SvguiCtrl = None
        self.Controler.SvgFile = None
        self.mySVGroot = None
        self.SVG = False
        self.rotatings = None
            
    def OnClose(self,event):
        #self.SaveQuestion()
        self.CloseProject()
        event.Skip()
        
    def OnSave(self, event):
        self.SaveProject()
        event.Skip()
        
    def OnNew(self,event):
        if self.Controler.HasOpenedProject():
                self.CloseProject()
                
        self.Controler.CreateRootElement()
        self.RefreshProjectTree()
        self.OnNewFile()
        self.RefreshGrid()
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        event.Skip()
        
    def OnSaveAs(self, event):
        self.SaveProjectAs()
        event.Skip()
        
    def OnExit(self,evt):
        self.Destroy()
        
    def OnGenerate(self,event):
        self.SaveProject()
        if self.Controler.filepath != "":
            current_directory, filename = os.path.split(self.Controler.filepath)
            self.Controler.GenerateProgram(current_directory)
        event.Skip()
        
    def OnAdd(self,event):
        dialog = ElementDialog(self)
        dialog.SetElementName(self.Controler.GetElementsNames())
        if dialog.ShowModal() == wxID_OK:
            values = dialog.GetValues()
            self.Controler.AddElement(self.Controler.GetSelectedObj(),values["element"],values["name"])
            self.RefreshProjectTree()
            self.new_pt_item = self.ProjectTree.GetLastChild(self.selected_pt_item)
            self.ProjectTree.SelectItem(self.new_pt_item)
            self.LookForRequiredCells()
        dialog.Destroy()
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        event.Skip()
        
    def OnCut(self,event):
        self.Controler.CutSelectedElement()
        self.RefreshProjectTree()
        self.ProjectTree.SelectItem(self.ProjectTree.GetRootItem())
        self.RefreshGrid()
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        event.Skip()
        
    def OnPaste(self,event):
        self.Controler.PasteElement()
        self.ProjectTree.CollapseAndReset(self.ProjectTree.GetRootItem())
        self.RefreshProjectTree()
        self.ProjectTree.SelectItem(self.ProjectTree.GetRootItem())
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        event.Skip()
        
    def OnDelete(self,event):
        if self.Controler.HasSelectedRoot():
            message = wxMessageDialog(self, "You can't delete the root Container !", "Error", wxOK|wxICON_ERROR)
        elif self.Controler.SelectedHasChildren():
            message = wxMessageDialog(self, "If you delete this container, his children will be deleted too.\nContinue ?  ", "Confirmation", wxYES_NO)
        else :
            message = wxMessageDialog(self, "Are You sure you want to delete this element ?  ", "Confirmation", wxYES_NO)
        if message.ShowModal() == wxID_YES:
            self.Controler.DeleteSelectedElement()
            self.completeGrid = True
            message.Destroy()
        self.OnNewFile()
        self.RefreshProjectTree()
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        event.Skip()
        
    def SaveProjectAs(self):
        filepath = self.Controler.GetFilePath()
        directory, filename = os.path.split(filepath)
        dialog = wxFileDialog(self, "Choose a file", directory, filename,  "DEF files (*.def)|*.def|All files|*.*", wxSAVE|wxOVERWRITE_PROMPT)
        if dialog.ShowModal() == wxID_OK:
            filepath = dialog.GetPath()
            self.Controler.filepath = filepath
            if os.path.isdir(os.path.dirname(filepath)):
                result = self.Controler.SaveXMLFile(filepath)
                if not result:
                    message = wxMessageDialog(self, "Can't save project to file %s!"%filepath, "Error", wxOK|wxICON_ERROR)
                    message.ShowModal()
                    message.Destroy()
            else:
                message = wxMessageDialog(self, "%s is not a valid folder!"%os.path.dirname(filepath), "Error", wxOK|wxICON_ERROR)
                message.ShowModal()
                message.Destroy()
        dialog.Destroy()
        
    def SaveProject(self):
        result = self.Controler.SaveXMLFile()
        if not result:
            self.SaveProjectAs()
        if self.SVG:
            self.ResetSVG()
            self.OpenSVGFile(self.Controler.filepath)
            
    def CloseProject(self):
        self.completeGrid = True
        self.Controler.Reset()
        self.Table.Empty()
        self.ProjectTree.DeleteAllItems()
        self.Table.ResetView(self.VariablesGrid)
        self.RefreshFileMenu()
        self.RefreshEditMenu()
        self.ResetSVG()




class SvgDialog(wx.Dialog):
    def _init_coll_flexGridSizer1_Items(self, parent):
        # generated method, don't edit

        parent.AddWindow(self.MainPanel, 0, border=0, flag=0)

    def _init_sizers(self):
        # generated method, don't edit
        self.flexGridSizer1 = wx.FlexGridSizer(cols=1, hgap=0, rows=2, vgap=0)

        self._init_coll_flexGridSizer1_Items(self.flexGridSizer1)

        self.SetSizer(self.flexGridSizer1)

    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self,
              name='ProjectDialog', parent=prnt, pos=wx.Point(376, 223),
              size=wx.Size(300, 150), style=wx.DEFAULT_DIALOG_STYLE,
              title='Choose a SVG Element')
        self.SetClientSize(wx.Size(300, 150))

        self.MainPanel = wx.Panel(
              name='MainPanel', parent=self, pos=wx.Point(0, 0),
              size=wx.Size(300, 100), style=wx.TAB_TRAVERSAL)
        self.MainPanel.SetAutoLayout(True)

        self.staticText1 = wx.StaticText(
              label='Element:', name='staticText3', parent=self.MainPanel,
              pos=wx.Point(24, 28), size=wx.Size(95, 17), style=0)

        self.Element = wx.Choice(
              name='Element', parent=self.MainPanel, pos=wx.Point(104, 24),
              size=wx.Size(150, 24), style=0)

        self._init_sizers()

    def __init__(self, parent, svgelement):
        self._init_ctrls(parent)
        self.ButtonSizer = self.CreateButtonSizer(wxOK|wxCANCEL|wxCENTRE)
        self.flexGridSizer1.Add(self.ButtonSizer, 1, wxALIGN_CENTRE)
        
        for option in svgelement:
            self.Element.Append(option.GetAttribute("id"))

        EVT_BUTTON(self, self.ButtonSizer.GetAffirmativeButton().GetId(), self.OnOK)
        
    def OnOK(self,event):
        element = self.Element.GetStringSelection()
        error = False
        if element == "":
            message = wxMessageDialog(self, "You must choose an element !", "Error", wxOK|wxICON_ERROR)
            message.ShowModal()
            message.Destroy()
            error = True
        if not error:
            self.EndModal(wxID_OK)
            
    def GetValue(self):
        return self.Element.GetStringSelection()











class ElementDialog(wx.Dialog):
    def _init_coll_flexGridSizer1_Items(self, parent):
        # generated method, don't edit

        parent.AddWindow(self.MainPanel, 0, border=0, flag=0)

    def _init_sizers(self):
        # generated method, don't edit
        self.flexGridSizer1 = wx.FlexGridSizer(cols=1, hgap=0, rows=2, vgap=0)

        self._init_coll_flexGridSizer1_Items(self.flexGridSizer1)

        self.SetSizer(self.flexGridSizer1)

    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Dialog.__init__(self,
              name='ProjectDialog', parent=prnt, pos=wx.Point(376, 223),
              size=wx.Size(300, 150), style=wx.DEFAULT_DIALOG_STYLE,
              title='Add a new element')
        self.SetClientSize(wx.Size(300, 150))

        self.MainPanel = wx.Panel(
              name='MainPanel', parent=self, pos=wx.Point(0, 0),
              size=wx.Size(300, 100), style=wx.TAB_TRAVERSAL)
        self.MainPanel.SetAutoLayout(True)

        self.staticText1 = wx.StaticText(
              label='Element:', name='staticText3', parent=self.MainPanel,
              pos=wx.Point(24, 28), size=wx.Size(95, 17), style=0)

        self.Element = wx.Choice(
              name='Element', parent=self.MainPanel, pos=wx.Point(104, 24),
              size=wx.Size(150, 24), style=0)
        
        self.staticText2 = wx.StaticText(
              label='Name:', name='staticText2', parent=self.MainPanel,
              pos=wx.Point(24, 68), size=wx.Size(95, 17), style=0)

        self.Name = wx.TextCtrl(
              name='Name', parent=self.MainPanel, pos=wx.Point(104, 64), 
              size=wx.Size(150, 24), style=0)

        self._init_sizers()

    def __init__(self, parent):
        self._init_ctrls(parent)
        self.ButtonSizer = self.CreateButtonSizer(wxOK|wxCANCEL|wxCENTRE)
        self.flexGridSizer1.Add(self.ButtonSizer, 1, wxALIGN_CENTRE)
        
        for option in ["Container","Button","TextCtrl","ScrollBar","RotatingCtrl","NoteBook","Transform"]:
            self.Element.Append(option)

        EVT_BUTTON(self, self.ButtonSizer.GetAffirmativeButton().GetId(), self.OnOK)
        
    def OnOK(self,event):
        element = self.Element.GetStringSelection()
        name = self.Name.GetValue()
        error = False
        if element == "":
            message = wxMessageDialog(self, "You must choose an element !", "Error", wxOK|wxICON_ERROR)
            message.ShowModal()
            message.Destroy()
            error = True
            
        elif name == "":
            message = wxMessageDialog(self, "You must choose a name for this new element !", "Error", wxOK|wxICON_ERROR)
            message.ShowModal()
            message.Destroy()
            error = True
        elif name.upper() in self.elementName:
            message = wxMessageDialog(self, "This name is already in use !", "Error", wxOK|wxICON_ERROR)
            message.ShowModal()
            message.Destroy()
            error = True
        if not error:
            self.EndModal(wxID_OK)
        
    def GetValues(self):
        return { "element" : self.Element.GetStringSelection(),"name" : self.Name.GetValue()}
    
    def SetElementName(self,elementName):
        self.elementName = elementName

#-------------------------------------------------------------------------------
#                               Exception Handler
#-------------------------------------------------------------------------------

Max_Traceback_List_Size = 20

def Display_Exception_Dialog(e_type,e_value,e_tb):
    trcbck_lst = []
    for i,line in enumerate(traceback.extract_tb(e_tb)):
        trcbck = " " + str(i+1) + ". "
        if line[0].find(os.getcwd()) == -1:
            trcbck += "file : " + str(line[0]) + ",   "
        else:
            trcbck += "file : " + str(line[0][len(os.getcwd()):]) + ",   "
        trcbck += "line : " + str(line[1]) + ",   " + "function : " + str(line[2])
        trcbck_lst.append(trcbck)
        
    # Allow clicking....
    cap = wx.Window_GetCapture()
    if cap:
        cap.ReleaseMouse()

    dlg = wx.SingleChoiceDialog(None, 
        """
An error happens.

Click on OK for saving an error report.

Please contact LOLITech at:
+33 (0)3 29 52 95 67
bugs_DefEditor@lolitech.fr


Error:
""" +
        str(e_type) + " : " + str(e_value), 
        "Error",
        trcbck_lst)
    try:
        res = (dlg.ShowModal() == wx.ID_OK)
    finally:
        dlg.Destroy()

    return res

def Display_Error_Dialog(e_value):
    message = wxMessageDialog(None, str(e_value), "Error", wxOK|wxICON_ERROR)
    message.ShowModal()
    message.Destroy()

def get_last_traceback(tb):
    while tb.tb_next:
        tb = tb.tb_next
    return tb


def format_namespace(d, indent='    '):
    return '\n'.join(['%s%s: %s' % (indent, k, repr(v)[:10000]) for k, v in d.iteritems()])


ignored_exceptions = [] # a problem with a line in a module is only reported once per session

def wxAddExceptHook(path, app_version='[No version]'):#, ignored_exceptions=[]):
    
    def handle_exception(e_type, e_value, e_traceback):
        traceback.print_exception(e_type, e_value, e_traceback) # this is very helpful when there's an exception in the rest of this func
        last_tb = get_last_traceback(e_traceback)
        ex = (last_tb.tb_frame.f_code.co_filename, last_tb.tb_frame.f_lineno)
        if str(e_value).startswith("!!!"):
            Display_Error_Dialog(e_value)
        elif ex not in ignored_exceptions:
            result = Display_Exception_Dialog(e_type,e_value,e_traceback)
            if result:
                ignored_exceptions.append(ex)
                info = {
                    'app-title' : wx.GetApp().GetAppName(), # app_title
                    'app-version' : app_version,
                    'wx-version' : wx.VERSION_STRING,
                    'wx-platform' : wx.Platform,
                    'python-version' : platform.python_version(), #sys.version.split()[0],
                    'platform' : platform.platform(),
                    'e-type' : e_type,
                    'e-value' : e_value,
                    'date' : time.ctime(),
                    'cwd' : os.getcwd(),
                    }
                if e_traceback:
                    info['traceback'] = ''.join(traceback.format_tb(e_traceback)) + '%s: %s' % (e_type, e_value)
                    last_tb = get_last_traceback(e_traceback)
                    exception_locals = last_tb.tb_frame.f_locals # the locals at the level of the stack trace where the exception actually occurred
                    info['locals'] = format_namespace(exception_locals)
                    if 'self' in exception_locals:
                        info['self'] = format_namespace(exception_locals['self'].__dict__)
                
                output = open(path+os.sep+"bug_report_"+info['date'].replace(':','-').replace(' ','_')+".txt",'w')
                lst = info.keys()
                lst.sort()
                for a in lst:
                    output.write(a+":\n"+str(info[a])+"\n\n")

    #sys.excepthook = lambda *args: wx.CallAfter(handle_exception, *args)
    sys.excepthook = handle_exception
 
if __name__ == '__main__':
    app = wxPySimpleApp()
    wxInitAllImageHandlers()
    
    # Install a exception handle for bug reports
    wxAddExceptHook(os.getcwd(),__version__)
    
    frame = EditorFrame(DEFControler())

    frame.Show()
    app.MainLoop()

