#!/usr/bin/env python
# -*- coding: utf-8 -*-
#    https://launchpad.net/wxbanker
#    analyzertests.py: Copyright 2007-2009 Mike Rooney <mrooney@ubuntu.com>
#
#    This file is part of wxBanker.
#
#    wxBanker is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    wxBanker is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with wxBanker.  If not, see <http://www.gnu.org/licenses/>.

from wxbanker.tests import testbase
from wxbanker.analyzers import MonthlyAnalyzer
import unittest, datetime

class AnalyzerTests(testbase.TestCaseWithController):
    def setUp(self):
        testbase.TestCaseWithController.setUp(self)
        model = self.Controller.Model
        a = model.CreateAccount("A")
        for i in xrange(1, 13):
            a.AddTransaction(amount=i, date=datetime.date(2009, i, 15))
            
    def createMonthly(self, *args, **kwargs):
        monthly = MonthlyAnalyzer(*args, **kwargs)
        monthly.Today = datetime.date(2010, 1, 15)
        return monthly
            
    def testMonthlyDateRangeDefault(self):
        monthly = self.createMonthly()
        start, end = monthly.GetDateRange()
        self.assertEqual(start, datetime.date(2009, 1, 1))
        self.assertEqual(end, datetime.date(2009, 12, 31))
        
    def testMonthlyDateRangeOne(self):
        monthly = self.createMonthly(months=1)
        start, end = monthly.GetDateRange()
        self.assertEqual(start, datetime.date(2009, 12, 1))
        self.assertEqual(end, datetime.date(2009, 12, 31))
        
    def testMonthlyAmountsDefault(self):
        monthly = self.createMonthly()
        earnings = monthly.GetEarnings(self.Controller.Model.GetTransactions())
        self.assertEqual(earnings, range(1,13))
    
    def testMonthlyAmountsOne(self):
        monthly = self.createMonthly(months=1)
        earnings = monthly.GetEarnings(self.Controller.Model.GetTransactions())
        self.assertEqual(earnings, [12])
