// $Id: EntityOps.cpp,v 1.4 2003/02/08 13:14:51 mrq Exp $
#include "EntityOps.h"
#include "ETNew.h"
#include "ETEdit.h"
#include "ETMove.h"
#include "ETRotate.h"

template <class T>
class EntityOpImpl: public EntityOp
{
   public:
      EntityOpImpl(const std::string &name, const std::string &icon) :
	 EntityOp (name, icon)
      {}

      ~EntityOpImpl() {}

      EntityTool *Create() 
      {return new T(0);}
};

EntityOp::EntityOp (const std::string& name, const std::string& icon) :
   m_Name (name), 
   m_Icon(icon)
{
}


//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

EntityOpList::EntityOpList()
{
   push_back (new EntityOpImpl<ETNew> ("add", ""));
   push_back (new EntityOpImpl<ETDelete> ("delete", ""));
   push_back (new EntityOpImpl<ETEdit> ("edit", ""));
   push_back (new EntityOpImpl<ETMove> ("move", ""));
   push_back (new EntityOpImpl<ETRotate> ("rotate", ""));
}

EntityOpList::~EntityOpList()
{
   for (iterator i = begin(); i != end(); i++)
      delete (*i);
}
