// $Id: ETEdit.cpp,v 1.4 2002/12/27 20:57:40 mat Exp $

#include "ETEdit.h"

#include "Application.h"
#include <sstream>

ETEdit::ETEdit (World *world) : EntityTool (world), m_Entity (NULL)
{}

ETEdit::~ETEdit()
{
   if (m_Entity) m_Entity->Unref();
}

/// Apply tool at (x,z)
void
ETEdit::Apply3D(Ark::Vector3 newpos, const Ark::Collision &col)
{
   if (col.GetType() != Ark::Collision::ENTITY)
   {
      m_Entity = NULL;
      return;
   }

   m_Entity = static_cast<Entity*>(col.m_Entity);
   std::cout << m_Entity->ToString();
   g_Application->GetUI()->EditEntity (m_Entity);
}

/// Update or reset tool
void
ETEdit::Update()
{
   m_Entity = NULL;
}

/// Create a command with a correct state.
Command*
ETEdit::CreateCommand()
{
   if (m_Entity == NULL)
      return NULL;
   else
      return new ECEdit (g_Application->GetWorld(), m_Entity);
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

ECEdit::ECEdit(World *world, Entity *entity) : 
   m_World (world),
   m_Entity (entity)
{
   assert (m_Entity != 0);
   m_Entity->Ref();
}

ECEdit::~ECEdit()
{
   if (m_Entity)
      m_Entity->Unref();
}

/// Return the command type.
std::string
ECEdit::Type() const
{
   return "Edit entity";
}

/// Execute this command.
void
ECEdit::Execute()
{
}

/// Undo the action done by this command.
void
ECEdit::Unexecute()
{
}
