/* ownop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: ownop.cc,v 1.37 2005/10/19 18:03:30 ralf Exp $ */

#include "ownop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include "filereq.h"

const char *OwnOp::name="OwnOp";

OwnOp::OwnOp() : FunctionProto()
{
  separate_each_entry=false;
  recursive=false;
  inbackground = false;
  take_dirs = false;

  ownstart=OWNOP_START_NORMAL;

  com_str=dupstring("");
  view_str=dupstring("");
  hasConfigure = true;
  
  dontcd = false;
}

OwnOp::~OwnOp()
{
  _freesafe(com_str);
  _freesafe(view_str);
}

OwnOp*
OwnOp::duplicate() const
{
  OwnOp *ta=new OwnOp();
  ta->separate_each_entry=separate_each_entry;
  ta->recursive=recursive;
  ta->inbackground = inbackground;
  ta->take_dirs = take_dirs;
  ta->dontcd = dontcd;

  ta->ownstart=ownstart;

  _freesafe(ta->com_str);
  _freesafe(ta->view_str);
  ta->com_str=dupstring(com_str);
  ta->view_str=dupstring(view_str);
  return ta;
}

bool
OwnOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
OwnOp::getName()
{
  return name;
}

int
OwnOp::run( WPUContext *wpu, ActionMessage *msg )
{
  ListerMode *lm1;
  use_wpu = wpu;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      endlister = msg->getWorker()->getOtherLister(startlister);
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodeown( msg );
    }
  } else normalmodeown( msg );
  return 0;
}

bool
OwnOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;

  fh->configPutPairBool( "separateeachentry", separate_each_entry );
  fh->configPutPairBool( "recursive", recursive );
  switch ( ownstart ) {
    case OWNOP_START_IN_TERMINAL:
      fh->configPutPair( "start", "terminal" );
      break;
    case OWNOP_START_IN_TERMINAL_AND_WAIT4KEY:
      fh->configPutPair( "start", "terminalwait" );
      break;
    case OWNOP_SHOW_OUTPUT:
      fh->configPutPair( "start", "showoutput" );
      break;
    default:
      fh->configPutPair( "start", "normal" );
      break;
  }
  fh->configPutPairString( "com", com_str );
  fh->configPutPairString( "viewstr", view_str );
  
  fh->configPutPairBool( "inbackground", inbackground );
  fh->configPutPairBool( "takedirs", take_dirs );
  fh->configPutPairBool( "dontcd", dontcd );
  return true;
}

const char *
OwnOp::getDescription()
{
  return catalog.getLocaleCom(28);
}

int
OwnOp::normalmodeown( ActionMessage *am )
{
  class NM_externorder extorder;
  NormalMode *nm1=NULL,
             *nm2=NULL;
  ListerMode *lm1=NULL;
  NM_specialsourceExt *specialsource=NULL;
  
  if(am->mode==am->AM_MODE_DNDACTION) {
    lm1 = am->dndmsg->getSourceMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    lm1 = am->dndmsg->getDestMode();
    if(lm1!=NULL)
      if(lm1->isType("NormalMode")==true)
        nm2=(NormalMode*)lm1;
  } else {
    if(startlister==NULL) return 1;
    lm1=startlister->getActiveMode();
    if(lm1==NULL) return 1;
    if(lm1->isType("NormalMode")!=true) return 1;
    nm1=(NormalMode*)lm1;
    if(endlister!=NULL) {
      lm1=endlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          nm2=(NormalMode*)lm1;
    }
  }
  
  extorder.wpu = use_wpu;
  extorder.destmode=NULL;
  if(am->mode==am->AM_MODE_ONLYACTIVE)
    extorder.source=extorder.NM_ONLYACTIVE;
  else if(am->mode==am->AM_MODE_DNDACTION) {
    // insert DND-element into list
    extorder.source=extorder.NM_SPECIAL;
    extorder.sources=new std::list<NM_specialsourceExt*>;
    specialsource = new NM_specialsourceExt( am->dndmsg->getFE() );
    extorder.sources->push_back(specialsource);
    extorder.destmode=nm2;
  } else if(am->mode==am->AM_MODE_SPECIAL) {
    extorder.source=extorder.NM_SPECIAL;
    extorder.sources=new std::list<NM_specialsourceExt*>;
    specialsource = new NM_specialsourceExt( am->getFE() );
    extorder.sources->push_back(specialsource);
  } else
    extorder.source=extorder.NM_ALLENTRIES;

  extorder.separate_each_entry=separate_each_entry;
  extorder.recursive=recursive;
  extorder.inbackground = inbackground;
  extorder.take_dirs = take_dirs;
  switch(ownstart) {
    case OWNOP_START_IN_TERMINAL:
      extorder.extstart=extorder.NM_EXT_START_IN_TERMINAL;
      break;
    case OWNOP_START_IN_TERMINAL_AND_WAIT4KEY:
      extorder.extstart=extorder.NM_EXT_START_IN_TERMINAL_AND_WAIT4KEY;
      break;
    case OWNOP_SHOW_OUTPUT:
      extorder.extstart=extorder.NM_EXT_SHOW_OUTPUT;
      break;
    default:
      extorder.extstart=extorder.NM_EXT_START_NORMAL;
      break;
  }
  extorder.com_str=NULL;
  extorder.view_str=NULL;
  if(strlen(com_str)>0) extorder.com_str=com_str;
  if(strlen(view_str)>0) extorder.view_str=view_str;

  extorder.dontcd = dontcd;

  nm1->externprog(&extorder);

  if(extorder.source==extorder.NM_SPECIAL) {
    if ( specialsource != NULL ) delete specialsource;
    delete extorder.sources;
  }

  return 0;
}

int
OwnOp::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *fb, *comreqb, *comreqb2;
  StringGadget *sg[2];
  AWindow *win;
  ChooseButton *scb,*rcb, *ibcb, *tdcb, *dcdcb;
  CycleButton *cyb;
  AGMessage *msg;
  int endmode=-1;
  Requester *req;
  FileRequester *freq;
  const char *textstr;
  char *buttonstr,*tstr;
  int erg;
  std::string str1;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  
  req=new Requester(aguix);
  freq = new FileRequester( aguix );

  tstr=(char*)_allocsafe(strlen(catalog.getLocale(293))+strlen(catalog.getLocaleCom(28))+1);
  sprintf(tstr,catalog.getLocale(293),catalog.getLocaleCom(28));
  win = new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe(tstr);

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 9 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  scb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( separate_each_entry == true ) ? 1 : 0,
						   catalog.getLocale( 329 ), LABEL_RIGHT, 1, 0 ), 0, 0, cincwnr );

  rcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( recursive == true ) ? 1 : 0,
						   catalog.getLocale( 330 ), LABEL_RIGHT, 1, 0 ), 0, 1, cincwnr );

  tdcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( take_dirs == true ) ? 1 : 0,
                                                    catalog.getLocale( 513 ), LABEL_RIGHT, 1, 0 ), 0, 2, cincwnr );

  dcdcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( dontcd == true ) ? 1 : 0,
						     catalog.getLocale( 617 ), LABEL_RIGHT, 1, 0 ), 0, 3, cincwnr );

  ibcb = (ChooseButton*)ac1->add( new ChooseButton( aguix,
                                                    0,
                                                    0,
                                                    ( inbackground == true ) ? 1 : 0,
                                                    catalog.getLocale( 435 ),
                                                    LABEL_RIGHT,
                                                    1,
                                                    0 ), 0, 4, cincwnr );

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 5 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );

  ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 331 ), 1 ), 0, 0, cfix );
  cyb = (CycleButton*)ac1_1->add( new CycleButton( aguix, 0, 0, 100, 1, 0, 0 ), 1, 0, cincw );
  cyb->addOption(catalog.getLocale(332));
  cyb->addOption(catalog.getLocale(333));
  cyb->addOption(catalog.getLocale(334));
  cyb->addOption(catalog.getLocale(335));
  cyb->resize(cyb->getMaxSize(),cyb->getHeight());
  ac1_1->readLimits();
  switch(ownstart) {
    case OWNOP_START_IN_TERMINAL:
      cyb->setOption(1);
      break;
    case OWNOP_START_IN_TERMINAL_AND_WAIT4KEY:
      cyb->setOption(2);
      break;
    case OWNOP_SHOW_OUTPUT:
      cyb->setOption(3);
      break;
    default:
      cyb->setOption(0);
      break;
  }
  
  AContainer *ac1_2 = ac1->add( new AContainer( win, 5, 1 ), 0, 6 );
  ac1_2->setMinSpace( 0 );
  ac1_2->setMaxSpace( 0 );
  ac1_2->setBorderWidth( 0 );

  ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 336 ), 1 ), 0, 0, cfix );
  ac1_2->setMinWidth( 5, 1, 0 );
  ac1_2->setMaxWidth( 5, 1, 0 );

  comreqb = (Button*)ac1_2->add( new Button( aguix, 0, 0, catalog.getLocale( 458 ), 1, 0, 0 ), 2, 0, cfix );

  sg[0] = (StringGadget*)ac1_2->add( new StringGadget( aguix, 0, 0, 100, com_str, 0 ), 3, 0, cincw );
  
  fb = (Button*)ac1_2->add( new Button( aguix, 0, 0, "O", 1, 0, 0 ), 4, 0, cfix );
  
  AContainer *ac1_3 = ac1->add( new AContainer( win, 4, 1 ), 0, 7 );
  ac1_3->setMinSpace( 0 );
  ac1_3->setMaxSpace( 0 );
  ac1_3->setBorderWidth( 0 );

  Text *view_text = (Text*)ac1_3->add( new Text( aguix, 0, 0, catalog.getLocale( 337 ), 1 ), 0, 0, cfix );
  ac1_3->setMinWidth( 5, 1, 0 );
  ac1_3->setMaxWidth( 5, 1, 0 );
  comreqb2 = (Button*)ac1_3->add( new Button( aguix, 0, 0, catalog.getLocale( 458 ), 1, 0, 0 ), 2, 0, cfix );
  sg[1] = (StringGadget*)ac1_3->add( new StringGadget( aguix, 0, 0, 100, view_str, 0 ), 3, 0, cincw );
  
  if ( cyb->getSelectedOption() == 3 ) {
      sg[1]->show();
      comreqb2->show();
      view_text->show();
  } else {
      sg[1]->hide();
      comreqb2->hide();
      view_text->hide();
  }
  
  AContainer *ac1_4 = ac1->add( new AContainer( win, 2, 1 ), 0, 8 );
  ac1_4->setMinSpace( 5 );
  ac1_4->setMaxSpace( -1 );
  ac1_4->setBorderWidth( 0 );
  Button *okb =(Button*)ac1_4->add( new Button( aguix,
                                                0,
                                                0,
                                                catalog.getLocale( 11 ),
                                                1,
                                                0,
                                                0 ), 0, 0, cfix );
  Button *cb = (Button*)ac1_4->add( new Button( aguix,
						0,
						0,
						catalog.getLocale( 8 ),
						1,
						0,
						0 ), 1, 0, cfix );
  
  win->setDoTabCycling( true );
  win->contMaximize( true );
  win->show();
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) {
            if(NormalMode::isCorrectViewProg(sg[1]->getText())==false) {
              // show requester
              textstr=catalog.getLocale(312);
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                          strlen(catalog.getLocale(314))+1);
              sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                        catalog.getLocale(314));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(buttonstr);
              if(erg==0) {
                sg[0]->deactivate();
                sg[1]->activate();
              } else {
                sg[1]->setText("");
              }
            } else endmode=0;
          } else if(msg->button.button==cb) endmode=1;
          else if(msg->button.button==fb) {
            tstr=getFlag();
            if(tstr!=NULL) {
              const char *newstr1=sg[0]->getText();
              char *newstr2;
              int pos=sg[0]->getCursor();
              newstr2=(char*)_allocsafe(strlen(newstr1)+strlen(tstr)+1);
              strncpy(newstr2,newstr1,pos);
              strcpy(newstr2+pos,tstr);
              strcpy(newstr2+pos+strlen(tstr),newstr1+pos);
              sg[0]->setText(newstr2);
              _freesafe(newstr2);
              _freesafe(tstr);
            }
          } else if ( msg->button.button == comreqb ) {
            if ( freq->request_entry( catalog.getLocale( 265 ),
                                      NULL,
                                      catalog.getLocale( 11 ),
                                      catalog.getLocale( 8 ),
                                      catalog.getLocale( 265 ),
                                      true ) > 0 ) {
              str1 = freq->getLastEntryStr();
              if ( str1.length() > 0 ) {
                const char *newstr1 = sg[ 0 ]->getText();
                char *newstr2;
                int pos = sg[ 0 ]->getCursor();

                newstr2 = (char*)_allocsafe( strlen( newstr1 ) + strlen( str1.c_str() ) + 1 );
                strncpy( newstr2, newstr1, pos );
                strcpy( newstr2 + pos, str1.c_str() );
                strcpy( newstr2 + pos + strlen( str1.c_str() ), newstr1 + pos );
                sg[ 0 ]->setText( newstr2 );
                _freesafe( newstr2 );
              }
            }
          } else if ( msg->button.button == comreqb2 ) {
            if ( freq->request_entry( catalog.getLocale( 265 ),
                                      NULL,
                                      catalog.getLocale( 11 ),
                                      catalog.getLocale( 8 ),
                                      catalog.getLocale( 265 ),
                                      true ) > 0 ) {
              str1 = freq->getLastEntryStr();
              if ( str1.length() > 0 ) {
                const char *newstr1 = sg[ 1 ]->getText();
                char *newstr2;
                int pos = sg[ 1 ]->getCursor();

                newstr2 = (char*)_allocsafe( strlen( newstr1 ) + strlen( str1.c_str() ) + 1 );
                strncpy( newstr2, newstr1, pos );
                strcpy( newstr2 + pos, str1.c_str() );
                strcpy( newstr2 + pos + strlen( str1.c_str() ), newstr1 + pos );
                sg[ 1 ]->setText( newstr2 );
                _freesafe( newstr2 );
              }
            }
          }
          break;
	case AG_STRINGGADGET_DEACTIVATE:
          if(msg->stringgadget.sg==sg[1]) {
            if(NormalMode::isCorrectViewProg(sg[1]->getText())==false) {
              // show requester
              textstr=catalog.getLocale(312);
              buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(313))+1+
                                          strlen(catalog.getLocale(314))+1);
              sprintf(buttonstr,"%s|%s",catalog.getLocale(313),
                                        catalog.getLocale(314));
              erg=req->request(catalog.getLocale(125),textstr,buttonstr);
              _freesafe(buttonstr);
              if(erg==0) {
                sg[0]->deactivate();
                sg[1]->activate();
              } else {
                sg[1]->setText("");
              }
            }
          }
	  break;
        case AG_CYCLEBUTTONCLICKED:
            if ( msg->cyclebutton.cyclebutton == cyb ) {
                if ( cyb->getSelectedOption() == 3 ) {
                    sg[1]->show();
                    comreqb2->show();
                    view_text->show();
                } else {
                    sg[1]->hide();
                    comreqb2->hide();
                    view_text->hide();
                }
            }
            break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  if(endmode==0) {
    // ok
    separate_each_entry = scb->getState();
    recursive = rcb->getState();
    take_dirs = tdcb->getState();
    dontcd = dcdcb->getState();
    inbackground = ibcb->getState();
    _freesafe(com_str);
    _freesafe(view_str);
    com_str=dupstring(sg[0]->getText());
    view_str=dupstring(sg[1]->getText());
    switch(cyb->getSelectedOption()) {
      case 1:
        ownstart=OWNOP_START_IN_TERMINAL;
        break;
      case 2:
        ownstart=OWNOP_START_IN_TERMINAL_AND_WAIT4KEY;
        break;
      case 3:
        ownstart=OWNOP_SHOW_OUTPUT;
        break;
      default:
        ownstart=OWNOP_START_NORMAL;
        break;
    }
  }
  
  delete win;
  delete req;
  delete freq;

  return endmode;
}

char*
OwnOp::getFlag()
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cb;
  AWindow *win;
  FieldListView *lv;
  AGMessage *msg;
  int endmode=-1;
  char *returnstr;
  int i, trow, nr;
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  
  win = new AWindow( aguix, 10, 10, 10, 10, 0, catalog.getLocale( 338 ) );
  win->create();

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  ac1->add( new Text( aguix, 0, 0, catalog.getLocale( 338 ), 1 ), 0, 0, cincwnr );

  lv = (FieldListView*)ac1->add( new FieldListView( aguix,
                                                    0,
                                                    0,
                                                    300,
                                                    200,
                                                    0 ), 0, 1, cmin );
  lv->setHBarState(2);
  lv->setVBarState(2);

  lv->setNrOfFields( 3 );
  lv->setFieldWidth( 1, 3 );
  
  nr = sizeof( ownop_flags ) / sizeof( ownop_flags[0] );

  for( i=0;i<nr;i++) {
    trow = lv->addRow();
    lv->setText( trow, 0, ownop_flags[ i ].flag );
    lv->setText( trow, 2, catalog.getLocaleFlag( ownop_flags[ i ].catcode ) );
    lv->setPreColors( trow, FieldListView::PRECOLOR_ONLYACTIVE );
    lv->setData( trow, i );
  }

  AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 2 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( -1 );
  ac1_2->setBorderWidth( 0 );
  okb = (Button*)ac1_2->add( new Button( aguix,
					 0,
					 0,
					 catalog.getLocale( 11 ),
					 1,
					 0,
					 0 ), 0, 0, cfix );
  cb = (Button*)ac1_2->add( new Button( aguix,
					0,
					0,
					catalog.getLocale( 8 ),
					1,
					0,
					0 ), 1, 0, cfix );
  win->contMaximize( true );
  win->setDoTabCycling( true );
  win->show();
  
  for(;endmode==-1;) {
    msg=aguix->WaitMessage(win);
    if(msg!=NULL) {
      switch(msg->type) {
        case AG_CLOSEWINDOW:
          if(msg->closewindow.window==win->getWindow()) endmode=1;
          break;
        case AG_BUTTONCLICKED:
          if(msg->button.button==okb) endmode=0;
          else if(msg->button.button==cb) endmode=1;
          break;
      }
      aguix->ReplyMessage(msg);
    }
  }
  
  returnstr=NULL;
  if(endmode==0) {
    // ok
    trow = lv->getActiveRow();
    if ( lv->isValidRow( trow ) == true ) {
      nr = lv->getData( trow );
      returnstr = dupstring( ownop_flags[nr].flag );
    }
  }
  
  delete win;

  return returnstr;
}

void OwnOp::setSeparateEachEntry(bool nv)
{
  separate_each_entry=nv;
}

void OwnOp::setRecursive(bool nv)
{
  recursive=nv;
}

void OwnOp::setOwnStart(ownstart_t nv)
{
  ownstart=nv;
}

void OwnOp::setComStr(const char* nv)
{
  if ( nv == NULL ) return;
  _freesafe(com_str);
  com_str=dupstring(nv);
}

void OwnOp::setViewStr( const char* nv )
{
  if ( nv == NULL ) return;
  _freesafe( view_str );
  view_str = dupstring( nv );
}

void OwnOp::setInBackground( bool nv )
{
  inbackground = nv;
}

void OwnOp::setTakeDirs( bool nv )
{
  take_dirs = nv;
}

void OwnOp::setDontCD( bool nv )
{
  dontcd = nv;
}
