/* nwc_path.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2006 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "nwc_path.hh"
#include "datei.h"
#include <aguix/lowlevelfunc.h>

namespace NWC {
  namespace Path {
    
    std::string join( const std::string &p1, const std::string &p2 )
    {
      std::string res;
      res = p1;

      int l = res.length();
      if ( l > 0 ) {
        if ( res[l - 1] != '/' ) {
          res += "/";
        }
      } else {
        res += "/";
      }
      
      res += p2;
      return res;
    }

    std::string normalize( const std::string &path )
    {
      //TODO this could be done better
      // perhaps just splitting the string on slash into array
      // then push each directoy component onto new array unless .. appears
      // which removes the last component again
      // after that a new path string is created
      char *tstr = HandlePath( path.c_str() );
      if ( tstr != NULL ) {
        std::string res = tstr;
        _freesafe( tstr );
        return res;
      }
      return "";
    }

  }
}
