/* functionproto.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "functionproto.h"
#include "worker.h"
#include <aguix/util.h>
#include "fileentry.hh"

const char *FunctionProto::name="FunctionProto";

bool FunctionProto::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *FunctionProto::getName()
{
  return name;
}

FunctionProto::FunctionProto()
{
  hasConfigure = false;
}

FunctionProto::~FunctionProto()
{
}

int FunctionProto::configure()
{
  AGUIX *aguix = Worker::getAGUIX();
  Requester *req;
  const char *textstr,*buttonstr;
  
  req=new Requester(aguix);
  textstr=catalog.getLocale(292);
  buttonstr=catalog.getLocale(11);
  req->request(catalog.getLocale(124),textstr,buttonstr);
  delete req;

  return 0;
}

FunctionProto *FunctionProto::duplicate() const
{
  return NULL;
}

bool FunctionProto::save(Datei *fh)
{
  return false;
}

int FunctionProto::presave(Datei *fh,FunctionProto *fp)
{
  if ( ( fh == NULL ) || ( fp == NULL ) ) return 1;
  fh->configOpenSection( fp->getName() );
  fp->save( fh );
  fh->configCloseSection();
  return 0;
}

int FunctionProto::run( WPUContext *wpu, ActionMessage *msg )
{
  return 0;
}

ActionMessage::ActionMessage( Worker *w)
{
  mode=AM_MODE_NORMAL;
  startLister=NULL;
  dndmsg = NULL;
  fe = NULL;
  worker = w;

  filetype = NULL;
}

ActionMessage::~ActionMessage()
{
  if ( fe != NULL ) delete fe;
}

Worker *ActionMessage::getWorker() const
{
  return worker;
}

const FileEntry *ActionMessage::getFE() const
{
  return fe;
}

void ActionMessage::setFE( const FileEntry *tfe )
{
  if ( fe != NULL ) delete fe;
  if ( tfe != NULL ) {
    fe = new FileEntry( *tfe );
  } else {
    fe = NULL;
  }
}

const char *FunctionProto::getDescription()
{
  return "Prototype einer Aktion";
}

int FunctionProto::configureWhenAvail()
{
  if ( hasConfigure == false ) return -1;
  return configure();
}

void freecoms(List *com)
{
  FunctionProto *fp;
  int id=com->initEnum();
  fp=(FunctionProto*)com->getFirstElement(id);
  while(fp!=NULL) {
    delete fp;
    fp=(FunctionProto*)com->getNextElement(id);
  }
  com->removeAllElements();
  com->closeEnum(id);
}
