###########################################################################
#
# This program is part of Zenoss Core, an open source monitoring platform.
# Copyright (C) 2007, Zenoss Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published by
# the Free Software Foundation.
#
# For complete information please visit: http://www.zenoss.com/oss/
#
###########################################################################
wbemNoErr = 0
wbemErrFailed = -2147217407
wbemErrNotFound = -2147217406
wbemErrAccessDenied = -2147217405
wbemErrProviderFailure = -2147217404
wbemErrTypeMismatch = -2147217403
wbemErrOutOfMemory = -2147217402
wbemErrInvalidContext = -2147217401
wbemErrInvalidParameter = -2147217400
wbemErrNotAvailable = -2147217399
wbemErrCriticalError = -2147217398
wbemErrInvalidStream = -2147217397
wbemErrNotSupported = -2147217396
wbemErrInvalidSuperclass = -2147217395
wbemErrInvalidNamespace = -2147217394
wbemErrInvalidObject = -2147217393
wbemErrInvalidClass = -2147217392
wbemErrProviderNotFound = -2147217391
wbemErrInvalidProviderRegistration = -2147217390
wbemErrProviderLoadFailure = -2147217389
wbemErrInitializationFailure = -2147217388
wbemErrTransportFailure = -2147217387
wbemErrInvalidOperation = -2147217386
wbemErrInvalidQuery = -2147217385
wbemErrInvalidQueryType = -2147217384
wbemErrAlreadyExists = -2147217383
wbemErrOverrideNotAllowed = -2147217382
wbemErrPropagatedQualifier = -2147217381
wbemErrPropagatedProperty = -2147217380
wbemErrUnexpected = -2147217379
wbemErrIllegalOperation = -2147217378
wbemErrCannotBeKey = -2147217377
wbemErrIncompleteClass = -2147217376
wbemErrInvalidSyntax = -2147217375
wbemErrNondecoratedObject = -2147217374
wbemErrReadOnly = -2147217373
wbemErrProviderNotCapable = -2147217372
wbemErrClassHasChildren = -2147217371
wbemErrClassHasInstances = -2147217370
wbemErrQueryNotImplemented = -2147217369
wbemErrIllegalNull = -2147217368
wbemErrInvalidQualifierType = -2147217367
wbemErrInvalidPropertyType = -2147217366
wbemErrValueOutOfRange = -2147217365
wbemErrCannotBeSingleton = -2147217364
wbemErrInvalidCimType = -2147217363
wbemErrInvalidMethod = -2147217362
wbemErrInvalidMethodParameters = -0
wbemErrSystemProperty = -2147217360
wbemErrInvalidProperty = -2147217359
wbemErrCallCancelled = -2147217358
wbemErrShuttingDown = -2147217357
wbemErrPropagatedMethod = -2147217356
wbemErrUnsupportedParameter = -2147217355
wbemErrMissingParameter = -2147217354
wbemErrInvalidParameterId = -2147217353
wbemErrNonConsecutiveParameterIds = -2147217352
wbemErrParameterIdOnRetval = -2147217351
wbemErrInvalidObjectPath = -2147217350
wbemErrOutOfDiskSpace = -2147217349
wbemErrBufferTooSmall = -2147217348
wbemErrUnsupportedPutExtension = -2147217347
wbemErrUnknownObjectType = -2147217346
wbemErrUnknownPacketType = -2147217345
wbemErrMarshalVersionMismatch = -2147217344
wbemErrMarshalInvalidSignature = -2147217343
wbemErrInvalidQualifier = -2147217342
wbemErrInvalidDuplicateParameter = -2147217341
wbemErrTooMuchData = -2147217340
wbemErrServerTooBusy = -2147217339
wbemErrInvalidFlavor = -2147217338
wbemErrCircularReference = -2147217337
wbemErrUnsupportedClassUpdate = -2147217336
wbemErrCannotChangeKeyInheritance = -2147217335
wbemErrCannotChangeIndexInheritance = -2147217328
wbemErrTooManyProperties = -2147217327
wbemErrUpdateTypeMismatch = -2147217326
wbemErrUpdateOverrideNotAllowed	= -2147217325
wbemErrUpdatePropagatedMethod = -2147217324
wbemErrMethodNotImplemented	= -2147217323
wbemErrMethodDisabled = -2147217322
wbemErrRefresherBusy = -2147217321
wbemErrUnparsableQuery = -2147217320
wbemErrNotEventClass = -2147217319
wbemErrMissingGroupWithin = -2147217318
wbemErrMissingAggregationList = -2147217317
wbemErrPropertyNotAnObject = -2147217316
wbemErrAggregatingByObject = -2147217315
wbemErrUninterpretableProviderQuery = -2147217313
wbemErrBackupRestoreWinmgmtRunning = -2147217312
wbemErrQueueOverflow = -2147217311
wbemErrPrivilegeNotHeld = -2147217310
wbemErrInvalidOperator = -2147217309
wbemErrLocalCredentials = -2147217308
wbemErrCannotBeAbstract = -2147217307
wbemErrAmendedObject = -2147217306
wbemErrClientTooSlow = -2147217305
wbemErrNullSecurityDescriptor = -2147217304
wbemErrTimeout = -2147217303
wbemErrInvalidAssociation = -2147217302
wbemErrAmbiguousOperation = -2147217301
wbemErrQuotaViolation = -2147217300
wbemErrTransactionConflict = -2147217299
wbemErrForcedRollback = -2147217298
wbemErrUnsupportedLocale = -2147217297
wbemErrHandleOutOfDate = -2147217296
wbemErrConnectionFailed = -2147217295
wbemErrInvalidHandleRequest = -2147217294
wbemErrPropertyNameTooWide = -2147217293
wbemErrClassNameTooWide = -2147217292
wbemErrMethodNameTooWide = -2147217291
wbemErrQualifierNameTooWide = -2147217290
wbemErrRerunCommand = -2147217289
wbemErrDatabaseVerMismatch = -2147217288
wbemErrVetoPut	= -2147217287
wbemErrVetoDelete = -2147217286
wbemErrInvalidLocale = -2147217280
wbemErrProviderSuspended = -2147217279
wbemErrSynchronizationRequired = -2147217278
wbemErrNoSchema = -2147217277
wbemErrProviderAlreadyRegistered = -2147217276
wbemErrProviderNotRegistered = -2147217275
wbemErrFatalTransportError = -2147217274
wbemErrEncryptedConnectionRequired = -2147217273
wbemErrRegistrationTooBroad = -2147213311
wbemErrRegistrationTooPrecise = -2147213310
wbemErrTimedout = -2147209215
wbemErrResetToDefault = -4160732416

_werror_to_wbemErr = {
    0x40004: wbemErrTimedout
}

class com_error(Exception):
    def __init__(self, code, txt = ""):
	try:
	    code = _werror_to_wbemErr[code]
	except:
	    pass
	wcode, source, descr, hfile, hcont, scode = code, "Src", "Desc", "Hfile", 0, code
	info = wcode, source, descr, hfile, hcont, scode
	param = None
	self.args = code, txt, info, param
    def __str__(self):
	return "com_error(%s): %s" % (self.args[0], self.args[1])
