# These macros are stolen (and slightly modfied) from the Ethereal program
# I have modified some - forexample PCAP_INCLIDE. I don't know how
# this should really be done..

AC_DEFUN(AC_ETHEREAL_ADD_DASH_L,
[$1="$$1 -L$2"
case "$host_os" in
  solaris*)
    $1="$$1 -R$2"
  ;;
esac
])

AC_DEFUN(AC_ETHEREAL_PCAP_CHECK,
[
        if test -z "$pcap_dir"
        then
          #
          # The user didn't specify a directory in which libpcap resides;
          # we assume that the current library search path will work,
          # but we may have to look for the header in a "pcap"
          # subdirectory of "/usr/include" or "/usr/local/include",
          # as some systems apparently put "pcap.h" in a "pcap"
          # subdirectory, and we also check "$prefix/include".
          #
          # XXX - should we just add "$prefix/include" to the include
          # search path and "$prefix/lib" to the library search path?
          #
          AC_MSG_CHECKING(for extraneous pcap header directories)
          PCAP_INCLUDE=""
          for pcap_dir in /usr/include/pcap /usr/local/include/pcap $prefix/include
          do
            if test -d $pcap_dir ; then
                PCAP_INCLUDE="$PCAP_INCLUDE -I$pcap_dir"
            fi
          done

          if test "$PCAP_INCLUDE" != "" ; then
            AC_MSG_RESULT(found --$PCAP_INCLUDE added to CPPFLAGS)
          else
            AC_MSG_RESULT(not found)
          fi
        else
          #
          # The user specified a directory in which libpcap resides,
          # so add the "include" subdirectory of that directory to
          # the include file search path and the "lib" subdirectory
          # of that directory to the library search path.
          #
          # XXX - if there's also a libpcap in a directory that's
          # already in CFLAGS, CPPFLAGS, or LDFLAGS, this won't
          # make us find the version in the specified directory,
          # as the compiler and/or linker will search that other
          # directory before it searches the specified directory.
          #
          PCAP_INCLUDE="-I$pcap_dir/include"
          AC_ETHEREAL_ADD_DASH_L(LDFLAGS, $pcap_dir/lib)
        fi
        CPPFLAGS="$CPPFLAGS $PCAP_INCLUDE"

        # Pcap header checks
        AC_CHECK_HEADER(net/bpf.h,,
            AC_MSG_ERROR([[Header file net/bpf.h not found; if you installed libpcap from source, did you also do \"make install-incl\"?]]))
        AC_CHECK_HEADER(pcap.h,, AC_MSG_ERROR(Header file pcap.h not found.))

        #
        # Check to see if we find "pcap_open_live" in "-lpcap".
        #
        AC_CHECK_LIB(pcap, pcap_open_live,
          [
            PCAP_LIBS=-lpcap
          ], AC_MSG_ERROR(Library libpcap not found.),
          $SOCKET_LIBS $NSL_LIBS)
        AC_SUBST(PCAP_LIBS)
        AC_SUBST(PCAP_INCLUDE)
])
