%%
%%  wpf_fixed6x12.erl --
%%
%%    6x12 fixed bitmap font.
%%
%%  Copyright (c) 2001-2004 Bjorn Gustavsson.
%%
%%  See the file "license.terms" for information on usage and redistribution
%%  of this file, and for a DISCLAIMER OF ALL WARRANTIES.
%%
%%     $Id$
%%

-module(wpf_fixed6x12).
-export([desc/0,width_fun/0,width/0,height/0,draw/1,char/1,bold/1]).

desc() ->
    "Fixed (6x12)".

width_fun() -> fun cw/1.

width() -> 6.
height() -> 12.

draw([C|T]) ->
    char(C),
    draw(T);
draw([]) -> ok.

bold([C|T]) ->
    bold_char(C),
    bold(T);
bold([]) -> ok.

bold_char(C) ->
    char(C),
    Cw = cw(C),
    gl:bitmap(1, 1, 0, 0, -Cw+1, 0, <<0>>),
    char(C).

cw(_) -> 6.

char(0) ->
  B = <<16#a8,16#00,16#88,16#00,16#88,16#00,16#88,16#00,16#a8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(1) ->
  B = <<16#20,16#70,16#f8,16#70,16#20>>,
  gl:bitmap(5, 5, 0, -2, 6, 0, B);
char(2) ->
  B = <<16#a8,16#54,16#a8,16#54,16#a8,16#54,16#a8,16#54,16#a8,16#54,16#a8,16#54,16#a8>>,
  gl:bitmap(6, 13, 0, 2, 6, 0, B);
char(3) ->
  B = <<16#10,16#10,16#10,16#38,16#a0,16#a0,16#e0,16#a0,16#a0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(4) ->
  B = <<16#20,16#20,16#30,16#20,16#b8,16#80,16#c0,16#80,16#e0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(5) ->
  B = <<16#28,16#28,16#30,16#28,16#30,16#60,16#80,16#80,16#60>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(6) ->
  B = <<16#20,16#20,16#30,16#20,16#38,16#e0,16#80,16#80,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(7) ->
  B = <<16#60,16#90,16#90,16#60>>,
  gl:bitmap(4, 4, -1, -5, 6, 0, B);
char(8) ->
  B = <<16#f8,16#00,16#20,16#20,16#f8,16#20,16#20>>,
  gl:bitmap(5, 7, 0, -1, 6, 0, B);
char(9) ->
  B = <<16#38,16#20,16#20,16#20,16#20,16#90,16#b0,16#d0,16#90>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(10) ->
  B = <<16#10,16#10,16#10,16#38,16#40,16#40,16#a0,16#a0,16#a0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(11) ->
  B = <<16#e0,16#20,16#20,16#20,16#20,16#20,16#20>>,
  gl:bitmap(3, 7, 0, -4, 6, 0, B);
char(12) ->
  B = <<16#20,16#20,16#20,16#20,16#20,16#20,16#e0>>,
  gl:bitmap(3, 7, 0, 2, 6, 0, B);
char(13) ->
  B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#f0>>,
  gl:bitmap(4, 7, -2, 2, 6, 0, B);
char(14) ->
  B = <<16#f0,16#80,16#80,16#80,16#80,16#80,16#80>>,
  gl:bitmap(4, 7, -2, -4, 6, 0, B);
char(15) ->
  B = <<16#20,16#20,16#20,16#20,16#20,16#20,16#fc,16#20,16#20,16#20,16#20,16#20,16#20>>,
  gl:bitmap(6, 13, 0, 2, 6, 0, B);
char(16) ->
  B = <<16#fc>>,
  gl:bitmap(6, 1, 0, -10, 6, 0, B);
char(17) ->
  B = <<16#fc>>,
  gl:bitmap(6, 1, 0, -7, 6, 0, B);
char(18) ->
  B = <<16#fc>>,
  gl:bitmap(6, 1, 0, -4, 6, 0, B);
char(19) ->
  B = <<16#fc>>,
  gl:bitmap(6, 1, 0, -1, 6, 0, B);
char(20) ->
  B = <<16#fc>>,
  gl:bitmap(6, 1, 0, 2, 6, 0, B);
char(21) ->
  B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#f0,16#80,16#80,16#80,16#80,16#80,16#80>>,
  gl:bitmap(4, 13, -2, 2, 6, 0, B);
char(22) ->
  B = <<16#20,16#20,16#20,16#20,16#20,16#20,16#e0,16#20,16#20,16#20,16#20,16#20,16#20>>,
  gl:bitmap(3, 13, 0, 2, 6, 0, B);
char(23) ->
  B = <<16#fc,16#20,16#20,16#20,16#20,16#20,16#20>>,
  gl:bitmap(6, 7, 0, -4, 6, 0, B);
char(24) ->
  B = <<16#20,16#20,16#20,16#20,16#20,16#20,16#fc>>,
  gl:bitmap(6, 7, 0, 2, 6, 0, B);
char(25) ->
  B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
  gl:bitmap(1, 13, -2, 2, 6, 0, B);
char(26) ->
  B = <<16#f8,16#00,16#18,16#60,16#80,16#60,16#18>>,
  gl:bitmap(5, 7, 0, -1, 6, 0, B);
char(27) ->
  B = <<16#f8,16#00,16#c0,16#30,16#08,16#30,16#c0>>,
  gl:bitmap(5, 7, 0, -1, 6, 0, B);
char(28) ->
  B = <<16#50,16#50,16#50,16#50,16#50,16#f8>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(29) ->
  B = <<16#80,16#f8,16#20,16#f8,16#08>>,
  gl:bitmap(5, 5, 0, -1, 6, 0, B);
char(30) ->
  B = <<16#b0,16#48,16#40,16#40,16#e0,16#40,16#40,16#48,16#30>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(31) ->
  B = <<16#c0>>,
  gl:bitmap(2, 1, -2, -4, 6, 0, B);
char(32) ->
  B = <<>>,
  gl:bitmap(0, 0, 0, 0, 6, 0, B);
char(33) ->
  B = <<16#80,16#00,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
  gl:bitmap(1, 9, -2, 0, 6, 0, B);
char(34) ->
  B = <<16#a0,16#a0,16#a0>>,
  gl:bitmap(3, 3, -1, -6, 6, 0, B);
char(35) ->
  B = <<16#50,16#50,16#f8,16#50,16#f8,16#50,16#50>>,
  gl:bitmap(5, 7, 0, -1, 6, 0, B);
char(36) ->
  B = <<16#20,16#f0,16#28,16#28,16#70,16#a0,16#a0,16#78,16#20>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(37) ->
  B = <<16#90,16#a8,16#50,16#40,16#20,16#10,16#50,16#a8,16#48>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(38) ->
  B = <<16#68,16#90,16#98,16#a0,16#40,16#a0,16#a0,16#40>>,
  gl:bitmap(5, 8, 0, 0, 6, 0, B);
char(39) ->
  B = <<16#80,16#80,16#80>>,
  gl:bitmap(1, 3, -2, -6, 6, 0, B);
char(40) ->
  B = <<16#20,16#40,16#40,16#80,16#80,16#80,16#80,16#80,16#40,16#40,16#20>>,
  gl:bitmap(3, 11, -1, 1, 6, 0, B);
char(41) ->
  B = <<16#80,16#40,16#40,16#20,16#20,16#20,16#20,16#20,16#40,16#40,16#80>>,
  gl:bitmap(3, 11, -1, 1, 6, 0, B);
char(42) ->
  B = <<16#20,16#a8,16#70,16#a8,16#20>>,
  gl:bitmap(5, 5, 0, -4, 6, 0, B);
char(43) ->
  B = <<16#20,16#20,16#f8,16#20,16#20>>,
  gl:bitmap(5, 5, 0, -2, 6, 0, B);
char(44) ->
  B = <<16#80,16#40,16#60>>,
  gl:bitmap(3, 3, -1, 1, 6, 0, B);
char(45) ->
  B = <<16#f8>>,
  gl:bitmap(5, 1, 0, -4, 6, 0, B);
char(46) ->
  B = <<16#40,16#e0,16#40>>,
  gl:bitmap(3, 3, -1, 1, 6, 0, B);
char(47) ->
  B = <<16#80,16#80,16#40,16#40,16#20,16#10,16#10,16#08,16#08>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(48) ->
  B = <<16#20,16#50,16#88,16#88,16#88,16#88,16#88,16#50,16#20>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(49) ->
  B = <<16#f8,16#20,16#20,16#20,16#20,16#20,16#a0,16#60,16#20>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(50) ->
  B = <<16#f8,16#80,16#40,16#20,16#10,16#08,16#88,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(51) ->
  B = <<16#70,16#88,16#08,16#08,16#70,16#20,16#10,16#08,16#f8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(52) ->
  B = <<16#10,16#10,16#f8,16#90,16#50,16#50,16#30,16#10,16#10>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(53) ->
  B = <<16#70,16#88,16#08,16#08,16#c8,16#b0,16#80,16#80,16#f8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(54) ->
  B = <<16#70,16#88,16#88,16#88,16#f0,16#80,16#80,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(55) ->
  B = <<16#40,16#40,16#40,16#20,16#20,16#10,16#10,16#08,16#f8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(56) ->
  B = <<16#70,16#88,16#88,16#88,16#70,16#88,16#88,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(57) ->
  B = <<16#70,16#88,16#08,16#08,16#78,16#88,16#88,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(58) ->
  B = <<16#40,16#e0,16#40,16#00,16#00,16#40,16#e0,16#40>>,
  gl:bitmap(3, 8, -1, 1, 6, 0, B);
char(59) ->
  B = <<16#80,16#40,16#60,16#00,16#00,16#40,16#e0,16#40>>,
  gl:bitmap(3, 8, -1, 1, 6, 0, B);
char(60) ->
  B = <<16#08,16#10,16#20,16#40,16#80,16#40,16#20,16#10,16#08>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(61) ->
  B = <<16#f8,16#00,16#00,16#f8>>,
  gl:bitmap(5, 4, 0, -2, 6, 0, B);
char(62) ->
  B = <<16#80,16#40,16#20,16#10,16#08,16#10,16#20,16#40,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(63) ->
  B = <<16#20,16#00,16#20,16#20,16#10,16#08,16#88,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(64) ->
  B = <<16#78,16#80,16#b0,16#a8,16#a8,16#98,16#88,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(65) ->
  B = <<16#88,16#88,16#88,16#f8,16#88,16#88,16#88,16#50,16#20>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(66) ->
  B = <<16#f0,16#48,16#48,16#48,16#70,16#48,16#48,16#48,16#f0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(67) ->
  B = <<16#70,16#88,16#80,16#80,16#80,16#80,16#80,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(68) ->
  B = <<16#f0,16#48,16#48,16#48,16#48,16#48,16#48,16#48,16#f0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(69) ->
  B = <<16#f8,16#80,16#80,16#80,16#f0,16#80,16#80,16#80,16#f8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(70) ->
  B = <<16#80,16#80,16#80,16#80,16#f0,16#80,16#80,16#80,16#f8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(71) ->
  B = <<16#70,16#88,16#88,16#98,16#80,16#80,16#80,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(72) ->
  B = <<16#88,16#88,16#88,16#88,16#f8,16#88,16#88,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(73) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#40,16#40,16#40,16#e0>>,
  gl:bitmap(3, 9, -1, 0, 6, 0, B);
char(74) ->
  B = <<16#60,16#90,16#10,16#10,16#10,16#10,16#10,16#10,16#38>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(75) ->
  B = <<16#88,16#88,16#90,16#a0,16#c0,16#a0,16#90,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(76) ->
  B = <<16#f8,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(77) ->
  B = <<16#88,16#88,16#88,16#88,16#a8,16#a8,16#d8,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(78) ->
  B = <<16#88,16#88,16#98,16#98,16#a8,16#a8,16#c8,16#c8,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(79) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#88,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(80) ->
  B = <<16#80,16#80,16#80,16#80,16#f0,16#88,16#88,16#88,16#f0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(81) ->
  B = <<16#08,16#70,16#a8,16#88,16#88,16#88,16#88,16#88,16#88,16#70>>,
  gl:bitmap(5, 10, 0, 1, 6, 0, B);
char(82) ->
  B = <<16#88,16#88,16#90,16#a0,16#f0,16#88,16#88,16#88,16#f0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(83) ->
  B = <<16#70,16#88,16#08,16#08,16#70,16#80,16#80,16#88,16#70>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(84) ->
  B = <<16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#f8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(85) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#88,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(86) ->
  B = <<16#20,16#20,16#50,16#50,16#50,16#88,16#88,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(87) ->
  B = <<16#50,16#a8,16#a8,16#a8,16#a8,16#88,16#88,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(88) ->
  B = <<16#88,16#88,16#50,16#50,16#20,16#50,16#50,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(89) ->
  B = <<16#20,16#20,16#20,16#20,16#20,16#50,16#50,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(90) ->
  B = <<16#f8,16#80,16#40,16#40,16#20,16#10,16#10,16#08,16#f8>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(91) ->
  B = <<16#e0,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#e0>>,
  gl:bitmap(3, 11, -1, 1, 6, 0, B);
char(92) ->
  B = <<16#08,16#08,16#10,16#10,16#20,16#40,16#40,16#80,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(93) ->
  B = <<16#e0,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#20,16#e0>>,
  gl:bitmap(3, 11, -1, 1, 6, 0, B);
char(94) ->
  B = <<16#88,16#50,16#20>>,
  gl:bitmap(5, 3, 0, -6, 6, 0, B);
char(95) ->
  B = <<16#f8>>,
  gl:bitmap(5, 1, 0, 1, 6, 0, B);
char(96) ->
  B = <<16#40,16#80>>,
  gl:bitmap(2, 2, -2, -8, 6, 0, B);
char(97) ->
  B = <<16#68,16#98,16#88,16#78,16#08,16#70>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(98) ->
  B = <<16#f0,16#88,16#88,16#88,16#88,16#f0,16#80,16#80,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(99) ->
  B = <<16#70,16#88,16#80,16#80,16#88,16#70>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(100) ->
  B = <<16#78,16#88,16#88,16#88,16#88,16#78,16#08,16#08,16#08>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(101) ->
  B = <<16#70,16#88,16#80,16#f8,16#88,16#70>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(102) ->
  B = <<16#40,16#40,16#40,16#40,16#f0,16#40,16#40,16#48,16#30>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(103) ->
  B = <<16#70,16#88,16#08,16#78,16#88,16#88,16#88,16#70>>,
  gl:bitmap(5, 8, 0, 2, 6, 0, B);
char(104) ->
  B = <<16#88,16#88,16#88,16#88,16#c8,16#b0,16#80,16#80,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(105) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#c0,16#00,16#40>>,
  gl:bitmap(3, 8, -1, 0, 6, 0, B);
char(106) ->
  B = <<16#60,16#90,16#90,16#10,16#10,16#10,16#10,16#30,16#00,16#10>>,
  gl:bitmap(4, 10, 0, 2, 6, 0, B);
char(107) ->
  B = <<16#88,16#90,16#a0,16#c0,16#a0,16#90,16#80,16#80,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(108) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#40,16#40,16#40,16#c0>>,
  gl:bitmap(3, 9, -1, 0, 6, 0, B);
char(109) ->
  B = <<16#88,16#a8,16#a8,16#a8,16#a8,16#d0>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(110) ->
  B = <<16#88,16#88,16#88,16#88,16#c8,16#b0>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(111) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#70>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(112) ->
  B = <<16#80,16#80,16#80,16#f0,16#88,16#88,16#88,16#f0>>,
  gl:bitmap(5, 8, 0, 2, 6, 0, B);
char(113) ->
  B = <<16#08,16#08,16#08,16#78,16#88,16#88,16#88,16#78>>,
  gl:bitmap(5, 8, 0, 2, 6, 0, B);
char(114) ->
  B = <<16#80,16#80,16#80,16#80,16#c8,16#b0>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(115) ->
  B = <<16#70,16#88,16#10,16#60,16#88,16#70>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(116) ->
  B = <<16#30,16#48,16#40,16#40,16#40,16#f0,16#40,16#40>>,
  gl:bitmap(5, 8, 0, 0, 6, 0, B);
char(117) ->
  B = <<16#68,16#98,16#88,16#88,16#88,16#88>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(118) ->
  B = <<16#20,16#50,16#50,16#88,16#88,16#88>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(119) ->
  B = <<16#50,16#a8,16#a8,16#a8,16#88,16#88>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(120) ->
  B = <<16#88,16#50,16#20,16#20,16#50,16#88>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(121) ->
  B = <<16#70,16#88,16#08,16#68,16#98,16#88,16#88,16#88>>,
  gl:bitmap(5, 8, 0, 2, 6, 0, B);
char(122) ->
  B = <<16#f8,16#80,16#40,16#20,16#10,16#f8>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(123) ->
  B = <<16#18,16#20,16#20,16#20,16#20,16#c0,16#20,16#20,16#20,16#20,16#18>>,
  gl:bitmap(5, 11, 0, 1, 6, 0, B);
char(124) ->
  B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#80>>,
  gl:bitmap(1, 9, -2, 0, 6, 0, B);
char(125) ->
  B = <<16#c0,16#20,16#20,16#20,16#20,16#18,16#20,16#20,16#20,16#20,16#c0>>,
  gl:bitmap(5, 11, 0, 1, 6, 0, B);
char(126) ->
  B = <<16#90,16#a8,16#48>>,
  gl:bitmap(5, 3, 0, -6, 6, 0, B);
char(160) ->
  B = <<>>,
  gl:bitmap(0, 0, 0, 0, 6, 0, B);
char(161) ->
  B = <<16#80,16#80,16#80,16#80,16#80,16#80,16#80,16#00,16#80>>,
  gl:bitmap(1, 9, -2, 0, 6, 0, B);
char(162) ->
  B = <<16#20,16#70,16#a8,16#a0,16#a0,16#a8,16#70,16#20>>,
  gl:bitmap(5, 8, 0, -1, 6, 0, B);
char(163) ->
  B = <<16#b0,16#48,16#40,16#40,16#e0,16#40,16#40,16#48,16#30>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(164) ->
  B = <<16#88,16#70,16#50,16#50,16#70,16#88>>,
  gl:bitmap(5, 6, 0, -1, 6, 0, B);
char(165) ->
  B = <<16#20,16#20,16#f8,16#20,16#f8,16#50,16#50,16#88,16#88>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(166) ->
  B = <<16#80,16#80,16#80,16#80,16#00,16#80,16#80,16#80,16#80>>,
  gl:bitmap(1, 9, -2, 0, 6, 0, B);
char(167) ->
  B = <<16#60,16#90,16#10,16#60,16#90,16#90,16#60,16#80,16#90,16#60>>,
  gl:bitmap(4, 10, -1, 0, 6, 0, B);
char(168) ->
  B = <<16#a0,16#a0>>,
  gl:bitmap(3, 2, -1, -8, 6, 0, B);
char(169) ->
  B = <<16#70,16#88,16#a8,16#d8,16#c8,16#d8,16#a8,16#88,16#70>>,
  gl:bitmap(5, 9, 0, -1, 6, 0, B);
char(170) ->
  B = <<16#f8,16#00,16#78,16#88,16#78,16#08,16#70>>,
  gl:bitmap(5, 7, 0, -2, 6, 0, B);
char(171) ->
  B = <<16#28,16#50,16#a0,16#a0,16#50,16#28>>,
  gl:bitmap(5, 6, 0, -1, 6, 0, B);
char(172) ->
  B = <<16#08,16#08,16#f8>>,
  gl:bitmap(5, 3, 0, -2, 6, 0, B);
char(173) ->
  B = <<16#e0>>,
  gl:bitmap(3, 1, -1, -4, 6, 0, B);
char(174) ->
  B = <<16#70,16#88,16#d8,16#e8,16#d8,16#d8,16#e8,16#88,16#70>>,
  gl:bitmap(5, 9, 0, -1, 6, 0, B);
char(175) ->
  B = <<16#f8>>,
  gl:bitmap(5, 1, 0, -8, 6, 0, B);
char(176) ->
  B = <<16#60,16#90,16#90,16#60>>,
  gl:bitmap(4, 4, -1, -5, 6, 0, B);
char(177) ->
  B = <<16#f8,16#00,16#20,16#20,16#f8,16#20,16#20>>,
  gl:bitmap(5, 7, 0, -1, 6, 0, B);
char(178) ->
  B = <<16#e0,16#40,16#20,16#a0,16#40>>,
  gl:bitmap(3, 5, 0, -5, 6, 0, B);
char(179) ->
  B = <<16#c0,16#20,16#40,16#a0,16#40>>,
  gl:bitmap(3, 5, 0, -5, 6, 0, B);
char(180) ->
  B = <<16#80,16#40>>,
  gl:bitmap(2, 2, -2, -8, 6, 0, B);
char(181) ->
  B = <<16#80,16#80,16#e8,16#98,16#88,16#88,16#88,16#88>>,
  gl:bitmap(5, 8, 0, 2, 6, 0, B);
char(182) ->
  B = <<16#28,16#28,16#28,16#68,16#e8,16#e8,16#e8,16#e8,16#78>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(183) ->
  B = <<16#c0>>,
  gl:bitmap(2, 1, -2, -4, 6, 0, B);
char(184) ->
  B = <<16#80,16#40>>,
  gl:bitmap(2, 2, -2, 2, 6, 0, B);
char(185) ->
  B = <<16#e0,16#40,16#40,16#c0,16#40>>,
  gl:bitmap(3, 5, 0, -5, 6, 0, B);
char(186) ->
  B = <<16#f8,16#00,16#70,16#88,16#88,16#88,16#70>>,
  gl:bitmap(5, 7, 0, -2, 6, 0, B);
char(187) ->
  B = <<16#a0,16#50,16#28,16#28,16#50,16#a0>>,
  gl:bitmap(5, 6, 0, -1, 6, 0, B);
char(188) ->
  B = <<16#08,16#38,16#28,16#18,16#08,16#e0,16#40,16#40,16#c0,16#40>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(189) ->
  B = <<16#38,16#10,16#08,16#28,16#10,16#e0,16#40,16#40,16#c0,16#40>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(190) ->
  B = <<16#08,16#38,16#28,16#18,16#48,16#a0,16#20,16#40,16#a0,16#40>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(191) ->
  B = <<16#70,16#88,16#88,16#80,16#40,16#20,16#20,16#00,16#20>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(192) ->
  B = <<16#88,16#88,16#f8,16#88,16#88,16#50,16#20,16#00,16#20,16#40>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(193) ->
  B = <<16#88,16#88,16#f8,16#88,16#88,16#50,16#20,16#00,16#20,16#10>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(194) ->
  B = <<16#88,16#88,16#f8,16#88,16#88,16#50,16#20,16#00,16#48,16#30>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(195) ->
  B = <<16#88,16#88,16#f8,16#88,16#88,16#50,16#20,16#00,16#50,16#28>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(196) ->
  B = <<16#88,16#88,16#f8,16#88,16#88,16#50,16#20,16#00,16#50,16#50>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(197) ->
  B = <<16#88,16#88,16#f8,16#88,16#88,16#50,16#20,16#20,16#50,16#20>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(198) ->
  B = <<16#b8,16#a0,16#a0,16#e0,16#b0,16#a0,16#a0,16#a0,16#58>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(199) ->
  B = <<16#40,16#20,16#70,16#88,16#80,16#80,16#80,16#80,16#80,16#88,16#70>>,
  gl:bitmap(5, 11, 0, 2, 6, 0, B);
char(200) ->
  B = <<16#f8,16#80,16#80,16#f0,16#80,16#80,16#f8,16#00,16#20,16#40>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(201) ->
  B = <<16#f8,16#80,16#80,16#f0,16#80,16#80,16#f8,16#00,16#20,16#10>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(202) ->
  B = <<16#f8,16#80,16#80,16#f0,16#80,16#80,16#f8,16#00,16#48,16#30>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(203) ->
  B = <<16#f8,16#80,16#80,16#f0,16#80,16#80,16#f8,16#00,16#50,16#50>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(204) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#40,16#e0,16#00,16#40,16#80>>,
  gl:bitmap(3, 10, -1, 0, 6, 0, B);
char(205) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#40,16#e0,16#00,16#40,16#20>>,
  gl:bitmap(3, 10, -1, 0, 6, 0, B);
char(206) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#40,16#e0,16#00,16#90,16#60>>,
  gl:bitmap(4, 10, -1, 0, 6, 0, B);
char(207) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#40,16#e0,16#00,16#a0,16#a0>>,
  gl:bitmap(3, 10, -1, 0, 6, 0, B);
char(208) ->
  B = <<16#f0,16#48,16#48,16#48,16#e8,16#48,16#48,16#48,16#f0>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(209) ->
  B = <<16#88,16#88,16#98,16#a8,16#c8,16#88,16#88,16#00,16#50,16#28>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(210) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#70,16#00,16#20,16#40>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(211) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#70,16#00,16#20,16#10>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(212) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#70,16#00,16#48,16#30>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(213) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#70,16#00,16#50,16#28>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(214) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#70,16#00,16#50,16#50>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(215) ->
  B = <<16#88,16#50,16#20,16#50,16#88>>,
  gl:bitmap(5, 5, 0, -1, 6, 0, B);
char(216) ->
  B = <<16#80,16#70,16#c8,16#c8,16#a8,16#a8,16#a8,16#98,16#98,16#70,16#08>>,
  gl:bitmap(5, 11, 0, 1, 6, 0, B);
char(217) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#88,16#00,16#20,16#40>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(218) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#88,16#00,16#20,16#10>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(219) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#88,16#00,16#48,16#30>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(220) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#88,16#88,16#00,16#50,16#50>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(221) ->
  B = <<16#20,16#20,16#20,16#20,16#50,16#88,16#88,16#00,16#20,16#10>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(222) ->
  B = <<16#80,16#80,16#80,16#f0,16#88,16#88,16#88,16#f0,16#80>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(223) ->
  B = <<16#b0,16#88,16#88,16#90,16#a0,16#a0,16#90,16#90,16#60>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(224) ->
  B = <<16#68,16#98,16#88,16#78,16#08,16#70,16#00,16#20,16#40>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(225) ->
  B = <<16#68,16#98,16#88,16#78,16#08,16#70,16#00,16#20,16#10>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(226) ->
  B = <<16#68,16#98,16#88,16#78,16#08,16#70,16#00,16#48,16#30>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(227) ->
  B = <<16#68,16#98,16#88,16#78,16#08,16#70,16#00,16#50,16#28>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(228) ->
  B = <<16#68,16#98,16#88,16#78,16#08,16#70,16#00,16#50,16#50>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(229) ->
  B = <<16#68,16#98,16#88,16#78,16#08,16#70,16#00,16#30,16#48,16#30>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(230) ->
  B = <<16#50,16#a8,16#a0,16#70,16#28,16#70>>,
  gl:bitmap(5, 6, 0, 0, 6, 0, B);
char(231) ->
  B = <<16#40,16#20,16#70,16#88,16#80,16#80,16#88,16#70>>,
  gl:bitmap(5, 8, 0, 2, 6, 0, B);
char(232) ->
  B = <<16#70,16#88,16#80,16#f8,16#88,16#70,16#00,16#20,16#40>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(233) ->
  B = <<16#70,16#88,16#80,16#f8,16#88,16#70,16#00,16#20,16#10>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(234) ->
  B = <<16#70,16#88,16#80,16#f8,16#88,16#70,16#00,16#48,16#30>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(235) ->
  B = <<16#70,16#88,16#80,16#f8,16#88,16#70,16#00,16#50,16#50>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(236) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#c0,16#00,16#40,16#80>>,
  gl:bitmap(3, 9, -1, 0, 6, 0, B);
char(237) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#c0,16#00,16#40,16#20>>,
  gl:bitmap(3, 9, -1, 0, 6, 0, B);
char(238) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#c0,16#00,16#90,16#60>>,
  gl:bitmap(4, 9, -1, 0, 6, 0, B);
char(239) ->
  B = <<16#e0,16#40,16#40,16#40,16#40,16#c0,16#00,16#a0,16#a0>>,
  gl:bitmap(3, 9, -1, 0, 6, 0, B);
char(240) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#70,16#10,16#60,16#20,16#50>>,
  gl:bitmap(5, 10, 0, 0, 6, 0, B);
char(241) ->
  B = <<16#88,16#88,16#88,16#88,16#c8,16#b0,16#00,16#50,16#28>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(242) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#70,16#00,16#20,16#40>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(243) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#70,16#00,16#20,16#10>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(244) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#70,16#00,16#48,16#30>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(245) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#70,16#00,16#50,16#28>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(246) ->
  B = <<16#70,16#88,16#88,16#88,16#88,16#70,16#00,16#50,16#50>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(247) ->
  B = <<16#20,16#20,16#00,16#f8,16#00,16#20,16#20>>,
  gl:bitmap(5, 7, 0, -1, 6, 0, B);
char(248) ->
  B = <<16#80,16#70,16#c8,16#a8,16#a8,16#98,16#70,16#08>>,
  gl:bitmap(5, 8, 0, 1, 6, 0, B);
char(249) ->
  B = <<16#68,16#98,16#88,16#88,16#88,16#88,16#00,16#20,16#40>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(250) ->
  B = <<16#68,16#98,16#88,16#88,16#88,16#88,16#00,16#20,16#10>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(251) ->
  B = <<16#68,16#98,16#88,16#88,16#88,16#88,16#00,16#48,16#30>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(252) ->
  B = <<16#68,16#98,16#88,16#88,16#88,16#88,16#00,16#50,16#50>>,
  gl:bitmap(5, 9, 0, 0, 6, 0, B);
char(253) ->
  B = <<16#70,16#88,16#08,16#68,16#98,16#88,16#88,16#88,16#00,16#20,16#10>>,
  gl:bitmap(5, 11, 0, 2, 6, 0, B);
char(254) ->
  B = <<16#80,16#80,16#b0,16#c8,16#88,16#88,16#c8,16#b0,16#80,16#80>>,
  gl:bitmap(5, 10, 0, 2, 6, 0, B);
char(255) ->
  B = <<16#70,16#88,16#08,16#68,16#98,16#88,16#88,16#88,16#00,16#50,16#50>>,
  gl:bitmap(5, 11, 0, 2, 6, 0, B).
