1. ВВЕДЕНИЕ

Wine - это программа, которая позволяет запускать программы Microsoft
Windows (включая DOS, Windows 3.x и Win32) на Unix. Она состоит из
программы загрузки, которая загружает и выполняет программы Microsoft
Windows, и библиотеки (Winelib), которая реализует вызовы Windows API,
используя их Unix- или X11-эквиваленты. Библиотека также может быть
использована для портирования кода Win32 в среду Unix.

Wine - свободное программное обеспечение, опубликованное по лицензии
GNU LGPL; смотрите файл LICENSE.


2. БЫСТРЫЙ СТАРТ

Каждый раз, когда вы компилируете исходный код, рекомендуется использовать
Wine Installer для компоновки и установки Wine. В каталоге, содержащем
исходный код Wine (в ней находится этот файл), введите:

./tools/wineinstall

Запустите программу как "wine program". Источники дополнительной информации
перечислены в конце этого файла. Ознакомьтесь с руководством по Wine,
а также с сайтом http://www.winehq.org.


3. ТРЕБОВАНИЯ

Компиляция и запуск Wine поддерживается в следующих операционных системах:

  Linux версии 2.0.36 или более новой
  FreeBSD 7.0 или более новой
  Solaris x86 9 или более новой
  NetBSD-текущей версии
  Mac OS X 10.4 или более новой

Так как Wine требует для запуска поддержку потоков на уровне ядра, поддерживаются
только операционные системы, перечисленные выше. Другие операционные системы,
с поддержкой многопоточности ядром, могут поддерживаться Wine в будущем.

Linux:
  Linux 2.2.x: должен работать; Linux 2.0.x: может работать
  (версии старше 2.0.x версии вызывают сбой системы),
  Лучше использовать текущую версию ядра 2.4.x или 2.6.x.

FreeBSD:
  Wine не будет работать как следует на версиях ниже, чем FreeBSD
  7.0. Для FreeBSD 6.3 есть патч, позволяющий Wine запускаться. Посетите
  <http://wiki.freebsd.org/Wine> для дополнительной информации.

Solaris:
  Лучше всего компоновать Wine инструментами GNU
  (gcc, gas, и т.д.). Внимание: установка gas *НЕ* гарантирует
  что gcc будет его использовать. Необходимо перекомпилировать gcc после
  установки gas или создать ссылку на cc, как и на ld в инструментах gnu. (?)

NetBSD:
  Убедитесь что, параметры USER_LDT, SYSVSHM, SYSVSEM и SYSVMSG
  включены в вашем ядре.

Mac OS X:
  Вам нужен Xcode 2.4 или более новый для компоновки x86.


Поддерживаемые файловые системы:
  Wine должен работать на большинстве файловых систем. При использовании файлов
  через Samba возможны некоторые проблемы с совместимостью. NTFS не обладает
  необходимой функциональностью для запуска некоторых приложений.
  Рекомендуется использовать файловые системы Linux, такие как ext3.

Базовые требования:
  У вас должны быть установлены заголовочные файлы X11
  (xlib6g-dev в Debian и XFree86-devel в Red Hat).

  Разумеется, вам необходим "make" (лучше всего использовать GNU make).

  Вам также понадобятся flex (версии 2.5 или старше) и bison.

Поддержка дополнительных библиотек:
  Конфигурационный скрипт выведет список дополнительных библиотек, которые не были
  найдены в вашей системе. Ознакомьтесь с перечнем необходимых пакетов по адресу
  http://wiki.winehq.org/Recommended_Packages.

  На 64-битных платформах вы должны убедиться, что у вас установлены 32-битные
  версии этих библиотек; за более подробной информацией обратитесь к
  http://wiki.winehq.org/WineOn64bit.

4. КОМПИЛЯЦИЯ

Если вы не хотите использовать wineinstall, введите следующие команды
для компоновки Wine:

./configure
make depend
make

Это скомпонует программу "wine" и остальные библиотеки и бинарные файлы,
необходимые для работы Wine.
Программа "wine" будет загружать, и выполнять программы Windows.
Библиотека "libwine" ("Winelib") может быть использована для компилирования и
компоновки исходного кода Windows под Unix.

Для вывода конфигурационных настроек введите ./configure --help.

Для обновления до нового релиза используя патч, сначала перейдите в
корневой каталог релиза (он содержит README файл).
Затем введите "make clean" и пропачьте релиз:

    bunzip2 -c patch-file | patch -p1

где "patch-file" - имя файла с патчем (что-то вроде
wine-1.0.x.diff.bz2). Затем введите "./configure", и после этого
"make depend && make".


5. УСТАНОВКА

После того как, Wine будет успешно скомпонован, введите "make install"; это
установит исполняемые файлы wine, руководство Wine и некоторые
необходимые файлы.

Сначала не забудьте удалить любые конфликтующие предыдущие установки Wine.
Попробуйте "dpkg -r wine" или "rpm -e wine" или "make uninstall"
до установки.

После установки запустите конфигурационную программу "winecfg". Посетите
Службу поддержки на http://www.winehq.org/, если возникнут вопросы по конфигурации.


6. ЗАПУСК ПРОГРАММ

Вы можете указывать путь до файла или только имя файла.

Например: запуск Блокнота:

	wine notepad		   (используя пути, сохранённые
	wine notepad.exe	    в реестре, для нахождения файла)

	wine c:\\windows\\notepad.exe  (используя синтаксис DOS)

	wine ~/.wine/drive_c/windows/notepad.exe  (используя синтаксис Unix)

        wine notepad.exe /parameter1 -parameter2 parameter3
				   (вызов программы с параметрами)

Wine находится в процессе разработки, поэтому некоторые программы могут
вызывать ошибки. Во время ошибки вы будете перенаправлены в отладчик для того,
чтобы вы могли исследовать и решить проблему. Для подробной информации,
прочтите главу Отладка в Wine Developer's Guide.


7. ПОЛУЧЕНИЕ ДОПОЛНИТЕЛЬНОЙ ИНФОРМАЦИИ

WWW:	 Много информации о Wine доступно в WineHQ на
	 http://www.winehq.org/: различные руководства Wine, база данных приложений,
	 база данных ошибок. Вероятно лучше всего начать с этого сайта.

FAQ:	 Wine FAQ расположен на http://www.winehq.org/FAQ

Usenet:	 Вы можете обсудить выпуски Wine и получить помощь
	 на comp.emulators.ms-windows.wine.

Ошибки:	 Сообщайте об ошибках в Wine Bugzilla на http://bugs.winehq.org
	 Прежде чем отправлять сообщение об ошибке проверьте, может эта ошибка
	 уже найдена. Вы также можете отправлять сообщения об ошибках на
         comp.emulators.ms-windows.wine.

IRC:	 Онлайн помощь доступна на канале #WineHQ на irc.freenode.net.

Git:	 Текущие разработки Wine доступны через Git.
	 Смотрите http://www.winehq.org/site/git для дополнительной информации.

Рассылки:
	 Имеется несколько рассылок для пользователей и разработчиков Wine;
	 смотрите http://www.winehq.org/forums для дополнительной информации.

Wiki:	 Wine Wiki расположен на http://wiki.winehq.org

Если вы что-то добавили или исправили ошибку, пришлите патч (в формате 'diff -u')
на wine-patches@winehq.org для его включения в следующий релиз.

--
Alexandre Julliard
julliard@winehq.org

Перевели на русский язык
Владимир Панкратов
scriptkid@mail.ru
Виталий Липатов
lav@etersoft.ru
