# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
# Copyright 2012 Canonical
# Author: Thomi Richards
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.

from __future__ import print_function
import logging
from PyQt4 import QtGui
from PyQt4 import QtCore
import sys

from windowmocker.plugins.base import ApplicationTypePluginBase


logger = logging.getLogger(__name__)

class QtPlugin(ApplicationTypePluginBase):

    Name = "Qt4"

    def create_application(self):
        self.app = QtGui.QApplication(sys.argv[:1])

    def create_window(self, window_spec):
        win = QtGui.QMainWindow()
        win.setWindowTitle(window_spec["Title"])

        if 'Menu' in window_spec:
            menu_bar = win.menuBar()
            self._create_menus(menu_bar, window_spec['Menu'])

        if window_spec['Maximized']:
            win.showMaximized()
        if window_spec['Minimized']:
            win.showMinimized()

        if not window_spec['Maximized'] and not window_spec['Minimized']:
            win.showNormal()

        # In some cases, it's also needed to have the appliaction start normally
        # but minimize itself right after starting
        if window_spec['MinimizeImmediatelyAfterShow']:
            win.setWindowState(QtCore.Qt.WindowMinimized)

        if not getattr(self, 'windows', None):
            self.windows = []
        self.windows.append(win)

    def _create_menus(self, parent, menu_spec):
        for item in menu_spec:
            if type(item) is dict:
                title = item.get('Title', 'Default Title')
                menu = parent.addMenu(title)
                if 'Menu' in item:
                    self._create_menus(menu, item['Menu'])
            elif isinstance(item, basestring):
                parent.addAction(item)
            else:
                logger.error("Invalid menu item - is not a dict or string: %r", item)

    def run(self):
        self.app.exec_()
