/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import rene.dialogs.FileListFinder;
import rene.dialogs.SearchFileThread;
import rene.gui.ButtonAction;
import rene.gui.CheckboxAction;
import rene.gui.CloseDialog;
import rene.gui.DoActionListener;
import rene.gui.Global;
import rene.gui.HistoryTextField;
import rene.gui.MyLabel;
import rene.gui.MyList;
import rene.gui.MyPanel;
import rene.gui.Panel3D;
import rene.util.FileList;

public class SearchFileDialog
extends CloseDialog
implements Runnable,
Enumeration {
    HistoryTextField Dir;
    HistoryTextField Pattern;
    MyList L;
    public static int ListNumber = Global.getParameter("searchfile.number", 10);
    String Result = null;
    Button ActionButton;
    Button CloseButton;
    Button SearchButton;
    Button SearchrekButton;
    public FileList F = null;
    public boolean Abort = true;
    Checkbox Mod;
    Thread Run;
    String[] S;
    int Sn;

    public SearchFileDialog(Frame frame, String string, String string2, boolean bl) {
        super(frame, Global.name("searchfile.title"), true);
        this.setLayout(new BorderLayout());
        MyPanel myPanel = new MyPanel();
        myPanel.setLayout(new BorderLayout());
        MyPanel myPanel2 = new MyPanel();
        myPanel2.setLayout(new BorderLayout());
        MyPanel myPanel3 = new MyPanel();
        myPanel3.setLayout(new GridLayout(0, 2));
        myPanel3.add(new MyLabel(Global.name("searchfile.directory")));
        this.Dir = new HistoryTextField((DoActionListener)this, "Dir", 20);
        myPanel3.add(this.Dir);
        this.Dir.setText(".");
        myPanel3.add(new MyLabel(Global.name("searchfile.pattern")));
        this.Pattern = new HistoryTextField((DoActionListener)this, "TextAction", 20);
        myPanel3.add(this.Pattern);
        myPanel2.add("Center", myPanel3);
        MyPanel myPanel4 = new MyPanel();
        this.SearchButton = new ButtonAction(this, Global.name("searchfile.search"), "Search");
        myPanel4.add(this.SearchButton);
        this.SearchrekButton = new ButtonAction(this, Global.name("searchfile.searchrek"), "SearchRek");
        myPanel4.add(this.SearchrekButton);
        myPanel2.add("South", myPanel4);
        myPanel.add("North", myPanel2);
        this.add("North", new Panel3D(myPanel));
        this.L = new MyList(ListNumber);
        this.add("Center", new Panel3D(this.L));
        this.L.addActionListener(this);
        this.L.setMultipleMode(true);
        MyPanel myPanel5 = new MyPanel();
        myPanel5.setLayout(new FlowLayout(2));
        if (!string2.equals("")) {
            this.Mod = new CheckboxAction(this, string2, "");
            myPanel5.add(this.Mod);
            this.Mod.setState(bl);
        }
        this.ActionButton = new ButtonAction(this, string, "Action");
        myPanel5.add(this.ActionButton);
        this.CloseButton = new ButtonAction(this, Global.name("abort"), "Close");
        myPanel5.add(this.CloseButton);
        this.add("South", new Panel3D(myPanel5));
        this.pack();
        this.Dir.loadHistory("searchfile.dir");
        this.Pattern.loadHistory("searchfile.pattern");
        this.setSize("searchfiledialog");
        this.addKeyListener(this);
        this.Dir.addKeyListener(this);
        this.Pattern.addKeyListener(this);
    }

    public SearchFileDialog(Frame frame, String string) {
        this(frame, string, "", false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.L) {
            this.action();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void doAction(String string) {
        this.Result = null;
        if (string.equals("SearchRek")) {
            this.search(true);
        } else if (string.equals("Search")) {
            this.search(false);
        } else if (string.equals("TextAction")) {
            this.L.removeAll();
            this.action();
        } else if (string.equals("Action")) {
            this.action();
        } else if (string.equals("Help")) {
            this.help();
        } else if (string.equals("Close")) {
            this.Abort = true;
            this.doclose();
        }
    }

    public void help() {
    }

    public void search(boolean bl) {
        this.saveHistory();
        if (this.Run != null && this.Run.isAlive()) {
            return;
        }
        this.Run = new SearchFileThread(this, this.L, this.Dir.getText(), this.Pattern.getText(), bl);
        this.Run.start();
    }

    public void action() {
        this.saveHistory();
        if (this.Run != null && this.Run.isAlive()) {
            return;
        }
        this.Run = new Thread(this);
        this.Run.start();
    }

    public void enableButtons(boolean bl) {
        this.Pattern.setEnabled(bl);
        this.SearchButton.setEnabled(bl);
        this.SearchrekButton.setEnabled(bl);
        this.ActionButton.setEnabled(bl);
    }

    public void run() {
        this.Result = null;
        this.enableButtons(false);
        if (this.L.getItemCount() > 0) {
            int n = this.L.getSelectedIndex();
            this.Result = n > 0 ? this.L.getItem(n) : this.L.getItem(0);
        } else {
            FileListFinder fileListFinder = new FileListFinder(this.Dir.getText(), this.Pattern.getText(), true);
            this.F = fileListFinder;
            fileListFinder.search();
            this.Result = fileListFinder.getResult();
        }
        this.enableButtons(true);
        this.Abort = false;
        this.doclose();
    }

    public String getResult() {
        return this.Result;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.Pattern.requestFocus();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.enableButtons(true);
        }
        super.setVisible(bl);
    }

    public boolean close() {
        this.Abort = true;
        return true;
    }

    public void doclose() {
        if (this.F != null) {
            this.F.stopIt();
        }
        this.Dir.saveHistory("searchfile.dir");
        this.Pattern.saveHistory("searchfile.pattern");
        this.noteSize("searchfiledialog");
        super.doclose();
    }

    public void saveHistory() {
        this.Dir.remember();
        this.Pattern.remember();
    }

    public void setPattern(String string) {
        this.Pattern.setText(string);
    }

    public Enumeration getFiles() {
        this.S = this.L.getSelectedItems();
        this.Sn = 0;
        return this;
    }

    public boolean hasMoreElements() {
        return this.Sn < this.S.length;
    }

    public Object nextElement() {
        if (this.Sn >= this.S.length) {
            return null;
        }
        String string = this.S[this.Sn];
        ++this.Sn;
        return string;
    }

    public boolean isAborted() {
        return this.Abort;
    }

    public void deselectAll() {
        for (int i = this.L.getItemCount() - 1; i >= 0; --i) {
            this.L.deselect(i);
        }
    }

    public boolean isModified() {
        return this.Mod.getState();
    }
}

