/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.AddressField;
import SharpTools.CellPoint;
import SharpTools.CellRange;
import SharpTools.NumberField;
import SharpTools.SharpDialog;
import SharpTools.SharpOptionPane;
import SharpTools.SharpTools;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public final class HistoDialog
extends SharpDialog {
    private JFrame owner;
    private JTextField title;
    private AddressField startCell;
    private AddressField endCell;
    private NumberField startValue;
    private NumberField endValue;
    private NumberField bucket;
    private NumberField xMin;
    private NumberField xMax;
    private NumberField xUnit;
    private NumberField yMin;
    private NumberField yMax;
    private NumberField yUnit;
    private JRadioButton percentageButton;
    private JRadioButton countButton;
    final ImageIcon histogramIcon32 = new ImageIcon(this.getClass().getResource("/images/chart32.gif"));
    private static final String bucketstring = SharpTools.translation.getProperty("Bucket_Size");
    private static final String startvaluestring = SharpTools.translation.getProperty("Start_Value");
    private static final String endvaluestring = SharpTools.translation.getProperty("End_Value");
    private static final String xunitstring = SharpTools.translation.getProperty("X_Unit");
    private static final String yunitstring = SharpTools.translation.getProperty("Y_Unit");
    private static final String xminstring = SharpTools.translation.getProperty("X_Start");
    private static final String xmaxstring = SharpTools.translation.getProperty("X_End");
    private static final String yminstring = SharpTools.translation.getProperty("Y_Start");
    private static final String ymaxstring = SharpTools.translation.getProperty("Y_End");

    HistoDialog(JFrame aFrame) {
        super(aFrame, "Histogram Options", true);
        this.owner = aFrame;
        this.title = new JTextField(10);
        this.startCell = new AddressField(5);
        this.endCell = new AddressField(5);
        this.startValue = new NumberField(5);
        this.endValue = new NumberField(5);
        this.bucket = new NumberField(5, true);
        this.xMin = new NumberField(5);
        this.xMax = new NumberField(5);
        this.xUnit = new NumberField(5, true);
        this.yMin = new NumberField(5);
        this.yMax = new NumberField(5);
        this.yUnit = new NumberField(5, true);
        this.startCell.setToolTipText(SharpTools.translation.getProperty("Start_cell"));
        this.endCell.setToolTipText(SharpTools.translation.getProperty("End_cell"));
        this.startValue.setToolTipText(SharpTools.translation.getProperty("Start_value"));
        this.endValue.setToolTipText(SharpTools.translation.getProperty("End_value"));
        this.xMin.setToolTipText(SharpTools.translation.getProperty("Minumum_value_on_X_axis"));
        this.xMax.setToolTipText(SharpTools.translation.getProperty("Maximum_value_on_X_axis"));
        this.xUnit.setToolTipText(SharpTools.translation.getProperty("Unit_on_X_axis"));
        this.yMin.setToolTipText(SharpTools.translation.getProperty("Minumum_value_on_Y_axis"));
        this.yMax.setToolTipText(SharpTools.translation.getProperty("Maximum_value_on_Y_axis"));
        this.yUnit.setToolTipText(SharpTools.translation.getProperty("Unit_on_Y_axis"));
        JPanel east = new JPanel();
        east.setLayout(new BoxLayout(east, 1));
        east.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        JPanel textPanel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel(SharpTools.translation.getProperty("Chart_Title") + " : ");
        label.setLabelFor(this.title);
        label.setDisplayedMnemonic(84);
        textPanel.add(label);
        textPanel.add(this.title);
        east.add(textPanel);
        textPanel = new JPanel(new FlowLayout(0));
        textPanel.add(new JSeparator());
        east.add(textPanel);
        textPanel = new JPanel(new FlowLayout(0));
        label = new JLabel(SharpTools.translation.getProperty("Cell_Range") + " : ");
        label.setLabelFor(this.startCell);
        label.setDisplayedMnemonic(67);
        textPanel.add(label);
        textPanel.add(this.startCell);
        textPanel.add(new JLabel(":"));
        textPanel.add(this.endCell);
        east.add(textPanel);
        textPanel = new JPanel(new FlowLayout(0));
        label = new JLabel(SharpTools.translation.getProperty("Value_Range") + " : ");
        label.setLabelFor(this.startValue);
        label.setDisplayedMnemonic(86);
        textPanel.add(label);
        textPanel.add(this.startValue);
        label = new JLabel(" " + SharpTools.translation.getProperty("to") + " ");
        label.setLabelFor(this.endValue);
        textPanel.add(label);
        textPanel.add(this.endValue);
        east.add(textPanel);
        label = new JLabel("   " + SharpTools.translation.getProperty("Bucket") + "  ");
        label.setLabelFor(this.bucket);
        label.setDisplayedMnemonic(66);
        textPanel.add(label);
        textPanel.add(this.bucket);
        east.add(textPanel);
        textPanel = new JPanel(new FlowLayout(0));
        textPanel.add(new JSeparator());
        east.add(textPanel);
        textPanel = new JPanel(new FlowLayout(0));
        label = new JLabel(SharpTools.translation.getProperty("X_Scale") + " : ");
        label.setLabelFor(this.xMin);
        label.setDisplayedMnemonic(88);
        textPanel.add(label);
        textPanel.add(this.xMin);
        label = new JLabel(" " + SharpTools.translation.getProperty("to") + " ");
        label.setLabelFor(this.xMax);
        textPanel.add(label);
        textPanel.add(this.xMax);
        label = new JLabel(" " + SharpTools.translation.getProperty("Unit") + " ");
        label.setLabelFor(this.xUnit);
        label.setDisplayedMnemonic(85);
        textPanel.add(label);
        textPanel.add(this.xUnit);
        east.add(textPanel);
        textPanel = new JPanel(new FlowLayout(0));
        label = new JLabel(SharpTools.translation.getProperty("Y_Scale") + " : ");
        label.setLabelFor(this.yMin);
        label.setDisplayedMnemonic(89);
        textPanel.add(label);
        textPanel.add(this.yMin);
        label = new JLabel(" " + SharpTools.translation.getProperty("to") + " ");
        label.setLabelFor(this.yMax);
        textPanel.add(label);
        textPanel.add(this.yMax);
        label = new JLabel(" " + SharpTools.translation.getProperty("Unit") + " ");
        label.setLabelFor(this.yUnit);
        label.setDisplayedMnemonic(78);
        textPanel.add(label);
        textPanel.add(this.yUnit);
        east.add(textPanel);
        textPanel = new JPanel(new FlowLayout(0));
        textPanel.add(new JSeparator());
        east.add(textPanel);
        textPanel = new JPanel();
        textPanel.setLayout(new FlowLayout(0));
        ButtonGroup metric = new ButtonGroup();
        this.percentageButton = new JRadioButton(SharpTools.translation.getProperty("percentage"));
        this.percentageButton.setMnemonic(80);
        metric.add(this.percentageButton);
        label = new JLabel(SharpTools.translation.getProperty("Display_Y_by") + " ");
        textPanel.add(label);
        textPanel.add(this.percentageButton);
        this.countButton = new JRadioButton(SharpTools.translation.getProperty("Count"));
        this.countButton.setMnemonic(79);
        metric.add(this.countButton);
        textPanel.add(this.countButton);
        east.add(textPanel);
        this.setOptionPane(east, -1, 2, this.histogramIcon32);
        this.setDefaultCloseOperation(2);
        this.startCell.requestFocus();
    }

    private boolean validateInput() {
        if (!this.addressOK(this.startCell, SharpTools.translation.getProperty("Start_Cell"))) {
            return false;
        }
        if (!this.addressOK(this.endCell, SharpTools.translation.getProperty("End_Cell"))) {
            return false;
        }
        if (!this.orderOK(this.startValue, this.endValue, startvaluestring, endvaluestring)) {
            return false;
        }
        if (!this.orderOK(this.xMin, this.xMax, xminstring, xmaxstring)) {
            return false;
        }
        if (!this.orderOK(this.yMin, this.yMax, yminstring, ymaxstring)) {
            return false;
        }
        if (this.isNegative(this.bucket, bucketstring)) {
            return false;
        }
        if (this.isNegative(this.xUnit, xunitstring)) {
            return false;
        }
        return !this.isNegative(this.yUnit, yunitstring);
    }

    private boolean isNegative(NumberField field, String name) {
        Float f = field.getNumber();
        if (f == null || f.floatValue() <= 0.0f) {
            this.invalidInput(name);
            field.selectAll();
            field.requestFocus();
            return true;
        }
        return false;
    }

    private boolean orderOK(NumberField start, NumberField end, String startname, String endname) {
        Float f1 = start.getNumber();
        if (f1 == null) {
            this.invalidInput(startname);
            start.selectAll();
            start.requestFocus();
            return false;
        }
        Float f2 = end.getNumber();
        if (f2 == null) {
            this.invalidInput(endname);
            end.selectAll();
            end.requestFocus();
            return false;
        }
        if (f1.floatValue() > f2.floatValue()) {
            start.setNumber(f2);
            end.setNumber(f1);
        }
        return true;
    }

    private boolean addressOK(AddressField field, String name) {
        CellPoint addr = field.getAddress();
        if (addr == null) {
            this.invalidInput(name);
            field.selectAll();
            field.requestFocus();
            return false;
        }
        return true;
    }

    public void setTitleField(String s) {
        this.title.setText(s);
        this.setTitle(SharpTools.translation.getProperty("Options") + "-" + s);
    }

    public String getTitleField() {
        return this.title.getText();
    }

    public void setCellRange(CellRange range) {
        if (range != null) {
            this.startCell.setAddress(range.getminCorner());
            this.endCell.setAddress(range.getmaxCorner());
        }
    }

    public CellRange getCellRange() {
        CellPoint point1 = this.startCell.getAddress();
        CellPoint point2 = this.endCell.getAddress();
        if (point1 == null || point2 == null) {
            return null;
        }
        int minrow = Math.min(point1.getRow(), point2.getRow());
        int maxrow = Math.max(point1.getRow(), point2.getRow());
        int mincol = Math.min(point1.getCol(), point2.getCol());
        int maxcol = Math.max(point1.getCol(), point2.getCol());
        return new CellRange(minrow, maxrow, mincol, maxcol);
    }

    public CellPoint getStartCell() {
        return this.startCell.getAddress();
    }

    public void setStartCell(CellPoint addr) {
        this.startCell.setAddress(addr);
    }

    public CellPoint getEndCell() {
        return this.endCell.getAddress();
    }

    public void setEndCell(CellPoint addr) {
        this.endCell.setAddress(addr);
    }

    public Float getStartValue() {
        return this.startValue.getNumber();
    }

    public void setStartValue(Float f) {
        this.startValue.setNumber(f);
    }

    public Float getEndValue() {
        return this.endValue.getNumber();
    }

    public void setEndValue(Float f) {
        this.endValue.setNumber(f);
    }

    public Float getBucket() {
        return this.bucket.getNumber();
    }

    public void setBucket(Float f) {
        this.bucket.setNumber(f);
    }

    public Float getXMin() {
        return this.xMin.getNumber();
    }

    public void setXMin(Float f) {
        this.xMin.setNumber(f);
    }

    public Float getXMax() {
        return this.xMax.getNumber();
    }

    public void setXMax(Float f) {
        this.xMax.setNumber(f);
    }

    public Float getXUnit() {
        return this.xUnit.getNumber();
    }

    public void setXUnit(Float f) {
        this.xUnit.setNumber(f);
    }

    public Float getYMin() {
        return this.yMin.getNumber();
    }

    public void setYMin(Float f) {
        this.yMin.setNumber(f);
    }

    public Float getYMax() {
        return this.yMax.getNumber();
    }

    public void setYMax(Float f) {
        this.yMax.setNumber(f);
    }

    public Float getYUnit() {
        return this.yUnit.getNumber();
    }

    public void setYUnit(Float f) {
        this.yUnit.setNumber(f);
    }

    public boolean getByPercentage() {
        return this.percentageButton.isSelected();
    }

    public void setByPercentage(boolean set) {
        this.percentageButton.setSelected(set);
        this.countButton.setSelected(!set);
    }

    private void invalidInput(String s) {
        SharpOptionPane.showMessageDialog(this.owner, SharpTools.translation.getProperty("Sorry"), SharpTools.translation.getProperty("Histogram"), 0, null);
    }

    protected boolean onOK() {
        return this.validateInput();
    }
}

