/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Viewer;

class StatusManager {
    private boolean allowStatusReporting;
    private Viewer viewer;
    private JmolStatusListener jmolStatusListener;
    private JmolCallbackListener jmolCallbackListener;
    private String statusList = "";
    private Hashtable messageQueue = new Hashtable();
    private int statusPtr = 0;
    private static int MAXIMUM_QUEUE_LENGTH = 16;
    private boolean asVector = true;
    private String[] jmolScriptCallbacks = new String[13];
    private int minSyncRepeatMs = 100;
    boolean syncingScripts = false;
    boolean syncingMouse = false;
    boolean drivingSync = false;
    boolean isSynced = false;
    boolean syncDisabled = false;
    boolean stereoSync = false;
    static final int SYNC_OFF = 0;
    static final int SYNC_DRIVER = 1;
    static final int SYNC_SLAVE = 2;
    static final int SYNC_DISABLE = 3;
    static final int SYNC_ENABLE = 4;
    static final int SYNC_STEREO = 5;

    StatusManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void setAllowStatusReporting(boolean bl) {
        this.allowStatusReporting = bl;
    }

    String getStatusList() {
        return this.statusList;
    }

    Hashtable getMessageQueue() {
        return this.messageQueue;
    }

    private boolean recordStatus(String string) {
        return this.allowStatusReporting && this.statusList.length() > 0 && (this.statusList.equals("all") || this.statusList.indexOf(string) >= 0);
    }

    private synchronized void setStatusChanged(String string, int n, Object object, boolean bl) {
        Vector vector;
        if (!this.recordStatus(string)) {
            return;
        }
        ++this.statusPtr;
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(new Integer(this.statusPtr));
        vector2.addElement(string);
        vector2.addElement(new Integer(n));
        vector2.addElement(object);
        if (bl && this.messageQueue.containsKey(string)) {
            this.messageQueue.remove(string);
        }
        if ((vector = this.messageQueue.containsKey(string) ? (Vector)this.messageQueue.remove(string) : new Vector()).size() == MAXIMUM_QUEUE_LENGTH) {
            vector.removeElementAt(0);
        }
        vector.addElement(vector2);
        this.messageQueue.put(string, vector);
    }

    synchronized Object getStatusChanged(String string) {
        if (string.indexOf("AS_") == 0) {
            this.asVector = string.indexOf("VECTOR") == 3;
            return string;
        }
        Cloneable cloneable = this.asVector ? new Vector() : new Hashtable();
        if (this.resetMessageQueue(string)) {
            return cloneable;
        }
        Enumeration enumeration = this.messageQueue.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Object v = this.messageQueue.remove(string2);
            if (this.asVector) {
                ((Vector)cloneable).addElement(v);
                continue;
            }
            ((Hashtable)cloneable).put(string2, v);
        }
        return cloneable;
    }

    private synchronized boolean resetMessageQueue(String string) {
        boolean bl = string.length() > 0 && string.charAt(0) == '-';
        boolean bl2 = string.length() > 0 && string.charAt(0) == '+';
        String string2 = this.statusList;
        if (bl) {
            this.statusList = TextFormat.simpleReplace(string2, string.substring(1, string.length()), "");
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            return true;
        }
        if (string2.equals(string = TextFormat.simpleReplace(string, "+", "")) || bl2 && string2.indexOf(string) >= 0) {
            return false;
        }
        if (!bl2) {
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            this.statusList = "";
        }
        this.statusList = this.statusList + string;
        if (Logger.debugging) {
            Logger.debug(string2 + "\nmessageQueue = " + this.statusList);
        }
        return true;
    }

    synchronized void setJmolStatusListener(JmolStatusListener jmolStatusListener, JmolCallbackListener jmolCallbackListener) {
        this.jmolStatusListener = jmolStatusListener;
        this.jmolCallbackListener = jmolCallbackListener == null ? jmolStatusListener : jmolCallbackListener;
    }

    synchronized void setJmolCallbackListener(JmolCallbackListener jmolCallbackListener) {
        this.jmolCallbackListener = jmolCallbackListener;
    }

    private String jmolScriptCallback(int n) {
        String string = this.jmolScriptCallbacks[n];
        if (string != null) {
            this.viewer.evalStringQuiet(string, true, false);
        }
        return string;
    }

    synchronized void setCallbackFunction(String string, String string2) {
        int n = JmolConstants.getCallbackId(string);
        if (n >= 0) {
            int n2 = string2 == null ? 0 : (string2.length() > 7 && string2.toLowerCase().indexOf("script:") == 0 ? 7 : (string2.length() > 11 && string2.toLowerCase().indexOf("jmolscript:") == 0 ? 11 : 0));
            String string3 = this.jmolScriptCallbacks[n] = n2 == 0 ? null : string2.substring(n2).trim();
        }
        if (this.jmolCallbackListener != null) {
            this.jmolCallbackListener.setCallbackFunction(string, string2);
        }
    }

    private boolean notifyEnabled(int n) {
        return this.jmolCallbackListener != null && this.jmolCallbackListener.notifyEnabled(n);
    }

    synchronized void setStatusAtomPicked(int n, String string) {
        String string2 = this.jmolScriptCallback(9);
        Logger.info("setStatusAtomPicked(" + n + "," + string + ")");
        this.setStatusChanged("atomPicked", n, string, false);
        if (this.notifyEnabled(9)) {
            this.jmolCallbackListener.notifyCallback(9, new Object[]{string2, string, new Integer(n)});
        }
    }

    synchronized void setStatusResized(int n, int n2) {
        String string = this.jmolScriptCallback(10);
        if (this.notifyEnabled(10)) {
            this.jmolCallbackListener.notifyCallback(10, new Object[]{string, new Integer(n), new Integer(n2)});
        }
    }

    synchronized void setStatusAtomHovered(int n, String string) {
        String string2 = this.jmolScriptCallback(4);
        if (this.notifyEnabled(4)) {
            this.jmolCallbackListener.notifyCallback(4, new Object[]{string2, string, new Integer(n)});
        }
    }

    synchronized void setFileLoadStatus(String string, String string2, String string3, String string4, int n, boolean bl) {
        this.setStatusChanged("fileLoaded", n, string, false);
        if (string4 != null) {
            this.setStatusChanged("fileLoadError", n, string4, false);
        }
        String string5 = this.jmolScriptCallback(5);
        if (bl && this.notifyEnabled(5)) {
            this.jmolCallbackListener.notifyCallback(5, new Object[]{string5, string, string2, string3, string4, new Integer(n)});
        }
    }

    synchronized void setStatusFrameChanged(int n, int n2, int n3, int n4, int n5) {
        if (this.viewer.getModelSet() == null) {
            return;
        }
        boolean bl = n <= -2;
        int n6 = n;
        if (bl) {
            n6 = -2 - n6;
        }
        this.setStatusChanged("frameChanged", n, n6 >= 0 ? this.viewer.getModelNumberDotted(n6) : "", false);
        String string = this.jmolScriptCallback(0);
        if (this.notifyEnabled(0)) {
            this.jmolCallbackListener.notifyCallback(0, new Object[]{string, new int[]{n, n2, n3, n4, n5}});
        }
    }

    synchronized void setScriptEcho(String string, boolean bl) {
        if (string == null) {
            return;
        }
        this.setStatusChanged("scriptEcho", 0, string, false);
        String string2 = this.jmolScriptCallback(1);
        if (this.notifyEnabled(1)) {
            this.jmolCallbackListener.notifyCallback(1, new Object[]{string2, string, new Integer(bl ? 1 : 0)});
        }
    }

    synchronized void setStatusMeasuring(String string, int n, String string2) {
        this.setStatusChanged(string, n, string2, false);
        String string3 = null;
        if (string.equals("measureCompleted")) {
            Logger.info("measurement[" + n + "] = " + string2);
            string3 = this.jmolScriptCallback(6);
        } else if (string.equals("measurePicked")) {
            this.setStatusChanged("measurePicked", n, string2, false);
            Logger.info("measurePicked " + n + " " + string2);
        }
        if (this.notifyEnabled(6)) {
            this.jmolCallbackListener.notifyCallback(6, new Object[]{string3, string2, new Integer(n), string});
        }
    }

    synchronized void notifyError(String string, String string2, String string3) {
        String string4 = this.jmolScriptCallback(2);
        if (this.notifyEnabled(2)) {
            this.jmolCallbackListener.notifyCallback(2, new Object[]{string4, string, string2, this.viewer.getShapeErrorState(), string3});
        }
    }

    synchronized void notifyMinimizationStatus(String string, Integer n, Float f, Float f2) {
        String string2 = this.jmolScriptCallback(8);
        if (this.notifyEnabled(8)) {
            this.jmolCallbackListener.notifyCallback(8, new Object[]{string2, string, n, f, f2});
        }
    }

    synchronized void setScriptStatus(String string, String string2, int n, String string3) {
        boolean bl;
        if (n < -1) {
            int n2 = -2 - n;
            this.setStatusChanged("scriptStarted", n2, string2, false);
            string = "script " + n2 + " started";
        } else if (string == null) {
            return;
        }
        String string4 = n == 0 ? this.jmolScriptCallback(11) : null;
        boolean bl2 = bl = string == "Script completed";
        if (this.recordStatus("script")) {
            boolean bl3 = string3 != null;
            this.setStatusChanged(bl3 ? "scriptError" : "scriptStatus", 0, string, false);
            if (bl3 || bl) {
                this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (bl3 ? " unsuccessfully: " + string : " successfully"), false);
            }
        }
        if (this.jmolStatusListener != null) {
            if (bl && this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
                this.jmolCallbackListener.notifyCallback(11, new Object[]{null, "script <exiting>", string2, new Integer(-1), string3});
                string = "Jmol script completed.";
            }
            this.jmolCallbackListener.notifyCallback(11, new Object[]{string4, string, string2, new Integer(bl ? -1 : n), string3});
        }
    }

    boolean doSync() {
        return this.isSynced && this.drivingSync && !this.syncDisabled;
    }

    synchronized void setSync(String string) {
        if (this.syncingMouse) {
            if (string != null) {
                this.syncSend(string, "*");
            }
        } else if (!this.syncingScripts) {
            this.syncSend("!" + this.viewer.getMoveToText((float)this.minSyncRepeatMs / 1000.0f), "*");
        }
    }

    synchronized void popupMenu(int n, int n2) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.handlePopupMenu(n, n2);
        }
    }

    void setSyncDriver(int n) {
        if (this.stereoSync && n != 4) {
            this.syncSend("SET_GRAPHICS_OFF", "*");
            this.stereoSync = false;
        }
        switch (n) {
            case 4: {
                if (!this.syncDisabled) {
                    return;
                }
                this.syncDisabled = false;
                break;
            }
            case 3: {
                this.syncDisabled = true;
                break;
            }
            case 5: {
                this.drivingSync = true;
                this.isSynced = true;
                this.stereoSync = true;
                break;
            }
            case 1: {
                this.drivingSync = true;
                this.isSynced = true;
                break;
            }
            case 2: {
                this.drivingSync = false;
                this.isSynced = true;
                break;
            }
            default: {
                this.drivingSync = false;
                this.isSynced = false;
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.viewer.getHtmlName() + " sync mode=" + n + "; synced? " + this.isSynced + "; driving? " + this.drivingSync + "; disabled? " + this.syncDisabled);
        }
    }

    void syncSend(String string, String string2) {
        if (this.jmolStatusListener != null) {
            this.jmolCallbackListener.notifyCallback(12, new Object[]{null, string, string2});
        }
    }

    int getSyncMode() {
        return !this.isSynced ? 0 : (this.drivingSync ? 1 : 2);
    }

    synchronized void showUrl(String string) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showUrl(string);
        }
    }

    synchronized void clearConsole() {
        if (this.jmolStatusListener != null) {
            this.jmolCallbackListener.notifyCallback(7, null);
        }
    }

    synchronized void showConsole(boolean bl) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showConsole(bl);
        }
    }

    float[][] functionXY(String string, int n, int n2) {
        return this.jmolStatusListener == null ? new float[Math.abs(n)][Math.abs(n2)] : this.jmolStatusListener.functionXY(string, n, n2);
    }

    String jsEval(String string) {
        return this.jmolStatusListener == null ? "" : this.jmolStatusListener.eval(string);
    }

    String createImage(String string, String string2, Object object, int n) {
        if (this.jmolStatusListener == null) {
            return GT._("File creation failed.");
        }
        if (string != null && string.startsWith("?")) {
            string = string.substring(1);
            if (!this.viewer.isSignedApplet()) {
                string = this.dialogAsk(n == Integer.MIN_VALUE ? "save" : "saveImage", string);
            }
        }
        if (string == null) {
            return null;
        }
        return this.jmolStatusListener.createImage(string, string2, object, n);
    }

    Hashtable getRegistryInfo() {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.getRegistryInfo();
    }

    String dialogAsk(String string, String string2) {
        if (this.jmolStatusListener != null) {
            return this.jmolStatusListener.dialogAsk(string, string2);
        }
        return "";
    }

    String getMenu(String string) {
        return this.jmolStatusListener == null ? "" : this.jmolStatusListener.eval("_GET_MENU|" + string);
    }
}

