/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.popup.JmolPopupAwt;
import org.jmol.popup.JmolPopupSwing;
import org.jmol.popup.PopupResourceBundle;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

public abstract class JmolPopup {
    private static final boolean forceAwt = false;
    private static final boolean dumpList = false;
    JmolViewer viewer;
    Component jmolComponent;
    MenuItemListener mil;
    CheckboxMenuItemListener cmil;
    boolean asPopup = true;
    Hashtable htMenus = new Hashtable();
    Properties menuText = new Properties();
    Object frankPopup;
    int aboutComputedMenuBaseCount;
    String nullModelSetName;
    String modelSetName;
    String modelSetFileName;
    String modelSetRoot;
    Hashtable modelSetInfo;
    Hashtable modelInfo;
    Vector PDBOnly = new Vector();
    Vector UnitcellOnly = new Vector();
    Vector FramesOnly = new Vector();
    Vector VibrationOnly = new Vector();
    Vector SymmetryOnly = new Vector();
    Vector SignedOnly = new Vector();
    Vector AppletOnly = new Vector();
    Vector ChargesOnly = new Vector();
    Vector TemperatureOnly = new Vector();
    boolean isPDB;
    boolean isSymmetry;
    boolean isUnitCell;
    boolean isMultiFrame;
    boolean isMultiConfiguration;
    boolean isVibration;
    boolean isApplet;
    boolean isSigned;
    boolean isZapped;
    boolean haveCharges;
    boolean haveBFactors;
    String altlocs;
    int modelIndex;
    int modelCount;
    int atomCount;
    static final int MAX_ITEMS = 25;
    static final int TITLE_MAX_WIDTH = 20;
    static String menuStructure;
    static final int UPDATE_ALL = 0;
    static final int UPDATE_CONFIG = 1;
    static final int UPDATE_SHOW = 2;
    int updateMode;
    String group3List;
    int[] group3Counts;
    String configurationSelected = "";
    Hashtable htCheckbox = new Hashtable();
    String currentMenuItemId = null;
    int thisx;
    int thisy;
    Object[][] frankList = new Object[10][];
    int nFrankList = 0;
    String currentFrankId = null;

    JmolPopup(JmolViewer jmolViewer, boolean bl) {
        this.viewer = jmolViewer;
        this.asPopup = bl;
        this.jmolComponent = jmolViewer.getAwtComponent();
        this.mil = new MenuItemListener();
        this.cmil = new CheckboxMenuItemListener();
    }

    public static JmolPopup newJmolPopup(JmolViewer jmolViewer, boolean bl, String string, boolean bl2) {
        JmolPopup jmolPopup;
        menuStructure = string;
        GT.setDoTranslate(true);
        try {
            jmolPopup = !jmolViewer.isJvm12orGreater() ? new JmolPopupAwt(jmolViewer, bl2) : new JmolPopupSwing(jmolViewer, bl2);
        }
        catch (Exception exception) {
            Logger.error("JmolPopup not loaded");
            GT.setDoTranslate(bl);
            return null;
        }
        try {
            jmolPopup.updateComputedMenus();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        GT.setDoTranslate(bl);
        return jmolPopup;
    }

    public abstract void installMainMenu(Object var1);

    void build(Object object) {
        this.htMenus.put("popupMenu", object);
        boolean bl = !this.viewer.isApplet() || this.viewer.getBooleanProperty("_signedApplet");
        this.addMenuItems("", "popupMenu", object, new PopupResourceBundle(menuStructure, this.menuText), this.viewer.isJvm12orGreater(), bl);
    }

    public String getMenu(String string) {
        int n = string.indexOf("|");
        if (n >= 0) {
            String string2 = string.substring(n);
            string = string.substring(0, n);
            if (string2.indexOf("current") >= 0) {
                return this.getMenuCurrent();
            }
        }
        return new PopupResourceBundle(menuStructure, null).getMenu(string);
    }

    abstract String getMenuCurrent();

    protected static void addCurrentItem(StringBuffer stringBuffer, char c, int n, String string, String string2, String string3, String string4) {
        stringBuffer.append(c).append(n).append('\t').append(string);
        if (string2 == null) {
            stringBuffer.append(".\n");
            return;
        }
        stringBuffer.append("\t").append(string2).append("\t").append(string3 == null || string3.length() == 0 ? "-" : string3).append("\t").append(string4).append("\n");
    }

    private String getMenuText(String string) {
        String string2 = this.menuText.getProperty(string);
        return string2 == null ? string : string2;
    }

    public void updateComputedMenus() {
        this.updateMode = 0;
        this.getViewerData();
        this.updateSelectMenu();
        this.updateWriteMenu();
        this.updateElementsComputedMenu(this.viewer.getElementsPresentBitSet(this.modelIndex));
        this.updateHeteroComputedMenu(this.viewer.getHeteroList(this.modelIndex));
        this.updateSurfMoComputedMenu((Hashtable)this.modelInfo.get("moData"));
        this.updateFileTypeDependentMenus();
        this.updatePDBComputedMenus();
        this.updateMode = 1;
        this.updateConfigurationComputedMenu();
        this.updateSYMMETRYComputedMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateLanguageSubmenu();
        this.updateAboutSubmenu();
    }

    private void updateWriteMenu() {
        Object v = this.htMenus.get("SIGNEDwriteMenu");
        if (v == null) {
            return;
        }
        String string = this.getMenuText("writeFileTextVARIABLE");
        v = this.htMenus.get("writeFileTextVARIABLE");
        this.setLabel(v, GT._(string, this.modelSetFileName, true));
        this.enableMenuItem(v, !this.modelSetFileName.equals("zapped"));
    }

    private void getViewerData() {
        this.isApplet = this.viewer.isApplet();
        this.isSigned = this.viewer.getBooleanProperty("_signedApplet");
        this.modelSetName = this.viewer.getModelSetName();
        this.modelSetRoot = this.modelSetName == null || this.modelSetName.indexOf("<") >= 0 || this.modelSetName.indexOf("[") >= 0 || this.modelSetName.indexOf(" ") >= 0 ? "Jmol" : this.modelSetName;
        this.modelSetFileName = this.viewer.getModelSetFileName();
        if ("string".equals(this.modelSetFileName)) {
            this.modelSetFileName = "";
        }
        this.isZapped = "zapped".equals(this.modelSetName);
        this.modelIndex = this.viewer.getDisplayModelIndex();
        this.modelCount = this.viewer.getModelCount();
        this.atomCount = this.viewer.getAtomCountInModel(this.modelIndex);
        this.modelSetInfo = this.viewer.getModelSetAuxiliaryInfo();
        this.modelInfo = this.viewer.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable();
        }
        this.isPDB = this.checkBoolean(this.modelSetInfo, "isPDB");
        this.isSymmetry = this.checkBoolean(this.modelSetInfo, "someModelsHaveSymmetry");
        this.isUnitCell = this.checkBoolean(this.modelSetInfo, "someModelsHaveUnitcells");
        this.isMultiFrame = this.modelCount > 1;
        this.altlocs = this.viewer.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.viewer.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.viewer.havePartialCharges();
        this.haveBFactors = this.viewer.getBooleanProperty("haveBFactors");
    }

    private void updateForShow() {
        this.updateMode = 2;
        this.updateSelectMenu();
        this.updateFRAMESbyModelComputedMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
    }

    boolean checkBoolean(Hashtable hashtable, String string) {
        if (hashtable == null || !hashtable.containsKey(string)) {
            return false;
        }
        return (Boolean)hashtable.get(string);
    }

    void updateSelectMenu() {
        Object v = this.htMenus.get("selectMenuText");
        if (v == null) {
            return;
        }
        this.enableMenu(v, this.atomCount != 0);
        this.setLabel(v, GT._(this.getMenuText("selectMenuText"), this.viewer.getSelectionCount(), true));
    }

    void updateElementsComputedMenu(BitSet bitSet) {
        String string;
        String string2;
        int n;
        Object v = this.htMenus.get("elementsComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        if (bitSet == null) {
            return;
        }
        for (n = 0; n < JmolConstants.elementNumberMax; ++n) {
            if (!bitSet.get(n)) continue;
            String string3 = JmolConstants.elementNameFromNumber(n);
            string2 = JmolConstants.elementSymbolFromNumber(n);
            string = string2 + " - " + string3;
            this.addMenuItem(v, string, "SELECT " + string3, null);
        }
        for (n = 4; n < JmolConstants.altElementMax; ++n) {
            int n2 = JmolConstants.elementNumberMax + n;
            if (!bitSet.get(n2)) continue;
            n2 = JmolConstants.altElementNumberFromIndex(n);
            string2 = JmolConstants.elementNameFromNumber(n2);
            string = JmolConstants.elementSymbolFromNumber(n2);
            String string4 = string + " - " + string2;
            this.addMenuItem(v, string4, "SELECT " + string2, null);
        }
        this.enableMenu(v, true);
    }

    void updateHeteroComputedMenu(Hashtable hashtable) {
        Object v = this.htMenus.get("PDBheteroComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 20) {
                string2 = string2.substring(0, 20) + "...";
            }
            String string3 = string + " - " + string2;
            this.addMenuItem(v, string3, "SELECT [" + string + "]", null);
            ++n;
        }
        this.enableMenu(v, n > 0);
    }

    void updateSurfMoComputedMenu(Hashtable hashtable) {
        int n;
        Object v = this.htMenus.get("surfMoComputedMenu");
        if (v == null) {
            return;
        }
        this.enableMenu(v, false);
        this.removeAll(v);
        if (hashtable == null) {
            return;
        }
        Vector vector = (Vector)hashtable.get("mos");
        int n2 = n = vector == null ? 0 : vector.size();
        if (n == 0) {
            return;
        }
        this.enableMenu(v, true);
        Object object = v;
        int n3 = n % 25;
        if (n3 == 0) {
            n3 = 25;
        }
        int n4 = n > 25 ? 0 : Integer.MIN_VALUE;
        int n5 = n;
        while (--n5 >= 0) {
            Object object2;
            if (n4 >= 0 && n4++ % n3 == 0) {
                if (n4 == n3 + 1) {
                    n3 = 25;
                }
                object2 = "mo" + n4 + "Menu";
                object = this.newMenu(Math.max(n5 + 2 - n3, 1) + "..." + (n5 + 1), this.getId(v) + "." + (String)object2);
                this.addMenuSubMenu(v, object);
                this.htMenus.put(object2, object);
                n4 = 1;
            }
            object2 = (Hashtable)vector.get(n5);
            String string = "#" + (n5 + 1) + " " + (((Hashtable)object2).containsKey("energy") ? ((Hashtable)object2).get("energy") : "") + " " + (((Hashtable)object2).containsKey("type") ? (String)((Hashtable)object2).get("type") : "");
            String string2 = "mo " + (n5 + 1);
            this.addMenuItem(object, string, string2, null);
        }
    }

    void updatePDBComputedMenus() {
        Object v = this.htMenus.get("PDBaaResiduesComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        Object v2 = this.htMenus.get("PDBnucleicResiduesComputedMenu");
        if (v2 == null) {
            return;
        }
        this.removeAll(v2);
        this.enableMenu(v2, false);
        Object v3 = this.htMenus.get("PDBcarboResiduesComputedMenu");
        if (v3 == null) {
            return;
        }
        this.removeAll(v3);
        this.enableMenu(v3, false);
        if (this.modelSetInfo == null) {
            return;
        }
        int n = this.modelIndex < 0 ? 0 : this.modelIndex + 1;
        String[] stringArray = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = stringArray == null ? null : stringArray[n];
        int[] nArray = this.group3Counts = stringArray == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int n2 = 0;
        for (int i = 1; i < 24; ++i) {
            n2 += this.updateGroup3List(v, JmolConstants.predefinedGroup3Names[i]);
        }
        this.enableMenu(v, (n2 += this.augmentGroup3List(v, "p>", true)) > 0);
        this.enableMenu(this.htMenus.get("PDBproteinMenu"), n2 > 0);
        n2 = this.augmentGroup3List(v2, "n>", false);
        this.enableMenu(v2, n2 > 0);
        this.enableMenu(this.htMenus.get("PDBnucleicMenu"), n2 > 0);
        n2 = this.augmentGroup3List(v3, "c>", false);
        this.enableMenu(v3, n2 > 0);
        this.enableMenu(this.htMenus.get("PDBcarboMenu"), n2 > 0);
    }

    int updateGroup3List(Object object, String string) {
        int n = 0;
        int n2 = this.group3Counts[this.group3List.indexOf(string) / 6];
        String string2 = null;
        if (n2 > 0) {
            string2 = "SELECT " + string;
            string = string + "  (" + n2 + ")";
            ++n;
        } else {
            string2 = null;
        }
        Object object2 = this.addMenuItem(object, string, string2, this.getId(object) + "." + string);
        if (n2 == 0) {
            this.enableMenuItem(object2, false);
        }
        return n;
    }

    int augmentGroup3List(Object object, String string, boolean bl) {
        int n = 138;
        int n2 = 0;
        while ((n = this.group3List.indexOf(string, n)) >= 0) {
            if (n2++ == 0 && bl) {
                this.addMenuSeparator(object);
            }
            int n3 = this.group3Counts[n / 6];
            String string2 = this.group3List.substring(n + 2, n + 5);
            String string3 = string2 + "  (" + n3 + ")";
            this.addMenuItem(object, string3, "SELECT [" + string2 + "]", this.getId(object) + "." + string3);
            ++n;
        }
        return n2;
    }

    void updateSYMMETRYComputedMenu() {
        Object v = this.htMenus.get("SYMMETRYComputedMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.enableMenu(v, false);
        if (!this.isSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] stringArray = (String[])this.modelInfo.get("symmetryOperations");
        if (stringArray == null) {
            return;
        }
        int[] nArray = (int[])this.modelInfo.get("unitCellRange");
        boolean bl = nArray != null;
        Object object = v;
        int n = 25;
        int n2 = stringArray.length > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "symop" + n2 + "Menu";
                object = this.newMenu(i + 1 + "..." + Math.min(i + 25, stringArray.length), this.getId(v) + "." + string);
                this.addMenuSubMenu(v, object);
                this.htMenus.put(string, object);
                n2 = 1;
            }
            string = "symop=" + (i + 1) + " # " + stringArray[i];
            this.enableMenuItem(this.addMenuItem(object, string, "SELECT symop=" + (i + 1), null), bl);
        }
        this.enableMenu(v, true);
    }

    void updateFRAMESbyModelComputedMenu() {
        Object v = this.htMenus.get("FRAMESbyModelComputedMenu");
        if (v == null) {
            return;
        }
        this.enableMenu(v, this.modelCount > 1);
        this.setLabel(v, this.modelIndex < 0 ? GT._(this.getMenuText("allModelsText"), this.modelCount, true) : this.getModelLabel());
        this.removeAll(v);
        if (this.modelCount < 2) {
            return;
        }
        this.addCheckboxMenuItem(v, GT._("All", true), "frame 0 ##", null, this.modelIndex < 0);
        Object object = v;
        int n = 25;
        int n2 = this.modelCount > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            String string;
            if (n2 >= 0 && n2++ % n == 0) {
                string = "model" + n2 + "Menu";
                object = this.newMenu(i + 1 + "..." + Math.min(i + 25, this.modelCount), this.getId(v) + "." + string);
                this.addMenuSubMenu(v, object);
                this.htMenus.put(string, object);
                n2 = 1;
            }
            string = "" + this.viewer.getModelNumberDotted(i);
            String string2 = this.viewer.getModelName(i);
            if (!string2.equals(string)) {
                string2 = string + ": " + string2;
            }
            if (string2.length() > 50) {
                string2 = string2.substring(0, 45) + "...";
            }
            this.addCheckboxMenuItem(object, string2, "model " + string + " ##", null, this.modelIndex == i);
        }
    }

    void updateConfigurationComputedMenu() {
        Object v = this.htMenus.get("configurationComputedMenu");
        if (v == null) {
            return;
        }
        this.enableMenu(v, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int n = this.altlocs.length();
        this.setLabel(v, GT._(this.getMenuText("configurationMenuText"), n, true));
        this.removeAll(v);
        String string = "hide none ##CONFIG";
        this.addCheckboxMenuItem(v, GT._("All", true), string, null, this.updateMode == 1 && this.configurationSelected.equals(string));
        for (int i = 0; i < n; ++i) {
            string = "configuration " + (i + 1) + "; hide thisModel and not selected ##CONFIG";
            String string2 = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.addCheckboxMenuItem(v, string2, string, null, this.updateMode == 1 && this.configurationSelected.equals(string));
        }
    }

    void updateModelSetComputedMenu() {
        Object v = this.htMenus.get("modelSetMenu");
        if (v == null) {
            return;
        }
        this.removeAll(v);
        this.renameMenu(v, this.nullModelSetName);
        this.enableMenu(v, false);
        this.enableMenu(this.htMenus.get("surfaceMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("measureMenu"), !this.isZapped);
        this.enableMenu(this.htMenus.get("pickingMenu"), !this.isZapped);
        if (this.modelSetName == null || this.isZapped) {
            return;
        }
        if (this.isMultiFrame) {
            this.modelSetName = GT._(this.getMenuText("modelSetCollectionText"), this.modelCount);
            if (this.modelSetName.length() > 20) {
                this.modelSetName = this.modelSetName.substring(0, 20) + "...";
            }
        } else if (this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.modelSetName = this.getMenuText("hiddenModelSetText");
        } else if (this.modelSetName.length() > 20) {
            this.modelSetName = this.modelSetName.substring(0, 20) + "...";
        }
        this.renameMenu(v, this.modelSetName);
        this.enableMenu(v, true);
        this.enableMenuItem(this.addMenuItem(v, GT._("Minimize"), "minimize", null), this.atomCount <= 100);
        this.addMenuSeparator(v);
        this.addMenuItem(v, GT._(this.getMenuText("atomsText"), this.atomCount, true));
        this.addMenuItem(v, GT._(this.getMenuText("bondsText"), this.viewer.getBondCountInModel(this.modelIndex), true));
        if (this.isPDB) {
            Vector vector;
            this.addMenuSeparator(v);
            this.addMenuItem(v, GT._(this.getMenuText("groupsText"), this.viewer.getGroupCountInModel(this.modelIndex), true));
            this.addMenuItem(v, GT._(this.getMenuText("chainsText"), this.viewer.getChainCountInModel(this.modelIndex), true));
            this.addMenuItem(v, GT._(this.getMenuText("polymersText"), this.viewer.getPolymerCountInModel(this.modelIndex), true));
            Object object = this.htMenus.get("BiomoleculesMenu");
            if (object == null) {
                object = this.newMenu(GT._(this.getMenuText("biomoleculesMenuText")), this.getId(v) + ".biomolecules");
                this.addMenuSubMenu(v, object);
            }
            this.removeAll(object);
            this.enableMenu(object, false);
            if (this.modelIndex >= 0 && (vector = (Vector)this.viewer.getModelAuxiliaryInfo(this.modelIndex, "biomolecules")) != null) {
                this.enableMenu(object, true);
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    String string = this.isMultiFrame ? "" : "save orientation;load \"\" FILTER \"biomolecule " + (i + 1) + "\";restore orientation;";
                    int n2 = (Integer)((Hashtable)vector.elementAt(i)).get("atomCount");
                    String string2 = GT._(this.getMenuText(this.isMultiFrame ? "biomoleculeText" : "loadBiomoleculeText"), new Object[]{new Integer(i + 1), new Integer(n2)});
                    this.addMenuItem(object, string2, string, null);
                }
            }
        }
        if (this.isApplet && this.viewer.showModelSetDownload() && !this.viewer.getBooleanProperty("hideNameInPopup")) {
            this.addMenuSeparator(v);
            this.addMenuItem(v, GT._(this.getMenuText("viewMenuText"), this.modelSetFileName, true), "show url", null);
        }
    }

    void updateFileTypeDependentMenus() {
        int n;
        for (n = 0; n < this.PDBOnly.size(); ++n) {
            this.enableMenu(this.PDBOnly.get(n), this.isPDB);
        }
        for (n = 0; n < this.UnitcellOnly.size(); ++n) {
            this.enableMenu(this.UnitcellOnly.get(n), this.isUnitCell);
        }
        for (n = 0; n < this.FramesOnly.size(); ++n) {
            this.enableMenu(this.FramesOnly.get(n), this.isMultiFrame);
        }
        for (n = 0; n < this.VibrationOnly.size(); ++n) {
            this.enableMenu(this.VibrationOnly.get(n), this.isVibration);
        }
        for (n = 0; n < this.SymmetryOnly.size(); ++n) {
            this.enableMenu(this.SymmetryOnly.get(n), this.isSymmetry && this.isUnitCell);
        }
        for (n = 0; n < this.SignedOnly.size(); ++n) {
            this.enableMenu(this.SignedOnly.get(n), this.isSigned || !this.isApplet);
        }
        for (n = 0; n < this.AppletOnly.size(); ++n) {
            this.enableMenu(this.AppletOnly.get(n), this.isApplet);
        }
        for (n = 0; n < this.ChargesOnly.size(); ++n) {
            this.enableMenu(this.ChargesOnly.get(n), this.haveCharges);
        }
        for (n = 0; n < this.TemperatureOnly.size(); ++n) {
            this.enableMenu(this.TemperatureOnly.get(n), this.haveBFactors);
        }
    }

    String getModelLabel() {
        return GT._(this.getMenuText("modelMenuText"), this.modelIndex + 1 + "/" + this.modelCount, true);
    }

    private void updateAboutSubmenu() {
        Object v = this.htMenus.get("aboutComputedMenu");
        if (v == null) {
            return;
        }
        int n = this.getMenuItemCount(v);
        while (--n >= this.aboutComputedMenuBaseCount) {
            this.removeMenuItem(v, n);
        }
        this.addMenuSeparator(v);
        this.addMenuItem(v, "Jmol " + JmolConstants.version + (this.isSigned ? " (signed)" : ""));
        this.addMenuItem(v, JmolConstants.date);
        this.addMenuItem(v, this.viewer.getOperatingSystemName());
        this.addMenuItem(v, this.viewer.getJavaVendor());
        this.addMenuItem(v, this.viewer.getJavaVersion());
        this.addMenuSeparator(v);
        this.addMenuItem(v, GT._("Java memory usage", true));
        Runtime runtime = Runtime.getRuntime();
        long l = this.convertToMegabytes(runtime.totalMemory());
        long l2 = this.convertToMegabytes(runtime.freeMemory());
        long l3 = this.convertToMegabytes(this.maxMemoryForNewerJvm());
        this.addMenuItem(v, GT._("{0} MB total", new Object[]{new Long(l)}, true));
        this.addMenuItem(v, GT._("{0} MB free", new Object[]{new Long(l2)}, true));
        if (l3 > 0L) {
            this.addMenuItem(v, GT._("{0} MB maximum", new Object[]{new Long(l3)}, true));
        } else {
            this.addMenuItem(v, GT._("unknown maximum", true));
        }
        int n2 = this.availableProcessorsForNewerJvm();
        if (n2 > 0) {
            this.addMenuItem(v, n2 == 1 ? GT._("1 processor", true) : GT._("{0} processors", n2, true));
        } else {
            this.addMenuItem(v, GT._("unknown processor count", true));
        }
    }

    private void updateLanguageSubmenu() {
        Object v = this.htMenus.get("languageComputedMenu");
        if (v == null) {
            return;
        }
        int n = this.getMenuItemCount(v);
        while (--n >= 0) {
            this.removeMenuItem(v, n);
        }
        String string = GT.getLanguage();
        String string2 = this.getId(v);
        GT.Language[] languageArray = GT.getLanguageList();
        for (int i = 0; i < languageArray.length; ++i) {
            if (!languageArray[i].display) continue;
            String string3 = languageArray[i].code;
            String string4 = languageArray[i].language;
            this.addCheckboxMenuItem(v, GT._(string4, true) + " (" + string3 + ")", "language = \"" + string3 + "\" ##" + string4, string2 + "." + string3, string.equals(string3));
        }
    }

    private long convertToMegabytes(long l) {
        if (l <= 0x7FFFFFFFFFF7FFFFL) {
            l += 524288L;
        }
        return l / 0x100000L;
    }

    private void addMenuItems(String string, String string2, Object object, PopupResourceBundle popupResourceBundle, boolean bl, boolean bl2) {
        String string3;
        Object object2;
        String string4 = string + "." + string2;
        String string5 = popupResourceBundle.getStructure(string2);
        if (string5 == null) {
            this.addMenuItem(object, "#" + string2, "", "");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string5);
        while (string5.indexOf("@") >= 0) {
            object2 = "";
            while (stringTokenizer.hasMoreTokens()) {
                object2 = (String)object2 + " " + ((string3 = stringTokenizer.nextToken()).startsWith("@") ? popupResourceBundle.getStructure(string3) : string3);
            }
            string5 = ((String)object2).substring(1);
            stringTokenizer = new StringTokenizer(string5);
        }
        while (stringTokenizer.hasMoreTokens()) {
            Object object3;
            object2 = null;
            String string6 = "";
            string3 = stringTokenizer.nextToken();
            boolean bl3 = !bl && string3.indexOf("JVM12") >= 0;
            String string7 = popupResourceBundle.getWord(string3);
            if (string3.indexOf("Menu") >= 0) {
                if (!bl2 && string3.startsWith("SIGNED")) continue;
                object3 = this.newMenu(string7, string4 + "." + string3);
                this.addMenuSubMenu(object, object3);
                this.htMenus.put(string3, object3);
                if (string3.indexOf("Computed") < 0) {
                    this.addMenuItems(string4, string3, object3, popupResourceBundle, bl, bl2);
                }
                if ("aboutComputedMenu".equals(string3)) {
                    this.aboutComputedMenuBaseCount = this.getMenuItemCount(object3);
                } else if ("modelSetMenu".equals(string3)) {
                    this.nullModelSetName = string7;
                    this.enableMenu(object3, false);
                }
                object2 = object3;
                if (bl3) {
                    this.enableMenu(object2, false);
                }
            } else if ("-".equals(string3)) {
                this.addMenuSeparator(object);
            } else if (string3.endsWith("Checkbox")) {
                string6 = popupResourceBundle.getStructure(string3);
                object3 = string3.substring(0, string3.length() - 8);
                if (string6 == null || string6.length() == 0) {
                    string6 = "set " + (String)object3 + " T/F";
                }
                object2 = this.addCheckboxMenuItem(object, string7, (String)object3 + ":" + string6, string4 + "." + string3);
            } else {
                string6 = popupResourceBundle.getStructure(string3);
                if (string6 == null) {
                    string6 = string3;
                }
                object2 = this.addMenuItem(object, string7, string6, string4 + "." + string3);
                if (bl3) {
                    this.enableMenuItem(object2, false);
                }
            }
            if (string3.indexOf("VARIABLE") >= 0) {
                this.htMenus.put(string3, object2);
            }
            if (string3.indexOf("PDB") >= 0) {
                this.PDBOnly.add(object2);
            } else if (string3.indexOf("URL") >= 0) {
                this.AppletOnly.add(object2);
            } else if (string3.indexOf("CHARGE") >= 0) {
                this.ChargesOnly.add(object2);
            } else if (string3.indexOf("BFACTORS") >= 0) {
                this.TemperatureOnly.add(object2);
            } else if (string3.indexOf("UNITCELL") >= 0) {
                this.UnitcellOnly.add(object2);
            } else if (string3.indexOf("FRAMES") >= 0) {
                this.FramesOnly.add(object2);
            } else if (string3.indexOf("VIBRATION") >= 0) {
                this.VibrationOnly.add(object2);
            } else if (string3.indexOf("SYMMETRY") >= 0) {
                this.SymmetryOnly.add(object2);
            }
            if (!string3.startsWith("SIGNED")) continue;
            this.SignedOnly.add(object2);
        }
    }

    void rememberCheckbox(String string, Object object) {
        this.htCheckbox.put(string, object);
    }

    void setCheckBoxValue(String string, boolean bl) {
        if (string.indexOf("##") < 0) {
            int n = string.indexOf(":");
            String string2 = string.substring(0, n);
            if (this.viewer.getBooleanProperty(string2) == bl) {
                return;
            }
            if ((n = (string = string.substring(n + 1)).indexOf("|")) >= 0) {
                string = (bl ? string.substring(0, n) : string.substring(n + 1)).trim();
            }
            string = TextFormat.simpleReplace(string, "T/F", bl ? " TRUE" : " FALSE");
        }
        this.viewer.evalStringQuiet(string);
        if (string.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = string;
            this.updateConfigurationComputedMenu();
            this.updateModelSetComputedMenu();
        }
    }

    String fixScript(String string, String string2) {
        if (string2 == "" || string.endsWith("Checkbox")) {
            return string2;
        }
        if (string2.indexOf("SELECT") == 0) {
            return "select thisModel and (" + string2.substring(6) + ")";
        }
        int n = string.lastIndexOf("[");
        if (n >= 0) {
            if ((n = (string = string.substring(n + 1)).indexOf("]")) >= 0) {
                string = string.substring(0, n);
            }
            string = string.replace('_', ' ');
            if (string2.indexOf("[]") < 0) {
                string2 = "[] " + string2;
            }
            return TextFormat.simpleReplace(string2, "[]", string);
        }
        if (string2.indexOf("?FILEROOT?") >= 0) {
            string2 = TextFormat.simpleReplace(string2, "FILEROOT?", this.modelSetRoot);
        } else if (string2.indexOf("?FILE?") >= 0) {
            string2 = TextFormat.simpleReplace(string2, "FILE?", this.modelSetFileName);
        } else if (string2.indexOf("?PdbId?") >= 0) {
            string2 = TextFormat.simpleReplace(string2, "PdbId?", "=" + (this.modelSetRoot.length() == 4 && this.modelSetRoot.indexOf(".") < 0 ? this.modelSetRoot : "1crn"));
        }
        return string2;
    }

    Object addMenuItem(Object object, String string) {
        return this.addMenuItem(object, string, "", null);
    }

    Object addCheckboxMenuItem(Object object, String string, String string2, String string3) {
        Object object2 = this.addCheckboxMenuItem(object, string, string2, string3, false);
        this.rememberCheckbox(string2, object2);
        return object2;
    }

    public void show(int n, int n2) {
        this.thisx = n;
        this.thisy = n2;
        String string = this.currentMenuItemId;
        this.updateForShow();
        Enumeration enumeration = this.htCheckbox.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Object v = this.htCheckbox.get(string2);
            String string3 = string2.substring(0, string2.indexOf(":"));
            boolean bl = this.viewer.getBooleanProperty(string3);
            this.setCheckBoxState(v, bl);
        }
        if (n < 0) {
            this.setFrankMenu(string);
            this.thisx = -n - 50;
            if (this.nFrankList > 1) {
                this.thisy = n2 - this.nFrankList * this.getMenuItemHeight();
                this.showFrankMenu(this.thisx, this.thisy);
                return;
            }
        }
        this.restorePopupMenu();
        if (this.asPopup) {
            this.showPopupMenu(this.thisx, this.thisy);
        }
    }

    void setFrankMenu(String string) {
        int n;
        if (this.currentFrankId != null && this.currentFrankId == string && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.createFrankPopup();
        }
        this.resetFrankMenu();
        if (string == null) {
            return;
        }
        this.currentFrankId = string;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        this.addMenuItem(this.frankPopup, GT._(this.getMenuText("mainMenuText")), "MAIN", "");
        int n2 = string.indexOf(".", 2) + 1;
        while ((n = string.indexOf(".", n2)) >= 0) {
            String string2 = string.substring(n2, n);
            Object v = this.htMenus.get(string2);
            this.frankList[this.nFrankList++] = new Object[]{this.getParent(v), v, new Integer(this.getPosition(v))};
            this.addMenuSubMenu(this.frankPopup, v);
            n2 = n + 1;
        }
    }

    void restorePopupMenu() {
        if (this.nFrankList < 2) {
            return;
        }
        int n = this.nFrankList;
        while (--n > 0) {
            this.insertMenuSubMenu(this.frankList[n][0], this.frankList[n][1], (Integer)this.frankList[n][2]);
        }
        this.nFrankList = 1;
    }

    abstract void resetFrankMenu();

    abstract Object getParent(Object var1);

    abstract void insertMenuSubMenu(Object var1, Object var2, int var3);

    abstract int getPosition(Object var1);

    abstract void showPopupMenu(int var1, int var2);

    abstract void showFrankMenu(int var1, int var2);

    abstract void setCheckBoxState(Object var1, boolean var2);

    abstract void addMenuSeparator(Object var1);

    abstract Object addMenuItem(Object var1, String var2, String var3, String var4);

    abstract void setLabel(Object var1, String var2);

    abstract void updateMenuItem(Object var1, String var2, String var3);

    abstract Object addCheckboxMenuItem(Object var1, String var2, String var3, String var4, boolean var5);

    abstract void addMenuSubMenu(Object var1, Object var2);

    abstract Object newMenu(String var1, String var2);

    abstract void enableMenu(Object var1, boolean var2);

    abstract void enableMenuItem(Object var1, boolean var2);

    abstract void renameMenu(Object var1, String var2);

    abstract void removeAll(Object var1);

    abstract int getMenuItemCount(Object var1);

    abstract void removeMenuItem(Object var1, int var2);

    abstract String getId(Object var1);

    abstract void setCheckBoxValue(Object var1);

    abstract void createFrankPopup();

    abstract int getMenuItemHeight();

    long maxMemoryForNewerJvm() {
        return 0L;
    }

    int availableProcessorsForNewerJvm() {
        return 0;
    }

    class CheckboxMenuItemListener
    implements ItemListener {
        CheckboxMenuItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JmolPopup.this.restorePopupMenu();
            JmolPopup.this.setCheckBoxValue(itemEvent.getSource());
            String string = JmolPopup.this.getId(itemEvent.getSource());
            if (string != null) {
                JmolPopup.this.currentMenuItemId = string;
            }
        }
    }

    class MenuItemListener
    implements ActionListener {
        MenuItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JmolPopup.this.restorePopupMenu();
            String string = actionEvent.getActionCommand();
            if (string == null || string.length() == 0) {
                return;
            }
            if (string.equals("MAIN")) {
                JmolPopup.this.show(JmolPopup.this.thisx, JmolPopup.this.thisy);
                return;
            }
            String string2 = JmolPopup.this.getId(actionEvent.getSource());
            if (string2 != null) {
                string = JmolPopup.this.fixScript(string2, string);
                JmolPopup.this.currentMenuItemId = string2;
            }
            JmolPopup.this.viewer.evalStringQuiet(string);
        }
    }
}

