/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;

public class AminoMonomer
extends AlphaMonomer {
    private static final byte CA = 0;
    private static final byte O = 1;
    private static final byte N = 2;
    private static final byte C = 3;
    private static final byte OT = 4;
    static final byte[] interestingAminoAtomIDs = new byte[]{2, -5, 1, 3, -65, -6};
    boolean nhChecked = false;
    private final Point3f ptTemp = new Point3f();
    private static final float beta = 0.29670596f;

    static Monomer validateAndAllocate(Chain chain, String string, int n, int n2, int n3, int[] nArray, Atom[] atomArray) {
        byte[] byArray = Monomer.scanForOffsets(n2, nArray, interestingAminoAtomIDs);
        if (byArray == null) {
            return null;
        }
        Monomer.checkOptional(byArray, (byte)1, n2, nArray[5]);
        if (atomArray[n2].isHetero() && !AminoMonomer.isBondedCorrectly(n2, byArray, atomArray)) {
            return null;
        }
        AminoMonomer aminoMonomer = new AminoMonomer(chain, string, n, n2, n3, byArray);
        return aminoMonomer;
    }

    private static boolean isBondedCorrectly(int n, int n2, int n3, byte[] byArray, Atom[] atomArray) {
        int n4 = n3 + (byArray[n] & 0xFF);
        int n5 = n3 + (byArray[n2] & 0xFF);
        if (n4 >= n5) {
            return false;
        }
        return atomArray[n4].isBonded(atomArray[n5]);
    }

    private static boolean isBondedCorrectly(int n, byte[] byArray, Atom[] atomArray) {
        return AminoMonomer.isBondedCorrectly(2, 0, n, byArray, atomArray) && AminoMonomer.isBondedCorrectly(0, 3, n, byArray, atomArray) && (byArray[1] == -1 || AminoMonomer.isBondedCorrectly(3, 1, n, byArray, atomArray));
    }

    private AminoMonomer(Chain chain, String string, int n, int n2, int n3, byte[] byArray) {
        super(chain, string, n, n2, n3, byArray);
    }

    boolean isAminoMonomer() {
        return true;
    }

    Atom getNitrogenAtom() {
        return this.getAtomFromOffsetIndex(2);
    }

    Point3f getNitrogenAtomPoint() {
        return this.getAtomFromOffsetIndex(2);
    }

    Atom getCarbonylCarbonAtom() {
        return this.getAtomFromOffsetIndex(3);
    }

    Point3f getCarbonylCarbonAtomPoint() {
        return this.getAtomFromOffsetIndex(3);
    }

    Atom getCarbonylOxygenAtom() {
        return this.getWingAtom();
    }

    Point3f getCarbonylOxygenAtomPoint() {
        return this.getWingAtomPoint();
    }

    Atom getInitiatorAtom() {
        return this.getNitrogenAtom();
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[4] != -1 ? 4 : 3);
    }

    boolean hasOAtom() {
        return this.offsets[1] != -1;
    }

    boolean isConnectedAfter(Monomer monomer) {
        if (monomer == null) {
            return true;
        }
        if (!(monomer instanceof AminoMonomer)) {
            return false;
        }
        AminoMonomer aminoMonomer = (AminoMonomer)monomer;
        return aminoMonomer.getCarbonylCarbonAtom().isBonded(this.getNitrogenAtom());
    }

    void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short s, short s2) {
        Atom atom;
        int n3;
        Atom atom2 = atomArray[0];
        Atom atom3 = this.getNitrogenAtom();
        int n4 = s / 2;
        if (n4 < 1200) {
            n4 = 1200;
        }
        if (atom3.screenZ == 0) {
            return;
        }
        int n5 = this.scaleToScreen(atom3.screenZ, n4);
        if (n5 < 4) {
            n5 = 4;
        }
        Atom atom4 = this.getCarbonylCarbonAtom();
        int n6 = s2 / 2;
        if (n6 < 1200) {
            n6 = 1200;
        }
        if ((n3 = this.scaleToScreen(atom3.screenZ, n6)) < 4) {
            n3 = 4;
        }
        if (this.isCursorOnTopOf(atom = this.getLeadAtom(), n, n2, (n5 + n3) / 2, atom2) || this.isCursorOnTopOf(atom3, n, n2, n5, atom2) || this.isCursorOnTopOf(atom4, n, n2, n3, atom2)) {
            atomArray[0] = atom;
        }
    }

    public void resetHydrogenPoint() {
        this.nhChecked = false;
        this.nitrogenHydrogenPoint = null;
    }

    Point3f getNitrogenHydrogenPoint() {
        if (this.nitrogenHydrogenPoint == null && !this.nhChecked) {
            this.nhChecked = true;
            Atom atom = this.getNitrogenAtom();
            Atom atom2 = null;
            Bond[] bondArray = atom.getBonds();
            for (int i = 0; i < bondArray.length; ++i) {
                atom2 = bondArray[i].getOtherAtom(atom);
                if (atom2.getElementNumber() != 1) continue;
                this.nitrogenHydrogenPoint = atom2;
                return this.nitrogenHydrogenPoint;
            }
        }
        return this.nitrogenHydrogenPoint;
    }

    public boolean getNHPoint(Point3f point3f, Vector3f vector3f) {
        if (this.monomerIndex == 0 || this.getGroupID() == 15) {
            return false;
        }
        Point3f point3f2 = this.getNitrogenAtomPoint();
        Point3f point3f3 = this.getNitrogenHydrogenPoint();
        if (point3f3 != null) {
            vector3f.sub(point3f3, point3f2);
            point3f.set(point3f3);
            return true;
        }
        vector3f.sub(point3f2, this.getLeadAtomPoint());
        vector3f.add(point3f2);
        vector3f.sub(((AminoMonomer)this.bioPolymer.monomers[this.monomerIndex - 1]).getCarbonylCarbonAtomPoint());
        vector3f.normalize();
        point3f.add(point3f2, vector3f);
        this.nitrogenHydrogenPoint = new Point3f(point3f);
        if (Logger.debugging) {
            Logger.info("draw pta" + this.monomerIndex + " {" + point3f.x + " " + point3f.y + " " + point3f.z + "} color red#aminoPolymer.calchbonds");
        }
        return true;
    }

    Point3f getQuaternionFrameCenter(char c) {
        switch (c) {
            default: {
                return this.getLeadAtomPoint();
            }
            case 'p': {
                return this.getCarbonylCarbonAtomPoint();
            }
            case 'n': 
        }
        return this.getNitrogenAtomPoint();
    }

    public Quaternion getQuaternion(char c) {
        Point3f point3f = this.getCarbonylCarbonAtomPoint();
        Point3f point3f2 = this.getLeadAtomPoint();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = null;
        switch (c) {
            default: {
                vector3f.sub(point3f, point3f2);
                vector3f2.sub(this.getNitrogenAtomPoint(), point3f2);
                break;
            }
            case 'p': {
                vector3f.sub(point3f2, point3f);
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
                    return null;
                }
                vector3f2.sub(((AminoMonomer)this.bioPolymer.getMonomers()[this.monomerIndex + 1]).getNitrogenAtomPoint(), point3f);
                break;
            }
            case 'n': {
                if (this.monomerIndex == 0 || this.getGroupID() == 15) {
                    return null;
                }
                vector3f3 = new Vector3f();
                this.getNHPoint(this.ptTemp, vector3f3);
                vector3f2.sub(point3f2, this.getNitrogenAtomPoint());
                vector3f2.cross(vector3f3, vector3f2);
                Matrix3f matrix3f = new Matrix3f();
                matrix3f.set(new AxisAngle4f(vector3f2, -0.29670596f));
                matrix3f.transform(vector3f3);
                vector3f.cross(vector3f2, vector3f3);
            }
        }
        return Quaternion.getQuaternionFrame(vector3f, vector3f2, vector3f3);
    }
}

