/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class PltFormattedReader
extends VolumeFileReader {
    PltFormattedReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isAngstroms = true;
        this.jvxlData.wasCubic = true;
    }

    protected int readVolumetricHeader() {
        try {
            this.readTitleLines();
            this.readAtomCountAndOrigin();
            Logger.info(this.jvxlFileHeaderBuffer.toString());
            this.readVoxelVectors();
            Logger.info("voxel grid origin:" + this.volumetricOrigin);
            for (int i = 0; i < 3; ++i) {
                Logger.info("voxel grid vector:" + this.volumetricVectors[i]);
            }
            JvxlReader.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
            return this.readExtraLine();
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
            throw new NullPointerException();
        }
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
    }

    protected void readAtomCountAndOrigin() throws Exception {
        this.atomCount = 0;
        this.negativeAtomCount = false;
        int n = this.parseInt(this.getLine());
        int n2 = this.parseInt();
        this.nPointsX = this.parseInt(this.getLine());
        this.nPointsY = this.parseInt();
        this.nPointsZ = this.parseInt();
        this.jvxlFileHeaderBuffer.append("Plt formatted data (" + n + "," + n2 + ") " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " \nJmol " + Viewer.getJmolVersion() + '\n');
        this.volumetricOrigin.set(0.0f, 0.0f, 0.0f);
    }

    protected void readVoxelVectors() throws Exception {
        float f = this.parseFloat(this.getLine().substring(0, 12));
        float f2 = this.parseFloat(this.line.substring(12, 24));
        float f3 = this.parseFloat(this.line.substring(24, 36));
        float f4 = this.parseFloat(this.line.substring(36, 48));
        float f5 = this.parseFloat(this.line.substring(48, 60));
        float f6 = this.parseFloat(this.line.substring(60, 72));
        this.volumetricOrigin.set(f, f3, f5);
        this.voxelCounts[0] = this.nPointsX;
        this.voxelCounts[1] = this.nPointsY;
        this.voxelCounts[2] = this.nPointsZ;
        this.volumetricVectors[0].set(0.0f, 0.0f, (f2 - f) / (float)this.nPointsX);
        this.volumetricVectors[1].set(0.0f, (f4 - f3) / (float)this.nPointsY, 0.0f);
        this.volumetricVectors[2].set((f6 - f5) / (float)this.nPointsZ, 0.0f, 0.0f);
        Logger.info("boundbox corners {" + f5 + " " + f3 + " " + f + "} {" + f6 + " " + f4 + " " + f2 + " }");
    }

    private String getLine() throws IOException {
        this.line = this.br.readLine();
        return this.line;
    }
}

