/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.JvxlReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Parser;

class CubeReader
extends VolumeFileReader {
    CubeReader(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super(surfaceGenerator, bufferedReader);
        this.isAngstroms = false;
        this.jvxlData.wasCubic = true;
        this.canDownsample = true;
    }

    protected void readTitleLines() throws Exception {
        this.jvxlFileHeaderBuffer = new StringBuffer();
        this.jvxlFileHeaderBuffer.append(this.br.readLine()).append('\n');
        this.jvxlFileHeaderBuffer.append(this.br.readLine()).append('\n');
    }

    protected void readAtomCountAndOrigin() throws Exception {
        String string = this.br.readLine();
        String[] stringArray = Parser.getTokens(string, 0);
        this.atomCount = this.parseInt(stringArray[0]);
        boolean bl = this.negativeAtomCount = this.atomCount < 0;
        if (this.negativeAtomCount) {
            this.atomCount = -this.atomCount;
        }
        this.volumetricOrigin.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        JvxlReader.jvxlCheckAtomLine(this.isXLowToHigh, this.isAngstroms, stringArray[0], string, this.jvxlFileHeaderBuffer);
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
    }
}

