/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.readers.more.MopacData;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class CsfReader
extends MopacDataReader {
    int nAtoms = 0;
    String atomicNumbers = "";
    int fieldCount;
    int nVibrations = 0;
    int nGaussians = 0;
    int nSlaters = 0;
    private Hashtable propertyItemCounts = new Hashtable();
    int[] fieldTypes = new int[100];
    static final byte objCls1 = 1;
    static final byte objID1 = 2;
    static final byte objCls2 = 3;
    static final byte objID2 = 4;
    static final String[] connectorFields = new String[]{"objCls1", "objID1", "objCls2", "objID2"};
    static final byte[] connectorFieldMap = new byte[]{1, 2, 3, 4};
    Hashtable connectors = new Hashtable();
    static final byte ID = -1;
    static final byte sym = 1;
    static final byte anum = 2;
    static final byte chrg = 3;
    static final byte xyz_coordinates = 4;
    static final byte pchrg = 5;
    static final String[] atomFields = new String[]{"ID", "sym", "anum", "chrg", "xyz_coordinates", "pchrg"};
    static final byte[] atomFieldMap = new byte[]{-1, 1, 2, 3, 4, 5};
    static final byte bondType = 1;
    static final String[] bondFields = new String[]{"ID", "type"};
    static final byte[] bondFieldMap = new byte[]{-1, 1};
    int nBonds = 0;
    static final byte normalMode = 1;
    static final byte vibEnergy = 2;
    static final byte transitionDipole = 3;
    static final String[] vibFields = new String[]{"ID", "normalMode", "Energy", "transitionDipole"};
    static final byte[] vibFieldMap = new byte[]{-1, 1, 2, 3};
    static final byte eig_val = 1;
    static final byte mo_occ = 2;
    static final byte eig_vec = 3;
    static final byte eig_vec_compressed = 4;
    static final byte coef_indices = 5;
    static final byte bfxn_ang = 6;
    static final byte sto_exp = 7;
    static final byte contractions = 8;
    static final byte gto_exp = 9;
    static final byte shell = 10;
    static final String[] moFields = new String[]{"ID", "eig_val", "mo_occ", "eig_vec", "eig_vec_compressed", "coef_indices", "bfxn_ang", "sto_exp", "contractions", "gto_exp", "shell"};
    static final byte[] moFieldMap = new byte[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("csf");
        try {
            this.readLine();
            while (this.line != null) {
                if (this.line.equals("local_transform")) {
                    this.processLocalTransform();
                } else if (this.line.startsWith("object_class")) {
                    this.processObjectClass();
                    continue;
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private void processObjectClass() throws Exception {
        if (this.line.equals("object_class connector")) {
            this.processConnectorObject();
            return;
        }
        if (this.line.equals("object_class atom")) {
            this.processAtomObject();
            return;
        }
        if (this.line.equals("object_class bond")) {
            this.processBondObject();
            return;
        }
        if (this.line.equals("object_class vibrational_level")) {
            this.processVibrationObject();
            return;
        }
        if (this.line.equals("object_class mol_orbital")) {
            this.processMolecularOrbitalObject();
            return;
        }
        if (this.line.equals("object_class sto_basis_fxn")) {
            this.processBasisObject("sto");
            return;
        }
        if (this.line.equals("object_class gto_basis_fxn")) {
            this.processBasisObject("gto");
            return;
        }
        this.readLine();
    }

    private void processLocalTransform() throws Exception {
        String[] stringArray = AtomSetCollectionReader.getTokens(this.readLine() + " " + this.readLine() + " " + this.readLine() + " " + this.readLine());
        this.setTransform(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]), this.parseFloat(stringArray[6]), this.parseFloat(stringArray[8]), this.parseFloat(stringArray[9]), this.parseFloat(stringArray[10]));
    }

    int getPropertyCount(String string) {
        Integer n = (Integer)this.propertyItemCounts.get(string);
        return string.equals("ID") ? 1 : (n == null ? 0 : n);
    }

    private int parseLineParameters(String[] stringArray, byte[] byArray) throws Exception {
        for (int i = 0; i < this.fieldCount; ++i) {
            this.fieldTypes[i] = 0;
        }
        this.fieldCount = -1;
        if (this.line == null || this.line.startsWith("property_flags:")) {
            this.readLine();
        }
        if (this.line == null || this.line.startsWith("object_class")) {
            return this.fieldCount;
        }
        String[] stringArray2 = new String[]{};
        while (this.line != null) {
            stringArray2 = this.getTokens();
            if (this.line.indexOf("property ") == 0) {
                this.propertyItemCounts.put(stringArray2[1], new Integer(stringArray2[6].equals("STRING") ? 1 : this.parseInt(stringArray2[5])));
            } else if (this.line.indexOf("ID") == 0) break;
            this.readLine();
        }
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray2[i];
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (!string.equals(stringArray[n2])) continue;
                this.fieldTypes[n] = byArray[n2];
                this.fieldCount = n + 1;
                break;
            }
            n += this.getPropertyCount(string);
        }
        return this.fieldCount;
    }

    private void fillCsfArray(String string, String[] stringArray, int n, Object object) throws Exception {
        int n2 = this.getPropertyCount(string);
        int n3 = n;
        boolean bl = object instanceof int[];
        for (int i = 0; i < n2; ++i) {
            int n4 = n3 + i;
            if (n4 == stringArray.length) {
                stringArray = AtomSetCollectionReader.getTokens(this.readLine());
                n3 -= n4 - n;
                n4 = n;
            }
            if (bl) {
                ((int[])object)[i] = this.parseInt(stringArray[n4]);
                continue;
            }
            ((float[])object)[i] = this.parseFloat(stringArray[n4]);
        }
    }

    void processConnectorObject() throws Exception {
        this.readLine();
        this.parseLineParameters(connectorFields, connectorFieldMap);
        block6: while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
            String string = null;
            String string2 = null;
            String[] stringArray = this.getTokens();
            String string3 = "";
            boolean bl = false;
            block7: for (int i = 0; i < this.fieldCount; ++i) {
                String string4 = stringArray[i];
                switch (this.fieldTypes[i]) {
                    case 1: {
                        if (string4.equals("atom")) continue block7;
                        continue block6;
                    }
                    case 3: {
                        string3 = string4;
                        if (string4.equals("sto_basis_fxn")) {
                            ++this.nSlaters;
                            continue block7;
                        }
                        if (string4.equals("gto_basis_fxn")) {
                            ++this.nGaussians;
                            continue block7;
                        }
                        if (string4.equals("vibrational_level")) {
                            bl = true;
                            continue block7;
                        }
                        if (string4.equals("bond")) continue block7;
                        continue block6;
                    }
                    case 2: {
                        string = "atom" + string4;
                        continue block7;
                    }
                    case 4: {
                        string2 = string3 + string4;
                        if (!bl) continue block7;
                        this.nVibrations = Math.max(this.nVibrations, this.parseInt(string4));
                        continue block7;
                    }
                }
            }
            if (string == null || string2 == null) continue;
            if (this.connectors.containsKey(string2)) {
                String[] stringArray2 = (String[])this.connectors.get(string2);
                stringArray2[1] = string;
                continue;
            }
            String[] stringArray3 = new String[2];
            stringArray3[0] = string;
            this.connectors.put(string2, stringArray3);
        }
    }

    void processAtomObject() throws Exception {
        this.readLine();
        this.parseLineParameters(atomFields, atomFieldMap);
        this.nAtoms = 0;
        while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
            String[] stringArray = this.getTokens();
            Atom atom = new Atom();
            block9: for (int i = 0; i < this.fieldCount; ++i) {
                String string = stringArray[i];
                if (string == null) {
                    Logger.warn("field == null in " + this.line);
                }
                switch (this.fieldTypes[i]) {
                    case -1: {
                        atom.atomName = "atom" + string;
                        continue block9;
                    }
                    case 1: {
                        atom.elementSymbol = string;
                        continue block9;
                    }
                    case 2: {
                        this.atomicNumbers = this.atomicNumbers + string + " ";
                        continue block9;
                    }
                    case 3: {
                        atom.formalCharge = this.parseInt(string);
                        continue block9;
                    }
                    case 5: {
                        atom.partialCharge = this.parseFloat(string);
                        continue block9;
                    }
                    case 4: {
                        this.setAtomCoord(atom, this.parseFloat(string), this.parseFloat(stringArray[i + 1]), this.parseFloat(stringArray[i + 2]));
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            ++this.nAtoms;
            this.atomSetCollection.addAtomWithMappedName(atom);
        }
    }

    void processBondObject() throws Exception {
        this.readLine();
        this.parseLineParameters(bondFields, bondFieldMap);
        while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
            String string = null;
            String[] stringArray = this.getTokens();
            block5: for (int i = 0; i < this.fieldCount; ++i) {
                String string2 = stringArray[i];
                switch (this.fieldTypes[i]) {
                    case -1: {
                        string = "bond" + string2;
                        continue block5;
                    }
                    case 1: {
                        int n = 1;
                        if (string2.equals("single")) {
                            n = 1;
                        } else if (string2.equals("double")) {
                            n = 2;
                        } else if (string2.equals("triple")) {
                            n = 3;
                        } else {
                            Logger.warn("unknown CSF bond order: " + string2);
                        }
                        String[] stringArray2 = (String[])this.connectors.get(string);
                        Bond bond = new Bond();
                        bond.atomIndex1 = this.atomSetCollection.getAtomNameIndex(stringArray2[0]);
                        bond.atomIndex2 = this.atomSetCollection.getAtomNameIndex(stringArray2[1]);
                        bond.order = n;
                        this.atomSetCollection.addBond(bond);
                        ++this.nBonds;
                    }
                }
            }
        }
    }

    void processVibrationObject() throws Exception {
        int n;
        int n2;
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        float[][] fArray = new float[this.nVibrations][this.nAtoms * 3];
        float[] fArray2 = new float[this.nVibrations];
        this.readLine();
        while (this.line != null && this.parseLineParameters(vibFields, vibFieldMap) > 0) {
            while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
                String[] stringArray = this.getTokens();
                n2 = -1;
                block7: for (n = 0; n < this.fieldCount; ++n) {
                    String string = stringArray[n];
                    switch (this.fieldTypes[n]) {
                        case -1: {
                            n2 = this.parseInt(string) - 1;
                            continue block7;
                        }
                        case 1: {
                            this.fillCsfArray("normalMode", stringArray, n, fArray[n2]);
                            continue block7;
                        }
                        case 2: {
                            fArray2[n2] = this.parseFloat(string);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < this.nVibrations; ++i) {
            this.atomSetCollection.cloneFirstAtomSetWithBonds(this.nBonds);
            this.atomSetCollection.setAtomSetName(fArray2[i] + " cm^-1", i + 1);
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
            n2 = 0;
            n = this.nAtoms * (i + 1);
            for (int j = 0; j < this.nAtoms; ++j) {
                atomArray[n + j].addVibrationVector(fArray[i][n2++], fArray[i][n2++], fArray[i][n2++]);
            }
        }
    }

    void processMolecularOrbitalObject() throws Exception {
        if (this.nSlaters == 0 && this.nGaussians == 0) {
            this.readLine();
            return;
        }
        this.nOrbitals = this.nSlaters + this.nGaussians;
        Logger.info("Reading CSF data for " + this.nOrbitals + " molecular orbitals");
        float[] fArray = new float[this.nOrbitals];
        float[] fArray2 = new float[this.nOrbitals];
        float[][] fArray3 = new float[this.nOrbitals][this.nOrbitals];
        float[][] fArray4 = null;
        int[][] nArray = null;
        int n = 0;
        boolean bl = false;
        this.readLine();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
                String[] stringArray = this.getTokens();
                block10: for (int i = 0; i < this.fieldCount; ++i) {
                    switch (this.fieldTypes[i]) {
                        case -1: {
                            n = this.parseInt(stringArray[i]) - 1;
                            continue block10;
                        }
                        case 1: {
                            fArray[n] = this.parseFloat(stringArray[i]);
                            continue block10;
                        }
                        case 2: {
                            fArray2[n] = this.parseFloat(stringArray[i]);
                            continue block10;
                        }
                        case 3: {
                            this.fillCsfArray("eig_vec", stringArray, i, fArray3[n]);
                            continue block10;
                        }
                        case 4: {
                            bl = true;
                            if (fArray4 == null) {
                                fArray4 = new float[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("eig_vec_compressed", stringArray, i, fArray4[n]);
                            continue block10;
                        }
                        case 5: {
                            if (nArray == null) {
                                nArray = new int[this.nOrbitals][this.nOrbitals];
                            }
                            this.fillCsfArray("coef_indices", stringArray, i, nArray[n]);
                        }
                    }
                }
            }
        }
        for (int i = 0; i < this.nOrbitals; ++i) {
            if (bl) {
                int n2;
                for (int j = 0; j < nArray[i].length && (n2 = nArray[i][j] - 1) >= 0; ++j) {
                    fArray3[i][n2] = fArray4[i][j];
                }
            }
            for (int j = 0; j < this.nOrbitals; ++j) {
                if (!(Math.abs(fArray3[i][j]) < 1.0E-4f)) continue;
                fArray3[i][j] = 0.0f;
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("energy", new Float(fArray[i]));
            hashtable.put("occupancy", new Float(fArray2[i]));
            hashtable.put("coefficients", fArray3[i]);
            this.orbitals.addElement(hashtable);
        }
        this.setMOs("eV");
    }

    void processBasisObject(String string) throws Exception {
        int n;
        String[] stringArray;
        int n2;
        String[] stringArray2 = AtomSetCollectionReader.getTokens(this.atomicNumbers);
        this.nOrbitals = this.nSlaters + this.nGaussians;
        boolean bl = string.equals("gto");
        float[][] fArrayArray = new float[this.nOrbitals][];
        float[][] fArray = null;
        String[] stringArray3 = new String[this.nOrbitals];
        int[] nArray = new int[this.nOrbitals];
        int n3 = 0;
        this.readLine();
        while (this.line != null && this.parseLineParameters(moFields, moFieldMap) > 0) {
            if (n3 == 0) {
                n3 = this.getPropertyCount(string + "_exp");
            }
            n2 = 0;
            while (this.readLine() != null && !this.line.startsWith("property_flags:")) {
                stringArray = this.getTokens();
                block9: for (n = 0; n < this.fieldCount; ++n) {
                    String string2 = stringArray[n];
                    switch (this.fieldTypes[n]) {
                        case -1: {
                            n2 = this.parseInt(string2) - 1;
                            continue block9;
                        }
                        case 6: {
                            stringArray3[n2] = string2;
                            continue block9;
                        }
                        case 7: 
                        case 9: {
                            fArrayArray[n2] = new float[n3];
                            this.fillCsfArray(string + "_exp", stringArray, n, fArrayArray[n2]);
                            continue block9;
                        }
                        case 10: {
                            nArray[n2] = this.parseInt(string2);
                            continue block9;
                        }
                        case 8: {
                            if (fArray == null) {
                                fArray = new float[this.nOrbitals][n3];
                            }
                            this.fillCsfArray("contractions", stringArray, n, fArray[n2]);
                        }
                    }
                }
            }
        }
        if (bl) {
            Vector<int[]> vector = new Vector<int[]>();
            stringArray = new Vector();
            n = 0;
            int n4 = 0;
            for (int i = 0; i < this.nGaussians; ++i) {
                int n5;
                if (nArray[i] == n) continue;
                n = nArray[i];
                int[] nArray2 = new int[4];
                nArray2[0] = n5 = this.atomSetCollection.getAtomNameIndex(((String[])this.connectors.get(string + "_basis_fxn" + (i + 1)))[0]);
                nArray2[1] = JmolAdapter.getQuantumShellTagID(stringArray3[i].substring(0, 1));
                int n6 = 0;
                while (++n6 < n3 && fArrayArray[i][n6] != 0.0f) {
                }
                nArray2[2] = n4;
                nArray2[3] = n6;
                vector.addElement(nArray2);
                n4 += n6;
                for (int j = 0; j < n6; ++j) {
                    stringArray.addElement(new float[]{fArrayArray[i][j], fArray[i][j]});
                }
            }
            float[][] fArrayArray2 = new float[n4][];
            for (int i = 0; i < n4; ++i) {
                fArrayArray2[i] = (float[])stringArray.get(i);
            }
            this.moData.put("shells", vector);
            this.moData.put("gaussians", fArrayArray2);
        } else {
            for (n2 = 0; n2 < this.nSlaters; ++n2) {
                int n7 = this.atomSetCollection.getAtomNameIndex(((String[])this.connectors.get(string + "_basis_fxn" + (n2 + 1)))[0]);
                n = this.parseInt(stringArray2[n7]);
                for (int i = 0; i < n3 && fArrayArray[n2][i] != 0.0f; ++i) {
                    this.createSlaterByType(n7, n, stringArray3[n2], fArrayArray[n2][i] * (float)(i == 0 ? 1 : -1), fArray == null ? 1.0f : fArray[n2][i]);
                }
            }
            this.setSlaters();
        }
    }

    void createSlaterByType(int n, int n2, String string, float f, float f2) {
        int n3 = "S Px Py Pz Dx2-y2 Dxz Dz2 Dyz Dxy".indexOf(string);
        float f3 = Math.abs(f);
        switch (n3) {
            case 0: {
                this.addSlater(n, 0, 0, 0, MopacData.getNPQs(n2) - 1, f, MopacData.getMopacConstS(n2, f3) * f2);
                return;
            }
            case 2: 
            case 5: 
            case 8: {
                this.addSlater(n, n3 == 2 ? 1 : 0, n3 == 5 ? 1 : 0, n3 == 8 ? 1 : 0, MopacData.getNPQp(n2) - 2, f, MopacData.getMopacConstP(n2, f3) * f2);
                return;
            }
            case 11: 
            case 18: 
            case 22: 
            case 26: 
            case 30: {
                int n4 = n3 == 11 ? 0 : (n3 == 18 ? 1 : (n3 == 22 ? 2 : (n3 == 26 ? 3 : 4)));
                int n5 = n4 * 3;
                this.addSlater(n, MopacDataReader.dValues[n5++], MopacDataReader.dValues[n5++], MopacDataReader.dValues[n5++], MopacData.getNPQd(n2) - 3, f, MopacData.getMopacConstD(n2, f3) * MopacData.getFactorD(n4) * f2);
                return;
            }
        }
    }
}

