/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.molxyz;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class XyzReader
extends AtomSetCollectionReader {
    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("xyz");
        try {
            int n;
            while ((n = this.readAtomCount()) > 0) {
                if (this.doGetModel(++this.modelNumber)) {
                    this.readAtomSetName();
                    this.readAtoms(n);
                    this.applySymmetryAndSetTrajectory();
                    if (!this.isLastModel(this.modelNumber)) continue;
                    break;
                }
                this.skipAtomSet(n);
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void skipAtomSet(int n) throws Exception {
        this.readLine();
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
    }

    int readAtomCount() throws Exception {
        int n;
        this.readLine();
        if (this.line != null && (n = this.parseInt(this.line)) > 0) {
            return n;
        }
        return 0;
    }

    void readAtomSetName() throws Exception {
        this.readLineTrimmed();
        this.checkLineForScript();
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.line);
    }

    void readAtoms(int n) throws Exception {
        block4: for (int i = 0; i < n; ++i) {
            this.readLine();
            String[] stringArray = this.getTokens();
            if (stringArray.length < 4) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                continue;
            }
            Atom atom = this.atomSetCollection.addNewAtom();
            String string = stringArray[0];
            int n2 = this.parseInt(string);
            if (n2 == Integer.MIN_VALUE) {
                atom.elementSymbol = string;
            } else {
                string = string.substring(("" + n2).length());
                atom.elementNumber = (short)((n2 << 7) + JmolAdapter.getElementNumber(string));
                this.atomSetCollection.setFileTypeName("xyzi");
            }
            atom.x = this.parseFloat(stringArray[1]);
            atom.y = this.parseFloat(stringArray[2]);
            atom.z = this.parseFloat(stringArray[3]);
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("line cannot be read for XYZ atom data: " + this.line);
                atom.set(0.0f, 0.0f, 0.0f);
            }
            int n3 = 4;
            this.setAtomCoord(atom);
            switch (stringArray.length) {
                case 4: 
                case 6: {
                    continue block4;
                }
                case 5: 
                case 8: {
                    string = stringArray[4];
                    if (string.indexOf(".") >= 0) {
                        atom.partialCharge = this.parseFloat(string);
                    } else {
                        int n4 = this.parseInt(string);
                        if (n4 != Integer.MIN_VALUE) {
                            atom.formalCharge = n4;
                        }
                    }
                    if (stringArray.length == 5) continue block4;
                }
                default: {
                    int n5 = ++n3;
                    float f = this.parseFloat(stringArray[n5]);
                    int n6 = ++n3;
                    float f2 = this.parseFloat(stringArray[n6]);
                    int n7 = ++n3;
                    ++n3;
                    float f3 = this.parseFloat(stringArray[n7]);
                    if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) continue block4;
                    atom.vectorX = f;
                    atom.vectorY = f2;
                    atom.vectorZ = f3;
                }
            }
        }
    }
}

