/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import rene.util.FileFilter;
import rene.util.SortFile;
import rene.util.sort.SortObject;
import rene.util.sort.Sorter;

public class FileList {
    Vector V = new Vector();
    Vector Vdir = new Vector();
    boolean Stop = false;
    boolean Recurse;
    String Dir;
    String Filter;
    boolean UseCase = false;

    public FileList(String string, String string2, boolean bl) {
        this.Recurse = bl;
        this.Dir = string;
        this.Filter = string2;
        if (this.Dir.equals("-")) {
            this.Dir = ".";
            this.Recurse = false;
        } else if (this.Dir.startsWith("-")) {
            this.Dir = this.Dir.substring(1);
            this.Recurse = false;
        }
    }

    public FileList(String string, String string2) {
        this(string, string2, true);
    }

    public FileList(String string) {
        this(string, "*", true);
    }

    public void setCase(boolean bl) {
        this.UseCase = bl;
    }

    public void search() {
        this.Stop = false;
        File file = new File(this.Dir);
        if (!this.UseCase) {
            this.Filter = this.Filter.toLowerCase();
        }
        if (file.isDirectory()) {
            this.find(file, new FileFilter(this.Filter));
        }
    }

    void find(File file, FileFilter fileFilter) {
        if (!this.directory(file)) {
            return;
        }
        String[] stringArray = file.list();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            SortFile sortFile = new SortFile(file, stringArray[i]);
            if (sortFile.isDirectory()) {
                this.Vdir.addElement(sortFile);
                if (this.Recurse) {
                    this.find(sortFile, fileFilter);
                }
            } else {
                String string = sortFile.getName();
                if (!this.UseCase) {
                    string = string.toLowerCase();
                }
                char[] cArray = string.toCharArray();
                for (int j = 0; j < fileFilter.filterCount(); ++j) {
                    if (!this.match(cArray, 0, fileFilter.filter(j), 0)) continue;
                    boolean bl = this.Stop = !this.file(sortFile);
                    if (this.Stop) break block0;
                    this.V.addElement(sortFile);
                }
            }
            if (this.Stop) break;
        }
        this.parsed(file);
    }

    boolean match(char[] cArray, int n, char[] cArray2, int n2) {
        if (cArray2 == null) {
            return true;
        }
        if (n2 >= cArray2.length) {
            return n >= cArray.length;
        }
        if (n >= cArray.length) {
            return n2 == cArray2.length - 1 && cArray2[n2] == '*';
        }
        if (cArray2[n2] == '?') {
            return this.match(cArray, n + 1, cArray2, n2 + 1);
        }
        if (cArray2[n2] == '*') {
            if (n2 == cArray2.length - 1) {
                return true;
            }
            for (int i = n; i < cArray.length; ++i) {
                if (!this.match(cArray, i, cArray2, n2 + 1)) continue;
                return true;
            }
            return false;
        }
        if (cArray2[n2] == cArray[n]) {
            return this.match(cArray, n + 1, cArray2, n2 + 1);
        }
        return false;
    }

    public Enumeration files() {
        return this.V.elements();
    }

    public Enumeration dirs() {
        return this.Vdir.elements();
    }

    public int size() {
        return this.V.size();
    }

    public void sort() {
        int n;
        int n2 = this.V.size();
        SortObject[] sortObjectArray = new SortObject[n2];
        for (n = 0; n < n2; ++n) {
            sortObjectArray[n] = (SortFile)this.V.elementAt(n);
        }
        Sorter.sort(sortObjectArray);
        for (n = 0; n < n2; ++n) {
            this.V.setElementAt(sortObjectArray[n], n);
        }
        n2 = this.Vdir.size();
        sortObjectArray = new SortObject[n2];
        for (n = 0; n < n2; ++n) {
            sortObjectArray[n] = (SortFile)this.Vdir.elementAt(n);
        }
        Sorter.sort(sortObjectArray);
        for (n = 0; n < n2; ++n) {
            this.Vdir.setElementAt(sortObjectArray[n], n);
        }
    }

    public void sort(int n) {
        SortFile.SortBy = n;
        this.sort();
        SortFile.SortBy = 0;
    }

    protected boolean directory(File file) {
        return true;
    }

    protected boolean file(File file) {
        return true;
    }

    protected void parsed(File file) {
    }

    public void stopIt() {
        this.Stop = true;
    }

    public String getDir() {
        File file = new File(this.Dir);
        try {
            return file.getCanonicalPath();
        }
        catch (Exception exception) {
            return "Dir does not exist!";
        }
    }
}

